/*
 * Decompiled with CFR 0.152.
 */
package app_util;

import fr.esrf.tangoatk.widget.util.Gradient;
import fr.esrf.tangoatk.widget.util.chart.IJLChartListener;
import fr.esrf.tangoatk.widget.util.chart.JLChart;
import fr.esrf.tangoatk.widget.util.chart.JLChartEvent;
import fr.esrf.tangoatk.widget.util.chart.JLDataView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class PopupChart
extends JDialog {
    protected Component parent;
    private OwnChart chart;
    protected JLDataView[] data = null;
    private JButton cancelBtn;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JRadioButton legendBtn;
    private JLabel titleLabel;
    private MyGradient gradient = null;

    public PopupChart(JFrame parent, String title) {
        super((Frame)parent, false);
        this.parent = parent;
        this.init(title);
    }

    public PopupChart(JDialog parent, String title) {
        super((Dialog)parent, false);
        this.parent = parent;
        this.init(title);
    }

    private void init(String title) {
        this.initComponents();
        this.chart = new OwnChart();
        this.chart.setPreferredSize(new Dimension(640, 480));
        this.getContentPane().add((Component)this.chart, "Center");
        this.titleLabel.setText(title);
        this.pack();
    }

    public void setPreferredSize(Dimension d) {
        this.chart.setPreferredSize(d);
        this.pack();
    }

    public void setY1Data(String[] names, long[][] t, double[][] values) {
        this.chart.setData(names, t, values, 0, names.length);
    }

    public void setY1Data(String[] names, long[] t, double[] v) {
        long[][] time = new long[1][];
        double[][] values = new double[1][];
        time[0] = t;
        values[0] = v;
        this.chart.setData(names, time, values, 0, names.length);
    }

    public void setY1Data(String[] names, long[] t, double[][] values) {
        long[][] time = new long[values.length][];
        for (int i = 0; i < values.length; ++i) {
            time[i] = t;
        }
        time[0] = t;
        this.chart.setData(names, time, values, 0, names.length);
    }

    public void setY2Data(String[] names, long[] t, double[] v) {
        long[][] time = new long[1][];
        double[][] values = new double[1][];
        time[0] = t;
        values[0] = v;
        this.chart.setData(names, time, values, 1, names.length);
    }

    public void setY2Data(String[] names, long[] t, double[][] values) {
        long[][] time = new long[values.length][];
        for (int i = 0; i < values.length; ++i) {
            time[i] = t;
        }
        this.chart.setData(names, time, values, 1, names.length);
    }

    public void setY1Data(String[] names, double[] v) {
        double[][] values = new double[][]{v};
        int nb = v.length;
        long[][] x = new long[1][nb];
        for (int i = 0; i < nb; ++i) {
            x[0][i] = i;
        }
        this.chart.setData(names, x, values, 0, 1);
        this.chart.getXAxis().setAnnotation(2);
    }

    public void setY1Data(String[] names, double[] x, double[] v) {
        double[][] values = new double[][]{v};
        int nb = x.length;
        double[][] x2 = new double[1][x.length];
        for (int i = 0; i < nb; ++i) {
            x2[0][i] = x[i];
        }
        this.chart.setData(names, x2, values, 0, 1);
        this.chart.getXAxis().setAnnotation(2);
    }

    public void setY2Data(String[] names, double[] v) {
        double[][] values = new double[][]{v};
        int nb = v.length;
        long[][] x = new long[1][nb];
        for (int i = 0; i < nb; ++i) {
            x[0][i] = i;
        }
        this.chart.setData(names, x, values, 1, 1);
        this.chart.getXAxis().setAnnotation(2);
    }

    public void setY2Data(String[] names, double[] x, double[] v) {
        double[][] values = new double[][]{v};
        int nb = x.length;
        double[][] x2 = new double[1][x.length];
        for (int i = 0; i < nb; ++i) {
            x2[0][i] = x[i];
        }
        this.chart.setData(names, x2, values, 1, 1);
        this.chart.getXAxis().setAnnotation(2);
    }

    public void setXGridVisible(boolean b2) {
        this.chart.getXAxis().setGridVisible(true);
    }

    public void setXSubGridVisible(boolean b2) {
        this.chart.getXAxis().setSubGridVisible(b2);
    }

    public void setY1GridVisible(boolean b2) {
        this.chart.getY1Axis().setGridVisible(true);
    }

    public void setY1SubGridVisible(boolean b2) {
        this.chart.getY1Axis().setSubGridVisible(b2);
    }

    public void setY2GridVisible(boolean b2) {
        this.chart.getY2Axis().setGridVisible(true);
    }

    public void setY2SubGridVisible(boolean b2) {
        this.chart.getY2Axis().setSubGridVisible(b2);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.cancelBtn = new JButton();
        this.legendBtn = new JRadioButton();
        this.jPanel2 = new JPanel();
        this.titleLabel = new JLabel();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                PopupChart.this.closeDialog(evt);
            }
        });
        this.cancelBtn.setText("Dismiss");
        this.cancelBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PopupChart.this.cancelBtnActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.cancelBtn);
        this.legendBtn.setText("Legend");
        this.legendBtn.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.legendBtn.setMargin(new Insets(0, 0, 0, 0));
        this.legendBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PopupChart.this.legendBtnActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.legendBtn);
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.titleLabel.setFont(new Font("Dialog", 1, 18));
        this.titleLabel.setText("Dialog Title");
        this.jPanel2.add(this.titleLabel);
        this.getContentPane().add((Component)this.jPanel2, "North");
        this.pack();
    }

    public void setAsBarGraph() {
        this.chart.setAsBarGraph();
    }

    public void setBarFromZero() {
        this.chart.setBarFromZero();
    }

    public void setLabelVisible(boolean b2) {
        this.chart.setLabelVisible(b2);
        this.legendBtn.setSelected(b2);
    }

    public void setY1Name(String name) {
        this.chart.getY1Axis().setName(name);
    }

    public void setY2Name(String name) {
        this.chart.getY2Axis().setName(name);
    }

    private void legendBtnActionPerformed(ActionEvent evt) {
        this.chart.setLabelVisible(this.legendBtn.getSelectedObjects() != null);
        this.chart.repaint();
    }

    private void cancelBtnActionPerformed(ActionEvent evt) {
        this.doClose();
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose();
    }

    private void doClose() {
        if (this.parent.getWidth() == 0) {
            System.exit(0);
        } else {
            this.setVisible(false);
            this.dispose();
        }
    }

    Color getNewColor() {
        if (this.gradient == null) {
            this.gradient = new MyGradient();
        }
        return this.gradient.getNextColor();
    }

    public static void main(String[] args) {
        PopupChart panel = new PopupChart(new JFrame(), "Profiles");
        long t0 = 1178713391L;
        t0 *= 1000L;
        String[] names = new String[]{"Curve 1", "Curve 2"};
        long[] t = new long[100];
        double[] y1 = new double[100];
        double[] y2 = new double[100];
        double[][] values = new double[][]{y1, y2};
        for (int i = 0; i < t.length; ++i) {
            t[i] = t0 + (long)(i * 2000);
            y1[i] = i;
            y2[i] = t.length - i;
        }
        panel.setY1Data(new String[]{names[0]}, t, y1);
        panel.setY2Data(new String[]{names[1]}, t, y2);
        panel.setVisible(true);
    }

    class MyGradient
    extends Gradient {
        private final int nbColors = 256;
        private int step = 128;
        private int colorIdx = -this.step;
        private int[] colorMap;
        private Vector<Integer> done = new Vector();

        private MyGradient() {
            this.buildRainbowGradient();
            this.colorMap = this.buildColorMap(256);
        }

        private boolean alreadyUsed(int idx) {
            for (int i : this.done) {
                if (i != idx) continue;
                return true;
            }
            return false;
        }

        private Color getNextColor() {
            if (this.done.size() == 256) {
                this.done.clear();
                this.step = 128;
                this.colorIdx = -this.step;
            }
            do {
                this.colorIdx += this.step;
                if (this.colorIdx < this.colorMap.length) continue;
                this.colorIdx = this.step;
                this.step /= 2;
            } while (this.alreadyUsed(this.colorIdx));
            this.done.add(this.colorIdx);
            return new Color(this.colorMap[this.colorIdx]);
        }
    }

    class OwnChart
    extends JLChart
    implements IJLChartListener {
        protected String[] names;

        public OwnChart() {
            this.setBackground(Color.lightGray);
            this.setChartBackground(Color.lightGray);
            this.setHeaderFont(new Font("Dialog", 1, 12));
            this.setLabelVisible(false);
            this.setJLChartListener(this);
        }

        private void setBarFromZero() {
            for (JLDataView dv : PopupChart.this.data) {
                dv.setFillMethod(1);
            }
            this.getXAxis().setPosition(3);
        }

        private void setAsBarGraph() {
            for (JLDataView dv : PopupChart.this.data) {
                dv.setViewType(1);
            }
        }

        private void setData(String[] names, long[][] t, double[][] values, int axis, int nb_curves) {
            double[][] x = new double[t.length][];
            for (int i = 0; i < t.length; ++i) {
                x[i] = new double[t[i].length];
                for (int j = 0; j < t[i].length; ++j) {
                    x[i][j] = t[i][j];
                }
            }
            this.setData(names, x, values, axis, nb_curves);
        }

        private void setData(String[] names, double[][] x, double[][] values, int axis, int nb_curves) {
            int i;
            this.names = names;
            PopupChart.this.data = new JLDataView[nb_curves];
            for (i = 0; i < nb_curves; ++i) {
                PopupChart.this.data[i] = new JLDataView();
                PopupChart.this.data[i].setViewType(0);
                PopupChart.this.data[i].setBarWidth(1);
                if (nb_curves == 1 && names.length > 1) {
                    PopupChart.this.data[i].setName("Values");
                } else {
                    PopupChart.this.data[i].setName(names[i]);
                }
                PopupChart.this.data[i].setLineWidth(1);
                PopupChart.this.data[i].setColor(PopupChart.this.getNewColor());
                if (axis == 0) {
                    this.getY1Axis().addDataView(PopupChart.this.data[i]);
                    continue;
                }
                this.getY2Axis().addDataView(PopupChart.this.data[i]);
            }
            for (i = 0; i < values.length; ++i) {
                for (int j = 0; j < x[i].length; ++j) {
                    PopupChart.this.data[i].add(x[i][j], values[i][j]);
                }
            }
            this.getY1Axis().setAutoScale(true);
            this.getY2Axis().setAutoScale(true);
            this.repaint();
        }

        public String[] clickOnChart(JLChartEvent event) {
            JLDataView dv = event.getDataView();
            int idx = event.getDataViewIndex();
            double x = dv.getXValueByIndex(idx);
            double y = dv.getYValueByIndex(idx);
            int anno = this.getXAxis().getAnnotation();
            String[] retval = new String[3];
            retval[0] = dv.getName();
            retval[1] = anno == 2 ? (this.names != null && this.names.length > idx ? this.names[idx] : "Index " + idx) : this.formatDate((long)x);
            retval[2] = "Y:  " + y;
            return retval;
        }

        private String formatDate(long ms) {
            StringTokenizer st = new StringTokenizer(new Date(ms).toString());
            Vector<String> v = new Vector<String>();
            while (st.hasMoreTokens()) {
                v.add(st.nextToken());
            }
            String month = (String)v.get(1);
            String day = (String)v.get(2);
            String time = (String)v.get(3);
            String year = (String)v.get(v.size() - 1);
            if (year.indexOf(41) > 0) {
                year = year.substring(0, year.indexOf(41));
            }
            return day + " " + month + " " + year + "  " + time;
        }
    }
}

