/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.jgl3dchart;

import fr.esrf.tangoatk.widget.util.jgl3dchart.JGL3DAxis;
import fr.esrf.tangoatk.widget.util.jgl3dchart.JGL3DChart;
import fr.esrf.tangoatk.widget.util.jgl3dchart.Utils;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

class AxisPanel
extends JPanel
implements ActionListener,
KeyListener {
    private JGL3DAxis axis;
    private JGL3DChart chart;
    private JPanel scalePanel;
    private JLabel MinLabel;
    private JTextField MinText;
    private JLabel MaxLabel;
    private JTextField MaxText;
    private JCheckBox AutoScaleCheck;
    private JPanel settingPanel;
    private JCheckBox VisibleCheck;
    private JComboBox FormatCombo;
    private JLabel FormatLabel;
    private JLabel TitleLabel;
    private JTextField TitleText;
    private JLabel ColorLabel;
    private JLabel ColorView;
    private JButton ColorBtn;
    private JLabel TickLabel;
    private JTextField TickText;
    private JLabel TitleOffsetLabel;
    private JTextField TitleOffsetText;
    private JPanel affTransformPanel;
    private JLabel offsetLabel;
    private JTextField offsetText;
    private JLabel gainLabel;
    private JTextField gainText;

    public AxisPanel(JGL3DAxis jGL3DAxis, JGL3DChart jGL3DChart) {
        this.axis = jGL3DAxis;
        this.chart = jGL3DChart;
        this.setLayout(null);
        this.scalePanel = new JPanel();
        this.scalePanel.setLayout(null);
        this.scalePanel.setBorder(Utils.createTitleBorder("Scale"));
        this.add(this.scalePanel);
        this.MinLabel = new JLabel("Min");
        this.MinLabel.setFont(Utils.labelFont);
        this.MinText = new JTextField();
        this.MinLabel.setForeground(Utils.fColor);
        this.MinLabel.setEnabled(!jGL3DAxis.isAutoScale());
        this.MinText.setText(Double.toString(jGL3DAxis.getMinimum()));
        this.MinText.setEditable(true);
        this.MinText.setEnabled(!jGL3DAxis.isAutoScale());
        this.MinText.setMargin(Utils.zInset);
        this.MinText.addKeyListener(this);
        this.MaxLabel = new JLabel("Max");
        this.MaxLabel.setFont(Utils.labelFont);
        this.MaxText = new JTextField();
        this.MaxLabel.setForeground(Utils.fColor);
        this.MaxLabel.setHorizontalAlignment(4);
        this.MaxLabel.setEnabled(!jGL3DAxis.isAutoScale());
        this.MaxText.setText(Double.toString(jGL3DAxis.getMaximum()));
        this.MaxText.setEditable(true);
        this.MaxText.setEnabled(!jGL3DAxis.isAutoScale());
        this.MaxText.setMargin(Utils.zInset);
        this.MaxText.addKeyListener(this);
        this.AutoScaleCheck = new JCheckBox("Auto scale");
        this.AutoScaleCheck.setFont(Utils.labelFont);
        this.AutoScaleCheck.setForeground(Utils.fColor);
        this.AutoScaleCheck.setSelected(jGL3DAxis.isAutoScale());
        this.AutoScaleCheck.addActionListener(this);
        this.scalePanel.add(this.MinLabel);
        this.scalePanel.add(this.MinText);
        this.scalePanel.add(this.MaxLabel);
        this.scalePanel.add(this.MaxText);
        this.scalePanel.add(this.AutoScaleCheck);
        this.MinLabel.setBounds(10, 20, 35, 25);
        this.MinText.setBounds(50, 20, 90, 25);
        this.MaxLabel.setBounds(145, 20, 40, 25);
        this.MaxText.setBounds(190, 20, 90, 25);
        this.AutoScaleCheck.setBounds(5, 50, 275, 25);
        this.scalePanel.setBounds(5, 10, 290, 85);
        this.settingPanel = new JPanel();
        this.settingPanel.setLayout(null);
        this.settingPanel.setBorder(Utils.createTitleBorder("Axis settings"));
        this.add(this.settingPanel);
        this.VisibleCheck = new JCheckBox("Visible");
        this.VisibleCheck.setFont(Utils.labelFont);
        this.VisibleCheck.setForeground(Utils.fColor);
        this.VisibleCheck.setSelected(jGL3DAxis.isVisible());
        this.VisibleCheck.setToolTipText("Display/Hide the axis");
        this.VisibleCheck.addActionListener(this);
        this.FormatCombo = new JComboBox();
        this.FormatCombo.setFont(Utils.labelFont);
        this.FormatCombo.addItem("Automatic");
        this.FormatCombo.addItem("Scientific");
        this.FormatCombo.addItem("Time (hh:mm:ss)");
        this.FormatCombo.addItem("Decimal int");
        this.FormatCombo.addItem("Hexadecimal int");
        this.FormatCombo.addItem("Binary int");
        this.FormatCombo.addItem("Scientific int");
        this.FormatCombo.addItem("Date");
        this.FormatCombo.setSelectedIndex(jGL3DAxis.getLabelFormat());
        this.FormatCombo.addActionListener(this);
        this.FormatLabel = new JLabel("Label format");
        this.FormatLabel.setFont(Utils.labelFont);
        this.FormatLabel.setForeground(Utils.fColor);
        this.TitleLabel = new JLabel("Title");
        this.TitleLabel.setFont(Utils.labelFont);
        this.TitleLabel.setForeground(Utils.fColor);
        this.TitleText = new JTextField();
        this.TitleText.setEditable(true);
        this.TitleText.setText(jGL3DAxis.getName());
        this.TitleText.setMargin(Utils.zInset);
        this.TitleText.addKeyListener(this);
        this.ColorLabel = new JLabel("Label color");
        this.ColorLabel.setFont(Utils.labelFont);
        this.ColorLabel.setForeground(Utils.fColor);
        this.ColorView = new JLabel("");
        this.ColorView.setOpaque(true);
        this.ColorView.setBorder(BorderFactory.createLineBorder(Color.black));
        this.ColorView.setBackground(jGL3DAxis.getLabelColor());
        this.ColorBtn = new JButton("...");
        this.ColorBtn.addActionListener(this);
        this.ColorBtn.setMargin(Utils.zInset);
        this.TickLabel = new JLabel("Tick spacing");
        this.TickLabel.setFont(Utils.labelFont);
        this.TickLabel.setForeground(Utils.fColor);
        this.TickText = new JTextField();
        this.TickText.setEditable(true);
        this.TickText.setText(Integer.toString(jGL3DAxis.getTickSpacing()));
        this.TickText.setMargin(Utils.zInset);
        this.TickText.addKeyListener(this);
        this.TitleOffsetLabel = new JLabel("Title offset");
        this.TitleOffsetLabel.setFont(Utils.labelFont);
        this.TitleOffsetLabel.setForeground(Utils.fColor);
        this.TitleOffsetText = new JTextField();
        this.TitleOffsetText.setEditable(true);
        this.TitleOffsetText.setText(Double.toString(jGL3DAxis.getTitleOffset()));
        this.TitleOffsetText.setMargin(Utils.zInset);
        this.TitleOffsetText.addKeyListener(this);
        this.settingPanel.add(this.VisibleCheck);
        this.settingPanel.add(this.FormatCombo);
        this.settingPanel.add(this.FormatLabel);
        this.settingPanel.add(this.TitleLabel);
        this.settingPanel.add(this.TitleText);
        this.settingPanel.add(this.ColorLabel);
        this.settingPanel.add(this.ColorView);
        this.settingPanel.add(this.ColorBtn);
        this.settingPanel.add(this.TickLabel);
        this.settingPanel.add(this.TickText);
        this.settingPanel.add(this.TitleOffsetLabel);
        this.settingPanel.add(this.TitleOffsetText);
        this.FormatLabel.setBounds(10, 20, 100, 25);
        this.FormatCombo.setBounds(115, 20, 165, 25);
        this.TitleLabel.setBounds(10, 50, 100, 25);
        this.TitleText.setBounds(115, 50, 165, 25);
        this.ColorLabel.setBounds(10, 80, 100, 25);
        this.ColorView.setBounds(115, 80, 130, 25);
        this.ColorBtn.setBounds(250, 80, 30, 25);
        this.TickLabel.setBounds(10, 110, 100, 25);
        this.TickText.setBounds(115, 110, 165, 25);
        this.TitleOffsetLabel.setBounds(10, 140, 100, 25);
        this.TitleOffsetText.setBounds(115, 140, 165, 25);
        this.VisibleCheck.setBounds(5, 170, 280, 25);
        this.settingPanel.setBounds(5, 100, 290, 205);
        this.affTransformPanel = new JPanel();
        this.affTransformPanel.setLayout(null);
        this.affTransformPanel.setBorder(Utils.createTitleBorder("Coordinates transform"));
        this.add(this.affTransformPanel);
        this.offsetLabel = new JLabel("Offset");
        this.offsetLabel.setFont(Utils.labelFont);
        this.offsetLabel.setForeground(Utils.fColor);
        this.offsetText = new JTextField();
        this.offsetText.setEditable(true);
        this.offsetText.setText(Double.toString(jGL3DAxis.getOffsetTransform()));
        this.offsetText.setMargin(Utils.zInset);
        this.offsetText.addKeyListener(this);
        this.gainLabel = new JLabel("Gain");
        this.gainLabel.setFont(Utils.labelFont);
        this.gainLabel.setForeground(Utils.fColor);
        this.gainText = new JTextField();
        this.gainText.setEditable(true);
        this.gainText.setText(Double.toString(jGL3DAxis.getGainTransform()));
        this.gainText.setMargin(Utils.zInset);
        this.gainText.addKeyListener(this);
        this.affTransformPanel.add(this.offsetLabel);
        this.affTransformPanel.add(this.offsetText);
        this.affTransformPanel.add(this.gainLabel);
        this.affTransformPanel.add(this.gainText);
        this.offsetLabel.setBounds(10, 20, 100, 25);
        this.offsetText.setBounds(115, 20, 165, 25);
        this.gainLabel.setBounds(10, 50, 100, 25);
        this.gainText.setBounds(115, 50, 165, 25);
        this.affTransformPanel.setBounds(5, 310, 290, 90);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.AutoScaleCheck) {
            boolean bl = this.AutoScaleCheck.isSelected();
            this.axis.setAutoScale(bl);
            this.MinLabel.setEnabled(!bl);
            this.MinText.setEnabled(!bl);
            this.MaxLabel.setEnabled(!bl);
            this.MaxText.setEnabled(!bl);
        } else if (object == this.FormatCombo) {
            int n = this.FormatCombo.getSelectedIndex();
            this.axis.setLabelFormat(n);
            this.chart.repaint();
        } else if (actionEvent.getSource() == this.ColorBtn) {
            Color color = JColorChooser.showDialog(this, "Choose axis Color", this.axis.getLabelColor());
            if (color != null) {
                this.axis.setLabelColor(color);
                this.ColorView.setBackground(color);
                this.chart.repaint();
            }
        } else if (actionEvent.getSource() == this.VisibleCheck) {
            this.axis.setVisible(this.VisibleCheck.isSelected());
            this.chart.repaint();
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        Object object = keyEvent.getSource();
        if (!(object != this.MinText && object != this.MaxText || this.axis.isAutoScale())) {
            if (keyEvent.getKeyCode() == 10) {
                try {
                    double d = Double.parseDouble(this.MinText.getText());
                    double d2 = Double.parseDouble(this.MaxText.getText());
                    if (d2 <= d) {
                        this.error("Min must be strictly lower than max.");
                        return;
                    }
                    this.axis.setMinimum(d);
                    this.axis.setMaximum(d2);
                    this.MinText.setCaretPosition(0);
                    this.MaxText.setCaretPosition(0);
                }
                catch (NumberFormatException numberFormatException) {
                    this.error("Min or Max: malformed number.");
                }
            }
        } else if (object == this.TitleText) {
            if (keyEvent.getKeyCode() == 10) {
                this.axis.setName(this.TitleText.getText());
                this.TitleText.setCaretPosition(0);
                this.chart.repaint();
            }
        } else if (object == this.TickText) {
            if (keyEvent.getKeyCode() == 10) {
                try {
                    int n = Integer.parseInt(this.TickText.getText());
                    this.axis.setTickSpacing(n);
                    this.TickText.setCaretPosition(0);
                    this.chart.repaint();
                }
                catch (NumberFormatException numberFormatException) {
                    this.error("Tick spacing, malformed number.");
                }
            }
        } else if (object == this.TitleOffsetText) {
            if (keyEvent.getKeyCode() == 10) {
                try {
                    double d = Double.parseDouble(this.TitleOffsetText.getText());
                    this.axis.setTitleOffset(d);
                    this.TitleOffsetText.setCaretPosition(0);
                    this.chart.repaint();
                }
                catch (NumberFormatException numberFormatException) {
                    this.error("Title offset, malformed number.");
                }
            }
        } else if (object == this.offsetText) {
            if (keyEvent.getKeyCode() == 10) {
                try {
                    double d = Double.parseDouble(this.offsetText.getText());
                    this.axis.setOffsetTransform(d);
                    this.offsetText.setCaretPosition(0);
                }
                catch (NumberFormatException numberFormatException) {
                    this.error("Offset, malformed number.");
                }
            }
        } else if (object == this.gainText && keyEvent.getKeyCode() == 10) {
            try {
                double d = Double.parseDouble(this.gainText.getText());
                this.axis.setGainTransform(d);
                this.gainText.setCaretPosition(0);
            }
            catch (NumberFormatException numberFormatException) {
                this.error("Gain, malformed number.");
            }
        }
    }

    private void error(String string) {
        JOptionPane.showMessageDialog(this, string, "Chart options error", 0);
    }
}

