/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util;

import com.braju.format.Format;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;

public class DigitalNumberViewer
extends JComponent {
    private String format = "%5.2f";
    private double value = 0.0;
    private int fontSize = 30;
    private int hOffset = 3;
    private int vOffset = 3;
    private int[] cX = new int[6];
    private int[] cY = new int[6];

    public DigitalNumberViewer() {
        this.setOpaque(true);
        this.setLayout(null);
        this.setBorder(null);
        this.setForeground(Color.black);
        this.setBackground(Color.white);
    }

    public void setFormat(String string) {
        this.format = string;
        this.repaint();
    }

    public String getFormat() {
        return this.format;
    }

    public void setValue(double d) {
        this.value = d;
        this.repaint();
    }

    public void setFontSize(int n) {
        this.fontSize = n;
        this.repaint();
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setVerticalOffset(int n) {
        this.vOffset = n;
    }

    public void setHorizontalOffset(int n) {
        this.hOffset = n;
    }

    public Dimension getPreferredSize() {
        String string = this.getFormattedValue();
        int n = string.length();
        int n2 = 0;
        if (string.indexOf(46) != -1) {
            --n;
            n2 = 5;
        }
        Insets insets = this.getInsets();
        return new Dimension((this.fontSize + 5) * n + n2 + 2 * this.hOffset + insets.left + insets.right, this.fontSize * 2 + 2 * this.vOffset + insets.top + insets.bottom);
    }

    private void drawASegment(Graphics graphics, int n, int n2) {
        int n3 = this.fontSize / 6;
        this.cX[0] = n + 1;
        this.cX[1] = n + this.fontSize - 1;
        this.cX[2] = n + this.fontSize - 1 - n3;
        this.cX[3] = n + n3 + 1;
        this.cY[0] = n2;
        this.cY[1] = n2;
        this.cY[2] = n2 + n3;
        this.cY[3] = n2 + n3;
        graphics.fillPolygon(this.cX, this.cY, 4);
    }

    private void drawBSegment(Graphics graphics, int n, int n2) {
        int n3 = this.fontSize / 6;
        this.cX[0] = n + this.fontSize;
        this.cX[1] = n + this.fontSize;
        this.cX[2] = n + this.fontSize - n3;
        this.cX[3] = n + this.fontSize - n3;
        this.cY[0] = n2 + 2;
        this.cY[1] = n2 + this.fontSize - 2;
        this.cY[2] = n2 + this.fontSize - 2 - n3;
        this.cY[3] = n2 + n3 + 2;
        graphics.fillPolygon(this.cX, this.cY, 4);
    }

    private void drawCSegment(Graphics graphics, int n, int n2) {
        int n3 = this.fontSize / 6;
        this.cX[0] = n + this.fontSize;
        this.cX[1] = n + this.fontSize;
        this.cX[2] = n + this.fontSize - n3;
        this.cX[3] = n + this.fontSize - n3;
        this.cY[0] = n2 + 2 + this.fontSize;
        this.cY[1] = n2 + 2 * this.fontSize - 2;
        this.cY[2] = n2 + 2 * this.fontSize - 2 - n3;
        this.cY[3] = n2 + this.fontSize + n3 + 2;
        graphics.fillPolygon(this.cX, this.cY, 4);
    }

    private void drawDSegment(Graphics graphics, int n, int n2) {
        int n3 = this.fontSize / 6;
        this.cX[0] = n + 1;
        this.cX[1] = n + this.fontSize - 1;
        this.cX[2] = n + this.fontSize - 1 - n3;
        this.cX[3] = n + n3 + 1;
        this.cY[0] = n2 + 2 * this.fontSize;
        this.cY[1] = n2 + 2 * this.fontSize;
        this.cY[2] = n2 + 2 * this.fontSize - n3;
        this.cY[3] = n2 + 2 * this.fontSize - n3;
        graphics.fillPolygon(this.cX, this.cY, 4);
    }

    private void drawESegment(Graphics graphics, int n, int n2) {
        int n3 = this.fontSize / 6;
        this.cX[0] = n;
        this.cX[1] = n;
        this.cX[2] = n + n3;
        this.cX[3] = n + n3;
        this.cY[0] = n2 + 2 + this.fontSize;
        this.cY[1] = n2 + 2 * this.fontSize - 2;
        this.cY[2] = n2 + 2 * this.fontSize - 2 - n3;
        this.cY[3] = n2 + this.fontSize + n3 + 2;
        graphics.fillPolygon(this.cX, this.cY, 4);
    }

    private void drawFSegment(Graphics graphics, int n, int n2) {
        int n3 = this.fontSize / 6;
        this.cX[0] = n;
        this.cX[1] = n;
        this.cX[2] = n + n3;
        this.cX[3] = n + n3;
        this.cY[0] = n2 + 2;
        this.cY[1] = n2 + this.fontSize - 2;
        this.cY[2] = n2 + this.fontSize - 2 - n3;
        this.cY[3] = n2 + n3 + 2;
        graphics.fillPolygon(this.cX, this.cY, 4);
    }

    private void drawGSegment(Graphics graphics, int n, int n2) {
        int n3 = this.fontSize / 6;
        int n4 = n3 / 2;
        this.cX[0] = n + n4;
        this.cX[1] = n + n3;
        this.cX[2] = n + this.fontSize - n3;
        this.cX[3] = n + this.fontSize - n4;
        this.cX[4] = n + this.fontSize - n3;
        this.cX[5] = n + n3;
        this.cY[0] = n2 + this.fontSize;
        this.cY[1] = n2 + this.fontSize - n3 / 2;
        this.cY[2] = n2 + this.fontSize - n3 / 2;
        this.cY[3] = n2 + this.fontSize;
        this.cY[4] = n2 + this.fontSize + n3 / 2 + 1;
        this.cY[5] = n2 + this.fontSize + n3 / 2 + 1;
        graphics.fillPolygon(this.cX, this.cY, 6);
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        if (this.isOpaque()) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, dimension.width, dimension.height);
        }
        graphics.setColor(this.getForeground());
        String string = this.getFormattedValue();
        Insets insets = this.getInsets();
        int n = insets.left + this.hOffset;
        int n2 = insets.top + this.vOffset;
        block15: for (int i = 0; i < string.length(); ++i) {
            switch (string.charAt(i)) {
                case '0': {
                    this.drawASegment(graphics, n, n2);
                    this.drawBSegment(graphics, n, n2);
                    this.drawCSegment(graphics, n, n2);
                    this.drawDSegment(graphics, n, n2);
                    this.drawESegment(graphics, n, n2);
                    this.drawFSegment(graphics, n, n2);
                    n += this.fontSize + 5;
                    continue block15;
                }
                case '1': {
                    this.drawBSegment(graphics, n, n2);
                    this.drawCSegment(graphics, n, n2);
                    n += this.fontSize + 5;
                    continue block15;
                }
                case '2': {
                    this.drawASegment(graphics, n, n2);
                    this.drawBSegment(graphics, n, n2);
                    this.drawGSegment(graphics, n, n2);
                    this.drawESegment(graphics, n, n2);
                    this.drawDSegment(graphics, n, n2);
                    n += this.fontSize + 5;
                    continue block15;
                }
                case '3': {
                    this.drawASegment(graphics, n, n2);
                    this.drawBSegment(graphics, n, n2);
                    this.drawGSegment(graphics, n, n2);
                    this.drawCSegment(graphics, n, n2);
                    this.drawDSegment(graphics, n, n2);
                    n += this.fontSize + 5;
                    continue block15;
                }
                case '4': {
                    this.drawFSegment(graphics, n, n2);
                    this.drawGSegment(graphics, n, n2);
                    this.drawBSegment(graphics, n, n2);
                    this.drawCSegment(graphics, n, n2);
                    n += this.fontSize + 5;
                    continue block15;
                }
                case '5': {
                    this.drawASegment(graphics, n, n2);
                    this.drawFSegment(graphics, n, n2);
                    this.drawGSegment(graphics, n, n2);
                    this.drawCSegment(graphics, n, n2);
                    this.drawDSegment(graphics, n, n2);
                    n += this.fontSize + 5;
                    continue block15;
                }
                case '6': {
                    this.drawASegment(graphics, n, n2);
                    this.drawFSegment(graphics, n, n2);
                    this.drawGSegment(graphics, n, n2);
                    this.drawCSegment(graphics, n, n2);
                    this.drawDSegment(graphics, n, n2);
                    this.drawESegment(graphics, n, n2);
                    n += this.fontSize + 5;
                    continue block15;
                }
                case '7': {
                    this.drawASegment(graphics, n, n2);
                    this.drawBSegment(graphics, n, n2);
                    this.drawCSegment(graphics, n, n2);
                    n += this.fontSize + 5;
                    continue block15;
                }
                case '8': {
                    this.drawASegment(graphics, n, n2);
                    this.drawBSegment(graphics, n, n2);
                    this.drawCSegment(graphics, n, n2);
                    this.drawDSegment(graphics, n, n2);
                    this.drawESegment(graphics, n, n2);
                    this.drawFSegment(graphics, n, n2);
                    this.drawGSegment(graphics, n, n2);
                    n += this.fontSize + 5;
                    continue block15;
                }
                case '9': {
                    this.drawASegment(graphics, n, n2);
                    this.drawBSegment(graphics, n, n2);
                    this.drawCSegment(graphics, n, n2);
                    this.drawDSegment(graphics, n, n2);
                    this.drawFSegment(graphics, n, n2);
                    this.drawGSegment(graphics, n, n2);
                    n += this.fontSize + 5;
                    continue block15;
                }
                case '-': {
                    this.drawGSegment(graphics, n, n2);
                    n += this.fontSize + 5;
                    continue block15;
                }
                case ' ': {
                    n += this.fontSize + 5;
                    continue block15;
                }
                case '.': {
                    graphics.fillRect(n, n2 + 2 * this.fontSize - 5, 5, 5);
                    n += 8;
                }
            }
        }
    }

    private String getFormattedValue() {
        if (Double.isNaN(this.value)) {
            return "-----";
        }
        return Format.sprintf((String)this.format, (Object[])new Object[]{new Double(this.value)});
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.setDefaultCloseOperation(3);
        DigitalNumberViewer digitalNumberViewer = new DigitalNumberViewer();
        digitalNumberViewer.setBorder(BorderFactory.createLoweredBevelBorder());
        digitalNumberViewer.setValue(-Math.PI);
        digitalNumberViewer.setFormat("%.6f");
        jFrame.setContentPane(digitalNumberViewer);
        ATKGraphicsUtils.centerFrameOnScreen(jFrame);
        jFrame.setVisible(true);
    }
}

