/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.image;

import fr.esrf.tangoatk.widget.image.BWRaster;
import fr.esrf.tangoatk.widget.image.IImageManipulator;
import fr.esrf.tangoatk.widget.image.IImagePanel;
import fr.esrf.tangoatk.widget.image.IImageViewer;
import fr.esrf.tangoatk.widget.image.IRasterConverter;
import fr.esrf.tangoatk.widget.image.ImageController;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class ImageViewer
extends JPanel
implements IImageViewer {
    IImageManipulator[] listenerList = new IImageManipulator[0];
    double[][] raster;
    BufferedImage image;
    JDialog controlFrame = new JDialog();
    int startx;
    int starty;
    int endx;
    int endy;
    JPanel canvas;
    JFrame frame;
    boolean rasterChanged = true;
    ImageController controller = new ImageController();
    IRasterConverter rasterConverter;

    public ImageViewer() {
        this.controller.setModel(this);
        this.controlFrame.getContentPane().add(this.controller);
        this.setRasterConverter(new BWRaster());
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 1) {
                    ImageViewer.this.startRoi(mouseEvent.getX(), mouseEvent.getY());
                }
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                int n = mouseEvent.getButton();
                switch (n) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        ImageViewer.this.setControllerVisible(true);
                        break;
                    }
                    case 3: {
                        ImageViewer.this.setControllerVisible(true);
                        break;
                    }
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent mouseEvent) {
                ImageViewer.this.dragRoi(mouseEvent.getX(), mouseEvent.getY());
            }
        });
    }

    public void setRasterConverter(IRasterConverter iRasterConverter) {
        this.rasterConverter = iRasterConverter;
        this.rasterConverter.setImageViewer(this);
    }

    public IRasterConverter getRasterConverter() {
        return this.rasterConverter;
    }

    public void setSize(Dimension dimension) {
        this.setPreferredSize(dimension);
        this.setMaximumSize(dimension);
    }

    public Dimension getSize() {
        return this.getPreferredSize();
    }

    public void repaint() {
        super.repaint();
    }

    protected void startRoi(int n, int n2) {
        this.startx = n;
        this.starty = n2;
        this.endx = n;
        this.endy = n2;
    }

    protected void dragRoi(int n, int n2) {
        for (int i = 0; i < this.listenerList.length; ++i) {
            this.listenerList[i].roiChanged(this.startx, n, this.starty, n2);
        }
    }

    public ImageController getController() {
        return this.controller;
    }

    public void setController(ImageController imageController) {
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public void setImage(BufferedImage bufferedImage) {
        this.image = bufferedImage;
    }

    public boolean isControllerVisible() {
        return this.controlFrame.isVisible();
    }

    public void setControllerVisible(boolean bl) {
        this.controlFrame.pack();
        this.controlFrame.setVisible(bl);
    }

    public double[][] getRaster() {
        return this.raster;
    }

    public void setRaster(double[][] dArray) {
        this.raster = dArray;
        this.rasterChanged = true;
        this.image = this.rasterConverter.convertRaster(this.raster);
        this.setSize(new Dimension(this.image.getWidth(), this.image.getHeight()));
        this.repaint();
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        this.internalPaint(graphics);
    }

    public void addImageListener(IImageManipulator iImageManipulator) {
    }

    public void addImagePanel(IImagePanel iImagePanel) {
        this.getController().addToPanel(iImagePanel);
    }

    public void addImageManipulator(IImageManipulator iImageManipulator) {
        int n = this.listenerList.length;
        IImageManipulator[] iImageManipulatorArray = new IImageManipulator[n + 1];
        System.arraycopy(this.listenerList, 0, iImageManipulatorArray, 0, n);
        iImageManipulatorArray[n] = iImageManipulator;
        this.listenerList = iImageManipulatorArray;
        iImageManipulator.setImageViewer(this);
        if (iImageManipulator instanceof IImagePanel) {
            this.addImagePanel((IImagePanel)((Object)iImageManipulator));
            iImageManipulator.setImageViewer(this);
        }
    }

    public void removeImageListener(IImageManipulator iImageManipulator) {
    }

    public void removeImageManipulator(IImageManipulator iImageManipulator) {
        boolean bl = false;
        int n = this.listenerList.length;
        for (int i = 0; i < n; ++i) {
            if (this.listenerList[i] != iImageManipulator) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return;
        }
        this.listenerList[i] = this.listenerList[n - 1];
        IImageManipulator[] iImageManipulatorArray = new IImageManipulator[n - 1];
        System.arraycopy(this.listenerList, 0, iImageManipulatorArray, 0, n - 1);
        this.listenerList = iImageManipulatorArray;
    }

    void internalPaint(Graphics graphics) {
        if (this.image == null) {
            return;
        }
        BufferedImage bufferedImage = this.image;
        for (int i = 0; i < this.listenerList.length; ++i) {
            bufferedImage = this.listenerList[i].filter(bufferedImage);
        }
        graphics.drawImage(bufferedImage, 0, 0, this);
        this.rasterChanged = false;
    }

    public boolean isRasterChanged() {
        return this.rasterChanged;
    }

    public JPanel getTopLayer() {
        return this;
    }

    public static void main(String[] stringArray) {
        ImageViewer imageViewer = new ImageViewer();
        JFrame jFrame = new JFrame();
        jFrame.getContentPane().add(imageViewer);
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

