/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.command;

import fr.esrf.tangoatk.core.DeviceFactory;
import fr.esrf.tangoatk.core.EndGroupExecutionEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.ICommandGroup;
import fr.esrf.tangoatk.core.IEndGroupExecutionListener;
import fr.esrf.tangoatk.core.command.VoidVoidCommandGroup;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class GroupCommandViewer
extends JButton
implements IEndGroupExecutionListener {
    protected ICommandGroup cmdgModel;
    private String buttonLabel = "Not Specified";
    private boolean hasConfirmation = true;
    protected Component confirmDialParent = null;
    protected String confirmTitle = "Command Execute Confirm Window";
    protected String confirmMessage = "Do you really want to execute this command?\n";

    public GroupCommandViewer() {
        this.setText("command-group");
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GroupCommandViewer.this.executeButtonActionPerformed(actionEvent);
            }
        });
    }

    public void setButtonLabel(String string) {
        if (string == null) {
            this.buttonLabel = "Not Specified";
            return;
        }
        if (string.length() <= 0) {
            this.buttonLabel = "Not Specified";
            return;
        }
        this.buttonLabel = string;
        this.setText(string);
    }

    public String getButtonLabel() {
        return this.buttonLabel;
    }

    public boolean getHasConfirmation() {
        return this.hasConfirmation;
    }

    public void setHasConfirmation(boolean bl) {
        this.hasConfirmation = bl;
    }

    public Component getConfirmDialParent() {
        return this.confirmDialParent;
    }

    public void setConfirmDialParent(Component component) {
        this.confirmDialParent = component;
    }

    public String getConfirmTitle() {
        return this.confirmTitle;
    }

    public void setConfirmTitle(String string) {
        this.confirmTitle = string;
    }

    public String getConfirmMessage() {
        return this.confirmMessage;
    }

    public void setConfirmMessage(String string) {
        this.confirmMessage = string;
    }

    protected void executeButtonActionPerformed(ActionEvent actionEvent) {
        if (this.cmdgModel == null) {
            return;
        }
        if (this.hasConfirmation) {
            int n = 1;
            try {
                n = JOptionPane.showConfirmDialog(this.confirmDialParent, this.confirmMessage, this.confirmTitle, 0);
            }
            catch (HeadlessException headlessException) {
                // empty catch block
            }
            if (n != 0) {
                return;
            }
        }
        this.cmdgModel.execute();
    }

    public void endGroupExecution(EndGroupExecutionEvent endGroupExecutionEvent) {
        this.setEnabled(true);
    }

    public void errorChange(ErrorEvent errorEvent) {
    }

    public void setModel(ICommandGroup iCommandGroup) {
        this.clearModel();
        if (iCommandGroup == null) {
            return;
        }
        if (iCommandGroup.size() <= 0) {
            return;
        }
        if (!(iCommandGroup instanceof VoidVoidCommandGroup)) {
            return;
        }
        this.cmdgModel = iCommandGroup;
        this.cmdgModel.addEndGroupExecutionListener((IEndGroupExecutionListener)this);
        if (!this.buttonLabel.equalsIgnoreCase("Not Specified")) {
            this.setText(this.buttonLabel);
            return;
        }
        String string = iCommandGroup.getCmdName();
        if (string != null) {
            this.setText(string);
        }
    }

    public void clearModel() {
        if (this.cmdgModel != null) {
            this.cmdgModel.removeEndGroupExecutionListener((IEndGroupExecutionListener)this);
            if (this.buttonLabel.equalsIgnoreCase("Not Specified")) {
                this.setText("command-group");
            }
            this.cmdgModel = null;
        }
    }

    public static void main(String[] stringArray) {
        VoidVoidCommandGroup voidVoidCommandGroup = new VoidVoidCommandGroup();
        GroupCommandViewer groupCommandViewer = new GroupCommandViewer();
        groupCommandViewer.setConfirmMessage("Do you really want to execute On?");
        try {
            voidVoidCommandGroup.add("jlp/test/1/On");
            voidVoidCommandGroup.add("jlp/test/2/On");
            groupCommandViewer.setModel((ICommandGroup)voidVoidCommandGroup);
        }
        catch (Exception exception) {
            // empty catch block
        }
        DeviceFactory.getInstance().setTraceMode(16);
        JFrame jFrame = new JFrame();
        jFrame.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jFrame.getContentPane().add((Component)groupCommandViewer, gridBagConstraints);
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

