/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import com.braju.format.Format;
import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.DevStateSpectrumEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.IDevStateSpectrum;
import fr.esrf.tangoatk.core.IDevStateSpectrumListener;
import fr.esrf.tangoatk.core.INumberSpectrum;
import fr.esrf.tangoatk.core.ISpectrumListener;
import fr.esrf.tangoatk.core.IStringSpectrum;
import fr.esrf.tangoatk.core.IStringSpectrumListener;
import fr.esrf.tangoatk.core.NumberSpectrumEvent;
import fr.esrf.tangoatk.core.Property;
import fr.esrf.tangoatk.core.StringSpectrumEvent;
import fr.esrf.tangoatk.widget.attribute.SimplePropertyFrame;
import fr.esrf.tangoatk.widget.util.ATKConstant;
import fr.esrf.tangoatk.widget.util.chart.ColorItem;
import fr.esrf.tangoatk.widget.util.chart.IJLChartListener;
import fr.esrf.tangoatk.widget.util.chart.JLChart;
import fr.esrf.tangoatk.widget.util.chart.JLChartEvent;
import fr.esrf.tangoatk.widget.util.chart.JLDataView;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.border.EtchedBorder;

public class NumberSpectrumStateBarChartViewer
extends JLChart
implements IJLChartListener,
ISpectrumListener,
IDevStateSpectrumListener,
IStringSpectrumListener,
PropertyChangeListener {
    private INumberSpectrum numberModel = null;
    private IDevStateSpectrum stateModel = null;
    private IStringSpectrum nameModel = null;
    protected JLDataView dvy = null;
    protected JLDataView minAlarmDv = null;
    protected JLDataView maxAlarmDv = null;
    private SimplePropertyFrame pf = null;
    private double A0 = 0.0;
    private double A1 = 1.0;
    private String format = null;
    private String[] currentStates = null;
    protected String[] names = null;
    private Color defaultBarChartColor = ATKConstant.getColor4State("UNKNOWN");
    private int barChartFillMethod = 2;
    private long lastForcedUpdateTime = System.currentTimeMillis() - 60000L;
    private boolean drawOnNaN = false;
    private boolean minAlarmVisible = false;
    private boolean maxAlarmVisible = false;
    private Color minAlarmColor = ATKConstant.getColor4State("ALARM");
    private Color maxAlarmColor = ATKConstant.getColor4State("ALARM");
    private int minAlarmStyle = 0;
    private int maxAlarmStyle = 0;
    private Double minAlarmValue = null;
    private Double maxAlarmValue = null;

    public NumberSpectrumStateBarChartViewer() {
        this.setBorder(new EtchedBorder());
        this.getY1Axis().setAutoScale(true);
        this.getXAxis().setAutoScale(true);
        this.getXAxis().setAnnotation(2);
        this.dvy = new JLDataView();
        this.dvy.setViewType(1);
        this.dvy.setBarWidth(5);
        this.dvy.setFillStyle(1);
        this.dvy.setLineWidth(0);
        this.dvy.setColor(this.defaultBarChartColor);
        this.dvy.setFillColor(this.defaultBarChartColor);
        this.dvy.setLabelVisible(false);
        this.getY1Axis().addDataView(this.dvy);
        this.minAlarmDv = new JLDataView();
        this.minAlarmDv.setName("Min Alarm");
        this.minAlarmDv.setStyle(this.minAlarmStyle);
        this.minAlarmDv.setLineWidth(2);
        this.minAlarmDv.setColor(this.minAlarmColor);
        this.minAlarmDv.setLabelVisible(false);
        this.maxAlarmDv = new JLDataView();
        this.maxAlarmDv.setName("Max Alarm");
        this.maxAlarmDv.setStyle(this.maxAlarmStyle);
        this.maxAlarmDv.setLineWidth(2);
        this.maxAlarmDv.setColor(this.maxAlarmColor);
        this.maxAlarmDv.setLabelVisible(false);
        this.setJLChartListener(this);
    }

    public Color getDefaultBarChartColor() {
        return this.defaultBarChartColor;
    }

    public void setDefaultBarChartColor(Color color) {
        if (this.defaultBarChartColor != color) {
            this.defaultBarChartColor = color;
            this.dvy.setColor(this.defaultBarChartColor);
            this.dvy.setFillColor(this.defaultBarChartColor);
            this.repaint();
        }
    }

    public int getBarChartFillMethod() {
        return this.barChartFillMethod;
    }

    public void setBarChartFillMethod(int n) {
        if (this.barChartFillMethod != n) {
            this.dvy.setFillMethod(n);
            this.barChartFillMethod = this.dvy.getFillMethod();
        }
    }

    public boolean getDrawOnNaN() {
        this.drawOnNaN = this.dvy.isDrawOnNaN();
        return this.drawOnNaN;
    }

    public void setDrawOnNaN(boolean bl) {
        this.dvy.setDrawOnNaN(bl);
        this.drawOnNaN = bl;
    }

    public boolean getMinAlarmVisible() {
        return this.minAlarmVisible;
    }

    public void setMinAlarmVisible(boolean bl) {
        if (this.minAlarmVisible != bl) {
            this.changeMinAlarmVisibility(bl);
        }
        this.minAlarmVisible = bl;
    }

    public boolean getMaxAlarmVisible() {
        return this.maxAlarmVisible;
    }

    public void setMaxAlarmVisible(boolean bl) {
        if (this.maxAlarmVisible != bl) {
            this.changeMaxAlarmVisibility(bl);
        }
        this.maxAlarmVisible = bl;
    }

    public Color getMinAlarmColor() {
        return this.minAlarmColor;
    }

    public void setMinAlarmColor(Color color) {
        this.minAlarmDv.setColor(color);
        this.minAlarmColor = color;
    }

    public Color getMaxAlarmColor() {
        return this.maxAlarmColor;
    }

    public void setMaxAlarmColor(Color color) {
        this.maxAlarmDv.setColor(color);
        this.maxAlarmColor = color;
    }

    public int getMinAlarmStyle() {
        return this.minAlarmStyle;
    }

    public void setMinAlarmStyle(int n) {
        this.minAlarmDv.setStyle(n);
        this.minAlarmStyle = n;
    }

    public int getMaxAlarmStyle() {
        return this.maxAlarmStyle;
    }

    public void setMaxAlarmStyle(int n) {
        this.maxAlarmDv.setStyle(n);
        this.maxAlarmStyle = n;
    }

    public INumberSpectrum getModel() {
        return this.numberModel;
    }

    public void setModel(INumberSpectrum iNumberSpectrum) {
        this.clearNumberModel();
        if (iNumberSpectrum == null) {
            this.repaint();
            return;
        }
        this.numberModel = iNumberSpectrum;
        this.format = this.numberModel.getFormat();
        this.dvy.setUserFormat(this.format);
        this.dvy.setUnit(iNumberSpectrum.getUnit());
        this.dvy.setName(iNumberSpectrum.getName());
        this.numberModel.addSpectrumListener((ISpectrumListener)this);
        this.numberModel.refresh();
        double d = this.numberModel.getMinAlarm();
        if (Double.isNaN(d)) {
            this.minAlarmValue = null;
            this.changeMinAlarmVisibility(false);
        } else {
            this.minAlarmValue = new Double(d);
            if (this.minAlarmVisible) {
                this.changeMinAlarmVisibility(true);
            }
        }
        double d2 = this.numberModel.getMaxAlarm();
        if (Double.isNaN(d2)) {
            this.maxAlarmValue = null;
            this.changeMaxAlarmVisibility(false);
        } else {
            this.maxAlarmValue = new Double(d2);
            if (this.maxAlarmVisible) {
                this.changeMaxAlarmVisibility(true);
            }
        }
        if (this.pf != null) {
            this.pf.setModel((IAttribute)this.numberModel);
        }
        this.numberModel.getProperty("min_alarm").addPresentationListener((PropertyChangeListener)this);
        this.numberModel.getProperty("max_alarm").addPresentationListener((PropertyChangeListener)this);
        this.repaint();
    }

    public void clearNumberModel() {
        if (this.numberModel != null) {
            this.numberModel.removeSpectrumListener((ISpectrumListener)this);
            if (this.pf != null) {
                this.pf.setModel(null);
            }
            this.setMinAlarmVisible(false);
            this.setMaxAlarmVisible(false);
            this.numberModel.getProperty("min_alarm").removePresentationListener((PropertyChangeListener)this);
            this.numberModel.getProperty("max_alarm").removePresentationListener((PropertyChangeListener)this);
            this.numberModel = null;
            this.minAlarmValue = null;
            this.maxAlarmValue = null;
        }
        this.setToolTipText(null);
    }

    public IDevStateSpectrum getStatesModel() {
        return this.stateModel;
    }

    public void setModel(IDevStateSpectrum iDevStateSpectrum) {
        this.clearStateModel();
        if (iDevStateSpectrum == null) {
            this.repaint();
            return;
        }
        this.stateModel = iDevStateSpectrum;
        this.stateModel.addDevStateSpectrumListener((IDevStateSpectrumListener)this);
        this.repaint();
    }

    public void clearStateModel() {
        if (this.stateModel != null) {
            this.stateModel.removeDevStateSpectrumListener((IDevStateSpectrumListener)this);
            this.stateModel = null;
            for (int i = 0; i < this.currentStates.length; ++i) {
                this.dvy.setBarFillColorAt(i, ATKConstant.getColor4State("UNKNOWN"));
            }
        }
        this.currentStates = null;
    }

    public IStringSpectrum getNamesModel() {
        return this.nameModel;
    }

    public void setModel(IStringSpectrum iStringSpectrum) {
        this.clearNameModel();
        if (iStringSpectrum == null) {
            return;
        }
        this.nameModel = iStringSpectrum;
        this.nameModel.addListener((IStringSpectrumListener)this);
    }

    public void clearNameModel() {
        if (this.nameModel != null) {
            this.nameModel.removeListener((IStringSpectrumListener)this);
            this.nameModel = null;
        }
    }

    void changeMinAlarmVisibility(boolean bl) {
        if (!bl) {
            this.minAlarmDv.reset();
            this.getY1Axis().removeDataView(this.minAlarmDv);
            this.repaint();
        } else {
            if (this.numberModel == null) {
                return;
            }
            if (this.minAlarmValue == null) {
                return;
            }
            this.getY1Axis().addDataView(this.minAlarmDv);
            this.refreshAlarmDv(this.minAlarmDv, this.minAlarmValue);
        }
    }

    void changeMaxAlarmVisibility(boolean bl) {
        if (!bl) {
            this.maxAlarmDv.reset();
            this.getY1Axis().removeDataView(this.maxAlarmDv);
            this.repaint();
        } else {
            if (this.numberModel == null) {
                return;
            }
            if (this.maxAlarmValue == null) {
                return;
            }
            this.getY1Axis().addDataView(this.maxAlarmDv);
            this.refreshAlarmDv(this.maxAlarmDv, this.maxAlarmValue);
        }
    }

    public String[] clickOnChart(JLChartEvent jLChartEvent) {
        int n;
        String[] stringArray;
        String string = null;
        String string2 = null;
        int n2 = -1;
        if (jLChartEvent.getDataView() != this.dvy) {
            return null;
        }
        if (this.numberModel == null) {
            stringArray = new String[2];
            n2 = 0;
        } else {
            stringArray = new String[3];
            stringArray[0] = this.numberModel.getName();
            n2 = 1;
            if (this.format != null) {
                Object[] objectArray = new Object[]{new Double(jLChartEvent.getTransformedYValue())};
                string = Format.sprintf((String)this.format, (Object[])objectArray) + " " + this.numberModel.getUnit();
            } else {
                string = jLChartEvent.getTransformedYValue() + " " + this.numberModel.getUnit();
            }
        }
        if (this.names != null && (n = jLChartEvent.getDataViewIndex()) >= 0 && n < this.names.length) {
            string2 = this.names[n];
        }
        stringArray[n2] = string2 != null ? "X=" + string2 : "X=" + jLChartEvent.getTransformedXValue();
        stringArray[n2 + 1] = string != null ? "Y=" + string : "Y=" + jLChartEvent.getTransformedYValue();
        return stringArray;
    }

    public void setXAxisAffineTransform(double d, double d2) {
        this.A0 = d;
        this.A1 = d2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void spectrumChange(NumberSpectrumEvent numberSpectrumEvent) {
        double[] dArray = numberSpectrumEvent.getValue();
        int n = dArray.length;
        JLDataView jLDataView = this.dvy;
        synchronized (jLDataView) {
            Vector vector = (Vector)this.dvy.getBarFillColors().clone();
            this.dvy.reset();
            for (int i = 0; i < n; ++i) {
                this.dvy.add(this.A0 + this.A1 * (double)i, dArray[i], false);
            }
            this.dvy.updateFilters();
            this.dvy.setBarFillColors(vector);
            this.repaint();
            this.refreshTableSingle(this.dvy);
        }
    }

    public void devStateSpectrumChange(DevStateSpectrumEvent devStateSpectrumEvent) {
        String[] stringArray = devStateSpectrumEvent.getValue();
        if (stringArray == null) {
            return;
        }
        if (this.currentStates == null) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.dvy.setBarFillColorAt(i, ATKConstant.getColor4State(stringArray[i]));
            }
            this.currentStates = (String[])devStateSpectrumEvent.getValue().clone();
            this.repaint();
            return;
        }
        long l = System.currentTimeMillis();
        if (l - this.lastForcedUpdateTime > 10000L) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.dvy.setBarFillColorAt(i, ATKConstant.getColor4State(stringArray[i]));
                this.currentStates[i] = stringArray[i];
            }
            this.repaint();
            this.lastForcedUpdateTime = l;
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (this.currentStates[i].equalsIgnoreCase(stringArray[i])) continue;
            this.dvy.setBarFillColorAt(i, ATKConstant.getColor4State(stringArray[i]));
            this.currentStates[i] = stringArray[i];
        }
        this.repaint();
    }

    public void stringSpectrumChange(StringSpectrumEvent stringSpectrumEvent) {
        if (stringSpectrumEvent.getValue() != null) {
            if (stringSpectrumEvent.getValue().length <= 0) {
                return;
            }
            this.names = stringSpectrumEvent.getValue();
        }
    }

    public void refreshAlarmDv(JLDataView jLDataView, double d) {
        if (this.dvy.getDataLength() < 3) {
            return;
        }
        double d2 = this.dvy.getXValueByIndex(0);
        double d3 = this.dvy.getXValueByIndex(this.dvy.getDataLength() - 1);
        jLDataView.reset();
        jLDataView.add(d2, d);
        jLDataView.add(d3, d);
        this.repaint();
    }

    public void stateChange(AttributeStateEvent attributeStateEvent) {
    }

    public void errorChange(ErrorEvent errorEvent) {
        if (errorEvent.getSource() == this.numberModel) {
            this.dvy.reset();
            this.repaint();
            this.refreshTableSingle(this.dvy);
            return;
        }
        if (errorEvent.getSource() == this.stateModel) {
            Vector<ColorItem> vector = this.dvy.getBarFillColors();
            vector.clear();
            this.currentStates = null;
            this.repaint();
            return;
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Property property = (Property)propertyChangeEvent.getSource();
        if (this.numberModel != null) {
            if (property.getName().equalsIgnoreCase("min_alarm")) {
                double d = this.numberModel.getMinAlarm();
                if (Double.isNaN(d)) {
                    this.minAlarmValue = null;
                    this.changeMinAlarmVisibility(false);
                } else {
                    this.minAlarmValue = new Double(d);
                    if (this.minAlarmVisible) {
                        this.changeMinAlarmVisibility(true);
                    }
                }
                return;
            }
            if (property.getName().equalsIgnoreCase("max_alarm")) {
                double d = this.numberModel.getMaxAlarm();
                if (Double.isNaN(d)) {
                    this.maxAlarmValue = null;
                    this.changeMaxAlarmVisibility(false);
                } else {
                    this.maxAlarmValue = new Double(d);
                    if (this.maxAlarmVisible) {
                        this.changeMaxAlarmVisibility(true);
                    }
                }
            }
        }
    }

    public static void main(String[] stringArray) {
        try {
            AttributeList attributeList = new AttributeList();
            NumberSpectrumStateBarChartViewer numberSpectrumStateBarChartViewer = new NumberSpectrumStateBarChartViewer();
            numberSpectrumStateBarChartViewer.setBarChartFillMethod(1);
            numberSpectrumStateBarChartViewer.getXAxis().setGridVisible(true);
            numberSpectrumStateBarChartViewer.getY1Axis().setGridVisible(true);
            numberSpectrumStateBarChartViewer.getY1Axis().setName("Neutron Dose Rate");
            numberSpectrumStateBarChartViewer.setMaxAlarmColor(Color.red);
            numberSpectrumStateBarChartViewer.setMaxAlarmVisible(true);
            INumberSpectrum iNumberSpectrum = (INumberSpectrum)attributeList.add("sr/neutron/all/Dose");
            numberSpectrumStateBarChartViewer.setModel(iNumberSpectrum);
            IDevStateSpectrum iDevStateSpectrum = (IDevStateSpectrum)attributeList.add("sr/neutron/all/SubDevicesStates");
            numberSpectrumStateBarChartViewer.setModel(iDevStateSpectrum);
            IStringSpectrum iStringSpectrum = (IStringSpectrum)attributeList.add("sr/neutron/all/SubDevicesNames");
            numberSpectrumStateBarChartViewer.setModel(iStringSpectrum);
            numberSpectrumStateBarChartViewer.setBorder(BorderFactory.createLoweredBevelBorder());
            numberSpectrumStateBarChartViewer.setFont(new Font("Dialog", 0, 12));
            numberSpectrumStateBarChartViewer.setPreferredSize(new Dimension(850, 480));
            attributeList.startRefresher();
            JFrame jFrame = new JFrame();
            jFrame.setContentPane(numberSpectrumStateBarChartViewer);
            jFrame.pack();
            jFrame.setVisible(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

