/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.attribute;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.events.TangoChangeEvent;
import fr.esrf.TangoApi.events.TangoPeriodicEvent;
import fr.esrf.tangoatk.core.ATKException;
import fr.esrf.tangoatk.core.AttributeReadException;
import fr.esrf.tangoatk.core.AttributeSetException;
import fr.esrf.tangoatk.core.DeviceFactory;
import fr.esrf.tangoatk.core.IStringImage;
import fr.esrf.tangoatk.core.IStringImageListener;
import fr.esrf.tangoatk.core.attribute.AAttribute;
import fr.esrf.tangoatk.core.attribute.StringImageHelper;
import java.io.IOException;
import java.io.ObjectInputStream;

public class StringImage
extends AAttribute
implements IStringImage {
    StringImageHelper imageHelper = new StringImageHelper(this);
    String[][] imageValue = null;

    public String[][] getValue() {
        return this.imageValue;
    }

    public void setValue(String[][] stringArray) {
        try {
            this.checkDimensions(stringArray);
            this.insert(stringArray);
            this.writeAtt();
            this.imageHelper.fireImageValueChanged(stringArray, System.currentTimeMillis());
        }
        catch (DevFailed devFailed) {
            this.setAttError("Couldn't set value", new AttributeSetException(devFailed));
        }
        catch (Exception exception) {
            this.setAttError("Couldn't set value", new ATKException(exception));
        }
    }

    void insert(String[][] stringArray) {
        this.imageHelper.insert(stringArray);
    }

    public void refresh() {
        DeviceAttribute deviceAttribute = null;
        if (this.skippingRefresh) {
            return;
        }
        ++this.refreshCount;
        try {
            try {
                deviceAttribute = this.readValueFromNetwork();
                if (deviceAttribute == null) {
                    return;
                }
                this.imageValue = this.imageHelper.getStringImageValue(deviceAttribute);
                this.fireValueChanged(this.imageValue);
            }
            catch (DevFailed devFailed) {
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            }
        }
        catch (Exception exception) {
            System.out.println("StringImage.refresh() Exception caught ------------------------------");
            exception.printStackTrace();
            System.out.println("StringImage.refresh()------------------------------------------------");
        }
    }

    public void dispatch(DeviceAttribute deviceAttribute) {
        if (this.skippingRefresh) {
            return;
        }
        ++this.refreshCount;
        try {
            try {
                if (deviceAttribute == null) {
                    return;
                }
                this.attribute = deviceAttribute;
                this.setState(deviceAttribute);
                this.timeStamp = deviceAttribute.getTimeValMillisSec();
                this.imageValue = this.imageHelper.getStringImageValue(deviceAttribute);
                this.fireValueChanged(this.imageValue);
            }
            catch (DevFailed devFailed) {
                this.dispatchError(devFailed);
            }
        }
        catch (Exception exception) {
            System.out.println("StringImage.dispatch() Exception caught ------------------------------");
            exception.printStackTrace();
            System.out.println("StringImage.dispatch()------------------------------------------------");
        }
    }

    public void dispatchError(DevFailed devFailed) {
        this.imageValue = null;
        this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
    }

    public boolean isWritable() {
        return super.isWritable();
    }

    protected void fireValueChanged(String[][] stringArray) {
        this.imageHelper.fireImageValueChanged(stringArray, this.timeStamp);
    }

    public void addStringImageListener(IStringImageListener iStringImageListener) {
        this.imageHelper.addStringImageListener(iStringImageListener);
        this.addStateListener(iStringImageListener);
    }

    public void removeStringImageListener(IStringImageListener iStringImageListener) {
        this.imageHelper.removeStringImageListener(iStringImageListener);
        this.removeStateListener(iStringImageListener);
    }

    public void periodic(TangoPeriodicEvent tangoPeriodicEvent) {
        ++this.periodicCount;
        DeviceAttribute deviceAttribute = null;
        long l = System.currentTimeMillis();
        this.trace(128, "StringImage.periodic method called for " + this.getName(), l);
        try {
            deviceAttribute = tangoPeriodicEvent.getValue();
            this.trace(128, "StringImage.periodicEvt.getValue(" + this.getName() + ") success", l);
        }
        catch (DevFailed devFailed) {
            this.trace(128, "StringImage.periodicEvt.getValue(" + this.getName() + ") failed, caught DevFailed", l);
            if (devFailed.errors[0].reason.equals("API_EventTimeout")) {
                this.trace(128, "StringImage.periodicEvt.getValue(" + this.getName() + ") failed, got heartbeat error", l);
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            } else {
                this.trace(128, "StringImage.periodicEvt.getValue(" + this.getName() + ") failed, got other error", l);
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            }
            return;
        }
        catch (Exception exception) {
            this.trace(128, "StringImage.periodicEvt.getValue(" + this.getName() + ") failed, caught Exception, code failure", l);
            System.out.println("StringImage.periodic.getValue() Exception caught ------------------------------");
            exception.printStackTrace();
            System.out.println("StringImage.periodic.getValue()------------------------------------------------");
            return;
        }
        if (deviceAttribute != null) {
            try {
                this.setState(deviceAttribute);
                this.attribute = deviceAttribute;
                this.timeStamp = deviceAttribute.getTimeValMillisSec();
                this.imageValue = this.imageHelper.getStringImageValue(deviceAttribute);
                this.fireValueChanged(this.imageValue);
            }
            catch (DevFailed devFailed) {
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            }
            catch (Exception exception) {
                System.out.println("StringImage.periodic.extractString() Exception caught ------------------------------");
                exception.printStackTrace();
                System.out.println("StringImage.periodic.extractString()------------------------------------------------");
            }
        }
    }

    public void change(TangoChangeEvent tangoChangeEvent) {
        ++this.changeCount;
        DeviceAttribute deviceAttribute = null;
        long l = System.currentTimeMillis();
        this.trace(32, "StringImage.change method called for " + this.getName(), l);
        try {
            deviceAttribute = tangoChangeEvent.getValue();
            this.trace(32, "StringImage.changeEvt.getValue(" + this.getName() + ") success", l);
        }
        catch (DevFailed devFailed) {
            this.trace(32, "StringImage.changeEvt.getValue(" + this.getName() + ") failed, caught DevFailed", l);
            if (devFailed.errors[0].reason.equals("API_EventTimeout")) {
                this.trace(32, "StringImage.changeEvt.getValue(" + this.getName() + ") failed, got heartbeat error", l);
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            } else {
                this.trace(32, "StringImage.changeEvt.getValue(" + this.getName() + ") failed, got other error", l);
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            }
            return;
        }
        catch (Exception exception) {
            this.trace(32, "StringImage.changeEvt.getValue(" + this.getName() + ") failed, caught Exception, code failure", l);
            System.out.println("StringImage.change.getValue() Exception caught ------------------------------");
            exception.printStackTrace();
            System.out.println("StringImage.change.getValue()------------------------------------------------");
            return;
        }
        if (deviceAttribute != null) {
            try {
                this.setState(deviceAttribute);
                this.attribute = deviceAttribute;
                this.timeStamp = deviceAttribute.getTimeValMillisSec();
                this.imageValue = this.imageHelper.getStringImageValue(deviceAttribute);
                this.fireValueChanged(this.imageValue);
            }
            catch (DevFailed devFailed) {
                this.readAttError(devFailed.getMessage(), new AttributeReadException(devFailed));
            }
            catch (Exception exception) {
                System.out.println("StringImage.change.extractString() Exception caught ------------------------------");
                exception.printStackTrace();
                System.out.println("StringImage.change.extractString()------------------------------------------------");
            }
        }
    }

    private void trace(int n, String string, long l) {
        DeviceFactory.getInstance().trace(n, string, l);
    }

    public String getVersion() {
        return "$Id: StringImage.java 12968 2009-01-26 17:54:56Z poncet $";
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        System.out.print("Loading attribute ");
        objectInputStream.defaultReadObject();
        this.serializeInit();
    }
}

