/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.impl.windows;

import com.sun.opengl.impl.GLContextShareSet;
import com.sun.opengl.impl.windows.WGL;
import com.sun.opengl.impl.windows.WindowsGLContext;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLException;

public class WindowsExternalGLContext
extends WindowsGLContext {
    private boolean firstMakeCurrent = true;
    private boolean created = true;
    private GLContext lastContext;

    public WindowsExternalGLContext() {
        super(null, null, true);
        this.hglrc = WGL.wglGetCurrentContext();
        if (this.hglrc == 0L) {
            throw new GLException("Error: attempted to make an external GLContext without a drawable/context current");
        }
        if (DEBUG) {
            System.err.println(WindowsExternalGLContext.getThreadName() + ": !!! Created external OpenGL context " + WindowsExternalGLContext.toHexString(this.hglrc) + " for " + this);
        }
        GLContextShareSet.contextCreated(this);
        this.resetGLFunctionAvailability();
    }

    public int makeCurrent() throws GLException {
        GLContext gLContext = WindowsExternalGLContext.getCurrent();
        if (gLContext != null && gLContext != this) {
            this.lastContext = gLContext;
            WindowsExternalGLContext.setCurrent(null);
        }
        return super.makeCurrent();
    }

    public void release() throws GLException {
        super.release();
        WindowsExternalGLContext.setCurrent(this.lastContext);
        this.lastContext = null;
    }

    protected int makeCurrentImpl() throws GLException {
        if (this.firstMakeCurrent) {
            this.firstMakeCurrent = false;
            return 2;
        }
        return 1;
    }

    protected void releaseImpl() throws GLException {
    }

    protected void destroyImpl() throws GLException {
        this.created = false;
        GLContextShareSet.contextDestroyed(this);
    }

    public boolean isCreated() {
        return this.created;
    }
}

