/*
 * Decompiled with CFR 0.152.
 */
package jive3;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.Database;
import java.util.Vector;
import javax.swing.ImageIcon;
import jive.JiveUtils;
import jive3.PropertyNode;
import jive3.TangoNodeRenderer;
import jive3.TreePanel;

class TaskSubDevicePropertyNode
extends PropertyNode {
    private Database db;
    private String devName;
    private String subName;

    TaskSubDevicePropertyNode(TreePanel treePanel, Database database, String string, String string2) {
        this.db = database;
        this.devName = string;
        this.parentPanel = treePanel;
        this.subName = string2;
    }

    void populateNode() throws DevFailed {
    }

    ImageIcon getIcon() {
        return TangoNodeRenderer.leaficon;
    }

    public String toString() {
        return this.subName;
    }

    String getTitle() {
        return "Device properties";
    }

    String getName() {
        return this.devName + "/" + this.subName;
    }

    String getDevName() {
        return this.devName;
    }

    String getSubName() {
        return this.subName;
    }

    public boolean isLeaf() {
        return true;
    }

    private boolean acceptProperty(String string) {
        return !JiveUtils.IsPollCfgItem(string) && !JiveUtils.IsLogCfgItem(string) && !JiveUtils.IsHdbCfgItem(string) && !JiveUtils.IsSystemItem(string);
    }

    public void viewHistory() {
        this.parentPanel.invoker.historyDlg.viewDevicePropertyHistory(this.devName, this.subName + "/*");
        this.parentPanel.invoker.showHistory();
    }

    String[][] getProperties() {
        String[][] stringArray = new String[0][0];
        try {
            int n;
            String[] stringArray2 = this.db.get_device_property_list(this.devName, this.subName + "/*");
            Vector<String> vector = new Vector<String>();
            int n2 = this.subName.length() + 1;
            for (n = 0; n < stringArray2.length; ++n) {
                if (!this.acceptProperty(stringArray2[n])) continue;
                vector.add(stringArray2[n].substring(n2));
                String[] stringArray3 = this.db.get_device_property(this.devName, stringArray2[n]).extractStringArray();
                vector.add(JiveUtils.stringArrayToString(stringArray3));
            }
            stringArray = new String[vector.size() / 2][2];
            for (n = 0; n < stringArray.length; ++n) {
                stringArray[n][0] = (String)vector.get(2 * n);
                stringArray[n][1] = (String)vector.get(2 * n + 1);
            }
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
        return stringArray;
    }

    void setProperty(String string, String string2) {
        try {
            this.db.put_device_property(this.devName, JiveUtils.makeDbDatum(this.subName + "/" + string, string2));
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }

    void deleteProperty(String string) {
        try {
            this.db.delete_device_property(this.devName, JiveUtils.makeDbDatum(this.subName + "/" + string, ""));
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }
}

