/*
 * Decompiled with CFR 0.152.
 */
package jive3;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.Database;
import javax.swing.ImageIcon;
import jive.JiveUtils;
import jive3.PropertyNode;
import jive3.TangoNodeRenderer;
import jive3.TreePanel;

class TaskFreePropertyNode
extends PropertyNode {
    private Database db;
    private String objectName;

    TaskFreePropertyNode(TreePanel treePanel, Database database, String string) {
        this.db = database;
        this.objectName = string;
        this.parentPanel = treePanel;
    }

    void populateNode() throws DevFailed {
    }

    ImageIcon getIcon() {
        return TangoNodeRenderer.leaficon;
    }

    public String toString() {
        return this.objectName;
    }

    String getTitle() {
        return "Free properties";
    }

    String getName() {
        return this.objectName;
    }

    public boolean isLeaf() {
        return true;
    }

    public void viewHistory() {
        this.parentPanel.invoker.historyDlg.viewFreePropertyHistory(this.objectName, "*");
        this.parentPanel.invoker.showHistory();
    }

    String[][] getProperties() {
        String[][] stringArray = new String[0][0];
        try {
            String[] stringArray2 = this.db.get_object_property_list(this.objectName, "*");
            stringArray = new String[stringArray2.length][2];
            for (int i = 0; i < stringArray2.length; ++i) {
                String[] stringArray3 = this.db.get_property(this.objectName, stringArray2[i]).extractStringArray();
                stringArray[i][0] = stringArray2[i];
                stringArray[i][1] = JiveUtils.stringArrayToString(stringArray3);
            }
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
        return stringArray;
    }

    void setProperty(String string, String string2) {
        try {
            this.db.put_property(this.objectName, JiveUtils.makeDbDatum(string, string2));
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }

    void deleteProperty(String string) {
        try {
            this.db.delete_property(this.objectName, JiveUtils.makeDbDatum(string, ""));
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }
}

