/*
 * Decompiled with CFR 0.152.
 */
package jive3;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.Database;
import java.util.Vector;
import javax.swing.ImageIcon;
import jive.JiveUtils;
import jive3.PropertyNode;
import jive3.TangoNodeRenderer;
import jive3.TaskSubDevicePropertyNode;
import jive3.TreePanel;

class TaskDevicePropertyNode
extends PropertyNode {
    private Database db;
    private String devName;

    TaskDevicePropertyNode(TreePanel treePanel, Database database, String string) {
        this.db = database;
        this.devName = string;
        this.parentPanel = treePanel;
    }

    void populateNode() throws DevFailed {
        int n;
        Vector vector = new Vector();
        String[] stringArray = this.db.get_device_property_list(this.devName, "*");
        for (n = 0; n < stringArray.length; ++n) {
            int n2 = stringArray[n].indexOf(47);
            if (n2 < 0) continue;
            String string = stringArray[n].substring(0, n2);
            this.addToList(vector, string);
        }
        for (n = 0; n < vector.size(); ++n) {
            this.add(new TaskSubDevicePropertyNode(this.parentPanel, this.db, this.devName, (String)vector.get(n)));
        }
    }

    public void viewHistory() {
        this.parentPanel.invoker.historyDlg.viewDevicePropertyHistory(this.devName, "*");
        this.parentPanel.invoker.showHistory();
    }

    ImageIcon getIcon() {
        return TangoNodeRenderer.leaficon;
    }

    public String toString() {
        return "Properties";
    }

    String getTitle() {
        return "Device properties";
    }

    String getName() {
        return this.devName;
    }

    public boolean isLeaf() {
        return false;
    }

    private void addToList(Vector vector, String string) {
        int n = -1;
        int n2 = 0;
        while (n2 < vector.size() && n < 0) {
            n = ((String)vector.get(n2)).compareToIgnoreCase(string);
            if (n >= 0) continue;
            ++n2;
        }
        if (n < 0) {
            vector.add(string);
        } else if (n > 0) {
            vector.add(n2, string);
        }
    }

    private boolean acceptProperty(String string) {
        int n = string.indexOf(47);
        return !JiveUtils.IsPollCfgItem(string) && !JiveUtils.IsLogCfgItem(string) && !JiveUtils.IsHdbCfgItem(string) && !JiveUtils.IsSystemItem(string) && n < 0;
    }

    String[][] getProperties() {
        String[][] stringArray = new String[0][0];
        try {
            int n;
            String[] stringArray2 = this.db.get_device_property_list(this.devName, "*");
            Vector<String> vector = new Vector<String>();
            for (n = 0; n < stringArray2.length; ++n) {
                if (!this.acceptProperty(stringArray2[n])) continue;
                vector.add(stringArray2[n]);
                String[] stringArray3 = this.db.get_device_property(this.devName, stringArray2[n]).extractStringArray();
                vector.add(JiveUtils.stringArrayToString(stringArray3));
            }
            stringArray = new String[vector.size() / 2][2];
            for (n = 0; n < stringArray.length; ++n) {
                stringArray[n][0] = (String)vector.get(2 * n);
                stringArray[n][1] = (String)vector.get(2 * n + 1);
            }
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
        return stringArray;
    }

    void setProperty(String string, String string2) {
        try {
            this.db.put_device_property(this.devName, JiveUtils.makeDbDatum(string, string2));
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
        int n = string.indexOf(47);
        if (n >= 0) {
            String string3 = string.substring(0, n);
            this.parentPanel.refreshNode(this, string3);
        }
    }

    void deleteProperty(String string) {
        try {
            this.db.delete_device_property(this.devName, JiveUtils.makeDbDatum(string, ""));
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
        }
    }
}

