/*
 * Decompiled with CFR 0.152.
 */
package jive;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DbAttribute;
import fr.esrf.TangoApi.DbDatum;
import java.io.FileReader;
import java.io.IOException;

public class TangoFileReader {
    private final int NUMBER = 1;
    private final int STRING = 2;
    private final int COMA = 3;
    private final int COLON = 4;
    private final int SLASH = 5;
    private final int ASLASH = 6;
    private final int ARROW = 7;
    private final String[] lexical_word = new String[]{"NULL", "NUMBER", "STRING", "COMA", "COLON", "SLASH", "BackSLASH", "->"};
    private int CrtLine;
    private int StartLine;
    private char CurrentChar;
    private char NextChar;
    private Database db;
    private boolean DELETE_ENTRY;
    private String word;

    public TangoFileReader(Database database) {
        this.db = database;
    }

    private void read_char(FileReader fileReader) throws IOException {
        this.CurrentChar = this.NextChar;
        this.NextChar = fileReader.ready() ? (char)fileReader.read() : (char)'\u0000';
        if (this.CurrentChar == '\n') {
            ++this.CrtLine;
        }
    }

    private void jump_line(FileReader fileReader) throws IOException {
        while (this.CurrentChar != '\n' && this.CurrentChar != '\u0000') {
            this.read_char(fileReader);
        }
        this.read_char(fileReader);
    }

    private void jump_space(FileReader fileReader) throws IOException {
        while (this.CurrentChar <= ' ' && this.CurrentChar > '\u0000') {
            this.read_char(fileReader);
        }
    }

    private String read_word(FileReader fileReader) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        this.jump_space(fileReader);
        while (this.CurrentChar == '#') {
            this.jump_line(fileReader);
            this.jump_space(fileReader);
        }
        if (this.CurrentChar == '/') {
            this.read_char(fileReader);
            if (this.CurrentChar == '*') {
                boolean bl = false;
                this.read_char(fileReader);
                while (bl) {
                    while (this.CurrentChar != '*') {
                        this.read_char(fileReader);
                    }
                    this.read_char(fileReader);
                    bl = this.CurrentChar == '/';
                }
                this.read_char(fileReader);
                this.jump_space(fileReader);
            } else {
                return "/";
            }
        }
        this.StartLine = this.CrtLine;
        if (this.CurrentChar == ':' || this.CurrentChar == '/' || this.CurrentChar == ',' || this.CurrentChar == '\\' || this.CurrentChar == '-' && this.NextChar == '>') {
            if (this.CurrentChar != '-') {
                stringBuffer.append(this.CurrentChar);
            } else {
                stringBuffer.append(this.CurrentChar);
                this.read_char(fileReader);
                stringBuffer.append(this.CurrentChar);
            }
            this.read_char(fileReader);
            return stringBuffer.toString();
        }
        if (this.CurrentChar == '\"') {
            this.read_char(fileReader);
            while (this.CurrentChar != '\"' && this.CurrentChar != '\u0000' && this.CurrentChar != '\n') {
                stringBuffer.append(this.CurrentChar);
                this.read_char(fileReader);
            }
            if (this.CurrentChar == '\u0000' || this.CurrentChar == '\n') {
                IOException iOException = new IOException("String too long at line " + this.StartLine);
                throw iOException;
            }
            this.read_char(fileReader);
            return stringBuffer.toString();
        }
        while (this.CurrentChar > ' ' && this.CurrentChar != ':' && this.CurrentChar != '/' && this.CurrentChar != '\\' && this.CurrentChar != ',' && (this.CurrentChar != '-' || this.NextChar != '>')) {
            stringBuffer.append(this.CurrentChar);
            this.read_char(fileReader);
        }
        if (stringBuffer.length() == 0) {
            return null;
        }
        return stringBuffer.toString();
    }

    private String read_full_word(FileReader fileReader) throws IOException {
        String string = "";
        this.StartLine = this.CrtLine;
        this.jump_space(fileReader);
        if (this.CurrentChar == ',' || this.CurrentChar == '\\') {
            string = string + this.CurrentChar;
            this.read_char(fileReader);
            return string;
        }
        if (this.CurrentChar == '\"') {
            this.read_char(fileReader);
            while (this.CurrentChar != '\"' && this.CurrentChar != '\u0000' && this.CurrentChar != '\n') {
                string = string + this.CurrentChar;
                this.read_char(fileReader);
            }
            if (this.CurrentChar == '\u0000' || this.CurrentChar == '\n') {
                IOException iOException = new IOException("String too long at line " + this.StartLine);
                throw iOException;
            }
            this.read_char(fileReader);
            return string;
        }
        while (this.CurrentChar > ' ' && this.CurrentChar != '\\' && this.CurrentChar != ',') {
            string = string + this.CurrentChar;
            this.read_char(fileReader);
        }
        if (string.length() == 0) {
            return null;
        }
        return string;
    }

    private int class_lex(String string) {
        if (string == null) {
            return 0;
        }
        if (string.length() == 0) {
            return 2;
        }
        if (string.equals("/")) {
            return 5;
        }
        if (string.equals("\\")) {
            return 6;
        }
        if (string.equals(",")) {
            return 3;
        }
        if (string.equals(":")) {
            return 4;
        }
        if (string.equals("->")) {
            return 7;
        }
        return 2;
    }

    private DbDatum[] makeDbDatum(String string, String[] stringArray) {
        DbDatum[] dbDatumArray = new DbDatum[1];
        this.DELETE_ENTRY = false;
        if (stringArray.length == 0) {
            throw new IllegalStateException("Unexpected empty value");
        }
        if (stringArray.length == 1) {
            dbDatumArray[0] = new DbDatum(string, stringArray[0]);
            this.DELETE_ENTRY = stringArray[0].compareTo("%") == 0;
        } else {
            dbDatumArray[0] = new DbDatum(string, stringArray);
        }
        return dbDatumArray;
    }

    private void checkAttDatum(String[] stringArray) {
        this.DELETE_ENTRY = false;
        if (stringArray.length == 0) {
            throw new IllegalStateException("Unexpected empty value");
        }
        if (stringArray.length == 1) {
            this.DELETE_ENTRY = stringArray[0].compareTo("%") == 0;
        }
    }

    private String prtValue(String[] stringArray) {
        String string = ": ";
        for (int i = 0; i < stringArray.length; ++i) {
            string = string + stringArray[i];
            if (i >= stringArray.length - 1) continue;
            string = string + ',';
        }
        return string;
    }

    private void put_tango_dev_attr_prop(String string, String string2, String string3, String[] stringArray) throws DevFailed {
        this.checkAttDatum(stringArray);
        DbAttribute dbAttribute = new DbAttribute(string2);
        if (stringArray.length == 0) {
            throw new IllegalStateException("Unexpected empty value");
        }
        if (stringArray.length == 1) {
            dbAttribute.add(string3, stringArray[0]);
        } else {
            dbAttribute.add(string3, stringArray);
        }
        if (this.DELETE_ENTRY) {
            this.db.delete_device_attribute_property(string, dbAttribute);
        } else {
            this.db.put_device_attribute_property(string, dbAttribute);
        }
    }

    private void put_tango_class_attr_prop(String string, String string2, String string3, String[] stringArray) throws DevFailed {
        this.checkAttDatum(stringArray);
        DbAttribute dbAttribute = new DbAttribute(string2);
        if (stringArray.length == 0) {
            throw new IllegalStateException("Unexpected empty value");
        }
        if (stringArray.length == 1) {
            dbAttribute.add(string3, stringArray[0]);
        } else {
            dbAttribute.add(string3, stringArray);
        }
        if (!this.DELETE_ENTRY) {
            this.db.put_class_attribute_property(string, dbAttribute);
        }
    }

    private void put_tango_res(String string, String string2, String[] stringArray) throws DevFailed {
        DbDatum[] dbDatumArray = this.makeDbDatum(string2, stringArray);
        if (this.DELETE_ENTRY) {
            this.db.delete_device_property(string, dbDatumArray);
        } else {
            this.db.put_device_property(string, dbDatumArray);
        }
    }

    private void put_free_tango_res(String string, String string2, String[] stringArray) throws DevFailed {
        DbDatum[] dbDatumArray = this.makeDbDatum(string2, stringArray);
        if (this.DELETE_ENTRY) {
            this.db.delete_property(string, dbDatumArray);
        } else {
            this.db.put_property(string, dbDatumArray);
        }
    }

    private void put_tango_res_class(String string, String string2, String[] stringArray) throws DevFailed {
        DbDatum[] dbDatumArray = this.makeDbDatum(string2, stringArray);
        if (this.DELETE_ENTRY) {
            this.db.delete_class_property(string, dbDatumArray);
        } else {
            this.db.put_class_property(string, dbDatumArray);
        }
    }

    private boolean IsMember(String string, String[] stringArray) {
        int n = 0;
        boolean bl = false;
        while (n < stringArray.length && !bl) {
            bl = stringArray[n].equalsIgnoreCase(string);
            if (bl) continue;
            ++n;
        }
        return bl;
    }

    private void add_tango_devices(String string, String string2, String[] stringArray) throws DevFailed {
        int n;
        String[] stringArray2 = this.db.get_device_name(string2, string);
        for (n = 0; n < stringArray.length; ++n) {
            if (this.IsMember(stringArray[n], stringArray2)) continue;
            this.db.add_device(stringArray[n], string, string2);
        }
        for (n = 0; n < stringArray2.length; ++n) {
            if (this.IsMember(stringArray2[n], stringArray)) continue;
            this.db.delete_device(stringArray2[n]);
        }
    }

    private void CHECK_LEX(int n, int n2) {
        if (n != n2) {
            throw new IllegalStateException("Error at line " + this.StartLine + ", " + this.lexical_word[n2] + " expected");
        }
    }

    private String[] parse_resource_value(FileReader fileReader) throws IOException {
        String[] stringArray = new String[1024];
        int n = 3;
        int n2 = 0;
        while ((n == 3 || n == 6) && this.word != null) {
            this.word = this.read_full_word(fileReader);
            n = this.class_lex(this.word);
            if (n == 6) {
                this.word = this.read_full_word(fileReader);
                n = this.class_lex(this.word);
            }
            this.CHECK_LEX(n, 2);
            stringArray[n2] = this.word;
            ++n2;
            this.word = this.read_word(fileReader);
            n = this.class_lex(this.word);
        }
        String[] stringArray2 = new String[n2];
        for (int i = 0; i < n2; ++i) {
            stringArray2[i] = stringArray[i];
        }
        return stringArray2;
    }

    public String parse_res_file(String string) {
        boolean bl = false;
        this.CrtLine = 1;
        this.NextChar = (char)32;
        this.CurrentChar = (char)32;
        try {
            FileReader fileReader = new FileReader(string);
            this.word = this.read_word(fileReader);
            if (this.word == null) {
                return string + " is empty...";
            }
            int n = this.class_lex(this.word);
            while (!bl) {
                block1 : switch (n) {
                    case 2: {
                        String string2 = this.word;
                        this.word = this.read_word(fileReader);
                        n = this.class_lex(this.word);
                        this.CHECK_LEX(n, 5);
                        this.word = this.read_word(fileReader);
                        n = this.class_lex(this.word);
                        this.CHECK_LEX(n, 2);
                        String string3 = this.word;
                        this.word = this.read_word(fileReader);
                        n = this.class_lex(this.word);
                        switch (n) {
                            case 5: {
                                String[] stringArray;
                                this.word = this.read_word(fileReader);
                                n = this.class_lex(this.word);
                                this.CHECK_LEX(n, 2);
                                String string4 = this.word;
                                this.word = this.read_word(fileReader);
                                n = this.class_lex(this.word);
                                switch (n) {
                                    case 5: {
                                        String string5;
                                        this.word = this.read_word(fileReader);
                                        n = this.class_lex(this.word);
                                        this.CHECK_LEX(n, 2);
                                        String string6 = this.word;
                                        this.word = this.read_word(fileReader);
                                        n = this.class_lex(this.word);
                                        switch (n) {
                                            case 4: {
                                                stringArray = this.parse_resource_value(fileReader);
                                                n = this.class_lex(this.word);
                                                if (!string4.equalsIgnoreCase("device")) break block1;
                                                this.add_tango_devices(string6, string2 + "/" + string3, stringArray);
                                                break block1;
                                            }
                                            case 7: {
                                                this.word = this.read_word(fileReader);
                                                n = this.class_lex(this.word);
                                                this.CHECK_LEX(n, 2);
                                                string5 = this.word;
                                                this.word = this.read_word(fileReader);
                                                n = this.class_lex(this.word);
                                                this.CHECK_LEX(n, 4);
                                                stringArray = this.parse_resource_value(fileReader);
                                                n = this.class_lex(this.word);
                                                this.put_tango_dev_attr_prop(string2 + "/" + string3 + "/" + string4, string6, string5, stringArray);
                                                break block1;
                                            }
                                            default: {
                                                return "COLON or -> expected at line " + this.StartLine;
                                            }
                                        }
                                    }
                                    case 7: {
                                        this.word = this.read_word(fileReader);
                                        n = this.class_lex(this.word);
                                        this.CHECK_LEX(n, 2);
                                        String string5 = this.word;
                                        this.word = this.read_word(fileReader);
                                        n = this.class_lex(this.word);
                                        if (n == 5) {
                                            this.word = this.read_word(fileReader);
                                            n = this.class_lex(this.word);
                                            this.CHECK_LEX(n, 2);
                                            string5 = string5 + "/" + this.word;
                                            this.word = this.read_word(fileReader);
                                            n = this.class_lex(this.word);
                                        }
                                        this.CHECK_LEX(n, 4);
                                        stringArray = this.parse_resource_value(fileReader);
                                        n = this.class_lex(this.word);
                                        if (string2.equalsIgnoreCase("class")) {
                                            this.put_tango_class_attr_prop(string3, string4, string5, stringArray);
                                            break block1;
                                        }
                                        this.put_tango_res(string2 + "/" + string3 + "/" + string4, string5, stringArray);
                                        break block1;
                                    }
                                    default: {
                                        return "SLASH or -> expected at line " + this.StartLine;
                                    }
                                }
                            }
                            case 7: {
                                this.word = this.read_word(fileReader);
                                n = this.class_lex(this.word);
                                this.CHECK_LEX(n, 2);
                                String string4 = this.word;
                                this.word = this.read_word(fileReader);
                                n = this.class_lex(this.word);
                                String[] stringArray = this.parse_resource_value(fileReader);
                                n = this.class_lex(this.word);
                                if (string2.equalsIgnoreCase("class")) {
                                    this.put_tango_res_class(string3, string4, stringArray);
                                    break block1;
                                }
                                if (string2.equalsIgnoreCase("free")) {
                                    this.put_free_tango_res(string3, string4, stringArray);
                                    break block1;
                                }
                                return "Invlalid class property syntax on " + string2 + "/" + string3 + "/" + string4;
                            }
                            default: {
                                return "SLASH or -> expected at line " + this.StartLine;
                            }
                        }
                    }
                    default: {
                        return "Invalid resource name get " + this.lexical_word[n] + " instead of STRING al line " + this.StartLine;
                    }
                }
                bl = this.word == null;
            }
            return "";
        }
        catch (Exception exception) {
            if (exception instanceof DevFailed) {
                String string7 = "";
                DevFailed devFailed = (DevFailed)((Object)exception);
                for (int i = 0; i < devFailed.errors.length; ++i) {
                    string7 = string7 + "Desc -> " + devFailed.errors[i].desc + "\n";
                    string7 = string7 + "Reason -> " + devFailed.errors[i].reason + "\n";
                    string7 = string7 + "Origin -> " + devFailed.errors[i].origin + "\n";
                }
                return string7;
            }
            return exception.getMessage();
        }
    }
}

