/*
 * Decompiled with CFR 0.152.
 */
package jive;

import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevState;
import fr.esrf.Tango.DevVarDoubleStringArray;
import fr.esrf.Tango.DevVarLongStringArray;
import fr.esrf.TangoApi.CommandInfo;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoDs.TangoConst;
import fr.esrf.tangoatk.widget.util.ATKConstant;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import fr.esrf.tangoatk.widget.util.chart.JLChart;
import fr.esrf.tangoatk.widget.util.chart.JLDataView;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jive.ArgParser;
import jive.CommonPanel;
import jive.ConsolePanel;
import jive.JiveUtils;
import jive.TransferableString;

class CommandPanel
extends JPanel
implements ActionListener,
ListSelectionListener,
TangoConst,
MouseListener,
ClipboardOwner,
DragGestureListener,
DragSourceListener {
    private CommandInfo[] cmdList;
    private ConsolePanel console;
    private DeviceProxy device;
    private CommonPanel common;
    private JList commandList;
    private JScrollPane commandView;
    private JComboBox arginCombo;
    private JLabel arginLabel;
    private JLabel descrLabel;
    private JLabel arginTypeLabel;
    private JTextField arginTypeText;
    private JLabel argoutTypeLabel;
    private JTextField argoutTypeText;
    private JButton argDescrBtn;
    private JButton executeBtn;
    private JButton plotBtn;
    private JFrame chartDlg = null;
    private JLChart chart;
    private JLDataView plotData;
    private JFrame argDescriptionDlg = null;
    private JScrollPane arginDescrView;
    private JScrollPane argoutDescrView;
    private JTextArea arginDescrText;
    private JTextArea argoutDescrText;
    private JPopupMenu copyMenu;
    private JMenuItem copyCommandMenuItem;
    private JMenuItem copyDevCommandMenuItem;

    CommandPanel(DeviceProxy deviceProxy, ConsolePanel consolePanel, CommonPanel commonPanel) throws DevFailed {
        this.setLayout(null);
        this.console = consolePanel;
        this.common = commonPanel;
        this.device = deviceProxy;
        this.cmdList = this.getCommandList();
        DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
        for (int i = 0; i < this.cmdList.length; ++i) {
            defaultListModel.add(i, this.cmdList[i].cmd_name);
        }
        this.commandList = new JList(defaultListModel);
        this.commandList.addListSelectionListener(this);
        this.commandList.addMouseListener(this);
        DragSource dragSource = DragSource.getDefaultDragSource();
        dragSource.createDefaultDragGestureRecognizer(this.commandList, 2, this);
        this.commandView = new JScrollPane(this.commandList);
        this.add(this.commandView);
        this.arginLabel = new JLabel("Argin value");
        this.arginLabel.setFont(ATKConstant.labelFont);
        this.add(this.arginLabel);
        this.descrLabel = new JLabel();
        this.descrLabel.setFont(ATKConstant.labelFont);
        this.descrLabel.setHorizontalAlignment(4);
        this.add(this.descrLabel);
        this.arginCombo = new JComboBox();
        this.arginCombo.setEditable(true);
        this.arginCombo.setFont(ATKConstant.labelFont);
        this.add(this.arginCombo);
        this.arginTypeLabel = new JLabel("Argin Type");
        this.arginTypeLabel.setFont(ATKConstant.labelFont);
        this.add(this.arginTypeLabel);
        this.arginTypeText = new JTextField();
        this.arginTypeText.setMargin(JiveUtils.noMargin);
        this.arginTypeText.setEditable(false);
        this.add(this.arginTypeText);
        this.argDescrBtn = new JButton("Show description");
        this.argDescrBtn.setFont(ATKConstant.labelFont);
        this.argDescrBtn.addActionListener(this);
        this.add(this.argDescrBtn);
        this.argoutTypeLabel = new JLabel("Argout Type");
        this.argoutTypeLabel.setFont(ATKConstant.labelFont);
        this.add(this.argoutTypeLabel);
        this.argoutTypeText = new JTextField();
        this.argoutTypeText.setMargin(JiveUtils.noMargin);
        this.argoutTypeText.setEditable(false);
        this.add(this.argoutTypeText);
        this.argDescrBtn = new JButton("Show description");
        this.argDescrBtn.setFont(ATKConstant.labelFont);
        this.argDescrBtn.addActionListener(this);
        this.add(this.argDescrBtn);
        this.executeBtn = new JButton("Execute");
        this.executeBtn.setFont(ATKConstant.labelFont);
        this.add(this.executeBtn);
        this.executeBtn.addActionListener(this);
        this.plotBtn = new JButton("Plot");
        this.plotBtn.setFont(ATKConstant.labelFont);
        this.add(this.plotBtn);
        this.plotBtn.addActionListener(this);
        this.addComponentListener(new ComponentListener(){

            public void componentHidden(ComponentEvent componentEvent) {
            }

            public void componentMoved(ComponentEvent componentEvent) {
            }

            public void componentResized(ComponentEvent componentEvent) {
                CommandPanel.this.placeComponents(CommandPanel.this.getSize());
            }

            public void componentShown(ComponentEvent componentEvent) {
                CommandPanel.this.placeComponents(CommandPanel.this.getSize());
            }
        });
        this.commandList.setSelectedIndex(0);
        this.copyMenu = new JPopupMenu();
        this.copyCommandMenuItem = new JMenuItem("Copy command");
        this.copyCommandMenuItem.addActionListener(this);
        this.copyMenu.add(this.copyCommandMenuItem);
        this.copyDevCommandMenuItem = new JMenuItem("Copy device->command");
        this.copyDevCommandMenuItem.addActionListener(this);
        this.copyMenu.add(this.copyDevCommandMenuItem);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        int n = this.commandList.getSelectedIndex();
        if (!listSelectionEvent.getValueIsAdjusting()) {
            this.arginCombo.setEnabled(this.cmdList[n].in_type != 0);
            this.descrLabel.setText(this.getExample(this.cmdList[n].in_type));
            this.arginTypeText.setText(Tango_CmdArgTypeName[this.cmdList[n].in_type]);
            this.argoutTypeText.setText(Tango_CmdArgTypeName[this.cmdList[n].out_type]);
            if (this.argDescriptionDlg != null) {
                this.arginDescrText.setText("Argin description:\n" + this.cmdList[n].in_type_desc);
                this.arginDescrText.setCaretPosition(0);
                this.argoutDescrText.setText("Argout description:\n" + this.cmdList[n].out_type_desc);
                this.argoutDescrText.setCaretPosition(0);
                this.arginDescrView.revalidate();
                this.argoutDescrView.revalidate();
            }
            this.plotBtn.setEnabled(this.isPlotable(this.cmdList[n].out_type));
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        Object object = mouseEvent.getSource();
        if (object == this.commandList) {
            if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 2) {
                this.executeCommand();
            }
            if (mouseEvent.getButton() == 3) {
                this.copyMenu.show(this.commandList, mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        dragGestureEvent.startDrag(DragSource.DefaultMoveDrop, new TransferableString(this.getCopyString(false)), this);
    }

    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
    }

    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
        DragSourceContext dragSourceContext = dragSourceDragEvent.getDragSourceContext();
        dragSourceContext.setCursor(DragSource.DefaultMoveDrop);
    }

    public void dragExit(DragSourceEvent dragSourceEvent) {
    }

    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.executeBtn) {
            this.executeCommand();
        } else if (object == this.plotBtn) {
            this.plotCommand();
        } else if (object == this.argDescrBtn) {
            this.showDescription();
        } else if (object == this.copyCommandMenuItem) {
            this.copyCommandToClipboard(true);
        } else if (object == this.copyDevCommandMenuItem) {
            this.copyCommandToClipboard(false);
        }
    }

    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    public Dimension getPreferredSize() {
        return this.getMinimunSize();
    }

    public Dimension getMinimunSize() {
        return new Dimension(470, 210);
    }

    private String getCopyString(boolean bl) {
        String string;
        String string2 = "";
        CommandInfo commandInfo = this.cmdList[this.commandList.getSelectedIndex()];
        string2 = bl ? commandInfo.cmd_name : this.device.get_name() + "->" + commandInfo.cmd_name;
        if (this.arginCombo.isEnabled() && (string = (String)this.arginCombo.getEditor().getItem()) != null && string.length() > 0) {
            this.addArgin(string);
            string2 = string2 + "(" + string + ")";
        }
        return string2;
    }

    private void copyCommandToClipboard(boolean bl) {
        StringSelection stringSelection = new StringSelection(this.getCopyString(bl));
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(stringSelection, this);
    }

    private CommandInfo[] getCommandList() throws DevFailed {
        CommandInfo[] commandInfoArray = this.device.command_list_query();
        boolean bl = false;
        int n = commandInfoArray.length - 1;
        while (!bl) {
            bl = true;
            for (int i = 0; i < n; ++i) {
                if (commandInfoArray[i].cmd_name.compareToIgnoreCase(commandInfoArray[i + 1].cmd_name) <= 0) continue;
                bl = false;
                CommandInfo commandInfo = commandInfoArray[i];
                commandInfoArray[i] = commandInfoArray[i + 1];
                commandInfoArray[i + 1] = commandInfo;
            }
            --n;
        }
        return commandInfoArray;
    }

    private boolean isPlotable(int n) {
        switch (n) {
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                return true;
            }
        }
        return false;
    }

    private void placeComponents(Dimension dimension) {
        this.arginLabel.setBounds(10, 0, 80, 20);
        this.descrLabel.setBounds(90, 0, dimension.width - 100, 20);
        this.arginCombo.setBounds(10, 20, dimension.width - 20, 25);
        this.commandView.setBounds(10, 50, 190, dimension.height - 60);
        this.commandView.revalidate();
        int n = (dimension.width - 220) / 2;
        this.arginTypeLabel.setBounds(205, 50, n, 20);
        this.arginTypeText.setBounds(205, 70, n, 25);
        this.argoutTypeLabel.setBounds(210 + n, 50, n, 20);
        this.argoutTypeText.setBounds(210 + n, 70, n, 25);
        int n2 = 200;
        int n3 = (dimension.width - 220 - n2) / 2;
        this.argDescrBtn.setBounds(205 + n3, dimension.height - 105, n2, 25);
        this.executeBtn.setBounds(205 + n3, dimension.height - 70, n2, 25);
        this.plotBtn.setBounds(205 + n3, dimension.height - 35, n2, 25);
    }

    private void addArgin(String string) {
        boolean bl = false;
        int n = 0;
        while (n < this.arginCombo.getItemCount() && !bl) {
            bl = string.equals(this.arginCombo.getItemAt(n).toString());
            if (bl) continue;
            ++n;
        }
        if (!bl) {
            this.arginCombo.addItem(string);
        }
    }

    private void plotCommand() {
        try {
            CommandInfo commandInfo = this.cmdList[this.commandList.getSelectedIndex()];
            String string = (String)this.arginCombo.getSelectedItem();
            if (string != null) {
                this.addArgin(string);
            }
            DeviceData deviceData = new DeviceData();
            this.insertData(string, deviceData, commandInfo.in_type);
            String string2 = commandInfo.cmd_name;
            DeviceData deviceData2 = this.device.command_inout(string2, deviceData);
            double[] dArray = this.extractPlotData(deviceData2, commandInfo.out_type);
            if (this.chartDlg == null) {
                this.chart = new JLChart();
                this.chart.setPreferredSize(new Dimension(640, 480));
                this.plotData = new JLDataView();
                this.chart.getY1Axis().addDataView(this.plotData);
                this.chart.getY1Axis().setAutoScale(true);
                this.chart.getXAxis().setAnnotation(2);
                this.chartDlg = new JFrame("Plot command [" + this.device.name() + "]");
                this.chartDlg.setContentPane((Container)this.chart);
            }
            this.plotData.reset();
            this.plotData.setName(string2);
            for (int i = 0; i < dArray.length; ++i) {
                this.plotData.add((double)i, dArray[i]);
            }
            this.chart.repaint();
            if (!this.chartDlg.isVisible()) {
                ATKGraphicsUtils.centerFrameOnScreen((Frame)this.chartDlg);
                this.chartDlg.setVisible(true);
            }
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(this, "Invalid argin syntaxt\n" + numberFormatException.getMessage());
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)this, (String)this.device.name(), (DevFailed)devFailed);
        }
    }

    private void executeCommand() {
        try {
            CommandInfo commandInfo = this.cmdList[this.commandList.getSelectedIndex()];
            String string = (String)this.arginCombo.getSelectedItem();
            if (string != null) {
                this.addArgin(string);
            }
            DeviceData deviceData = new DeviceData();
            this.insertData(string, deviceData, commandInfo.in_type);
            String string2 = commandInfo.cmd_name;
            long l = System.currentTimeMillis();
            DeviceData deviceData2 = this.device.command_inout(string2, deviceData);
            long l2 = System.currentTimeMillis();
            this.console.print("----------------------------------------------------\n");
            this.console.print("Command: " + this.device.name() + "/" + string2 + "\n");
            this.console.print("Duration: " + (l2 - l) + " msec\n");
            if (commandInfo.out_type == 0) {
                this.console.print("Command OK\n");
            } else {
                this.console.print("Output argument(s) :\n");
                this.console.print(this.extractData(deviceData2, commandInfo.out_type));
            }
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(this, "Invalid argin syntaxt\n" + numberFormatException.getMessage());
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)this, (String)this.device.name(), (DevFailed)devFailed);
        }
    }

    private String getExample(int n) {
        String string = new String("Ex: ");
        switch (n) {
            case 0: {
                string = new String("");
                break;
            }
            case 19: {
                string = string + "0 (16bits value)";
                break;
            }
            case 1: {
                string = string + "true,false or 0,1";
                break;
            }
            case 22: {
                string = string + "10 or 0xa (unsigned 8bits)";
                break;
            }
            case 6: {
                string = string + "10 or 0xa (unsigned 16bits)";
                break;
            }
            case 2: {
                string = string + "10 or 0xa (signed 16bits)";
                break;
            }
            case 7: {
                string = string + "10 or 0xa (unsigned 32bits)";
                break;
            }
            case 3: {
                string = string + "10 or 0xa (signed 32bits)";
                break;
            }
            case 4: {
                string = string + "2.3 (32bits float)";
                break;
            }
            case 5: {
                string = string + "2.3 (64bits float)";
                break;
            }
            case 8: {
                string = "quotes needed for string with space or special char";
                break;
            }
            case 9: {
                string = string + "2,0xa,'A' (signed 8bits)";
                break;
            }
            case 14: {
                string = string + "2,0xa,4 (unsigned 16bits)";
                break;
            }
            case 10: {
                string = string + "2,0xa,4 (signed 16bits)";
                break;
            }
            case 15: {
                string = string + "2,0xa,4 (unsigned 32bits)";
                break;
            }
            case 11: {
                string = string + "2,0xa,4 (signed 32bits)";
                break;
            }
            case 12: {
                string = string + "2.3,4 (32bits floats)";
                break;
            }
            case 13: {
                string = string + "2.3,4 (64bits floats)";
                break;
            }
            case 16: {
                string = string + "Dance,\"the TANGO\" (quotes needed for string with space or special char)";
                break;
            }
            case 17: {
                string = string + "[1,2][A,\"B C\",D] (quotes needed for string with space or special char)";
                break;
            }
            case 18: {
                string = "[1.0,2.0][A,\"B C\",D] (quotes needed for string with space or special char)";
                break;
            }
            default: {
                string = new String("");
            }
        }
        return string;
    }

    private int getLimitMax(StringBuffer stringBuffer, int n) {
        stringBuffer.append("array length: " + n + "\n");
        if (n > this.common.getAnswerLimitMax()) {
            stringBuffer.append("Array cannot be fully displayed. (You may change the AnswerLimitMax)\n");
            return this.common.getAnswerLimitMax();
        }
        return n;
    }

    private int getLimitMin(StringBuffer stringBuffer, int n) {
        if (n <= this.common.getAnswerLimitMin()) {
            stringBuffer.append("Array cannot be displayed. (You may change the AnswerLimitMin)\n");
            return n;
        }
        return this.common.getAnswerLimitMin();
    }

    private int getLimitMaxForPlot(int n) {
        if (n > this.common.getAnswerLimitMax()) {
            return this.common.getAnswerLimitMax();
        }
        return n;
    }

    private int getLimitMinForPlot(int n) {
        if (n <= this.common.getAnswerLimitMin()) {
            return n;
        }
        return this.common.getAnswerLimitMin();
    }

    private void insertData(String string, DeviceData deviceData, int n) throws NumberFormatException {
        if (n == 0) {
            return;
        }
        ArgParser argParser = new ArgParser(string);
        switch (n) {
            case 1: {
                deviceData.insert(argParser.parse_boolean());
                break;
            }
            case 6: {
                deviceData.insert_us(argParser.parse_ushort());
                break;
            }
            case 2: {
                deviceData.insert(argParser.parse_short());
                break;
            }
            case 7: {
                deviceData.insert_ul(argParser.parse_ulong());
                break;
            }
            case 3: {
                deviceData.insert(argParser.parse_long());
                break;
            }
            case 4: {
                deviceData.insert(argParser.parse_float());
                break;
            }
            case 5: {
                deviceData.insert(argParser.parse_double());
                break;
            }
            case 8: {
                deviceData.insert(argParser.parse_string());
                break;
            }
            case 9: {
                deviceData.insert(argParser.parse_char_array());
                break;
            }
            case 14: {
                deviceData.insert_us(argParser.parse_ushort_array());
                break;
            }
            case 10: {
                deviceData.insert(argParser.parse_short_array());
                break;
            }
            case 15: {
                deviceData.insert_ul(argParser.parse_ulong_array());
                break;
            }
            case 11: {
                deviceData.insert(argParser.parse_long_array());
                break;
            }
            case 12: {
                deviceData.insert(argParser.parse_float_array());
                break;
            }
            case 13: {
                deviceData.insert(argParser.parse_double_array());
                break;
            }
            case 16: {
                deviceData.insert(argParser.parse_string_array());
                break;
            }
            case 17: {
                deviceData.insert(new DevVarLongStringArray(argParser.parse_long_array(), argParser.parse_string_array()));
                break;
            }
            case 18: {
                deviceData.insert(new DevVarDoubleStringArray(argParser.parse_double_array(), argParser.parse_string_array()));
                break;
            }
            case 19: {
                deviceData.insert(DevState.from_int((int)argParser.parse_ushort()));
                break;
            }
            default: {
                throw new NumberFormatException("Command type not supported code=" + n);
            }
        }
    }

    private String extractData(DeviceData deviceData, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                stringBuffer.append(Boolean.toString(deviceData.extractBoolean()));
                stringBuffer.append("\n");
                break;
            }
            case 6: {
                stringBuffer.append(Integer.toString(deviceData.extractUShort()));
                stringBuffer.append("\n");
                break;
            }
            case 2: {
                stringBuffer.append(Short.toString(deviceData.extractShort()));
                stringBuffer.append("\n");
                break;
            }
            case 7: {
                stringBuffer.append(Long.toString(deviceData.extractULong()));
                stringBuffer.append("\n");
                break;
            }
            case 3: {
                stringBuffer.append(Integer.toString(deviceData.extractLong()));
                stringBuffer.append("\n");
                break;
            }
            case 4: {
                stringBuffer.append(Float.toString(deviceData.extractFloat()));
                stringBuffer.append("\n");
                break;
            }
            case 5: {
                stringBuffer.append(Double.toString(deviceData.extractDouble()));
                stringBuffer.append("\n");
                break;
            }
            case 8: {
                stringBuffer.append(deviceData.extractString());
                stringBuffer.append("\n");
                break;
            }
            case 9: {
                byte[] byArray = deviceData.extractByteArray();
                int n2 = this.getLimitMin(stringBuffer, byArray.length);
                int n3 = this.getLimitMax(stringBuffer, byArray.length);
                for (int i = n2; i < n3; ++i) {
                    stringBuffer.append("[" + i + "]\t " + Integer.toString(byArray[i]));
                    if (byArray[i] >= 32) {
                        stringBuffer.append(" '" + new Character((char)byArray[i]).toString() + "'");
                    } else {
                        stringBuffer.append(" '.'");
                    }
                    stringBuffer.append("\n");
                }
                break;
            }
            case 14: {
                int[] nArray = deviceData.extractUShortArray();
                int n4 = this.getLimitMin(stringBuffer, nArray.length);
                int n5 = this.getLimitMax(stringBuffer, nArray.length);
                for (int i = n4; i < n5; ++i) {
                    stringBuffer.append("[" + i + "]\t " + Integer.toString(nArray[i]) + "\n");
                }
                break;
            }
            case 10: {
                short[] sArray = deviceData.extractShortArray();
                int n6 = this.getLimitMin(stringBuffer, sArray.length);
                int n7 = this.getLimitMax(stringBuffer, sArray.length);
                for (int i = n6; i < n7; ++i) {
                    stringBuffer.append("[" + i + "]\t " + Short.toString(sArray[i]) + "\n");
                }
                break;
            }
            case 15: {
                long[] lArray = deviceData.extractULongArray();
                int n8 = this.getLimitMin(stringBuffer, lArray.length);
                int n9 = this.getLimitMax(stringBuffer, lArray.length);
                for (int i = n8; i < n9; ++i) {
                    stringBuffer.append("[" + i + "]\t " + Long.toString(lArray[i]) + "\n");
                }
                break;
            }
            case 11: {
                int[] nArray = deviceData.extractLongArray();
                int n10 = this.getLimitMin(stringBuffer, nArray.length);
                int n11 = this.getLimitMax(stringBuffer, nArray.length);
                for (int i = n10; i < n11; ++i) {
                    stringBuffer.append("[" + i + "]\t " + Integer.toString(nArray[i]) + "\n");
                }
                break;
            }
            case 12: {
                float[] fArray = deviceData.extractFloatArray();
                int n12 = this.getLimitMin(stringBuffer, fArray.length);
                int n13 = this.getLimitMax(stringBuffer, fArray.length);
                for (int i = n12; i < n13; ++i) {
                    stringBuffer.append("[" + i + "]\t " + Float.toString(fArray[i]) + "\n");
                }
                break;
            }
            case 13: {
                double[] dArray = deviceData.extractDoubleArray();
                int n14 = this.getLimitMin(stringBuffer, dArray.length);
                int n15 = this.getLimitMax(stringBuffer, dArray.length);
                for (int i = n14; i < n15; ++i) {
                    stringBuffer.append("[" + i + "]\t" + Double.toString(dArray[i]) + "\n");
                }
                break;
            }
            case 16: {
                String[] stringArray = deviceData.extractStringArray();
                int n16 = this.getLimitMin(stringBuffer, stringArray.length);
                int n17 = this.getLimitMax(stringBuffer, stringArray.length);
                for (int i = n16; i < n17; ++i) {
                    stringBuffer.append("[" + i + "]\t " + stringArray[i] + "\n");
                }
                break;
            }
            case 17: {
                int n18;
                DevVarLongStringArray devVarLongStringArray = deviceData.extractLongStringArray();
                int n19 = this.getLimitMin(stringBuffer, devVarLongStringArray.lvalue.length);
                int n20 = this.getLimitMax(stringBuffer, devVarLongStringArray.lvalue.length);
                stringBuffer.append("lvalue:\n");
                for (n18 = n19; n18 < n20; ++n18) {
                    stringBuffer.append("[" + n18 + "]\t " + Integer.toString(devVarLongStringArray.lvalue[n18]) + "\n");
                }
                n19 = this.getLimitMin(stringBuffer, devVarLongStringArray.svalue.length);
                n20 = this.getLimitMax(stringBuffer, devVarLongStringArray.svalue.length);
                stringBuffer.append("svalue:\n");
                for (n18 = n19; n18 < n20; ++n18) {
                    stringBuffer.append("[" + n18 + "]\t " + devVarLongStringArray.svalue[n18] + "\n");
                }
                break;
            }
            case 18: {
                int n21;
                DevVarDoubleStringArray devVarDoubleStringArray = deviceData.extractDoubleStringArray();
                int n22 = this.getLimitMin(stringBuffer, devVarDoubleStringArray.dvalue.length);
                int n23 = this.getLimitMax(stringBuffer, devVarDoubleStringArray.dvalue.length);
                stringBuffer.append("dvalue:\n");
                for (n21 = n22; n21 < n23; ++n21) {
                    stringBuffer.append("[" + n21 + "]\t " + Double.toString(devVarDoubleStringArray.dvalue[n21]) + "\n");
                }
                n22 = this.getLimitMin(stringBuffer, devVarDoubleStringArray.svalue.length);
                n23 = this.getLimitMax(stringBuffer, devVarDoubleStringArray.svalue.length);
                stringBuffer.append("svalue:\n");
                for (n21 = n22; n21 < n23; ++n21) {
                    stringBuffer.append("[" + n21 + "]\t " + devVarDoubleStringArray.svalue[n21] + "\n");
                }
                break;
            }
            case 19: {
                stringBuffer.append(Tango_DevStateName[deviceData.extractDevState().value()]);
                stringBuffer.append("\n");
                break;
            }
            default: {
                stringBuffer.append("Unsupported command type code=" + n);
                stringBuffer.append("\n");
            }
        }
        return stringBuffer.toString();
    }

    private double[] extractPlotData(DeviceData deviceData, int n) {
        double[] dArray = new double[]{};
        switch (n) {
            case 9: {
                byte[] byArray = deviceData.extractByteArray();
                int n2 = this.getLimitMinForPlot(byArray.length);
                int n3 = this.getLimitMaxForPlot(byArray.length);
                dArray = new double[n3 - n2];
                for (int i = n2; i < n3; ++i) {
                    dArray[i - n2] = byArray[i];
                }
                break;
            }
            case 14: {
                int[] nArray = deviceData.extractUShortArray();
                int n4 = this.getLimitMinForPlot(nArray.length);
                int n5 = this.getLimitMaxForPlot(nArray.length);
                dArray = new double[n5 - n4];
                for (int i = n4; i < n5; ++i) {
                    dArray[i - n4] = nArray[i];
                }
                break;
            }
            case 10: {
                short[] sArray = deviceData.extractShortArray();
                int n6 = this.getLimitMinForPlot(sArray.length);
                int n7 = this.getLimitMaxForPlot(sArray.length);
                dArray = new double[n7 - n6];
                for (int i = n6; i < n7; ++i) {
                    dArray[i - n6] = sArray[i];
                }
                break;
            }
            case 15: {
                long[] lArray = deviceData.extractULongArray();
                int n8 = this.getLimitMinForPlot(lArray.length);
                int n9 = this.getLimitMaxForPlot(lArray.length);
                dArray = new double[n9 - n8];
                for (int i = n8; i < n9; ++i) {
                    dArray[i - n8] = lArray[i];
                }
                break;
            }
            case 11: {
                int[] nArray = deviceData.extractLongArray();
                int n10 = this.getLimitMinForPlot(nArray.length);
                int n11 = this.getLimitMaxForPlot(nArray.length);
                dArray = new double[n11 - n10];
                for (int i = n10; i < n11; ++i) {
                    dArray[i - n10] = nArray[i];
                }
                break;
            }
            case 12: {
                float[] fArray = deviceData.extractFloatArray();
                int n12 = this.getLimitMinForPlot(fArray.length);
                int n13 = this.getLimitMaxForPlot(fArray.length);
                dArray = new double[n13 - n12];
                for (int i = n12; i < n13; ++i) {
                    dArray[i - n12] = fArray[i];
                }
                break;
            }
            case 13: {
                double[] dArray2 = deviceData.extractDoubleArray();
                int n14 = this.getLimitMinForPlot(dArray2.length);
                int n15 = this.getLimitMaxForPlot(dArray2.length);
                dArray = new double[n15 - n14];
                for (int i = n14; i < n15; ++i) {
                    dArray[i - n14] = dArray2[i];
                }
                break;
            }
        }
        return dArray;
    }

    private void showDescription() {
        if (this.argDescriptionDlg == null) {
            JSplitPane jSplitPane = new JSplitPane(0);
            this.arginDescrText = new JTextArea();
            this.arginDescrText.setEditable(false);
            this.arginDescrView = new JScrollPane(this.arginDescrText);
            this.arginDescrView.setHorizontalScrollBarPolicy(32);
            this.arginDescrView.setVerticalScrollBarPolicy(22);
            jSplitPane.setTopComponent(this.arginDescrView);
            this.argoutDescrText = new JTextArea();
            this.argoutDescrText.setEditable(false);
            this.argoutDescrView = new JScrollPane(this.argoutDescrText);
            this.argoutDescrView.setHorizontalScrollBarPolicy(32);
            this.argoutDescrView.setVerticalScrollBarPolicy(22);
            jSplitPane.setBottomComponent(this.argoutDescrView);
            this.argoutDescrText.setPreferredSize(new Dimension(400, 150));
            this.arginDescrText.setPreferredSize(new Dimension(400, 150));
            this.argDescriptionDlg = new JFrame("Command description [" + this.device.name() + "]");
            this.argDescriptionDlg.setContentPane(jSplitPane);
        }
        int n = this.commandList.getSelectedIndex();
        this.arginDescrText.setText("Argin description:\n" + this.cmdList[n].in_type_desc);
        this.argoutDescrText.setText("Argout description:\n" + this.cmdList[n].out_type_desc);
        if (!this.argDescriptionDlg.isVisible()) {
            ATKGraphicsUtils.centerFrameOnScreen((Frame)this.argDescriptionDlg);
            this.argDescriptionDlg.setVisible(true);
        } else {
            this.argDescriptionDlg.toFront();
        }
    }
}

