/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.tools;

import admin.astor.AstorUtil;
import admin.astor.tools.PingHosts;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.DbServer;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class UnAvailableHostsDialog
extends JDialog {
    private JFrame parent;
    private ArrayList<String> stoppedHosts;
    private JPanel centerPanel;

    public UnAvailableHostsDialog(JFrame jFrame) throws DevFailed {
        super((Frame)jFrame, true);
        this.parent = jFrame;
        this.initComponents();
        AstorUtil.startSplash("Pinging crates.....");
        String[] stringArray = AstorUtil.getInstance().getHostControlledList();
        PingHosts pingHosts = new PingHosts(stringArray);
        this.stoppedHosts = pingHosts.getStopped();
        int n = 0;
        int n2 = 0;
        for (String string : this.stoppedHosts) {
            JButton jButton = new JButton(string);
            jButton.setBackground(Color.red);
            jButton.setForeground(Color.white);
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    UnAvailableHostsDialog.this.hostBtnActionPerformed(actionEvent);
                }
            });
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = n++;
            gridBagConstraints.gridy = n2++;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(10, 10, 10, 10);
            this.centerPanel.add((Component)jButton, gridBagConstraints);
            if (n != 4) continue;
            n = 0;
        }
        this.pack();
        ATKGraphicsUtils.centerDialog((Dialog)this);
        AstorUtil.stopSplash();
    }

    private void initComponents() {
        JPanel jPanel = new JPanel();
        JLabel jLabel = new JLabel();
        this.centerPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JButton jButton = new JButton();
        JButton jButton2 = new JButton();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                UnAvailableHostsDialog.this.closeDialog(windowEvent);
            }
        });
        jLabel.setFont(new Font("Dialog", 1, 18));
        jLabel.setText("Unreachable Hosts");
        jPanel.add(jLabel);
        this.getContentPane().add((Component)jPanel, "North");
        this.centerPanel.setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.centerPanel, "Center");
        jPanel2.setLayout(new FlowLayout(1, 50, 5));
        jButton.setText("Unexport All ");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UnAvailableHostsDialog.this.unexportAllBtnActionPerformed(actionEvent);
            }
        });
        jPanel2.add(jButton);
        jButton2.setText("Cancel");
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UnAvailableHostsDialog.this.cancelBtnActionPerformed(actionEvent);
            }
        });
        jPanel2.add(jButton2);
        this.getContentPane().add((Component)jPanel2, "South");
        this.pack();
    }

    private void hostBtnActionPerformed(ActionEvent actionEvent) {
        JButton jButton = (JButton)actionEvent.getSource();
        String string = jButton.getText();
        try {
            this.setCursor(new Cursor(3));
            OneHost oneHost = new OneHost(string);
            new PopupText(this, oneHost).setVisible(true);
            this.setCursor(new Cursor(0));
        }
        catch (DevFailed devFailed) {
            this.setCursor(new Cursor(0));
            ErrorPane.showErrorMessage((Component)this, null, (DevFailed)devFailed);
        }
    }

    private void cancelBtnActionPerformed(ActionEvent actionEvent) {
        this.doClose();
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.doClose();
    }

    private void unexportAllBtnActionPerformed(ActionEvent actionEvent) {
        Object[] objectArray = new Object[]{"Un Export", "Next Host", "Cancel"};
        if (JOptionPane.showConfirmDialog(this.parent, "Unexport all devices registered on " + this.stoppedHosts.size() + " hosts ?", "Confirm Dialog", 0) == 0) {
            AstorUtil.startSplash("Un export");
            int n = 100 / this.stoppedHosts.size();
            for (String string : this.stoppedHosts) {
                AstorUtil.increaseSplashProgress(n, "un export devices for " + string);
                try {
                    this.setCursor(new Cursor(3));
                    OneHost oneHost = new OneHost(string);
                    oneHost.unExportDevices();
                    this.setCursor(new Cursor(0));
                }
                catch (DevFailed devFailed) {
                    AstorUtil.stopSplash();
                    this.setCursor(new Cursor(0));
                    ErrorPane.showErrorMessage((Component)this, null, (DevFailed)devFailed);
                }
            }
            AstorUtil.stopSplash();
        }
    }

    private void doClose() {
        this.setVisible(false);
        this.dispose();
        if (this.parent.getWidth() == 0) {
            System.exit(0);
        }
    }

    public static void main(String[] stringArray) {
        try {
            new UnAvailableHostsDialog(new JFrame()).setVisible(true);
        }
        catch (DevFailed devFailed) {
            AstorUtil.stopSplash();
            ErrorPane.showErrorMessage((Component)new Frame(), null, (DevFailed)devFailed);
        }
    }

    public class PopupText
    extends JDialog {
        private OneHost host;
        private JScrollPane jScrollPane1;
        private JTextArea textArea;

        public PopupText(JDialog jDialog, OneHost oneHost) {
            super((Dialog)jDialog, true);
            this.host = oneHost;
            this.initComponents();
            this.textArea.setText(oneHost.toString());
            this.pack();
            ATKGraphicsUtils.centerDialog((Dialog)this);
        }

        private void initComponents() {
            this.jScrollPane1 = new JScrollPane();
            this.textArea = new JTextArea();
            this.textArea.setFont(new Font("monospaced", 1, 12));
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    PopupText.this.closeDialog(windowEvent);
                }
            });
            JButton jButton = new JButton("UnExport devices");
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    PopupText.this.unexportButtonActionPerformed(actionEvent);
                }
            });
            JButton jButton2 = new JButton("Cancel");
            jButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    PopupText.this.cancelButtonActionPerformed(actionEvent);
                }
            });
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new FlowLayout(2, 5, 5));
            jPanel.add(jButton);
            jPanel.add(jButton2);
            this.getContentPane().add((Component)jPanel, "South");
            this.jScrollPane1.setViewportView(this.textArea);
            this.getContentPane().add((Component)this.jScrollPane1, "Center");
        }

        public void setFont(Font font) {
            this.textArea.setFont(font);
        }

        private void unexportButtonActionPerformed(ActionEvent actionEvent) {
            System.out.println("Unexport devices for " + this.host.name);
            try {
                this.setCursor(new Cursor(3));
                this.host.unExportDevices();
                this.setCursor(new Cursor(0));
            }
            catch (DevFailed devFailed) {
                this.setCursor(new Cursor(0));
                ErrorPane.showErrorMessage((Component)this, null, (DevFailed)devFailed);
            }
            this.doClose();
        }

        private void cancelButtonActionPerformed(ActionEvent actionEvent) {
            this.doClose();
        }

        private void closeDialog(WindowEvent windowEvent) {
            this.doClose();
        }

        private void doClose() {
            this.setVisible(false);
            this.dispose();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class OneServer
    extends ArrayList<DeviceProxy> {
        private String name;

        private OneServer(String string) throws DevFailed {
            this.name = string;
            DbServer dbServer = new DbServer(string);
            String[] stringArray = dbServer.get_device_class_list();
            for (int i = 0; i < stringArray.length; ++i) {
                if (i % 2 != 0) continue;
                this.add(new DeviceProxy(stringArray[i]));
            }
        }

        private void unExportDeices() throws DevFailed {
            for (DeviceProxy deviceProxy : this) {
                deviceProxy.unexport_device();
            }
        }

        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(this.name + ":\n");
            for (DeviceProxy deviceProxy : this) {
                stringBuffer.append("\t").append(deviceProxy.name()).append("\n");
            }
            return stringBuffer.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class OneHost
    extends ArrayList<OneServer> {
        private String name;

        private OneHost(String string) throws DevFailed {
            this.name = string;
            DeviceProxy deviceProxy = new DeviceProxy(ApiUtil.get_db_obj().get_name());
            DeviceData deviceData = new DeviceData();
            deviceData.insert(string);
            DeviceData deviceData2 = deviceProxy.command_inout("DbGetHostServersInfo", deviceData);
            String[] stringArray = deviceData2.extractStringArray();
            for (int i = 0; i < stringArray.length; ++i) {
                if (i % 3 != 0) continue;
                this.add(new OneServer(stringArray[i]));
            }
        }

        private void unExportDevices() throws DevFailed {
            for (OneServer oneServer : this) {
                oneServer.unExportDeices();
            }
        }

        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(this.name + ":\n");
            for (OneServer oneServer : this) {
                stringBuffer.append(oneServer).append("\n");
            }
            return stringBuffer.toString();
        }
    }
}

