/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.tools;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class PopupText
extends JDialog {
    private JPanel buttonPanel;
    private JButton cancelButton;
    private JScrollPane jScrollPane1;
    private JTextPane textPane;

    public PopupText(Frame frame, boolean bl) {
        super(frame, bl);
        this.initComponents();
        this.pack();
        try {
            Point point = frame.getLocationOnScreen();
            point.x += 10;
            point.y += 10;
            this.setLocation(point);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public PopupText(JDialog jDialog, boolean bl) {
        super((Dialog)jDialog, bl);
        this.initComponents();
        this.pack();
        try {
            Point point = jDialog.getLocationOnScreen();
            point.x += 10;
            point.y += 10;
            this.setLocation(point);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initComponents() {
        this.buttonPanel = new JPanel();
        this.cancelButton = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.textPane = new JTextPane();
        this.textPane.setFont(new Font("monospaced", 1, 12));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                PopupText.this.closeDialog(windowEvent);
            }
        });
        this.buttonPanel.setLayout(new FlowLayout(2, 5, 5));
        this.cancelButton.setText("Dismiss");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PopupText.this.cancelButtonActionPerformed(actionEvent);
            }
        });
        this.buttonPanel.add(this.cancelButton);
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.jScrollPane1.setViewportView(this.textPane);
        this.getContentPane().add((Component)this.jScrollPane1, "Center");
    }

    public void setFont(Font font) {
        this.textPane.setFont(font);
    }

    private void cancelButtonActionPerformed(ActionEvent actionEvent) {
        this.doClose();
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.doClose();
    }

    private void doClose() {
        this.setVisible(false);
        this.dispose();
    }

    private void showMsg(String string, SimpleAttributeSet simpleAttributeSet) {
        Document document = this.textPane.getDocument();
        try {
            document.insertString(document.getLength(), string, simpleAttributeSet);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
    }

    public void showFormated(String string) {
        int n;
        int n2 = 0;
        int n3 = 0;
        while ((n = string.indexOf(10, n3)) >= 0) {
            String string2 = string.substring(n3, ++n);
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
            if (string2.indexOf(58) < 0) {
                StyleConstants.setBold(simpleAttributeSet, false);
            } else {
                StyleConstants.setBold(simpleAttributeSet, true);
            }
            int n4 = string2.indexOf("Running");
            if (n4 > 0) {
                this.showMsg(string2.substring(0, n4), simpleAttributeSet);
                StyleConstants.setForeground(simpleAttributeSet, Color.green);
                this.showMsg(string2.substring(n4), simpleAttributeSet);
            } else {
                n4 = string2.indexOf("Stopped");
                if (n4 > 0) {
                    this.showMsg(string2.substring(0, n4), simpleAttributeSet);
                    StyleConstants.setForeground(simpleAttributeSet, Color.red);
                    this.showMsg(string2.substring(n4), simpleAttributeSet);
                } else {
                    StyleConstants.setForeground(simpleAttributeSet, Color.black);
                    this.showMsg(string2, simpleAttributeSet);
                }
            }
            n3 = n;
            ++n2;
        }
        this.textPane.setEditable(false);
        this.textPane.setSize(400, 300);
        this.pack();
        this.setVisible(true);
    }

    public void setTitle(String string) {
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        int n = StyleConstants.getFontSize(simpleAttributeSet);
        StyleConstants.setBold(simpleAttributeSet, true);
        StyleConstants.setUnderline(simpleAttributeSet, true);
        StyleConstants.setFontSize(simpleAttributeSet, n + 4);
        this.showMsg(string + "\n\n", simpleAttributeSet);
    }

    public void show(String string) {
        this.textPane.setText(string);
        this.textPane.setEditable(false);
        this.textPane.setSize(400, 300);
        this.pack();
        this.setVisible(true);
    }

    public void show(String string, String[] stringArray, int n, int n2) {
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        int n3 = StyleConstants.getFontSize(simpleAttributeSet);
        StyleConstants.setBold(simpleAttributeSet, true);
        StyleConstants.setUnderline(simpleAttributeSet, true);
        StyleConstants.setFontSize(simpleAttributeSet, n3 + 4);
        this.showMsg(string + "\n\n", simpleAttributeSet);
        StyleConstants.setBold(simpleAttributeSet, false);
        StyleConstants.setUnderline(simpleAttributeSet, false);
        StyleConstants.setFontSize(simpleAttributeSet, n3);
        for (int i = 0; i < stringArray.length; ++i) {
            this.showMsg(stringArray[i] + "\n", simpleAttributeSet);
        }
        this.textPane.setEditable(false);
        this.textPane.setPreferredSize(new Dimension(n, n2));
        this.pack();
        this.setVisible(true);
    }

    public void show(String string, String[] stringArray) {
        this.show(string, stringArray, 800, 600);
    }

    public void show(String string, int n, int n2) {
        this.textPane.setText(string);
        this.textPane.setEditable(false);
        this.textPane.setPreferredSize(new Dimension(n, n2));
        this.pack();
        this.setVisible(true);
    }

    public void setSize(int n, int n2) {
        this.textPane.setPreferredSize(new Dimension(n, n2));
        this.pack();
    }

    public void addText(String string) {
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        int n = StyleConstants.getFontSize(simpleAttributeSet);
        StyleConstants.setBold(simpleAttributeSet, false);
        StyleConstants.setUnderline(simpleAttributeSet, false);
        StyleConstants.setFontSize(simpleAttributeSet, n);
        this.showMsg(string + "\n", simpleAttributeSet);
        this.textPane.setEditable(false);
    }

    public static void main(String[] stringArray) {
        PopupText popupText = new PopupText((Frame)new JFrame(), true);
        popupText.show("My Title", new String[]{"Line #1", "line #2", "Bla bla bla !"});
    }
}

