/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.tools;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoDs.Except;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;

public class PopupTable
extends JDialog {
    private DataTableModel model;
    private static String[] col_names;
    private String[][] data;
    private Window parent;
    private boolean from_appli = true;
    private boolean sort_available = true;
    private JTable my_table;
    private JScrollPane scrollPane;
    private JPanel jPanel1;
    private JButton cancelBtn;
    private JPanel jPanel2;
    private JLabel titleLabel;

    public PopupTable(JFrame jFrame, String string) throws SecurityException, IOException, DevFailed {
        this(jFrame, string, (Dimension)null);
    }

    public PopupTable(JFrame jFrame, String string, Dimension dimension) throws SecurityException, IOException, DevFailed {
        super((Frame)jFrame, false);
        this.parent = jFrame;
        this.readDataFile(string);
        this.buildObject(string, col_names, this.data, dimension);
        if (jFrame.getWidth() == 0) {
            this.from_appli = false;
        }
    }

    public PopupTable(JFrame jFrame, String string, String string2) throws SecurityException, IOException, DevFailed {
        this(jFrame, string, string2, null);
    }

    public PopupTable(JFrame jFrame, String string, String string2, Dimension dimension) throws SecurityException, IOException, DevFailed {
        super((Frame)jFrame, false);
        this.parent = jFrame;
        this.readDataFile(string2);
        this.buildObject(string, col_names, this.data, dimension);
        if (jFrame.getWidth() == 0) {
            this.from_appli = false;
        }
    }

    public PopupTable(JDialog jDialog, String string, String[] stringArray, String[][] stringArray2) throws DevFailed {
        this(jDialog, string, stringArray, stringArray2, null);
    }

    public PopupTable(JDialog jDialog, String string, String[] stringArray, String[][] stringArray2, Dimension dimension) throws DevFailed {
        super((Dialog)jDialog, false);
        this.parent = jDialog;
        this.buildObject(string, stringArray, stringArray2, dimension);
    }

    public PopupTable(JFrame jFrame, String string, String[] stringArray, String[][] stringArray2) throws DevFailed {
        this(jFrame, string, stringArray, stringArray2, null);
    }

    public PopupTable(JFrame jFrame, String string, String[] stringArray, String[][] stringArray2, Dimension dimension) throws DevFailed {
        super((Frame)jFrame, false);
        this.parent = jFrame;
        this.buildObject(string, stringArray, stringArray2, dimension);
        if (jFrame.getWidth() == 0) {
            this.from_appli = false;
        }
    }

    private void readDataFile(String string) throws SecurityException, IOException, DevFailed {
        FileInputStream fileInputStream = new FileInputStream(string);
        int n = fileInputStream.available();
        byte[] byArray = new byte[n];
        int n2 = fileInputStream.read(byArray);
        if (n2 == 0) {
            return;
        }
        String string2 = new String(byArray);
        fileInputStream.close();
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "\n");
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        System.out.println(arrayList.size() + " lines");
        this.data = new String[arrayList.size() - 1][];
        for (int i = 0; i < arrayList.size(); ++i) {
            int n3;
            String string3 = (String)arrayList.get(i);
            stringTokenizer = new StringTokenizer(string3, "\t");
            if (i == 0) {
                col_names = new String[stringTokenizer.countTokens()];
                n3 = 0;
                while (stringTokenizer.hasMoreTokens()) {
                    PopupTable.col_names[n3] = stringTokenizer.nextToken();
                    ++n3;
                }
                continue;
            }
            this.data[i - 1] = new String[stringTokenizer.countTokens()];
            n3 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                this.data[i - 1][n3] = stringTokenizer.nextToken();
                ++n3;
            }
        }
    }

    private void buildObject(String string, String[] stringArray, String[][] stringArray2, Dimension dimension) throws DevFailed {
        col_names = stringArray;
        this.initComponents();
        this.data = stringArray2;
        this.initMyComponents(dimension);
        this.titleLabel.setText(string);
        if (this.parent.getWidth() > 0) {
            Point point = this.parent.getLocationOnScreen();
            point.x += 10;
            point.y += 10;
            this.setLocation(point);
        }
        this.pack();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.cancelBtn = new JButton();
        this.jPanel2 = new JPanel();
        this.titleLabel = new JLabel();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                PopupTable.this.closeDialog(windowEvent);
            }
        });
        this.cancelBtn.setText("Dismiss");
        this.cancelBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PopupTable.this.cancelBtnActionPerformed(actionEvent);
            }
        });
        this.jPanel1.add(this.cancelBtn);
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.titleLabel.setFont(new Font("Dialog", 1, 18));
        this.titleLabel.setText("Dialog Title");
        this.jPanel2.add(this.titleLabel);
        this.getContentPane().add((Component)this.jPanel2, "North");
        this.pack();
    }

    private void initMyComponents(Dimension dimension) throws DevFailed {
        try {
            this.model = new DataTableModel();
            JTable jTable = new JTable(this.model);
            jTable.setRowSelectionAllowed(true);
            jTable.setColumnSelectionAllowed(true);
            jTable.setDragEnabled(true);
            jTable.setSelectionMode(0);
            jTable.getTableHeader().setFont(new Font("Dialog", 1, 14));
            jTable.getTableHeader().addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    PopupTable.this.tableActionPerformed(mouseEvent);
                }
            });
            this.scrollPane = new JScrollPane(jTable);
            if (dimension == null) {
                int n = 18 + 18 * this.data.length;
                if (n > 400) {
                    n = 400;
                }
                this.scrollPane.setPreferredSize(new Dimension(650, n));
            } else {
                this.scrollPane.setPreferredSize(dimension);
            }
            this.getContentPane().add((Component)this.scrollPane, "Center");
            this.my_table = jTable;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Except.throw_exception((String)"INIT_ERROR", (String)exception.toString(), (String)"PopupTable.initMyComponents()");
        }
        this.model.fireTableDataChanged();
    }

    public void setSortAvailable(boolean bl) {
        this.sort_available = bl;
    }

    private void tableActionPerformed(MouseEvent mouseEvent) {
        int n = this.my_table.getTableHeader().columnAtPoint(new Point(mouseEvent.getX(), mouseEvent.getY()));
        if (this.sort_available) {
            new UsedData().sort(n);
        }
        this.model.fireTableDataChanged();
    }

    public void setColumnWidth(int[] nArray) {
        Enumeration<TableColumn> enumeration = this.my_table.getColumnModel().getColumns();
        int n = 0;
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            tableColumn.setPreferredWidth(nArray[n2]);
            n += nArray[n2];
            ++n2;
        }
        this.scrollPane.setPreferredSize(new Dimension(n, 450));
        this.pack();
    }

    private void cancelBtnActionPerformed(ActionEvent actionEvent) {
        this.doClose();
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.doClose();
    }

    private void doClose() {
        this.setVisible(false);
        this.dispose();
        if (!this.from_appli) {
            System.exit(0);
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.out.println("File's name to find data ?");
            System.exit(0);
        }
        try {
            new PopupTable(new JFrame(), stringArray[0]).setVisible(true);
        }
        catch (Exception exception) {
            ErrorPane.showErrorMessage((Component)new JFrame(), null, (Exception)exception);
            exception.printStackTrace();
            System.exit(0);
        }
    }

    public class DataTableModel
    extends AbstractTableModel {
        public int getColumnCount() {
            return PopupTable.this.data[0].length;
        }

        public int getRowCount() {
            return PopupTable.this.data.length;
        }

        public String getColumnName(int n) {
            if (n >= this.getColumnCount()) {
                return col_names[this.getColumnCount() - 1];
            }
            return col_names[n];
        }

        public Object getValueAt(int n, int n2) {
            return PopupTable.this.data[n][n2];
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class UsedData
    extends ArrayList<String[]> {
        private int column;

        UsedData() {
            for (String[] stringArray : PopupTable.this.data) {
                this.add(stringArray);
            }
        }

        void sort(int n) {
            this.column = n;
            Collections.sort(this, new StringArrayComparator());
            for (int i = 0; i < this.size(); ++i) {
                ((PopupTable)PopupTable.this).data[i] = (String[])this.get(i);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class StringArrayComparator
        implements Comparator<String[]> {
            StringArrayComparator() {
            }

            @Override
            public int compare(String[] stringArray, String[] stringArray2) {
                String string = stringArray[UsedData.this.column];
                String string2 = stringArray2[UsedData.this.column];
                try {
                    double d = Double.parseDouble(string);
                    double d2 = Double.parseDouble(string2);
                    return d > d2 ? 1 : 0;
                }
                catch (NumberFormatException numberFormatException) {
                    return string.compareToIgnoreCase(string2) > 0 ? 1 : 0;
                }
            }
        }
    }
}

