/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.tools;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoApi.DbServer;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoDs.Except;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HostSerialList {
    private int maxLength = 0;
    private ArrayList<SerialDevice> allSerialDeviceNames = new ArrayList();

    public HostSerialList(String string) throws DevFailed {
        String[] stringArray;
        try {
            new DeviceProxy("dserver/starter/" + string);
        }
        catch (DevFailed devFailed) {
            // empty catch block
        }
        for (String string2 : stringArray = this.getServerList(string)) {
            ArrayList<SerialDevice> arrayList = this.getSerialDeviceList(string2);
            for (SerialDevice serialDevice : arrayList) {
                this.allSerialDeviceNames.add(serialDevice);
                if (serialDevice.deviceName.length() <= this.maxLength) continue;
                this.maxLength = serialDevice.deviceName.length();
            }
        }
        Collections.sort(this.allSerialDeviceNames, new SerialCompare());
    }

    private ArrayList<SerialDevice> getSerialDeviceList(String string) throws DevFailed {
        DbServer dbServer = new DbServer(string);
        String[] stringArray = dbServer.get_device_class_list();
        ArrayList<SerialDevice> arrayList = new ArrayList<SerialDevice>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("Serial")) continue;
            arrayList.add(new SerialDevice(stringArray[i - 1]));
        }
        return arrayList;
    }

    private String[] getServerList(String string) throws DevFailed {
        DeviceData deviceData = new DeviceData();
        deviceData.insert(string);
        DeviceData deviceData2 = ApiUtil.get_db_obj().command_inout("DbGetHostServerList", deviceData);
        return deviceData2.extractStringArray();
    }

    public ArrayList<String> getList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (SerialDevice serialDevice : this.allSerialDeviceNames) {
            arrayList.add(serialDevice.toString());
        }
        return arrayList;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (SerialDevice serialDevice : this.allSerialDeviceNames) {
            stringBuilder.append(serialDevice).append('\n');
        }
        return stringBuilder.toString();
    }

    public static void main(String[] stringArray) {
        String string = "l-c29-1";
        if (stringArray.length > 0) {
            string = stringArray[0];
        }
        try {
            HostSerialList hostSerialList = new HostSerialList(string);
            System.out.println(hostSerialList);
        }
        catch (DevFailed devFailed) {
            Except.print_exception((Exception)((Object)devFailed));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class SerialCompare
    implements Comparator<SerialDevice> {
        SerialCompare() {
        }

        @Override
        public int compare(SerialDevice serialDevice, SerialDevice serialDevice2) {
            if (serialDevice.serialNumber == -1) {
                return 0;
            }
            if (serialDevice2.serialNumber == -1) {
                return 0;
            }
            return serialDevice.serialNumber > serialDevice2.serialNumber ? 1 : 0;
        }
    }

    private class SerialDevice {
        private String deviceName;
        private String serialName = "? ? ?";
        private int serialNumber = -1;

        private SerialDevice(String string) throws DevFailed {
            this.deviceName = string;
            DbDatum dbDatum = new DeviceProxy(string).get_property("SerialLine");
            if (!dbDatum.is_empty()) {
                int n;
                this.serialName = dbDatum.extractString();
                for (n = 0; n < this.serialName.length() && !this.isNumber(this.serialName.charAt(n)); ++n) {
                }
                if (n < this.serialName.length()) {
                    String string2 = this.serialName.substring(n);
                    try {
                        this.serialNumber = Integer.parseInt(string2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.err.println(numberFormatException);
                    }
                }
            }
        }

        private boolean isNumber(char c) {
            return c >= '0' && c <= '9';
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(this.deviceName);
            stringBuilder.append(':');
            for (int i = this.deviceName.length(); i < HostSerialList.this.maxLength + 2; ++i) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(this.serialName);
            return stringBuilder.toString();
        }
    }
}

