/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.tools;

import admin.astor.tools.DevPropertyDialog;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DbAttribute;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoApi.DbDevice;
import fr.esrf.TangoApi.DbServer;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoDs.Except;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class DbServerArchitecture
extends JDialog {
    private Component parent;
    private Server server;
    private ServerTree tree;
    static final Dimension dimension = new Dimension(290, 400);
    private JPanel jPanel1;
    private JButton okBtn;
    private JButton cancelBtn;
    private JPanel jPanel2;
    private JLabel titleLabel;

    public DbServerArchitecture(JFrame jFrame, String string) throws DevFailed {
        super((Frame)jFrame, true);
        this.parent = jFrame;
        this.createDialog(string);
    }

    public DbServerArchitecture(JDialog jDialog, String string) throws DevFailed {
        super((Dialog)jDialog, true);
        this.parent = jDialog;
        this.createDialog(string);
    }

    private void createDialog(String string) throws DevFailed {
        new DeviceProxy("dserver/" + string);
        this.initComponents();
        this.setTitle("Server in Database");
        this.titleLabel.setText(string + " architecture");
        this.server = new Server(string);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setPreferredSize(dimension);
        this.tree = new ServerTree(this);
        jScrollPane.add(this.tree);
        jScrollPane.setViewportView(this.tree);
        this.getContentPane().add((Component)jScrollPane, "Center");
        this.okBtn.setVisible(false);
        this.cancelBtn.setText("Dismiss");
        this.pack();
        ATKGraphicsUtils.centerDialog((Dialog)this);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.okBtn = new JButton();
        this.cancelBtn = new JButton();
        this.jPanel2 = new JPanel();
        this.titleLabel = new JLabel();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                DbServerArchitecture.this.closeDialog(windowEvent);
            }
        });
        this.okBtn.setText("OK");
        this.okBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DbServerArchitecture.this.okBtnActionPerformed(actionEvent);
            }
        });
        this.jPanel1.add(this.okBtn);
        this.cancelBtn.setText("Cancel");
        this.cancelBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DbServerArchitecture.this.cancelBtnActionPerformed(actionEvent);
            }
        });
        this.jPanel1.add(this.cancelBtn);
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.titleLabel.setFont(new Font("Dialog", 1, 18));
        this.titleLabel.setText("Dialog Title");
        this.jPanel2.add(this.titleLabel);
        this.getContentPane().add((Component)this.jPanel2, "North");
        this.pack();
    }

    private void okBtnActionPerformed(ActionEvent actionEvent) {
        this.doClose();
    }

    private void cancelBtnActionPerformed(ActionEvent actionEvent) {
        this.doClose();
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.doClose();
    }

    private void doClose() {
        this.setVisible(false);
        this.dispose();
        if (this.parent.getWidth() == 0) {
            System.exit(0);
        }
    }

    public static void main(String[] stringArray) {
        String string = null;
        if (stringArray.length > 0) {
            string = stringArray[0];
        }
        try {
            if (string == null) {
                Except.throw_exception((String)"ServerName_Unknown", (String)"No Server name ?????", (String)"DbServerArchitecture()");
            }
            new DbServerArchitecture(new JFrame(), string).setVisible(true);
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)new JFrame(), (String)"DbServerArchitecture", (DevFailed)devFailed);
            System.exit(0);
        }
    }

    private class ServerRenderer
    extends DefaultTreeCellRenderer {
        private ImageIcon root_icon;
        private ImageIcon server_icon;
        private ImageIcon class_icon;
        private ImageIcon device_icon;
        private ImageIcon list_icon;
        private ImageIcon empty_icon;
        private ImageIcon att_icon;
        private Font[] fonts;
        private static final int ROOT = 0;
        private static final int SERVER = 1;
        private static final int CLASS = 2;
        private static final int DEVICE = 2;
        private static final int ATTR = 3;

        public ServerRenderer() {
            String string = "/admin/astor/images/";
            this.root_icon = new ImageIcon(this.getClass().getResource(string + "server.gif"));
            this.class_icon = new ImageIcon(this.getClass().getResource(string + "class.gif"));
            this.device_icon = new ImageIcon(this.getClass().getResource(string + "device.gif"));
            this.list_icon = new ImageIcon(this.getClass().getResource(string + "greenbal.gif"));
            this.empty_icon = new ImageIcon(this.getClass().getResource(string + "greyball.gif"));
            this.att_icon = new ImageIcon(this.getClass().getResource(string + "uleaf.gif"));
            this.fonts = new Font[4];
            this.fonts[0] = new Font("Dialog", 1, 18);
            this.fonts[1] = new Font("Dialog", 1, 12);
            this.fonts[2] = new Font("Dialog", 0, 12);
            this.fonts[3] = new Font("Dialog", 0, 10);
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            this.setBackgroundNonSelectionColor(Color.white);
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            Object object2 = defaultMutableTreeNode.getUserObject();
            if (n == 0) {
                this.setIcon(this.root_icon);
                this.setBackgroundSelectionColor(Color.white);
                this.setBackgroundNonSelectionColor(Color.white);
                this.setFont(this.fonts[0]);
            } else if (object2 instanceof Server) {
                this.setIcon(this.server_icon);
                this.setFont(this.fonts[1]);
            } else if (object2 instanceof TangoClass) {
                this.setIcon(this.class_icon);
                this.setFont(this.fonts[2]);
            } else if (object2 instanceof TangoDevice) {
                this.setIcon(this.device_icon);
                this.setFont(this.fonts[2]);
            } else if (object2 instanceof String) {
                if (defaultMutableTreeNode.isLeaf()) {
                    this.setIcon(this.empty_icon);
                } else {
                    this.setIcon(this.list_icon);
                }
                this.setFont(this.fonts[3]);
            } else if (object2 instanceof TangoAtt) {
                this.setIcon(this.att_icon);
                this.setFont(this.fonts[3]);
            }
            return this;
        }
    }

    class ServerTree
    extends JTree {
        private JDialog dialog;
        private DefaultTreeModel treeModel;

        public ServerTree(JDialog jDialog) {
            this.dialog = jDialog;
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(((DbServerArchitecture)DbServerArchitecture.this).server.name);
            for (int i = 0; i < ((DbServerArchitecture)DbServerArchitecture.this).server.classes.length; ++i) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(((DbServerArchitecture)DbServerArchitecture.this).server.classes[i]);
                this.craateDeviceNodes(defaultMutableTreeNode2, ((DbServerArchitecture)DbServerArchitecture.this).server.classes[i]);
                defaultMutableTreeNode.add(defaultMutableTreeNode2);
            }
            this.getSelectionModel().setSelectionMode(4);
            this.treeModel = new DefaultTreeModel(defaultMutableTreeNode);
            this.setModel(this.treeModel);
            ToolTipManager.sharedInstance().registerComponent(this);
            this.setCellRenderer(new ServerRenderer());
            this.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    ServerTree.this.treeMouseClicked(mouseEvent);
                }
            });
        }

        private void craateDeviceNodes(DefaultMutableTreeNode defaultMutableTreeNode, TangoClass tangoClass) {
            for (int i = 0; i < tangoClass.devices.length; ++i) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode((Object)tangoClass.devices[i]);
                this.craateAttributeNodes(defaultMutableTreeNode2, tangoClass.devices[i]);
                defaultMutableTreeNode.add(defaultMutableTreeNode2);
            }
        }

        private void craateAttributeNodes(DefaultMutableTreeNode defaultMutableTreeNode, TangoDevice tangoDevice) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Attributes");
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            for (int i = 0; i < tangoDevice.attributes.length; ++i) {
                DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(tangoDevice.attributes[i]);
                defaultMutableTreeNode2.add(defaultMutableTreeNode3);
            }
        }

        private void treeMouseClicked(MouseEvent mouseEvent) {
            if (DbServerArchitecture.this.tree.getRowForLocation(mouseEvent.getX(), mouseEvent.getY()) < 1) {
                return;
            }
            TreePath treePath = DbServerArchitecture.this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getPathComponent(treePath.getPathCount() - 1);
            Object object = defaultMutableTreeNode.getUserObject();
            int n = mouseEvent.getModifiers();
            if (mouseEvent.getClickCount() == 2 && (n & 0x10) != 0 && object instanceof TangoAtt) {
                Serializable serializable;
                TangoAtt tangoAtt = (TangoAtt)object;
                TangoDevice tangoDevice = null;
                for (int i = treePath.getPathCount() - 2; tangoDevice == null && i > 0; --i) {
                    serializable = (DefaultMutableTreeNode)treePath.getPathComponent(i);
                    Object object2 = ((DefaultMutableTreeNode)serializable).getUserObject();
                    if (!(object2 instanceof TangoDevice)) continue;
                    tangoDevice = (TangoDevice)((Object)object2);
                }
                if (tangoDevice == null) {
                    System.out.println("TangoDevice not found");
                } else {
                    serializable = new DevPropertyDialog(this.dialog, tangoDevice, tangoAtt);
                    ((Dialog)serializable).setVisible(true);
                }
            }
        }
    }

    class TangoAttProp {
        String name;
        String strval;

        public TangoAttProp(String string, String string2) {
            this.name = string;
            this.strval = string2;
        }

        public String toString() {
            return this.name;
        }
    }

    class TangoAtt {
        String name;
        DbAttribute att;
        TangoAttProp[] prop;

        public TangoAtt(DbAttribute dbAttribute) throws DevFailed {
            this.name = dbAttribute.name;
            this.att = dbAttribute;
            String[] stringArray = dbAttribute.get_property_list();
            this.prop = new TangoAttProp[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                this.prop[i] = new TangoAttProp(stringArray[i], dbAttribute.get_string_value(stringArray[i]));
            }
        }

        public String toString() {
            return this.name;
        }
    }

    class TangoDevice
    extends DbDevice {
        String name;
        DbDatum[] properties;
        TangoAtt[] attributes;

        public TangoDevice(String string) throws DevFailed {
            String[] stringArray;
            super(string);
            this.name = string;
            this.properties = this.get_property(this.get_property_list("*"));
            Database database = ApiUtil.get_db_obj();
            try {
                stringArray = this.get_attribute_list();
            }
            catch (NoSuchMethodError noSuchMethodError) {
                System.out.println(noSuchMethodError);
                System.out.println("get_device_attribute_list() not found in Database class");
                DeviceData deviceData = new DeviceData();
                deviceData.insert(new String[]{string, "*"});
                DeviceData deviceData2 = database.command_inout("DbGetDeviceAttributeList", deviceData);
                stringArray = deviceData2.extractStringArray();
            }
            DbAttribute[] dbAttributeArray = database.get_device_attribute_property(string, stringArray);
            this.attributes = new TangoAtt[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                this.attributes[i] = new TangoAtt(dbAttributeArray[i]);
            }
        }

        public String toString() {
            return this.name;
        }
    }

    class TangoClass {
        String name;
        TangoDevice[] devices;

        public TangoClass(String string, String[] stringArray) throws DevFailed {
            this.name = string;
            this.devices = new TangoDevice[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                this.devices[i] = new TangoDevice(stringArray[i]);
            }
        }

        public String toString() {
            return this.name;
        }
    }

    class Server
    extends DbServer {
        String name;
        TangoClass[] classes;

        public Server(String string) throws DevFailed {
            super(string);
            this.name = string;
            String[] stringArray = this.get_class_list();
            this.classes = new TangoClass[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                String[] stringArray2 = this.get_device_name(stringArray[i]);
                this.classes[i] = new TangoClass(stringArray[i], stringArray2);
            }
        }

        public String toString() {
            String string = this.name + "\n";
            for (int i = 0; i < this.classes.length; ++i) {
                string = string + this.classes[i] + "\n";
            }
            return string.trim();
        }
    }
}

