/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.statistics;

import admin.astor.statistics.Utils;
import fr.esrf.Tango.DevState;
import java.util.StringTokenizer;

public class LogRecord {
    String name;
    DevState newState;
    long startedTime = -1L;
    long failedTime = -1L;
    long failedDuration = 0L;
    long runDuration = 0L;
    int autoRestart = 0;

    public LogRecord(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
        this.name = stringTokenizer.nextToken();
        this.newState = this.getState(stringTokenizer.nextToken());
        this.startedTime = this.getValue(stringTokenizer.nextToken()) * 1000L;
        this.failedTime = this.getValue(stringTokenizer.nextToken()) * 1000L;
        if (this.failedTime > 0L) {
            if (this.startedTime > this.failedTime) {
                this.failedDuration = this.startedTime - this.failedTime;
            } else if (this.newState == DevState.ON) {
                this.runDuration = this.failedTime - this.startedTime;
            }
        }
        if (this.newState == DevState.ON && stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            this.autoRestart = string2.equals("true") ? 2 : 1;
        }
    }

    private long getValue(String string) {
        long l = -1L;
        try {
            l = Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println(numberFormatException);
        }
        return l;
    }

    private DevState getState(String string) {
        if (string.equals("ON")) {
            return DevState.ON;
        }
        return DevState.FAULT;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.name).append(":\t");
        if (this.newState == DevState.FAULT) {
            stringBuffer.append("Failed at   ").append(Utils.formatDate(this.failedTime));
        } else {
            stringBuffer.append("Start  at   ").append(Utils.formatDate(this.startedTime));
        }
        if (this.failedDuration > 0L) {
            stringBuffer.append("\tFailure ").append(Utils.formatDuration(this.failedDuration));
        }
        if (this.runDuration > 0L) {
            stringBuffer.append("\tAvailable ").append(Utils.formatDuration(this.runDuration));
        }
        return stringBuffer.toString();
    }
}

