/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.statistics;

import admin.astor.statistics.ServerStat;
import admin.astor.statistics.ServerStatisticsPanel;
import admin.astor.statistics.StarterStat;
import admin.astor.statistics.StarterStatTable;
import admin.astor.statistics.Utils;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlobalStatisticsTable
extends JTable {
    private JFrame parent;
    private ArrayList<ServerStat> serverStatistics;
    private ArrayList<ServerStat> filteredServerStatistics = new ArrayList();
    private DataTableModel model;
    private TablePopupMenu menu;
    private static final int SERVER_NAME = 0;
    private static final int HOST_NAME = 1;
    private static final int NB_FAILURES = 2;
    private static final int TIME_FAILURE = 3;
    private static final int AVAILABILITY = 4;
    private static final int LAST_FAILURE = 5;
    private final Column[] columns = new Column[]{new Column("Server Name", 200), new Column("Host Name", 100), new Column("Failures", 50), new Column("Failure Duration", 150), new Column("Availability", 80), new Column("Last Failure", 150)};
    private static final int OFFSET = 2;
    private static final int SERVER_STAT = 0;
    private static final int HOST_STAT = 1;
    private static String[] menuLabels = new String[]{"Server statistics", "Host statistics"};

    public GlobalStatisticsTable(JFrame jFrame) {
        this.parent = jFrame;
        this.setRowSelectionAllowed(true);
        this.setColumnSelectionAllowed(true);
        this.setDragEnabled(false);
        this.setSelectionMode(0);
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                GlobalStatisticsTable.this.tableActionPerformed(mouseEvent);
            }
        });
        this.model = new DataTableModel();
        this.setModel(this.model);
        this.getTableHeader().setFont(new Font("Dialog", 1, 12));
        this.getTableHeader().addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                GlobalStatisticsTable.this.headerTableActionPerformed(mouseEvent);
            }
        });
        Enumeration<TableColumn> enumeration = this.getColumnModel().getColumns();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            tableColumn.setPreferredWidth(this.columns[n++].width);
        }
        this.menu = new TablePopupMenu(this);
    }

    public int getDefaultHeight() {
        int n = 400;
        int n2 = 22 + 17 * this.filteredServerStatistics.size();
        if (n2 > n) {
            n2 = n;
        }
        return n2;
    }

    public int getDefaultWidth() {
        int n = 0;
        for (Column column : this.columns) {
            n += column.width;
        }
        return n;
    }

    private void tableActionPerformed(MouseEvent mouseEvent) {
        int n = this.columnAtPoint(new Point(mouseEvent.getX(), mouseEvent.getY()));
        int n2 = this.rowAtPoint(new Point(mouseEvent.getX(), mouseEvent.getY()));
        ServerStat serverStat = this.filteredServerStatistics.get(n2);
        if (mouseEvent.getButton() == 3) {
            switch (n) {
                case 0: {
                    this.menu.showMenu(mouseEvent, serverStat);
                    break;
                }
                case 1: {
                    this.menu.showMenu(mouseEvent, serverStat.starterStat);
                }
            }
        } else if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 2) {
            switch (n) {
                case 0: {
                    this.displayServerStat(serverStat);
                    break;
                }
                case 1: {
                    this.displayStarterStat(serverStat.starterStat);
                }
            }
        }
    }

    private void displayServerStat(ServerStat serverStat) {
        String string = serverStat.name + "  registered on  " + serverStat.starterStat.name;
        new ServerStatisticsPanel(this.parent, string, serverStat).setVisible(true);
    }

    private void displayStarterStat(StarterStat starterStat) {
        String string = starterStat.name;
        new StarterStatTable(this.parent, string, starterStat).setVisible(true);
    }

    private void headerTableActionPerformed(MouseEvent mouseEvent) {
        this.sort(this.getTableHeader().columnAtPoint(new Point(mouseEvent.getX(), mouseEvent.getY())));
    }

    private void sort(int n) {
        MyCompare myCompare = new MyCompare();
        myCompare.setSelectedColumn(n);
        Collections.sort(this.filteredServerStatistics, myCompare);
        this.model.fireTableDataChanged();
    }

    public void setStatistics(ArrayList<ServerStat> arrayList) {
        this.serverStatistics = arrayList;
        this.copyServerStatistics();
        this.sort(5);
        this.model.fireTableDataChanged();
    }

    public void setFilter(String string) {
        this.filteredServerStatistics.clear();
        for (ServerStat serverStat : this.serverStatistics) {
            if (!serverStat.name.startsWith(string)) continue;
            this.filteredServerStatistics.add(serverStat);
        }
        this.model.fireTableDataChanged();
    }

    public void resetFilter() {
        this.copyServerStatistics();
        this.model.fireTableDataChanged();
    }

    private void copyServerStatistics() {
        this.filteredServerStatistics.clear();
        for (ServerStat serverStat : this.serverStatistics) {
            this.filteredServerStatistics.add(serverStat);
        }
    }

    private class TablePopupMenu
    extends JPopupMenu {
        private JTable table;
        private ServerStat serverStat;
        private StarterStat starterStat;
        private JLabel title;

        private TablePopupMenu(JTable jTable) {
            this.table = jTable;
            this.title = new JLabel();
            this.title.setFont(new Font("Dialog", 1, 16));
            this.add(this.title);
            this.add(new JPopupMenu.Separator());
            for (String string : menuLabels) {
                if (string == null) {
                    this.add(new JPopupMenu.Separator());
                    continue;
                }
                JMenuItem jMenuItem = new JMenuItem(string);
                jMenuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        TablePopupMenu.this.menuActionPerformed(actionEvent);
                    }
                });
                this.add(jMenuItem);
            }
        }

        private void showMenu(MouseEvent mouseEvent, ServerStat serverStat) {
            this.title.setText(serverStat.name);
            this.serverStat = serverStat;
            this.getComponent(2).setVisible(true);
            this.getComponent(3).setVisible(false);
            this.show(this.table, mouseEvent.getX(), mouseEvent.getY());
        }

        private void showMenu(MouseEvent mouseEvent, StarterStat starterStat) {
            this.title.setText(starterStat.name);
            this.starterStat = starterStat;
            this.getComponent(2).setVisible(false);
            this.getComponent(3).setVisible(true);
            this.show(this.table, mouseEvent.getX(), mouseEvent.getY());
        }

        private void menuActionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            int n = 0;
            for (int i = 0; i < menuLabels.length; ++i) {
                if (this.getComponent(2 + i) != object) continue;
                n = i;
            }
            switch (n) {
                case 0: {
                    GlobalStatisticsTable.this.displayServerStat(this.serverStat);
                    break;
                }
                case 1: {
                    GlobalStatisticsTable.this.displayStarterStat(this.starterStat);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MyCompare
    implements Comparator<ServerStat> {
        private int column;

        MyCompare() {
        }

        private void setSelectedColumn(int n) {
            this.column = n;
        }

        @Override
        public int compare(ServerStat serverStat, ServerStat serverStat2) {
            switch (this.column) {
                case 0: {
                    return serverStat.name.compareToIgnoreCase(serverStat2.name) > 0 ? 1 : 0;
                }
                case 1: {
                    return serverStat.starterStat.name.compareToIgnoreCase(serverStat2.starterStat.name) > 0 ? 1 : 0;
                }
                case 2: {
                    return serverStat.nbFailures < serverStat2.nbFailures ? 1 : 0;
                }
                case 3: {
                    return serverStat.failedDuration < serverStat2.failedDuration ? 1 : 0;
                }
                case 4: {
                    return serverStat.getAvailability() < serverStat2.getAvailability() ? 1 : 0;
                }
                case 5: {
                    return serverStat.getLastFailure() < serverStat2.getLastFailure() ? 1 : 0;
                }
            }
            return serverStat.name.compareToIgnoreCase(serverStat2.name) > 0 ? 1 : 0;
        }
    }

    public class DataTableModel
    extends AbstractTableModel {
        public int getColumnCount() {
            return GlobalStatisticsTable.this.columns.length;
        }

        public int getRowCount() {
            return GlobalStatisticsTable.this.filteredServerStatistics.size();
        }

        public String getColumnName(int n) {
            return ((GlobalStatisticsTable)GlobalStatisticsTable.this).columns[n].name;
        }

        public Object getValueAt(int n, int n2) {
            ServerStat serverStat = (ServerStat)GlobalStatisticsTable.this.filteredServerStatistics.get(n);
            return this.getServerValueString(serverStat, n2);
        }

        private String getServerValueString(ServerStat serverStat, int n) {
            switch (n) {
                case 0: {
                    return serverStat.name;
                }
                case 1: {
                    return serverStat.starterStat.name;
                }
                case 2: {
                    return Integer.toString(serverStat.nbFailures);
                }
                case 3: {
                    return Utils.formatDuration(serverStat.failedDuration);
                }
                case 4: {
                    return Utils.formatPercentage(serverStat.getAvailability());
                }
                case 5: {
                    long l = serverStat.getLastFailure();
                    if (l > 0L) {
                        return Utils.formatDate(l);
                    }
                    return " ? ? ";
                }
            }
            return "--";
        }
    }

    class Column {
        String name;
        int width;

        Column(String string, int n) {
            this.name = string;
            this.width = n;
        }
    }
}

