/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.statistics;

import admin.astor.statistics.ServerStat;
import admin.astor.statistics.StarterStat;
import admin.astor.statistics.Utils;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoDs.Except;
import java.util.ArrayList;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlobalStatistics {
    public long readAt = 0L;
    public int nbHosts = 0;
    public int nbHostRead = 0;
    public int nbServers = 0;
    public int nbServersRead = 0;
    public long runDuration = 0L;
    public long failedDuration = 0L;
    public int nbFailures = 0;
    private ArrayList<StarterStat> starterStats;
    private String fileName = null;
    private static final String className = "GlobalStat";
    private static final String dateStr = "date";
    private static final String timeStr = "time";
    private static final String failuresStr = "failures";
    private static final String description = "<GlobalStatdate=\"DATE\" time=\"TIME\" failures=\"FAILURES\" >";
    public static final String system = "ctrlStatDsl:CtrlStatSystem";
    public static final String header = "<?xml version=\"1.0\" encoding=\"ASCII\"?>\n<ctrlStatDsl:CtrlStatSystem xmi:version=\"2.0\" xmlns:xmi=\"http://www.omg.org/XMI\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:ctrlStatDsl=\"http://www.esrf.fr/tango/starter/CtrlStatDslDsl\">";
    public static final String footer = "</ctrlStatDsl:CtrlStatSystem>";

    public GlobalStatistics(String string) throws DevFailed {
        this.fileName = string;
        this.starterStats = new ArrayList();
        String string2 = Utils.readFile(string);
        if (!string2.startsWith(header)) {
            Except.throw_exception((String)"FILE_NOT_VALID", (String)(string + " is not a TANGO statistics file"), (String)"GlobalStatistics.GlobalStatistics()");
        }
        this.parseStatistics(string2);
        this.computeStatistics();
    }

    public GlobalStatistics(ArrayList<StarterStat> arrayList) {
        this.starterStats = arrayList;
        this.readAt = System.currentTimeMillis();
        this.computeStatistics();
    }

    public ArrayList<StarterStat> getStarterStatistics() {
        return this.starterStats;
    }

    private void computeStatistics() {
        this.nbHosts = this.starterStats.size();
        for (StarterStat starterStat : this.starterStats) {
            this.nbServers += starterStat.size();
            if (!starterStat.readOK) continue;
            ++this.nbHostRead;
            for (ServerStat serverStat : starterStat) {
                ++this.nbServersRead;
                this.runDuration += serverStat.runDuration / 1000L;
                if (serverStat.nbFailures <= 0) continue;
                this.nbFailures += serverStat.nbFailures;
                this.failedDuration += serverStat.failedDuration / 1000L;
            }
        }
        this.runDuration *= 1000L;
        this.failedDuration *= 1000L;
    }

    public long getDuration() {
        return this.readAt - this.getOldestTime();
    }

    private long getOldestTime() {
        long l = System.currentTimeMillis();
        for (StarterStat starterStat : this.starterStats) {
            if (starterStat.resetTime >= l) continue;
            l = starterStat.resetTime;
        }
        return l;
    }

    private void parseStatistics(String string) throws DevFailed {
        Object object;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        ArrayList<Object> arrayList = new ArrayList<Object>();
        boolean bl = false;
        while (stringTokenizer.hasMoreTokens()) {
            object = stringTokenizer.nextToken().trim();
            if (((String)object).startsWith("<GlobalStat")) {
                bl = true;
                this.parseXmlLine((String)object);
                continue;
            }
            if (((String)object).startsWith("</GlobalStat")) {
                bl = false;
                continue;
            }
            if (!bl) continue;
            arrayList.add(object);
        }
        object = new ArrayList();
        for (String string2 : arrayList) {
            if (string2.startsWith("</StarterStat")) {
                StarterStat starterStat = new StarterStat((ArrayList<String>)object);
                this.starterStats.add(starterStat);
                ((ArrayList)object).clear();
                continue;
            }
            ((ArrayList)object).add(string2);
        }
    }

    private void parseXmlLine(String string) throws DevFailed {
        try {
            this.readAt = Long.parseLong(Utils.parseXmlProperty(string, timeStr));
        }
        catch (NumberFormatException numberFormatException) {
            Except.throw_exception((String)"SYNTAX_ERROR", (String)numberFormatException.toString(), (String)"GlobalStatistics.parseLine()");
        }
        System.out.println("Written " + Utils.parseXmlProperty(string, dateStr));
        System.out.println("--> " + Utils.formatDate(this.readAt));
        System.out.println(this.nbFailures + " failures");
    }

    public void saveStatistics(String string) throws DevFailed {
        StringBuffer stringBuffer = new StringBuffer(header);
        stringBuffer.append("\n");
        stringBuffer.append("\t").append(this.toXml()).append("\n");
        for (StarterStat starterStat : this.starterStats) {
            stringBuffer.append(starterStat.toXml()).append("\n");
        }
        stringBuffer.append("\t</").append(className).append(">\n");
        stringBuffer.append(footer);
        Utils.writeFile(string, stringBuffer.toString());
    }

    private String toXml() {
        String string = description;
        string = Utils.strReplace(string, "DATE", Utils.formatDate(this.readAt));
        string = Utils.strReplace(string, "TIME", Long.toString(this.readAt));
        string = Utils.strReplace(string, "FAILURES", Integer.toString(this.nbFailures));
        return string;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.fileName == null) {
            stringBuffer.append("Statistics from Starters\n");
        } else {
            stringBuffer.append("Statistics from file: ").append(this.fileName).append("\n");
        }
        stringBuffer.append("Between   ").append(Utils.formatDate(this.getOldestTime())).append("   and   ").append(Utils.formatDate(this.readAt)).append(" on:\n  ");
        stringBuffer.append(this.nbHostRead).append("/").append(this.nbHosts).append("   Controlled hosts\n  ");
        stringBuffer.append(this.nbServersRead).append("  Controlled servers\n  ");
        if (this.nbFailures == 0) {
            stringBuffer.append("Availability:    100 %");
        } else {
            double d = (double)this.runDuration / (double)(this.runDuration + this.failedDuration);
            stringBuffer.append("Nb failures:   ").append(this.nbFailures).append("\n  ");
            stringBuffer.append("Availability:  ").append(Utils.formatPercentage(d));
        }
        return stringBuffer.toString();
    }
}

