/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.access;

import admin.astor.access.UsersTree;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.tree.TreePath;

public class UsersTreePopupMenu
extends JPopupMenu {
    private UsersTree parent;
    private static final int ADD_USER = 0;
    private static final int COPY = 1;
    private static final int PASTE = 2;
    private static final int ADD_ITEM = 3;
    private static final int EDIT = 4;
    private static final int CLONE = 5;
    private static final int REMOVE = 6;
    private static final int TOGGLE_RIGHTS = 7;
    private static String[] menuLabels = new String[]{"Add User", "Copy", "Paste", "Add Item", "Edit", "Clone", "Remove", "Toggle rights"};
    private static final int OFFSET = 2;
    private JLabel title;

    public UsersTreePopupMenu(UsersTree usersTree) {
        this.parent = usersTree;
        this.buildBtnPopupMenu();
    }

    private void buildBtnPopupMenu() {
        this.title = new JLabel();
        this.title.setFont(new Font("Dialog", 1, 16));
        this.add(this.title);
        this.add(new JPopupMenu.Separator());
        for (String string : menuLabels) {
            if (string == null) {
                this.add(new JPopupMenu.Separator());
                continue;
            }
            JMenuItem jMenuItem = new JMenuItem(string);
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    UsersTreePopupMenu.this.userActionPerformed(actionEvent);
                }
            });
            this.add(jMenuItem);
        }
    }

    public void showMenu(MouseEvent mouseEvent, String string) {
        TreePath treePath = this.parent.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (treePath == null) {
            return;
        }
        this.parent.setSelectionPath(treePath);
        this.title.setText(string);
        for (int i = 0; i < menuLabels.length; ++i) {
            this.getComponent(2 + i).setVisible(false);
        }
        this.getComponent(2).setVisible(true);
        this.show(this.parent, mouseEvent.getX(), mouseEvent.getY());
    }

    public void showMenu(MouseEvent mouseEvent, int n, Object object) {
        TreePath treePath = this.parent.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (treePath == null) {
            return;
        }
        this.parent.setSelectionPath(treePath);
        this.title.setText(object.toString());
        for (int i = 0; i < menuLabels.length; ++i) {
            this.getComponent(2 + i).setVisible(false);
        }
        switch (n) {
            case -2: {
                this.getComponent(7).setVisible(true);
                if (object.toString().equals("All Users")) break;
                this.getComponent(8).setVisible(true);
                break;
            }
            case -1: {
                this.getComponent(5).setVisible(true);
                this.getComponent(4).setVisible(true);
                this.getComponent(4).setEnabled(false);
                if (object.toString().equals(UsersTree.collecStr[0]) && this.parent.copied_addresses.size() > 0) {
                    this.getComponent(4).setEnabled(true);
                }
                if (!object.toString().equals(UsersTree.collecStr[1]) || this.parent.copied_devices.size() <= 0) break;
                this.getComponent(4).setEnabled(true);
                break;
            }
            case 0: {
                this.getComponent(3).setVisible(true);
                this.getComponent(6).setVisible(true);
                this.getComponent(8).setVisible(true);
                break;
            }
            case 1: {
                this.getComponent(3).setVisible(true);
                this.getComponent(6).setVisible(true);
                this.getComponent(8).setVisible(true);
                this.getComponent(9).setVisible(true);
            }
        }
        this.show(this.parent, mouseEvent.getX(), mouseEvent.getY());
    }

    private void userActionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        int n = 0;
        for (int i = 0; i < menuLabels.length; ++i) {
            if (this.getComponent(2 + i) != object) continue;
            n = i;
        }
        switch (n) {
            case 0: {
                this.parent.addUser();
                break;
            }
            case 1: {
                this.parent.copyItem();
                break;
            }
            case 2: {
                this.parent.pasteItem();
                break;
            }
            case 3: {
                this.parent.addItem();
                break;
            }
            case 4: {
                this.parent.editItem();
                break;
            }
            case 5: {
                this.parent.cloneUser();
                break;
            }
            case 6: {
                this.parent.removeItem();
                break;
            }
            case 7: {
                this.parent.toggleRight();
            }
        }
    }
}

