/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.access;

import admin.astor.access.AccessProxy;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoDs.Except;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OPidUserCreation {
    private AccessProxy accessProxy = null;
    private static final String[] idDeviceMasks = new String[]{"fe/id/", "id/id/"};
    private static final String[] dDeviceMasks = new String[]{"fe/d/"};

    public OPidUserCreation(String string) throws DevFailed {
        ArrayList<String> arrayList = this.splitLines(OPidUserCreation.readFile(string));
        ArrayList<OPuser> arrayList2 = new ArrayList<OPuser>();
        for (String object : arrayList) {
            arrayList2.add(new OPuser(object));
        }
        for (OPuser oPuser : arrayList2) {
            this.addUser(oPuser);
            System.out.println(oPuser);
        }
        System.out.println(arrayList2.size() + " users");
    }

    private ArrayList<String> splitLines(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.length() <= 0 || string2.startsWith("#")) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    private boolean userExists(String string) throws DevFailed {
        String[] stringArray;
        for (String string2 : stringArray = this.accessProxy.getUsers()) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    private boolean checkUserName(String string) throws DevFailed {
        boolean bl = true;
        if (string.length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string.toLowerCase());
            String string2 = "";
            while (stringTokenizer.hasMoreTokens()) {
                string2 = string2 + stringTokenizer.nextToken();
            }
            if (string2.equals("allusers")) {
                System.err.println(string + " is reserved !");
                bl = false;
            }
        } else {
            bl = false;
        }
        if (string.length() > 0) {
            if (this.userExists(string)) {
                bl = false;
                System.out.println("User  " + string + "  Already exists !");
            }
        } else {
            bl = false;
        }
        return bl;
    }

    void addUser(OPuser oPuser) {
        try {
            if (this.accessProxy == null) {
                this.accessProxy = new AccessProxy(this.getTangoService());
            }
            if (this.checkUserName(oPuser.name)) {
                this.accessProxy.addAddress(oPuser.name, oPuser.address);
                this.accessProxy.addDevice(oPuser.name, "*/*/*", "read");
            }
            for (String string : oPuser.deviceMasks) {
                this.accessProxy.addDevice(oPuser.name, string, "write");
            }
        }
        catch (DevFailed devFailed) {
            System.err.println("Error during Database access" + devFailed.errors[0].desc);
        }
    }

    private String getTangoService() throws DevFailed {
        String[] stringArray = ApiUtil.get_db_obj().getServices("AccessControl", "tango");
        if (stringArray.length == 0) {
            Except.throw_communication_failed((String)"Service_DoesNotExist", (String)"There is no AccessControl service defined !", (String)"TangoAccess.TangoAccess()");
        }
        return stringArray[0];
    }

    public static String readFile(String string) throws DevFailed {
        String string2 = "";
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            int n = fileInputStream.available();
            byte[] byArray = new byte[n];
            n = fileInputStream.read(byArray);
            fileInputStream.close();
            if (n > 0) {
                string2 = new String(byArray);
            }
        }
        catch (Exception exception) {
            Except.throw_exception((String)"READ_FAILED", (String)exception.toString(), (String)"ParserTool.readFile()");
        }
        return string2;
    }

    public static void main(String[] stringArray) {
        String string = System.getProperty("ADDRESS_FILE");
        if (stringArray.length > 0) {
            string = stringArray[0];
        }
        try {
            if (string == null) {
                Except.throw_exception((String)"SYNTAX_ERROR", (String)"property ADDRESS_FILE not set", (String)"OPidUserCreation.main()");
            }
            new OPidUserCreation(string);
        }
        catch (DevFailed devFailed) {
            Except.print_exception((Exception)((Object)devFailed));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        System.exit(0);
    }

    private class OPuser {
        String name;
        String address;
        String[] deviceMasks;
        int idNum = -1;
        boolean isID;

        private OPuser(String string) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
            String string2 = stringTokenizer.nextToken().trim();
            String string3 = stringTokenizer.nextToken().trim();
            this.name = string2.substring(string2.lastIndexOf(47) + 1);
            this.address = string3 + ".*";
            if (this.name.startsWith("opid")) {
                this.isID = true;
                try {
                    this.idNum = Integer.parseInt(this.name.substring("opid".length()));
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println(this.name + ":\t" + numberFormatException);
                }
                this.deviceMasks = new String[idDeviceMasks.length];
                this.deviceMasks[0] = idDeviceMasks[0] + this.idNum;
                this.deviceMasks[1] = idDeviceMasks[1] + this.idNum;
            } else {
                this.isID = false;
                try {
                    this.idNum = Integer.parseInt(this.name.substring("opd".length()));
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println(this.name + ":\t" + numberFormatException);
                }
                this.deviceMasks = new String[dDeviceMasks.length];
                this.deviceMasks[0] = dDeviceMasks[0] + this.idNum;
            }
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(this.name);
            stringBuilder.append(" ->\t").append(this.address).append('\t');
            for (String string : this.deviceMasks) {
                stringBuilder.append(string).append("  ");
            }
            return stringBuilder.toString();
        }
    }
}

