/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.access;

import admin.astor.tools.Utils;
import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;

public class EditTreeItem
extends JDialog {
    private JTextField theText;
    private boolean ret_code;
    private int obj_type;
    private static final int TXT_OFFSET = 20;
    private static boolean keep_deco = false;

    public EditTreeItem(Frame frame, JTree jTree, String string, int n) {
        super(frame, true);
        this.obj_type = n;
        this.getContentPane().setLayout(null);
        this.theText = new JTextField();
        String string2 = System.getProperty("java.version");
        if (string2 != null) {
            keep_deco = string2.startsWith("1.5");
        }
        this.theText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
            }

            public void keyReleased(KeyEvent keyEvent) {
                EditTreeItem.this.keyReleasedListener(keyEvent);
            }

            public void keyTyped(KeyEvent keyEvent) {
            }
        });
        Rectangle rectangle = this.computeBounds(jTree);
        this.getContentPane().add(this.theText);
        this.theText.setBounds(0, 0, (int)rectangle.getWidth(), (int)rectangle.getHeight());
        this.theText.setText(string);
        this.theText.setBorder(BorderFactory.createLineBorder(Color.black));
        this.theText.setFont(new Font("Monospaced", 0, 12));
        this.theText.selectAll();
        this.setBounds(rectangle);
        if (!keep_deco) {
            this.setUndecorated(true);
        }
        this.ret_code = false;
    }

    public void keyReleasedListener(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10 && this.checkInputs()) {
            this.ret_code = true;
            this.closeDlg();
        }
        if (keyEvent.getKeyCode() == 27) {
            this.ret_code = false;
            this.closeDlg();
        }
    }

    private boolean checkInputs() {
        switch (this.obj_type) {
            case 0: {
                return this.checkAddress();
            }
            case 1: {
                return this.checkDevice();
            }
        }
        return false;
    }

    private boolean checkDevice() {
        String string = this.theText.getText().trim().toLowerCase();
        this.theText.setText(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        if (arrayList.size() > 3) {
            Utils.popupError(this, "Incorrect device name  (too many members)");
            return false;
        }
        if (arrayList.size() < 3) {
            Utils.popupError(this, "Incorrect device name  (not enough members)");
            return false;
        }
        return true;
    }

    private boolean checkAddress() {
        Object object;
        String string = this.theText.getText().trim();
        this.theText.setText(string);
        try {
            object = InetAddress.getByName(string);
            string = ((InetAddress)object).getHostAddress();
            this.theText.setText(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        object = new StringTokenizer(string, ".");
        ArrayList<String> arrayList = new ArrayList<String>();
        while (((StringTokenizer)object).hasMoreTokens()) {
            arrayList.add(((StringTokenizer)object).nextToken());
        }
        if (arrayList.size() > 4) {
            Utils.popupError(this, "Incorrect IP address  (Too many members)");
            return false;
        }
        if (arrayList.size() < 4) {
            Utils.popupError(this, "Incorrect IP address  (not enougth members)");
            return false;
        }
        string = (String)arrayList.get(0) + "." + (String)arrayList.get(1) + "." + (String)arrayList.get(2) + "." + (String)arrayList.get(3);
        this.theText.setText(string);
        for (int i = 0; i < arrayList.size(); ++i) {
            try {
                Short.parseShort((String)arrayList.get(i));
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                if (((String)arrayList.get(i)).equals("*")) continue;
                Utils.popupError(this, "Incorrect IP address  (member #" + (i + 1) + " (" + (String)arrayList.get(i) + ") is not a number)");
                return false;
            }
        }
        return true;
    }

    private void closeDlg() {
        this.setVisible(false);
    }

    public boolean showDlg() {
        this.setVisible(true);
        return this.ret_code;
    }

    public String getInputs() {
        return this.theText.getText();
    }

    private Rectangle computeBounds(JTree jTree) {
        TreePath treePath = jTree.getSelectionPath();
        jTree.scrollPathToVisible(treePath);
        Rectangle rectangle = jTree.getPathBounds(treePath);
        Point point = rectangle.getLocation();
        SwingUtilities.convertPointToScreen(point, jTree);
        rectangle.setLocation(point);
        rectangle.width = 250;
        rectangle.height += 2;
        rectangle.x += 20;
        return rectangle;
    }
}

