/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.access;

import admin.astor.AstorTree;
import admin.astor.access.AccessProxy;
import admin.astor.access.AllowedCmdTreePopupMenu;
import admin.astor.access.ClassAllowed;
import admin.astor.access.ListSelectionDialog;
import admin.astor.access.Utils;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoDs.TangoConst;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class AllowedCmdTree
extends JTree
implements TangoConst {
    static ImageIcon tango_icon;
    static ImageIcon class_icon;
    static ImageIcon cmd_icon;
    private DefaultTreeModel treeModel;
    private DefaultMutableTreeNode root;
    private AllowedCmdTreePopupMenu menu;
    private JFrame parent;
    private AccessProxy access_dev;
    private static final Color background;

    public AllowedCmdTree(JFrame jFrame, AccessProxy accessProxy) throws DevFailed {
        this.parent = jFrame;
        this.access_dev = accessProxy;
        this.setBackground(background);
        this.buildTree();
        this.menu = new AllowedCmdTreePopupMenu(this);
    }

    private void buildTree() throws DevFailed {
        String string = "Tango Control Access";
        try {
            string = "Access to  " + ApiUtil.get_db_obj().get_tango_host();
        }
        catch (DevFailed devFailed) {
            // empty catch block
        }
        this.root = new DefaultMutableTreeNode(string);
        this.createClassNodes();
        this.getSelectionModel().setSelectionMode(1);
        this.treeModel = new DefaultTreeModel(this.root);
        this.setModel(this.treeModel);
        ToolTipManager.sharedInstance().registerComponent(this);
        this.setCellRenderer(new TangoRenderer());
        this.addTreeExpansionListener(new TreeExpansionListener(){

            public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
            }

            public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                AllowedCmdTree.this.treeMouseClicked(mouseEvent);
            }
        });
    }

    private void treeMouseClicked(MouseEvent mouseEvent) {
        if (this.access_dev.getAccessControl() == 0) {
            return;
        }
        TreePath treePath = this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (treePath == null) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getPathComponent(treePath.getPathCount() - 1);
        Object object = defaultMutableTreeNode.getUserObject();
        int n = mouseEvent.getModifiers();
        if ((mouseEvent.getClickCount() != 2 || (n & 0x10) == 0) && (n & 4) != 0) {
            if (defaultMutableTreeNode == this.root) {
                this.menu.showMenu(mouseEvent, (String)object);
            } else if (object instanceof String) {
                String string = defaultMutableTreeNode.getParent().toString();
                String string2 = (String)object;
                if (!string2.toLowerCase().equals("state") && !string2.toLowerCase().equals("status")) {
                    this.menu.showMenu(mouseEvent, string, string2);
                }
            } else {
                this.menu.showMenu(mouseEvent, (ClassAllowed)object);
            }
        }
    }

    private void createClassNodes() throws DevFailed {
        try {
            String[] stringArray;
            DeviceData deviceData = this.access_dev.command_inout("GetAllowedCommandClassList");
            for (String string : stringArray = deviceData.extractStringArray()) {
                DeviceData deviceData2 = new DeviceData();
                deviceData2.insert(string);
                deviceData = this.access_dev.command_inout("GetAllowedCommands", deviceData2);
                ClassAllowed classAllowed = new ClassAllowed(string, deviceData.extractStringArray());
                DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(classAllowed);
                this.root.add(defaultMutableTreeNode);
                for (String string2 : classAllowed) {
                    defaultMutableTreeNode.add(new DefaultMutableTreeNode(string2));
                }
            }
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)this, null, (DevFailed)devFailed);
        }
    }

    DefaultMutableTreeNode getSelectedNode() {
        return (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
    }

    Object getSelectedObject() {
        DefaultMutableTreeNode defaultMutableTreeNode = this.getSelectedNode();
        if (defaultMutableTreeNode == null) {
            return null;
        }
        return defaultMutableTreeNode.getUserObject();
    }

    private String[] getDefinedClasses() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.root.getChildCount(); ++i) {
            arrayList.add(this.root.getChildAt(i).toString());
        }
        String[] stringArray = new String[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            stringArray[i] = (String)arrayList.get(i);
        }
        return stringArray;
    }

    void addClass() {
        try {
            ListSelectionDialog listSelectionDialog = new ListSelectionDialog(this.parent, this.getDefinedClasses());
            if (listSelectionDialog.showDialog() == 0) {
                Object object2;
                ClassAllowed classAllowed = new ClassAllowed(listSelectionDialog.getSelection());
                DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(classAllowed);
                this.treeModel.insertNodeInto(defaultMutableTreeNode, this.root, this.root.getChildCount());
                for (Object object2 : classAllowed) {
                    this.treeModel.insertNodeInto(new DefaultMutableTreeNode(object2), defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
                }
                Object[] objectArray = new DefaultMutableTreeNode[]{this.root, defaultMutableTreeNode, defaultMutableTreeNode.getChildAt(0)};
                object2 = new TreePath(objectArray);
                this.setSelectionPath((TreePath)object2);
                this.scrollPathToVisible((TreePath)object2);
            }
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)this, null, (DevFailed)devFailed);
        }
    }

    void addCommand() {
        Object object = this.getSelectedObject();
        if (object instanceof ClassAllowed) {
            ClassAllowed classAllowed = null;
            String string = null;
            boolean bl = false;
            try {
                classAllowed = (ClassAllowed)object;
                ListSelectionDialog listSelectionDialog = new ListSelectionDialog(this.parent, classAllowed);
                if (listSelectionDialog.showDialog() == 0) {
                    string = listSelectionDialog.getSelection();
                    classAllowed.add(string);
                    bl = true;
                    this.access_dev.addAllowedCommand(classAllowed);
                    DefaultMutableTreeNode defaultMutableTreeNode = this.getSelectedNode();
                    DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(string);
                    this.treeModel.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
                    Object[] objectArray = new DefaultMutableTreeNode[]{this.root, defaultMutableTreeNode, defaultMutableTreeNode2};
                    TreePath treePath = new TreePath(objectArray);
                    this.setSelectionPath(treePath);
                    this.scrollPathToVisible(treePath);
                }
            }
            catch (DevFailed devFailed) {
                if (bl) {
                    classAllowed.remove(string);
                }
                ErrorPane.showErrorMessage((Component)this, null, (DevFailed)devFailed);
            }
        }
    }

    void removeCommand() {
        Object object = this.getSelectedObject();
        if (object instanceof String) {
            String string = (String)object;
            DefaultMutableTreeNode defaultMutableTreeNode = this.getSelectedNode();
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
            if (defaultMutableTreeNode2.getUserObject() instanceof ClassAllowed) {
                ClassAllowed classAllowed = (ClassAllowed)defaultMutableTreeNode2.getUserObject();
                if (JOptionPane.showConfirmDialog(this, "Are you sure to want to remove " + string + "  for class " + classAllowed, "Confirm Dialog", 0) != 0) {
                    return;
                }
                try {
                    classAllowed.remove(string);
                    this.access_dev.addAllowedCommand(classAllowed);
                    this.treeModel.removeNodeFromParent(defaultMutableTreeNode);
                }
                catch (DevFailed devFailed) {
                    ErrorPane.showErrorMessage((Component)this, null, (DevFailed)devFailed);
                }
            }
        }
    }

    static {
        background = AstorTree.background;
    }

    private class TangoRenderer
    extends DefaultTreeCellRenderer {
        private Font[] fonts;
        private final int TITLE = 0;
        private final int CLASS = 1;
        private final int COMMAND = 2;

        public TangoRenderer() {
            Utils utils = Utils.getInstance();
            tango_icon = utils.getIcon("network5.gif");
            class_icon = utils.getIcon("class.gif");
            cmd_icon = utils.getIcon("attleaf.gif");
            this.fonts = new Font[3];
            this.fonts[0] = new Font("Dialog", 1, 18);
            this.fonts[1] = new Font("Dialog", 1, 12);
            this.fonts[2] = new Font("Dialog", 0, 12);
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            this.setBackgroundNonSelectionColor(background);
            this.setForeground(Color.black);
            this.setBackgroundSelectionColor(Color.lightGray);
            if (n == 0) {
                this.setFont(this.fonts[0]);
                this.setIcon(tango_icon);
            } else {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
                if (defaultMutableTreeNode.getUserObject() instanceof ClassAllowed) {
                    this.setFont(this.fonts[1]);
                    this.setIcon(class_icon);
                } else {
                    this.setFont(this.fonts[2]);
                    this.setIcon(cmd_icon);
                }
            }
            return this;
        }
    }
}

