/*
 * Decompiled with CFR 0.152.
 */
package admin.astor;

import admin.astor.AstorDefs;
import admin.astor.AstorUtil;
import admin.astor.PutServerInfoDialog;
import admin.astor.ServArchitectureDialog;
import admin.astor.TangoHost;
import admin.astor.tools.BlackBoxTable;
import admin.astor.tools.DbServerArchitecture;
import admin.astor.tools.PoolThreadsManager;
import admin.astor.tools.PopupHtml;
import admin.astor.tools.PopupText;
import admin.astor.tools.Utils;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevState;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.DbDevExportInfo;
import fr.esrf.TangoApi.DbDevImportInfo;
import fr.esrf.TangoApi.DbServInfo;
import fr.esrf.TangoApi.DbServer;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoDs.Except;
import fr.esrf.TangoDs.TangoConst;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import fr.esrf.tangoatk.widget.util.Splash;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import jive.DevWizard;
import tool_panels.servstate.ServStatePanel;

public class TangoServer
extends DeviceProxy
implements AstorDefs,
TangoConst {
    private String name;
    private DbServer server = null;
    private String devname;
    private DevState state;
    public DbServInfo info;
    public JLabel label;
    public boolean controlled = false;
    public int startup_level = 0;
    private static final long RestartTimeout = 10000L;
    private JDialog stateDialog;
    private ServStatePanel statePanel;
    private PoolThreadsManager pool_thread_man = null;

    public TangoServer(String string, DevState devState) throws DevFailed {
        super("dserver/" + string);
        this.set_transparency_reconnection(true);
        this.name = string;
        this.devname = this.get_name();
        this.state = devState;
    }

    public TangoServer(String string) throws DevFailed {
        super(string);
        this.set_transparency_reconnection(true);
        this.name = string;
        this.devname = this.get_name();
        this.state = DevState.ON;
    }

    public void putStartupInfo(DbServInfo dbServInfo) throws DevFailed {
        if (this.server == null) {
            this.server = new DbServer(this.name);
        }
        this.info = dbServInfo;
        this.server.put_info(this.info);
    }

    public void updateStartupInfo() throws DevFailed {
        if (this.server == null) {
            this.server = new DbServer(this.name);
        }
        this.info = this.server.get_info();
    }

    public void setState(DevState devState) {
        this.state = devState;
    }

    public DevState getState() {
        return this.state;
    }

    public String getName() {
        return this.name;
    }

    public String[] queryClass() throws DevFailed {
        DeviceData deviceData = this.command_inout("QueryClass");
        return deviceData.extractStringArray();
    }

    public DbDevImportInfo getImportInfo() throws DevFailed {
        return this.import_device();
    }

    public String[] queryDeviceFromDb() throws DevFailed {
        String[] stringArray;
        Object object;
        if (this.server == null) {
            object = this.name.substring(this.name.indexOf(47) + 1);
            this.server = new DbServer((String)object);
        }
        object = new ArrayList();
        for (String string : stringArray = this.server.get_class_list()) {
            String[] stringArray2 = this.server.get_device_name(string);
            ((ArrayList)object).addAll(Arrays.asList(stringArray2));
        }
        String[] stringArray3 = new String[((ArrayList)object).size()];
        for (int i = 0; i < ((ArrayList)object).size(); ++i) {
            stringArray3[i] = (String)((ArrayList)object).get(i);
        }
        return stringArray3;
    }

    public String[] queryDevice() throws DevFailed {
        return this.queryDevice(false);
    }

    public String[] queryDevice(boolean bl) throws DevFailed {
        DeviceData deviceData;
        try {
            deviceData = this.command_inout("QueryDevice");
        }
        catch (DevFailed devFailed) {
            if (!devFailed.errors[0].reason.equals("API_CommandNotFound")) {
                throw devFailed;
            }
            deviceData = this.command_inout("DevQueryDevice");
        }
        String string = "::";
        String[] stringArray = deviceData.extractStringArray();
        String[] stringArray2 = new String[bl ? stringArray.length + 1 : stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            int n = stringArray[i].indexOf(string);
            stringArray2[i] = n > 0 ? stringArray[i].substring(n + string.length()) : stringArray[i];
        }
        if (bl) {
            stringArray2[stringArray2.length - 1] = this.devname;
        }
        return stringArray2;
    }

    public String toString() {
        return this.name;
    }

    public boolean startupLevel(JDialog jDialog, String string, Point point) {
        boolean bl = false;
        try {
            PutServerInfoDialog putServerInfoDialog = new PutServerInfoDialog(jDialog, true);
            putServerInfoDialog.setLocation(point);
            this.updateStartupInfo();
            if (putServerInfoDialog.showDialog(this.info) == 0) {
                this.info = putServerInfoDialog.getSelection();
                if (this.info != null) {
                    this.info.host = string;
                    this.putStartupInfo(this.info);
                } else {
                    if (this.state == DevState.ON) {
                        Utils.popupMessage(jDialog, "Stop " + this.name + "  server before !");
                        return bl;
                    }
                    this.putStartupInfo(new DbServInfo(this.name, string, false, 0));
                    if (this.server == null) {
                        this.server = new DbServer(this.name);
                    }
                    String[] stringArray = this.server.get_device_class_list();
                    for (int i = 0; i < stringArray.length; i += 2) {
                        ApiUtil.get_db_obj().export_device(new DbDevExportInfo(stringArray[i], "", "", ""));
                        ApiUtil.get_db_obj().unexport_device(stringArray[i]);
                    }
                }
                bl = true;
            }
        }
        catch (DevFailed devFailed) {
            devFailed.printStackTrace();
            ErrorPane.showErrorMessage((Component)jDialog, null, (DevFailed)devFailed);
        }
        return bl;
    }

    public String chooseDevice(Component component) throws DevFailed {
        return this.chooseDevice(component, false);
    }

    public String chooseDevice(Component component, boolean bl) throws DevFailed {
        Object[] objectArray = this.queryDevice(bl);
        String string = null;
        switch (objectArray.length) {
            case 0: {
                Except.throw_exception((String)"NO_DEVICE_REGISTRED", (String)"No device registred for this derver", (String)"TangoServer.chooseDevice()");
                break;
            }
            case 1: {
                string = objectArray[0];
                break;
            }
            default: {
                string = (String)JOptionPane.showInputDialog(component, "Device selection :", "", 1, null, objectArray, objectArray[0]);
                if (string != null) break;
                string = null;
            }
        }
        return string;
    }

    public void displayBlackBox(Component component) {
        try {
            String string = this.chooseDevice(component, true);
            if (string == null) {
                return;
            }
            BlackBoxTable blackBoxTable = component instanceof JFrame ? new BlackBoxTable((JFrame)component, string) : new BlackBoxTable((JDialog)component, string);
            blackBoxTable.setVisible(true);
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)component, null, (DevFailed)devFailed);
        }
    }

    public void testDevice(Component component) {
        try {
            String string = this.chooseDevice(component);
            if (string == null) {
                return;
            }
            AstorUtil.testDevice(component, string);
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)component, null, (DevFailed)devFailed);
        }
    }

    public String getServerInfo(Component component, boolean bl) {
        String string = "------------ Server Info ------------\n\n";
        try {
            string = string + this.get_info().toString();
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)component, null, (DevFailed)devFailed);
            return "";
        }
        if (bl) {
            try {
                String[] stringArray = this.queryDevice();
                string = string + "\n\n----------- Device(s) Served -----------\n\n";
                for (String string2 : stringArray) {
                    string = string + string2 + "\n";
                }
            }
            catch (DevFailed devFailed) {
                // empty catch block
            }
        }
        return string;
    }

    public void configureWithWizard(JDialog jDialog) {
        DevWizard devWizard = new DevWizard((Dialog)jDialog);
        devWizard.showClassesWizard(this.name);
    }

    public void manageMemorizedAttributes(JDialog jDialog) {
        try {
            new DbServerArchitecture(jDialog, this.name).setVisible(true);
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)jDialog, null, (DevFailed)devFailed);
        }
    }

    public boolean displayArchitecture(JDialog jDialog) {
        try {
            ServArchitectureDialog servArchitectureDialog = new ServArchitectureDialog(jDialog, this);
            AstorUtil.centerDialog((JDialog)servArchitectureDialog, jDialog);
            servArchitectureDialog.setVisible(true);
        }
        catch (DevFailed devFailed) {
            if (devFailed.errors[0].reason.equals("API_CommandNotFound")) {
                return false;
            }
            ErrorPane.showErrorMessage((Component)jDialog, null, (DevFailed)devFailed);
        }
        return true;
    }

    public String[] getServerUptime() throws DevFailed {
        int n;
        String[] stringArray = new String[]{};
        String string = this.get_info().toString();
        int n2 = string.indexOf("last_exported:");
        if (n2 > 0 && (n = string.indexOf("\n", n2 += "last_exported:".length())) > 0) {
            stringArray = new String[]{string.substring(n2, n).trim(), (n2 = string.indexOf(":", n)) > 0 ? string.substring(n2 + 1).trim() : "???"};
        }
        return stringArray;
    }

    public void displayServerInfo(JDialog jDialog) {
        String string;
        boolean bl = false;
        if (this.state == DevState.ON) {
            bl = this.displayArchitecture(jDialog);
        }
        if (!bl && (string = this.getServerInfo(jDialog, this.state == DevState.ON)).length() > 0) {
            Utils.popupMessage(jDialog, string);
        }
    }

    public void displayClassInfo(JFrame jFrame) {
        try {
            FileOutputStream fileOutputStream;
            String string2;
            if (this.server == null) {
                this.server = new DbServer(this.name);
            }
            String[] stringArray = this.server.get_class_list();
            StringBuffer stringBuffer = new StringBuffer("<FONT SIZE=+2>Tango Device Server " + this.name + " : </font>\n\n");
            stringBuffer.append("<ul>\n");
            for (String string2 : stringArray) {
                stringBuffer.append("<li> <b> Class ").append(string2).append(":</b>\n");
                stringBuffer.append("<ul>\n");
                String[] stringArray2 = AstorUtil.getServerClassProperties(string2);
                if (stringArray2[2].equals("Doc location unknown....")) {
                    stringBuffer.append("Doc location unknown....<Br><Br>\n");
                } else {
                    stringBuffer.append("<a href=\"").append(stringArray2[2]).append("\">\n\t");
                    stringBuffer.append(stringArray2[2]).append("</a>\n<Br><Br>\n");
                }
                if (stringArray2[0] != null) {
                    stringBuffer.append(stringArray2[0]).append("<Br>\n");
                }
                if (stringArray2[1] != null) {
                    stringBuffer.append(stringArray2[1]).append("<Br>\n");
                }
                stringBuffer.append("</ul>\n<Br><Br>");
            }
            stringBuffer.append("</ul>\n");
            int n = new Random().nextInt(30000);
            String string3 = "/tmp/astor." + n;
            try {
                fileOutputStream = new FileOutputStream(string3);
            }
            catch (FileNotFoundException fileNotFoundException) {
                string3 = "c:/temp/astor." + n;
                fileOutputStream = new FileOutputStream(string3);
            }
            fileOutputStream.write("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2//EN\">\n<HTML>\n<BODY TEXT=\"#000000\" BGCOLOR=\"#FFFFFF\" LINK=\"#0000FF\" VLINK=\"#FF0000\" ALINK=\"#FF0000\">\n\n<table width=\"100%\" height=\"20%\"><tr>\n<td align=CENTER>\n<FONT COLOR=\"#0000FF\"><FONT SIZE=+4>E</FONT></FONT><FONT SIZE=+1>UROPEAN</FONT>\n<FONT COLOR=\"#0000FF\"><FONT SIZE=+4>S</FONT></FONT><FONT SIZE=+1>YNCHROTRON</FONT>\n<FONT COLOR=\"#0000FF\"><FONT SIZE=+4>R</FONT></FONT><FONT SIZE=+1>ADIATION</FONT>\n<FONT COLOR=\"#0000FF\"><FONT SIZE=+4>F</FONT></FONT><FONT SIZE=+1>ACILITY</FONT>\n</td><td>\n<IMG SRC=\"http://www.esrf.fr/gifs/logo/80.gif\">\n</td></tr></table>\n<P><Br>\n".getBytes());
            fileOutputStream.write(stringBuffer.toString().getBytes());
            fileOutputStream.write("\n</Body>\n</Html>\n".getBytes());
            fileOutputStream.close();
            string2 = "file:" + string3;
            new PopupHtml(jFrame, true).show(string2);
            if (!new File(string3).delete()) {
                System.err.println("Failed to delete " + string3);
            }
        }
        catch (Exception exception) {
            ErrorPane.showErrorMessage((Component)jFrame, null, (Exception)exception);
            exception.printStackTrace();
        }
    }

    private String indent(String string) {
        int n;
        String string2 = "";
        String string3 = "        ";
        int n2 = 0;
        while ((n = string.indexOf("\n", n2)) >= 0) {
            if (n2 > 0) {
                string2 = string2 + "\n";
            }
            string2 = string2 + string3 + string.substring(n2, n);
            n2 = n + 1;
        }
        if (n2 > 0) {
            string2 = string2 + "\n";
        }
        if ((string2 = string2 + string3 + string.substring(n2)).endsWith("\n")) {
            string2 = string2.substring(0, string2.length() - 2);
        }
        return string2;
    }

    public void checkStates(JDialog jDialog) {
        try {
            Splash splash = new Splash();
            splash.setTitle("Forking State Panel");
            splash.setMessage("Starting");
            splash.setVisible(true);
            splash.progress(10);
            this.statePanel = new ServStatePanel(this.name);
            splash.progress(30);
            this.stateDialog = new JDialog((Dialog)jDialog, false);
            this.stateDialog.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    TangoServer.this.statePanel.stopRefresher();
                    TangoServer.this.stateDialog.setVisible(false);
                    TangoServer.this.stateDialog.dispose();
                }
            });
            JButton jButton = new JButton("Dismiss");
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    TangoServer.this.statePanel.stopRefresher();
                    TangoServer.this.stateDialog.setVisible(false);
                    TangoServer.this.stateDialog.dispose();
                }
            });
            JPanel jPanel = new JPanel();
            jPanel.add(jButton);
            this.stateDialog.getContentPane().add((Component)jPanel, "South");
            splash.progress(50);
            this.stateDialog.getContentPane().add((Component)this.statePanel, "Center");
            this.stateDialog.pack();
            AstorUtil.cascadeDialog(this.stateDialog, jDialog);
            this.stateDialog.setVisible(true);
            splash.setVisible(false);
            return;
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)jDialog, null, (DevFailed)devFailed);
            return;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            System.out.println(noClassDefFoundError);
            try {
                int n;
                String string = "";
                String[] stringArray = this.queryDevice();
                String[] stringArray2 = new String[stringArray.length + 1];
                stringArray2[0] = this.devname;
                System.arraycopy(stringArray, 0, stringArray2, 1, stringArray.length);
                DevState[] devStateArray = new DevState[stringArray2.length];
                for (n = 0; n < stringArray2.length; ++n) {
                    DeviceProxy deviceProxy = new DeviceProxy(stringArray2[n]);
                    devStateArray[n] = deviceProxy.state();
                    string = string + stringArray2[n] + ":    ";
                    string = string + ApiUtil.stateName((DevState)devStateArray[n]) + "\n";
                    if (devStateArray[n] != DevState.FAULT && devStateArray[n] != DevState.ALARM && devStateArray[n] != DevState.UNKNOWN) continue;
                    string = string + this.indent(deviceProxy.status()) + "\n\n";
                }
                n = 0;
                for (int i = 0; i < string.length(); ++i) {
                    if (string.charAt(i) != '\n') continue;
                    ++n;
                }
                if (n <= 40) {
                    Utils.popupMessage(jDialog, string);
                } else {
                    new PopupText(jDialog, true).show(string);
                }
            }
            catch (DevFailed devFailed) {
                ErrorPane.showErrorMessage((Component)jDialog, null, (DevFailed)devFailed);
            }
            return;
        }
    }

    public void restart(Component component, TangoHost tangoHost, boolean bl) {
        String string = bl ? "Are you sure to" : "Do you";
        if (JOptionPane.showConfirmDialog(component, string = string + " want to restart " + this.getName(), "Confirm Dialog", 0) == 0) {
            new restartThread(component, tangoHost, bl).start();
        }
    }

    void poolThreadManager(JDialog jDialog, TangoHost tangoHost) {
        try {
            if (this.pool_thread_man == null) {
                this.pool_thread_man = new PoolThreadsManager(jDialog, tangoHost, this);
            } else {
                this.pool_thread_man.initializeTree();
            }
            this.pool_thread_man.setVisible(true);
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)jDialog, null, (DevFailed)devFailed);
        }
    }

    private class restartThread
    extends Thread {
        private TangoHost host;
        private Component parent;
        private boolean check_stop;

        restartThread(Component component, TangoHost tangoHost, boolean bl) {
            this.host = tangoHost;
            this.parent = component;
            this.check_stop = bl;
        }

        public void run() {
            try {
                long l;
                block8: {
                    try {
                        this.host.stopServer(TangoServer.this.name);
                    }
                    catch (DevFailed devFailed) {
                        if (!this.check_stop) break block8;
                        throw devFailed;
                    }
                }
                long l2 = l = System.currentTimeMillis();
                while (TangoServer.this.state == DevState.ON || TangoServer.this.state == DevState.MOVING && l2 - l < 10000L) {
                    this.host.updateData();
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    l2 = System.currentTimeMillis();
                }
                if (TangoServer.this.state == DevState.ON) {
                    Except.throw_exception((String)"STOP_TIMOUT", (String)("Stopping server " + TangoServer.this.name + " timeout\n" + "may be, it cannot be stopped."), (String)"TangoServer.restartThread.run()");
                }
                this.host.startServer(this.parent, TangoServer.this.name);
            }
            catch (DevFailed devFailed) {
                ErrorPane.showErrorMessage((Component)this.parent, null, (DevFailed)devFailed);
            }
        }
    }
}

