/*
 * Decompiled with CFR 0.152.
 */
package admin.astor;

import admin.astor.EditPropertyDialog;
import admin.astor.tools.Utils;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevInfo;
import fr.esrf.TangoApi.DbClass;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoApi.DbDevice;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceInfo;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoDs.Except;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import jive.MultiLineToolTipUI;

public class ServArchitectureDialog
extends JDialog {
    private String servname;
    private boolean from_appli = true;
    private boolean modified = false;
    private TgServer server;
    private ServInfoTree tree;
    public static final boolean EXPAND_NOT_FULL = false;
    public static final boolean EXPAND_FULL = true;
    private static String separator = ", ";
    private JRadioButton expandBtn;
    private JRadioButton infoBtn;
    private JTextArea textArea;
    private JScrollPane textScrollPane;
    private JLabel titleLabel;
    private JScrollPane treeScrollPane;
    private JRadioButton zmqButton;

    public ServArchitectureDialog(JFrame jFrame, String string) throws DevFailed {
        super((Frame)jFrame, false);
        this.servname = string;
        this.initComponents();
        this.initOwnComponent(jFrame);
    }

    public ServArchitectureDialog(JDialog jDialog, DeviceProxy deviceProxy) throws DevFailed {
        super((Dialog)jDialog, false);
        this.servname = deviceProxy.get_name().substring("dserver/".length());
        this.initComponents();
        this.initOwnComponent(jDialog);
    }

    private void initOwnComponent(Component component) throws DevFailed {
        this.tree = new ServInfoTree(this);
        this.treeScrollPane.setViewportView(this.tree);
        this.treeScrollPane.setPreferredSize(new Dimension(350, 450));
        this.textScrollPane.setPreferredSize(new Dimension(350, 180));
        this.titleLabel.setText(this.servname + "  Information");
        if (component == null) {
            this.from_appli = false;
        }
        MultiLineToolTipUI.initialize();
        this.pack();
        this.tree.expandTree(false);
    }

    private void initComponents() {
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        this.titleLabel = new JLabel();
        this.zmqButton = new JRadioButton();
        JPanel jPanel3 = new JPanel();
        this.textScrollPane = new JScrollPane();
        this.textArea = new JTextArea();
        this.treeScrollPane = new JScrollPane();
        JPanel jPanel4 = new JPanel();
        this.expandBtn = new JRadioButton();
        this.infoBtn = new JRadioButton();
        JButton jButton = new JButton();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ServArchitectureDialog.this.closeDialog(windowEvent);
            }
        });
        jPanel.setLayout(new BorderLayout());
        this.titleLabel.setFont(new Font("Dialog", 1, 18));
        this.titleLabel.setText("Dialog Title");
        jPanel2.add(this.titleLabel);
        jPanel.add((Component)jPanel2, "Center");
        this.zmqButton.setText("ZMQ event system compatible");
        this.zmqButton.setEnabled(false);
        jPanel.add((Component)this.zmqButton, "South");
        this.getContentPane().add((Component)jPanel, "North");
        jPanel3.setLayout(new BorderLayout());
        this.textScrollPane.setPreferredSize(new Dimension(200, 170));
        this.textArea.setEditable(false);
        this.textScrollPane.setViewportView(this.textArea);
        jPanel3.add((Component)this.textScrollPane, "North");
        jPanel3.add((Component)this.treeScrollPane, "Center");
        this.getContentPane().add((Component)jPanel3, "Center");
        this.expandBtn.setText("Expand tree");
        this.expandBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ServArchitectureDialog.this.expandBtnActionPerformed(actionEvent);
            }
        });
        jPanel4.add(this.expandBtn);
        this.infoBtn.setSelected(true);
        this.infoBtn.setText("Info");
        this.infoBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ServArchitectureDialog.this.infoBtnActionPerformed(actionEvent);
            }
        });
        jPanel4.add(this.infoBtn);
        jButton.setText("Dismiss");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ServArchitectureDialog.this.cancelBtnActionPerformed(actionEvent);
            }
        });
        jPanel4.add(jButton);
        this.getContentPane().add((Component)jPanel4, "South");
        this.pack();
    }

    private void infoBtnActionPerformed(ActionEvent actionEvent) {
        boolean bl = this.infoBtn.getSelectedObjects() != null;
        this.textScrollPane.setVisible(bl);
        this.pack();
    }

    private void expandBtnActionPerformed(ActionEvent actionEvent) {
        if (this.expandBtn.getSelectedObjects() != null) {
            this.tree.expandTree(true);
        } else {
            this.tree.expandTree(false);
        }
    }

    private void cancelBtnActionPerformed(ActionEvent actionEvent) {
        this.doClose();
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.doClose();
    }

    private void doClose() {
        if (this.modified && JOptionPane.showConfirmDialog(this, "Some properties have been modified !\n\nDo you want a restart devices ?", "Dialog", 0) == 0) {
            try {
                new DeviceProxy("dserver/" + this.servname).command_inout("init");
            }
            catch (DevFailed devFailed) {
                Utils.popupError(this, null, (Exception)((Object)devFailed));
            }
        }
        this.setVisible(false);
        this.dispose();
        if (!this.from_appli) {
            System.exit(0);
        }
    }

    public void showDialog() {
        this.setVisible(true);
    }

    public static String multiLine2OneLine(String string) {
        int n;
        if (string == null) {
            return string;
        }
        while ((n = string.indexOf(10)) >= 0) {
            string = string.substring(0, n) + separator + string.substring(n + 1);
        }
        return string;
    }

    public static String OneLine2multiLine(String string) {
        int n;
        if (string == null) {
            return string;
        }
        while ((n = string.indexOf(separator)) >= 0) {
            string = string.substring(0, n) + "\n" + string.substring(n + separator.length());
        }
        return string;
    }

    public static String[] string2array(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, separator);
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        String[] stringArray = new String[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            stringArray[i] = (String)arrayList.get(i);
        }
        return stringArray;
    }

    public static void main(String[] stringArray) {
        String string = "VacGaugeServer/sr_c27-ip";
        if (stringArray.length > 0) {
            string = stringArray[0];
        }
        try {
            new ServArchitectureDialog(null, string).setVisible(true);
        }
        catch (DevFailed devFailed) {
            Utils.popupError(new JDialog(), null, (Exception)((Object)devFailed));
            System.exit(0);
        }
    }

    private class TangoRenderer
    extends DefaultTreeCellRenderer {
        private ImageIcon root_icon = new ImageIcon(this.getClass().getResource("/admin/astor/images/network5.gif"));
        private ImageIcon class_icon = new ImageIcon(this.getClass().getResource("/admin/astor/images/class.gif"));
        private ImageIcon prop_icon = new ImageIcon(this.getClass().getResource("/admin/astor/images/attleaf.gif"));
        private ImageIcon leaf_icon = new ImageIcon(this.getClass().getResource("/admin/astor/images/uleaf.gif"));
        private Font[] fonts = new Font[5];
        private final int TITLE = 0;
        private final int CLASS = 1;
        private final int DEVICE = 2;
        private final int PROP_NAME = 3;
        private final int PROP_DESC = 4;

        public TangoRenderer() {
            this.fonts[0] = new Font("helvetica", 1, 18);
            this.fonts[1] = new Font("helvetica", 1, 16);
            this.fonts[2] = new Font("helvetica", 1, 12);
            this.fonts[3] = new Font("helvetica", 0, 12);
            this.fonts[4] = new Font("helvetica", 0, 10);
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            String string = null;
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            Object object2 = defaultMutableTreeNode.getUserObject();
            if (n == 0) {
                this.setIcon(this.root_icon);
                this.setFont(this.fonts[0]);
                string = ((TgServer)object2).desc;
                string = string + "\n\n" + ((TgServer)object2).nbDevices + "  devices";
            } else if (object2 instanceof TgClass) {
                this.setIcon(this.class_icon);
                this.setFont(this.fonts[1]);
                string = ((TgClass)((Object)object2)).desc;
                string = string + "\n" + ((TgClass)((Object)object2)).nbDevices + "  devices";
            } else if (object2 instanceof TgDevice) {
                this.setIcon(this.class_icon);
                this.setFont(this.fonts[2]);
            } else if (object2 instanceof TgProperty) {
                this.setIcon(this.prop_icon);
                this.setFont(this.fonts[3]);
                string = ((TgProperty)object2).desc;
            } else if (object2 instanceof String) {
                this.setIcon(this.leaf_icon);
                this.setFont(this.fonts[4]);
            }
            this.setToolTipText(string);
            return this;
        }
    }

    public class TgProperty {
        public String objname;
        public String src;
        public String name;
        public String desc;
        public String def_value;
        public String db_value = null;

        public TgProperty(String string, String string2, String string3, String string4, String string5) {
            this.objname = string;
            this.src = string2;
            this.name = string3;
            this.desc = string4;
            this.def_value = "";
            this.def_value = ServArchitectureDialog.multiLine2OneLine(string5);
        }

        public void setDbValue(String[] stringArray) {
            this.db_value = "";
            for (int i = 0; i < stringArray.length; ++i) {
                this.db_value = this.db_value + stringArray[i];
                if (i >= stringArray.length - 1) continue;
                this.db_value = this.db_value + ", ";
            }
        }

        public String getValue() {
            if (this.db_value == null) {
                return this.def_value;
            }
            return this.db_value;
        }

        public String toString(boolean bl) {
            if (bl) {
                return this.src + ": " + this.objname + "/" + this.name + " : \n" + this.desc + "\n" + "    default  value:  " + this.def_value + "\n" + "    database value:  " + this.db_value;
            }
            return this.toString();
        }

        public String toString() {
            return this.name;
        }
    }

    class TgClass
    extends DbClass {
        String name;
        String desc;
        String tagName;
        TgProperty[] properties;
        int nbDevices;

        public TgClass(String string, TgProperty[] tgPropertyArray) throws DevFailed {
            super(string);
            this.tagName = null;
            this.nbDevices = 0;
            this.name = string;
            this.desc = "No Description Found in Database";
            try {
                DbDatum dbDatum = this.get_property("Description");
                if (!dbDatum.is_empty()) {
                    DbDatum dbDatum2 = dbDatum.extractStringArray();
                    this.desc = "";
                    for (String string2 : dbDatum2) {
                        this.desc = this.desc + string2 + "\n";
                    }
                }
                this.properties = new TgProperty[tgPropertyArray.length];
                for (int i = 0; i < tgPropertyArray.length; ++i) {
                    this.properties[i] = new TgProperty(string, tgPropertyArray[i].src, tgPropertyArray[i].name, tgPropertyArray[i].desc, tgPropertyArray[i].def_value);
                    DbDatum dbDatum3 = this.get_property(tgPropertyArray[i].name);
                    if (dbDatum3.is_empty()) continue;
                    this.properties[i].setDbValue(dbDatum3.extractStringArray());
                }
            }
            catch (DevFailed devFailed) {
                // empty catch block
            }
        }

        void put_property(TgProperty tgProperty) throws DevFailed {
            if (tgProperty.db_value == null) {
                this.delete_property(tgProperty.name);
            } else {
                String[] stringArray = ServArchitectureDialog.string2array(tgProperty.db_value);
                DbDatum[] dbDatumArray = new DbDatum[]{new DbDatum(tgProperty.name)};
                dbDatumArray[0].insert(stringArray);
                this.put_property(dbDatumArray);
            }
        }

        public void setTagName(String string) {
            this.tagName = string;
        }

        public String toString() {
            String string = "Class: ";
            string = this.tagName != null ? (this.tagName.startsWith(this.name) ? string + this.tagName : string + this.name) : string + this.name;
            return string;
        }
    }

    class TgDevice
    extends DeviceProxy {
        String name;
        TgProperty[] properties;

        public TgDevice(String string, TgProperty[] tgPropertyArray) throws DevFailed {
            super(string);
            this.name = string;
            this.properties = new TgProperty[tgPropertyArray.length];
            for (int i = 0; i < tgPropertyArray.length; ++i) {
                this.properties[i] = new TgProperty(string, tgPropertyArray[i].src, tgPropertyArray[i].name, tgPropertyArray[i].desc, tgPropertyArray[i].def_value);
                try {
                    DbDatum dbDatum = this.get_property(tgPropertyArray[i].name);
                    if (dbDatum.is_empty()) continue;
                    this.properties[i].setDbValue(dbDatum.extractStringArray());
                    continue;
                }
                catch (DevFailed devFailed) {
                    Except.print_exception((Exception)((Object)devFailed));
                }
            }
        }

        void put_property(TgProperty tgProperty) throws DevFailed {
            if (tgProperty.db_value == null) {
                this.delete_property(tgProperty.name);
            } else {
                String[] stringArray = ServArchitectureDialog.string2array(tgProperty.db_value);
                DbDatum[] dbDatumArray = new DbDatum[]{new DbDatum(tgProperty.name)};
                dbDatumArray[0].insert(stringArray);
                this.put_property(dbDatumArray);
            }
        }

        public String getTagName() {
            String string = "";
            try {
                int n;
                DevInfo devInfo = this.info();
                String string2 = devInfo.doc_url;
                String string3 = "CVS Tag = ";
                int n2 = string2.indexOf(string3);
                if (n2 > 0 && (n = string2.indexOf(10, n2 += string3.length())) > n2) {
                    string = string2.substring(n2, n);
                }
            }
            catch (DevFailed devFailed) {
                // empty catch block
            }
            return string;
        }

        public String toString() {
            return "Device: " + this.name;
        }
    }

    class TgServer {
        String name;
        String desc;
        int nbDevices = 0;

        public TgServer(String string) {
            this.name = string;
            this.desc = "";
            try {
                String string2 = "dserver/" + string;
                DeviceInfo deviceInfo = new DbDevice(string2).get_info();
                this.desc = deviceInfo.toString();
                ServArchitectureDialog.this.textArea.setText(this.desc);
            }
            catch (DevFailed devFailed) {
                // empty catch block
            }
        }

        public String toString() {
            return this.name;
        }
    }

    class ServInfoTree
    extends JTree {
        private Component parent;
        private DeviceProxy deviceProxy = null;
        private String[] devlist = null;
        private DefaultTreeModel treeModel;
        private DefaultMutableTreeNode root;

        public ServInfoTree(Component component) throws DevFailed {
            this.parent = component;
            this.initComponent();
        }

        void expandTree(boolean bl) {
            this.expandTree(this.root, bl);
        }

        private void expandTree(DefaultMutableTreeNode defaultMutableTreeNode, boolean bl) {
            int n = defaultMutableTreeNode.getChildCount();
            for (int i = 0; i < n; ++i) {
                TreePath treePath;
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
                Object object = defaultMutableTreeNode2.getUserObject();
                if (bl || object instanceof TgProperty) {
                    treePath = new TreePath(defaultMutableTreeNode2.getPath());
                    this.expandPath(treePath);
                    this.expandTree(defaultMutableTreeNode2, bl);
                }
                if (bl || object instanceof TgProperty) continue;
                treePath = new TreePath(defaultMutableTreeNode2.getPath());
                this.collapsePath(treePath);
            }
        }

        private void initComponent() throws DevFailed {
            ServArchitectureDialog.this.server = new TgServer(ServArchitectureDialog.this.servname);
            this.root = new DefaultMutableTreeNode(ServArchitectureDialog.this.server);
            this.createNodes(this.root);
            this.getSelectionModel().setSelectionMode(1);
            this.treeModel = new DefaultTreeModel(this.root);
            this.setModel(this.treeModel);
            ToolTipManager.sharedInstance().registerComponent(this);
            this.setCellRenderer(new TangoRenderer());
            this.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    ServInfoTree.this.treeMouseClicked(mouseEvent);
                }
            });
            ServArchitectureDialog.this.zmqButton.setSelected(this.isZmqCompatible());
        }

        private void createNodes(DefaultMutableTreeNode defaultMutableTreeNode) throws DevFailed {
            if (this.deviceProxy == null) {
                this.deviceProxy = new DeviceProxy("dserver/" + ServArchitectureDialog.this.servname);
            }
            TgClass[] tgClassArray = this.getClasses();
            ((ServArchitectureDialog)ServArchitectureDialog.this).server.nbDevices = 0;
            for (TgClass tgClass : tgClassArray) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode((Object)tgClass);
                defaultMutableTreeNode.add(defaultMutableTreeNode2);
                for (int i = 0; i < tgClass.properties.length; ++i) {
                    TgDevice[] tgDeviceArray = tgClass.properties[i];
                    DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(tgDeviceArray);
                    defaultMutableTreeNode2.add(defaultMutableTreeNode3);
                    defaultMutableTreeNode3.add(new DefaultMutableTreeNode(tgDeviceArray.getValue()));
                }
                TgDevice[] tgDeviceArray = this.getDevices(tgClass.name);
                tgClass.nbDevices = tgDeviceArray.length;
                ((ServArchitectureDialog)ServArchitectureDialog.this).server.nbDevices += tgClass.nbDevices;
                for (TgDevice tgDevice : tgDeviceArray) {
                    DefaultMutableTreeNode defaultMutableTreeNode4 = new DefaultMutableTreeNode((Object)tgDevice);
                    defaultMutableTreeNode2.add(defaultMutableTreeNode4);
                    for (TgProperty tgProperty : tgDevice.properties) {
                        DefaultMutableTreeNode defaultMutableTreeNode5 = new DefaultMutableTreeNode(tgProperty);
                        defaultMutableTreeNode4.add(defaultMutableTreeNode5);
                        defaultMutableTreeNode5.add(new DefaultMutableTreeNode(tgProperty.getValue()));
                    }
                }
                if (tgDeviceArray.length <= 0) continue;
                tgClass.setTagName(tgDeviceArray[0].getTagName());
            }
        }

        private TgDevice[] getDevices(String string) throws DevFailed {
            DeviceData deviceData;
            if (this.devlist == null) {
                deviceData = this.deviceProxy.command_inout("QueryDevice");
                this.devlist = deviceData.extractStringArray();
            }
            deviceData = new ArrayList();
            String string2 = string + "::";
            for (String string3 : this.devlist) {
                if (!string3.startsWith(string2)) continue;
                deviceData.add(string3.substring(string2.length()));
            }
            String[] stringArray = new String[deviceData.size()];
            for (int i = 0; i < deviceData.size(); ++i) {
                stringArray[i] = (String)deviceData.get(i);
            }
            TgProperty[] tgPropertyArray = this.getProperties(string, "Dev");
            TgDevice[] tgDeviceArray = new TgDevice[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                tgDeviceArray[i] = new TgDevice(stringArray[i], tgPropertyArray);
            }
            return tgDeviceArray;
        }

        private TgClass[] getClasses() throws DevFailed {
            DeviceData deviceData = this.deviceProxy.command_inout("QueryClass");
            String[] stringArray = deviceData.extractStringArray();
            TgClass[] tgClassArray = new TgClass[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                TgProperty[] tgPropertyArray = this.getProperties(stringArray[i], "Class");
                tgClassArray[i] = new TgClass(stringArray[i], tgPropertyArray);
            }
            return tgClassArray;
        }

        private TgProperty[] getProperties(String string, String string2) throws DevFailed {
            DeviceData deviceData = new DeviceData();
            deviceData.insert(string);
            String string3 = "QueryWizard" + string2 + "Property";
            DeviceData deviceData2 = this.deviceProxy.command_inout(string3, deviceData);
            String[] stringArray = deviceData2.extractStringArray();
            TgProperty[] tgPropertyArray = new TgProperty[stringArray.length / 3];
            int n = 0;
            for (int i = 0; i < stringArray.length; i += 3) {
                tgPropertyArray[n] = new TgProperty(string, string2, stringArray[i], stringArray[i + 1], stringArray[i + 2]);
                ++n;
            }
            return tgPropertyArray;
        }

        private boolean isZmqCompatible() {
            try {
                this.deviceProxy.command_query("ZmqEventSubscriptionChange");
                return true;
            }
            catch (DevFailed devFailed) {
                return false;
            }
        }

        private void treeMouseClicked(MouseEvent mouseEvent) {
            if (this.getRowForLocation(mouseEvent.getX(), mouseEvent.getY()) < 1) {
                return;
            }
            int n = mouseEvent.getModifiers();
            if (mouseEvent.getClickCount() == 2 && (n & 0x10) != 0) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
                Object object = defaultMutableTreeNode.getUserObject();
                if (defaultMutableTreeNode.isLeaf() && object instanceof String) {
                    this.editProperty(defaultMutableTreeNode);
                }
            }
        }

        private void editProperty(DefaultMutableTreeNode defaultMutableTreeNode) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
            TgProperty tgProperty = (TgProperty)defaultMutableTreeNode2.getUserObject();
            EditPropertyDialog editPropertyDialog = this.parent instanceof JDialog ? new EditPropertyDialog((JDialog)this.parent, tgProperty) : new EditPropertyDialog((JFrame)this.parent, tgProperty);
            tgProperty = editPropertyDialog.showDialog();
            if (tgProperty != null) {
                DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode2.getParent();
                Object object = defaultMutableTreeNode3.getUserObject();
                try {
                    if (object instanceof TgClass) {
                        TgClass tgClass = (TgClass)((Object)object);
                        tgClass.put_property(tgProperty);
                        this.replaceNode(defaultMutableTreeNode, tgProperty.getValue());
                        ServArchitectureDialog.this.modified = true;
                    } else if (object instanceof TgDevice) {
                        TgDevice tgDevice = (TgDevice)((Object)object);
                        tgDevice.put_property(tgProperty);
                        this.replaceNode(defaultMutableTreeNode, tgProperty.getValue());
                        ServArchitectureDialog.this.modified = true;
                    } else {
                        System.out.println("object " + object + "  not implemented !");
                    }
                }
                catch (DevFailed devFailed) {
                    Utils.popupError(this, null, (Exception)((Object)devFailed));
                }
            }
        }

        private void replaceNode(DefaultMutableTreeNode defaultMutableTreeNode, String string) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
            int n = 0;
            for (int i = 0; i < defaultMutableTreeNode2.getChildCount(); ++i) {
                if (!defaultMutableTreeNode2.getChildAt(i).equals(defaultMutableTreeNode)) continue;
                n = i;
            }
            DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(string);
            this.treeModel.insertNodeInto(defaultMutableTreeNode3, defaultMutableTreeNode2, n);
            this.treeModel.removeNodeFromParent(defaultMutableTreeNode);
        }
    }
}

