/*
 * Decompiled with CFR 0.152.
 */
package admin.astor;

import admin.astor.Astor;
import admin.astor.AstorDefs;
import admin.astor.AstorUtil;
import admin.astor.MkStarter;
import admin.astor.PropListDialog;
import admin.astor.TangoHost;
import admin.astor.tools.Utils;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoApi.DeviceProxy;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewStarterDialog
extends JDialog
implements AstorDefs {
    private Astor parent;
    private TangoHost[] hosts;
    private TangoHost h;
    private ArrayList<String> collec;
    private int retVal = 2;
    private boolean creating;
    private JButton createBtn;
    private JButton familyBtn;
    private JTextField familyText;
    private JTextField hostText;
    private JLabel jLabel2;
    private JLabel jLabel4;
    private JTextArea pathText;
    private JLabel titleLbl;
    private JTextField usageText;
    private JRadioButton useEventsBtn;

    private boolean getUseEvents() {
        boolean bl = false;
        try {
            DbDatum dbDatum = this.h.get_property("UseEvents");
            if (!dbDatum.is_empty()) {
                bl = dbDatum.extractBoolean();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    public NewStarterDialog(Astor astor, TangoHost tangoHost, ArrayList<String> arrayList, TangoHost[] tangoHostArray, boolean bl) {
        super((Frame)astor, true);
        this.parent = astor;
        this.hosts = tangoHostArray;
        this.creating = bl;
        this.collec = new ArrayList();
        for (int i = 1; i < arrayList.size(); ++i) {
            this.collec.add(arrayList.get(i));
        }
        this.initComponents();
        this.h = tangoHost;
        if (tangoHost != null) {
            String[] stringArray;
            String string = tangoHost.getName();
            for (String string2 : stringArray = tangoHost.getPath()) {
                this.pathText.append(string2 + "\n");
            }
            this.usageText.setText(tangoHost.usage);
            this.familyText.setText(tangoHost.getFamily());
            this.hostText.setText(string);
            this.useEventsBtn.setSelected(this.getUseEvents());
            if (bl) {
                this.familyText.setText(tangoHost.getFamily());
                this.hostText.setText(string);
                this.hostText.select(0, string.length());
            } else {
                this.titleLbl.setText("Change property for " + string + " starter in database");
                this.jLabel2.setText("  ");
                this.hostText.setVisible(false);
                this.jLabel4.setVisible(false);
                this.familyText.setVisible(false);
                this.familyBtn.setVisible(false);
                this.createBtn.setText("Apply");
            }
        }
        this.pack();
        AstorUtil.centerDialog((JDialog)this, astor);
    }

    private void initComponents() {
        JPanel jPanel = new JPanel();
        this.titleLbl = new JLabel();
        JPanel jPanel2 = new JPanel();
        this.jLabel4 = new JLabel();
        JLabel jLabel = new JLabel();
        this.hostText = new JTextField();
        this.jLabel2 = new JLabel();
        this.familyText = new JTextField();
        JButton jButton = new JButton();
        this.familyBtn = new JButton();
        JScrollPane jScrollPane = new JScrollPane();
        this.pathText = new JTextArea();
        JLabel jLabel2 = new JLabel();
        this.usageText = new JTextField();
        this.useEventsBtn = new JRadioButton();
        JPanel jPanel3 = new JPanel();
        this.createBtn = new JButton();
        JLabel jLabel3 = new JLabel();
        JButton jButton2 = new JButton();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                NewStarterDialog.this.closeDialog(windowEvent);
            }
        });
        this.titleLbl.setFont(new Font("Dialog", 1, 14));
        this.titleLbl.setText("Create a Starter in Database For a New Host");
        jPanel.add(this.titleLbl);
        this.getContentPane().add((Component)jPanel, "North");
        jPanel2.setLayout(new GridBagLayout());
        this.jLabel4.setText("Host name :");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        jPanel2.add((Component)this.jLabel4, gridBagConstraints);
        jLabel.setText("Device Servers PATH :");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(20, 0, 0, 0);
        jPanel2.add((Component)jLabel, gridBagConstraints);
        this.hostText.setColumns(20);
        this.hostText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NewStarterDialog.this.hostTextActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)this.hostText, gridBagConstraints);
        this.jLabel2.setText("Host Family:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        jPanel2.add((Component)this.jLabel2, gridBagConstraints);
        this.familyText.setColumns(20);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)this.familyText, gridBagConstraints);
        jButton.setText("...");
        jButton.setMargin(new Insets(2, 5, 2, 5));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NewStarterDialog.this.pathBtnActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.insets = new Insets(20, 0, 0, 0);
        jPanel2.add((Component)jButton, gridBagConstraints);
        this.familyBtn.setText("...");
        this.familyBtn.setMargin(new Insets(2, 5, 2, 5));
        this.familyBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NewStarterDialog.this.familyBtnActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        jPanel2.add((Component)this.familyBtn, gridBagConstraints);
        jScrollPane.setPreferredSize(new Dimension(300, 180));
        jScrollPane.setViewportView(this.pathText);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)jScrollPane, gridBagConstraints);
        jLabel2.setText("Host Usage:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        jPanel2.add((Component)jLabel2, gridBagConstraints);
        this.usageText.setColumns(20);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)this.usageText, gridBagConstraints);
        this.useEventsBtn.setText("Use Events");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        jPanel2.add((Component)this.useEventsBtn, gridBagConstraints);
        this.getContentPane().add((Component)jPanel2, "Center");
        this.createBtn.setText("Create");
        this.createBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NewStarterDialog.this.createBtnActionPerformed(actionEvent);
            }
        });
        jPanel3.add(this.createBtn);
        jLabel3.setText("          ");
        jPanel3.add(jLabel3);
        jButton2.setText("Cancel");
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NewStarterDialog.this.cancelBtnActionPerformed(actionEvent);
            }
        });
        jPanel3.add(jButton2);
        this.getContentPane().add((Component)jPanel3, "South");
        this.pack();
    }

    private void hostTextActionPerformed(ActionEvent actionEvent) {
    }

    private void familyBtnActionPerformed(ActionEvent actionEvent) {
        PropListDialog propListDialog = new PropListDialog((JFrame)this.parent, this.collec);
        propListDialog.showDialog();
        String string = propListDialog.getSelectedItem();
        if (string != null) {
            this.familyText.setText(string);
        }
    }

    private void pathBtnActionPerformed(ActionEvent actionEvent) {
        new PropListDialog(this.parent, this.pathText, this.hosts).showDialog();
    }

    private void cancelBtnActionPerformed(ActionEvent actionEvent) {
        this.retVal = 2;
        this.doClose();
    }

    private void createBtnActionPerformed(ActionEvent actionEvent) {
        String string = this.hostText.getText();
        String string2 = this.usageText.getText();
        String string3 = this.familyText.getText();
        String string4 = this.pathText.getText().trim();
        if (string.length() == 0 || string4.length() == 0) {
            JOptionPane.showMessageDialog(this.parent, "Fill the fields before creation !", "Warning", 2);
            return;
        }
        try {
            Object object;
            string4 = NewStarterDialog.manageBackSlash(string4);
            String[] stringArray = AstorUtil.string2StringArray(string4);
            boolean bl = this.useEventsBtn.getSelectedObjects() != null;
            MkStarter mkStarter = new MkStarter(string, stringArray, bl);
            if (this.creating) {
                mkStarter.create();
            }
            mkStarter.setProperties();
            mkStarter.setAdditionalProperties(string2, string3);
            if (this.h != null && !this.creating && !string2.equals(this.h.usage)) {
                this.h.usage = string2;
                object = this.parent;
                ((Astor)object).tree.changeHostNode(this.h);
            }
            if (this.creating) {
                object = "A Starter server has been created in TANGO database.\n\nYou can now start it on " + string + " machine.";
            } else {
                object = "The property has been modified in database";
                try {
                    String string5 = "tango/admin/" + string;
                    new DeviceProxy(string5).command_inout("Init");
                    object = (String)object + "\nand the device has been re-initialized.";
                }
                catch (DevFailed devFailed) {
                    // empty catch block
                }
            }
            JOptionPane.showMessageDialog(this.parent, object, "Command Done", 1);
        }
        catch (DevFailed devFailed) {
            Utils.popupError(this.parent, null, (Exception)((Object)devFailed));
            return;
        }
        this.retVal = 0;
        this.doClose();
    }

    static String manageBackSlash(String string) {
        String string2 = "";
        int n = 0;
        while ((n = string.indexOf("\\", n)) >= 0) {
            string2 = string2 + string.substring(0, ++n);
            string2 = string2 + "\\";
            string = string.substring(n);
            n = 0;
        }
        string2 = string2 + string;
        return string2;
    }

    int getValue() {
        return this.retVal;
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.retVal = 2;
        this.doClose();
    }

    private void doClose() {
        this.setVisible(false);
        this.dispose();
    }
}

