/*
 * Decompiled with CFR 0.152.
 */
package admin.astor;

import admin.astor.HostInfoDialog;
import admin.astor.TangoServer;
import admin.astor.tools.Utils;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevState;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoApi.IORdump;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import jive.DevWizard;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListDialog
extends JDialog {
    private static String str_filter = "*";
    private static String previous_item = null;
    private HostInfoDialog parent;
    private ArrayList<String> selectedItems = null;
    private JButton cancelBtn;
    private JButton createBtn;
    private JTextField filterTxt;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JList jList;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JButton startBtn;

    private void setList() throws DevFailed {
        str_filter = this.filterTxt.getText();
        String[] stringArray = ApiUtil.get_db_obj().get_server_list(str_filter);
        this.jList.setListData(stringArray);
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(previous_item)) continue;
            this.jList.setSelectedIndex(i);
        }
    }

    public ListDialog(HostInfoDialog hostInfoDialog) {
        super((Dialog)hostInfoDialog, true);
        this.parent = hostInfoDialog;
        this.initComponents();
        this.filterTxt.setText(str_filter);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                ListDialog.this.listSelectionPerformed(mouseEvent);
            }
        };
        this.jList.addMouseListener(mouseAdapter);
        this.pack();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.startBtn = new JButton();
        this.cancelBtn = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jList = new JList();
        this.jPanel2 = new JPanel();
        this.jLabel2 = new JLabel();
        this.jLabel1 = new JLabel();
        this.filterTxt = new JTextField();
        this.createBtn = new JButton();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ListDialog.this.closeDialog(windowEvent);
            }
        });
        this.startBtn.setText("Start Server");
        this.startBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ListDialog.this.startBtnActionPerformed(actionEvent);
            }
        });
        this.jPanel1.add(this.startBtn);
        this.cancelBtn.setText("Cancel");
        this.cancelBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ListDialog.this.cancelBtnActionPerformed(actionEvent);
            }
        });
        this.jPanel1.add(this.cancelBtn);
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.jScrollPane1.setPreferredSize(new Dimension(200, 300));
        this.jScrollPane1.setViewportView(this.jList);
        this.getContentPane().add((Component)this.jScrollPane1, "Center");
        this.jLabel2.setText("Filter :  ");
        this.jPanel2.add(this.jLabel2);
        this.jPanel2.add(this.jLabel1);
        this.filterTxt.setColumns(20);
        this.filterTxt.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ListDialog.this.filterTxtActionPerformed(actionEvent);
            }
        });
        this.jPanel2.add(this.filterTxt);
        this.createBtn.setText("Create New Server");
        this.createBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ListDialog.this.createBtnActionPerformed(actionEvent);
            }
        });
        this.jPanel2.add(this.createBtn);
        this.getContentPane().add((Component)this.jPanel2, "North");
    }

    private void createBtnActionPerformed(ActionEvent actionEvent) {
        block5: {
            try {
                DevWizard devWizard = new DevWizard((Dialog)this.parent, (DeviceProxy)this.parent.host);
                devWizard.showWizard(null);
                String string = DevWizard.lastServStarted;
                if (string == null) break block5;
                Point point = this.getLocationOnScreen();
                point.translate(50, 50);
                try {
                    if (new TangoServer(string, DevState.OFF).startupLevel(this.parent, this.parent.host.getName(), point)) {
                        this.parent.updateData();
                    }
                }
                catch (DevFailed devFailed) {
                    Utils.popupError(this.parent, null, (Exception)((Object)devFailed));
                }
            }
            catch (NoSuchMethodError noSuchMethodError) {
                Utils.popupError(this.parent, "This server is too old !\nUse Jive to create it.");
            }
        }
        this.setVisible(false);
        this.dispose();
    }

    private void filterTxtActionPerformed(ActionEvent actionEvent) {
        try {
            this.setList();
        }
        catch (DevFailed devFailed) {
            Utils.popupError(this.parent, null, (Exception)((Object)devFailed));
        }
    }

    private void cancelBtnActionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
        this.dispose();
    }

    private void startBtnActionPerformed(ActionEvent actionEvent) {
        this.retreiveSelectedItem();
    }

    private void listSelectionPerformed(MouseEvent mouseEvent) {
        previous_item = (String)this.jList.getSelectedValue();
        if (mouseEvent.getClickCount() == 2) {
            this.retreiveSelectedItem();
        }
    }

    private void retreiveSelectedItem() {
        Object[] objectArray;
        this.selectedItems = new ArrayList();
        for (Object object : objectArray = this.jList.getSelectedValues()) {
            String string = (String)object;
            try {
                String string2 = "dserver/" + string;
                DeviceProxy deviceProxy = new DeviceProxy(string2);
                try {
                    deviceProxy.ping();
                    Utils.popupError(this.parent, string + "  is Already Running  on " + new IORdump(string2).get_host() + " !");
                    return;
                }
                catch (DevFailed devFailed) {
                }
            }
            catch (DevFailed devFailed) {
                Utils.popupError(this.parent, null, (Exception)((Object)devFailed));
                return;
            }
            this.selectedItems.add(string);
        }
        this.setVisible(false);
        this.dispose();
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.setVisible(false);
        this.dispose();
    }

    public void showDialog() {
        try {
            this.setList();
        }
        catch (DevFailed devFailed) {
            Utils.popupError(this.parent, null, (Exception)((Object)devFailed));
        }
        this.setVisible(true);
    }

    public ArrayList<String> getSelectedItems() {
        return this.selectedItems;
    }
}

