/*
 * Decompiled with CFR 0.152.
 */
package admin.astor;

import admin.astor.Astor;
import admin.astor.AstorDefs;
import admin.astor.AstorUtil;
import admin.astor.LevelTree;
import admin.astor.ListDialog;
import admin.astor.ServerCmdThread;
import admin.astor.ServerPopupMenu;
import admin.astor.TangoHost;
import admin.astor.TangoServer;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevState;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoApi.events.ITangoChangeListener;
import fr.esrf.TangoApi.events.TangoChange;
import fr.esrf.TangoApi.events.TangoChangeEvent;
import fr.esrf.TangoApi.events.TangoEventsAdapter;
import fr.esrf.TangoDs.Except;
import fr.esrf.TangoDs.TangoConst;
import fr.esrf.tangoatk.widget.util.ATKConstant;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HostInfoDialog
extends JDialog
implements AstorDefs,
TangoConst {
    public TangoHost host;
    public String name;
    private Astor astor;
    private Color bg = null;
    private String attribute = "Servers";
    private static final int NO_CHANGE = 0;
    private static final int LIST_CHANGED = 1;
    private static final int STATE_CHANGED = 2;
    private static Dimension preferred_size;
    private JScrollPane scrollPane = null;
    private LevelTree[] trees = null;
    private JPanel levelsPanel = null;
    private JPanel[] treePanels;
    private JPanel notifdPanel;
    private JLabel notifdLabel;
    private ServerPopupMenu notifd_menu;
    private JButton StartAllBtn;
    private JPanel btnPanel;
    private JButton cancelBtn;
    private JPanel centerPanel;
    private JRadioButton displayAllBtn;
    private JPanel jPanel1;
    private JButton startNewBtn;
    private JButton stopAllBtn;
    private JLabel titleLabel;
    private JPanel titlePanel;

    public HostInfoDialog(Astor astor, TangoHost tangoHost) {
        super((Frame)astor, false);
        this.astor = astor;
        this.host = tangoHost;
        this.name = tangoHost.getName();
        this.initComponents();
        this.setTitle((Object)((Object)tangoHost) + "  Control");
        this.displayAllBtn.setSelected(true);
        preferred_size = AstorUtil.getHostDialogPreferredSize();
        this.scrollPane = new JScrollPane();
        new UpdateThread().start();
        this.bg = this.titlePanel.getBackground();
        this.titleLabel.setText("Controlled Servers on " + this.name);
        this.notifd_menu = new ServerPopupMenu(this.astor, this, tangoHost, 2);
        this.pack();
        ATKGraphicsUtils.centerDialog((Dialog)this);
    }

    public Astor getAstorObject() {
        return this.astor;
    }

    public void displayHostInfoDialog(String string) {
        this.astor.tree.displayHostInfoDialog(string);
    }

    void setDialogPreferredSize(Dimension dimension) {
        preferred_size = dimension;
        this.packTheDialog();
    }

    void updatePanel() {
        int n;
        if (this.trees == null) {
            int n2 = AstorUtil.getStarterNbStartupLevels();
            ++n2;
            this.levelsPanel = new JPanel();
            this.levelsPanel.setLayout(new GridBagLayout());
            this.centerPanel.add((Component)this.levelsPanel, "Center");
            if (this.host.manageNotifd) {
                this.notifdPanel = new JPanel();
                this.notifdLabel = new JLabel("Event Notify Daemon");
                this.notifdLabel.setFont(new Font("Dialog", 1, 12));
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 0;
                gridBagConstraints.gridwidth = n2;
                gridBagConstraints.fill = 2;
                this.notifdPanel.add((Component)this.notifdLabel, gridBagConstraints);
                this.levelsPanel.add((Component)this.notifdPanel, gridBagConstraints);
                this.notifdLabel.addMouseListener(new MouseAdapter(){

                    public void mouseClicked(MouseEvent mouseEvent) {
                        HostInfoDialog.this.serverBtnMouseClicked(mouseEvent);
                    }
                });
            }
            this.treePanels = new JPanel[n2];
            this.trees = new LevelTree[n2];
            for (n = 0; n < n2; ++n) {
                this.trees[n] = new LevelTree(this.astor, this, this.host, n);
                this.treePanels[n] = new JPanel();
                this.treePanels[n].add(this.trees[n]);
            }
        } else {
            LevelTree[] levelTreeArray = this.trees;
            n = levelTreeArray.length;
            for (int i = 0; i < n; ++i) {
                LevelTree levelTree = levelTreeArray[i];
                levelTree.checkUpdate();
            }
        }
        int n3 = 0;
        for (n = 1; n < this.trees.length; ++n) {
            n3 += this.trees[n].getNbServers();
        }
        this.titleLabel.setText("" + n3 + " Controlled Servers on " + this.name);
        this.checkActiveLevels();
        this.updateHostState();
        this.packTheDialog();
    }

    void packTheDialog() {
        if (!this.isVisible()) {
            return;
        }
        Point point = this.getLocation();
        this.pack();
        int n = this.levelsPanel.getWidth();
        int n2 = this.levelsPanel.getHeight();
        if (n > HostInfoDialog.preferred_size.width || n2 > HostInfoDialog.preferred_size.height) {
            int n3 = 20;
            this.centerPanel.remove(this.levelsPanel);
            Dimension dimension = new Dimension(preferred_size);
            if (n < HostInfoDialog.preferred_size.width - n3) {
                dimension.width = n + n3;
            }
            if (n2 < HostInfoDialog.preferred_size.height - n3) {
                dimension.height = n2 + n3;
            }
            this.scrollPane.setPreferredSize(dimension);
            this.scrollPane.add(this.levelsPanel);
            this.scrollPane.setViewportView(this.levelsPanel);
            this.centerPanel.add((Component)this.scrollPane, "Center");
        } else {
            this.centerPanel.remove(this.scrollPane);
            this.scrollPane.remove(this.levelsPanel);
            this.centerPanel.add((Component)this.levelsPanel, "Center");
        }
        this.pack();
        this.setLocation(point);
    }

    private void checkActiveLevels() {
        int n;
        this.levelsPanel.removeAll();
        ArrayList<JPanel> arrayList = new ArrayList<JPanel>();
        for (n = 1; n < this.trees.length; ++n) {
            if (this.trees[n].getNbServers() <= 0) continue;
            arrayList.add(this.treePanels[n]);
        }
        if (this.trees[0].getNbServers() > 0) {
            arrayList.add(this.treePanels[0]);
        }
        n = 0;
        int n2 = 1;
        int n3 = arrayList.size() / 2 - 1;
        if (n3 < 2) {
            n3 = 2;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            JPanel jPanel = (JPanel)arrayList.get(i);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = n++;
            gridBagConstraints.gridy = n2;
            gridBagConstraints.insets = new Insets(5, 10, 0, 0);
            gridBagConstraints.fill = 2;
            gridBagConstraints.fill = 3;
            gridBagConstraints.anchor = 17;
            this.levelsPanel.add((Component)jPanel, gridBagConstraints);
            if (i != n3) continue;
            n = 0;
            n2 += 2;
        }
        if (this.host.manageNotifd) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = n3 + 1;
            gridBagConstraints.fill = 2;
            this.levelsPanel.add((Component)this.notifdPanel, gridBagConstraints);
        }
    }

    Color getBackgroundColor() {
        return this.startNewBtn.getBackground();
    }

    void updateHostState() {
        if (this.host.state == 4) {
            String string = ApiUtil.stateName((DevState)DevState.MOVING);
            this.titlePanel.setBackground(ATKConstant.getColor4State((String)string));
        } else if (this.host.state == 2) {
            String string = ApiUtil.stateName((DevState)DevState.ALARM);
            this.titlePanel.setBackground(ATKConstant.getColor4State((String)string));
        } else {
            this.titlePanel.setBackground(this.bg);
        }
        if (this.host.manageNotifd) {
            this.notifdLabel.setIcon(AstorUtil.state_icons[this.host.notifyd_state]);
        }
    }

    private void initComponents() {
        this.btnPanel = new JPanel();
        this.cancelBtn = new JButton();
        this.centerPanel = new JPanel();
        this.titlePanel = new JPanel();
        this.titleLabel = new JLabel();
        this.jPanel1 = new JPanel();
        this.startNewBtn = new JButton();
        this.StartAllBtn = new JButton();
        this.stopAllBtn = new JButton();
        this.displayAllBtn = new JRadioButton();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                HostInfoDialog.this.closeDialog(windowEvent);
            }
        });
        this.cancelBtn.setText("Dismiss");
        this.cancelBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HostInfoDialog.this.cancelBtnActionPerformed(actionEvent);
            }
        });
        this.btnPanel.add(this.cancelBtn);
        this.getContentPane().add((Component)this.btnPanel, "South");
        this.centerPanel.setLayout(new BorderLayout());
        this.titleLabel.setFont(new Font("Dialog", 1, 18));
        this.titleLabel.setText("Dialog Title");
        this.titlePanel.add(this.titleLabel);
        this.centerPanel.add((Component)this.titlePanel, "North");
        this.getContentPane().add((Component)this.centerPanel, "Center");
        this.startNewBtn.setText("Start New");
        this.startNewBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HostInfoDialog.this.startNewBtnActionPerformed(actionEvent);
            }
        });
        this.jPanel1.add(this.startNewBtn);
        this.StartAllBtn.setText("Start All");
        this.StartAllBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HostInfoDialog.this.StartAllBtnActionPerformed(actionEvent);
            }
        });
        this.jPanel1.add(this.StartAllBtn);
        this.stopAllBtn.setText("Stop All");
        this.stopAllBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HostInfoDialog.this.stopAllBtnActionPerformed(actionEvent);
            }
        });
        this.jPanel1.add(this.stopAllBtn);
        this.displayAllBtn.setText("Display All");
        this.displayAllBtn.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.displayAllBtn.setMargin(new Insets(0, 0, 0, 0));
        this.displayAllBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HostInfoDialog.this.displayAllBtnActionPerformed(actionEvent);
            }
        });
        this.jPanel1.add(this.displayAllBtn);
        this.getContentPane().add((Component)this.jPanel1, "North");
        this.pack();
    }

    private void serverBtnMouseClicked(MouseEvent mouseEvent) {
        this.notifd_menu.showMenu(mouseEvent);
    }

    private void displayAllBtnActionPerformed(ActionEvent actionEvent) {
        boolean bl;
        boolean bl2 = bl = this.displayAllBtn.getSelectedObjects() != null;
        if (this.trees != null) {
            for (LevelTree levelTree : this.trees) {
                if (bl) {
                    if (levelTree.getLevelRow() == 0) continue;
                    levelTree.expandTree();
                    continue;
                }
                levelTree.collapseTree();
            }
        }
    }

    private void stopAllBtnActionPerformed(ActionEvent actionEvent) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = this.trees.length - 1; i >= 0; --i) {
            int n = this.trees[i].getLevelRow();
            if (n == 0 || this.trees[i].getNbServers() <= 0 || !this.trees[i].hasRunningServer()) continue;
            arrayList.add(n);
        }
        new ServerCmdThread((Component)this, this.host, 1, arrayList).start();
    }

    private void StartAllBtnActionPerformed(ActionEvent actionEvent) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (LevelTree levelTree : this.trees) {
            int n = levelTree.getLevelRow();
            if (n == 0 || levelTree.getNbServers() <= 0 || levelTree.getState() == DevState.ON) continue;
            arrayList.add(n);
        }
        new ServerCmdThread((Component)this, this.host, 0, arrayList).start();
    }

    private void startNewBtnActionPerformed(ActionEvent actionEvent) {
        ListDialog listDialog = new ListDialog(this);
        Point point = this.getLocationOnScreen();
        point.translate(50, 50);
        listDialog.setLocation(point);
        listDialog.showDialog();
        ArrayList<String> arrayList = listDialog.getSelectedItems();
        if (arrayList == null) {
            return;
        }
        for (String string : arrayList) {
            if (string == null) continue;
            try {
                this.host.registerServer(string);
                this.host.startOneServer(string);
                TangoServer tangoServer = new TangoServer(string, DevState.OFF);
                tangoServer.startupLevel(this, this.host.getName(), point);
            }
            catch (DevFailed devFailed) {
                ErrorPane.showErrorMessage((Component)this.astor, null, (DevFailed)devFailed);
            }
        }
    }

    private void cancelBtnActionPerformed(ActionEvent actionEvent) {
        this.doClose();
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.doClose();
    }

    void doClose() {
        if (this.astor.getWidth() == 0) {
            System.exit(0);
        }
        this.setVisible(false);
        this.dispose();
    }

    void fireNewTreeSelection(LevelTree levelTree) {
        for (LevelTree levelTree2 : this.trees) {
            if (levelTree2 == levelTree) continue;
            levelTree2.clearSelection();
        }
    }

    void stopLevel(int n) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(n);
        new ServerCmdThread((Component)this, this.host, 1, arrayList).start();
    }

    void startLevel(int n) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(n);
        new ServerCmdThread((Component)this, this.host, 0, arrayList).start();
    }

    private void manageServersAttribute(DeviceAttribute deviceAttribute) {
        ArrayList<Server> arrayList = new ArrayList<Server>();
        try {
            if (!deviceAttribute.hasFailed()) {
                Object[] objectArray = deviceAttribute.extractStringArray();
                String[] stringArray = objectArray;
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String string = stringArray[i];
                    arrayList.add(new Server(string));
                }
            }
        }
        catch (DevFailed devFailed) {
            System.err.println(this.name);
            Except.print_exception((Exception)((Object)devFailed));
        }
        switch (this.updateHost(arrayList)) {
            case 1: {
                this.updatePanel();
                break;
            }
            case 0: {
                return;
            }
        }
        for (LevelTree levelTree : this.trees) {
            levelTree.repaint();
        }
    }

    public int updateHost(ArrayList<Server> arrayList) {
        boolean bl = false;
        boolean bl2 = false;
        for (Server object : arrayList) {
            TangoServer bl3 = this.host.getServer(object.name);
            if (bl3 == null) {
                try {
                    bl3 = new TangoServer(object.name, object.state);
                }
                catch (DevFailed devFailed) {
                    System.err.println(this.name);
                    Except.print_exception((Exception)((Object)devFailed));
                }
                this.host.addServer(bl3);
                bl2 = true;
            }
            if (bl3 == null) continue;
            if (object.state != bl3.getState()) {
                bl3.setState(object.state);
                bl = true;
            }
            if (!(object.controlled != bl3.controlled | object.level != bl3.startup_level)) continue;
            bl3.controlled = object.controlled;
            bl3.startup_level = object.level;
            bl2 = true;
        }
        for (int i = 0; i < this.host.nbServers(); ++i) {
            TangoServer tangoServer = this.host.getServer(i);
            boolean bl3 = false;
            for (int j = 0; !bl3 && j < arrayList.size(); ++j) {
                Server server = arrayList.get(j);
                bl3 = server.name.equals(tangoServer.getName());
            }
            if (bl3) continue;
            this.host.removeServer(tangoServer.getName());
            bl2 = true;
        }
        if (bl2) {
            return 1;
        }
        if (bl) {
            return 2;
        }
        return 0;
    }

    private DevState string2state(String string) {
        for (int i = 0; i < Tango_DevStateName.length; ++i) {
            if (!string.equals(Tango_DevStateName[i])) continue;
            return DevState.from_int((int)i);
        }
        return DevState.UNKNOWN;
    }

    void setSelection(String string) {
        if (this.trees != null) {
            for (LevelTree levelTree : this.trees) {
                TangoServer tangoServer = levelTree.getServer(string);
                if (tangoServer != null) {
                    levelTree.expandTree();
                    levelTree.setSelection(tangoServer);
                    continue;
                }
                levelTree.resetSelection();
            }
        }
    }

    void updateData() {
        this.updatePanel();
    }

    private void subscribeChangeEvent() {
        try {
            if (this.host.supplier == null) {
                this.host.supplier = new TangoEventsAdapter((DeviceProxy)this.host);
            }
        }
        catch (DevFailed devFailed) {
            this.host.onEvents = false;
            System.err.println("subscribeChangeServerEvent() for " + this.host.get_name() + " FAILED !");
            Except.print_exception((Exception)((Object)devFailed));
            return;
        }
        catch (Exception exception) {
            this.host.onEvents = false;
            System.err.println("subscribeChangeServerEvent() for " + this.host.get_name() + " FAILED !");
            System.err.println(exception);
            return;
        }
        try {
            ServerEventListener serverEventListener = new ServerEventListener();
            this.host.supplier.addTangoChangeListener((ITangoChangeListener)serverEventListener, this.attribute, new String[0]);
            System.out.println("subscribeChangeServerEvent() for " + this.host.get_name() + "/" + this.attribute + " OK!");
        }
        catch (DevFailed devFailed) {
            this.host.onEvents = false;
            System.err.println("subscribeChangeServerEvent() for " + this.host.get_name() + " FAILED !");
            Except.print_exception((Exception)((Object)devFailed));
        }
        catch (Exception exception) {
            this.host.onEvents = false;
            System.err.println("subscribeChangeServerEvent() for " + this.host.get_name() + " FAILED !");
            System.err.println(exception);
        }
    }

    class ServerEventListener
    implements ITangoChangeListener {
        ServerEventListener() {
        }

        public void change(TangoChangeEvent tangoChangeEvent) {
            TangoChange tangoChange = (TangoChange)tangoChangeEvent.getSource();
            String string = tangoChange.getEventSupplier().get_name();
            try {
                DeviceAttribute deviceAttribute = tangoChangeEvent.getValue();
                HostInfoDialog.this.manageServersAttribute(deviceAttribute);
            }
            catch (DevFailed devFailed) {
                System.out.println(HostInfoDialog.this.name);
                if (devFailed.errors[0].reason.equals("API_EventTimeout")) {
                    System.err.println("HostStataThread.ServerEventListener" + string + " : API_EventTimeout");
                } else {
                    Except.print_exception((Exception)((Object)devFailed));
                }
            }
            catch (Exception exception) {
                System.err.println(HostInfoDialog.this.name);
                System.err.println("AstorEvent." + string);
                System.err.println(exception);
                System.err.println("HostStateThread.ServerEventListener : could not extract data!");
            }
        }
    }

    class UpdateThread
    extends Thread {
        private int readInfoPeriod = 1000;
        private boolean stop_it = false;

        public void run() {
            if (HostInfoDialog.this.host.onEvents) {
                HostInfoDialog.this.subscribeChangeEvent();
            }
            while (!this.stop_it) {
                long l = System.currentTimeMillis();
                if (!HostInfoDialog.this.host.onEvents) {
                    this.manageSynchronous();
                }
                this.wait_next_loop(l);
            }
        }

        public synchronized void wait_next_loop(long l) {
            try {
                long l2 = System.currentTimeMillis();
                long l3 = (long)this.readInfoPeriod - (l2 - l);
                if (l3 <= 0L) {
                    l3 = 100L;
                }
                this.wait(l3);
            }
            catch (InterruptedException interruptedException) {
                System.out.println(interruptedException);
            }
        }

        private void manageSynchronous() {
            try {
                DeviceAttribute deviceAttribute = HostInfoDialog.this.host.read_attribute(HostInfoDialog.this.attribute);
                HostInfoDialog.this.manageServersAttribute(deviceAttribute);
            }
            catch (DevFailed devFailed) {
                // empty catch block
            }
        }
    }

    class Server {
        String name;
        DevState state;
        boolean controlled = false;
        int level = 0;

        public Server(String string) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            ArrayList<String> arrayList = new ArrayList<String>();
            while (stringTokenizer.hasMoreTokens()) {
                arrayList.add(stringTokenizer.nextToken());
            }
            if (arrayList.size() > 0) {
                this.name = (String)arrayList.get(0);
            }
            if (arrayList.size() > 1) {
                this.state = HostInfoDialog.this.string2state((String)arrayList.get(1));
            }
            if (arrayList.size() > 2) {
                this.controlled = ((String)arrayList.get(2)).equals("1");
            }
            if (arrayList.size() > 3) {
                String string2 = (String)arrayList.get(3);
                try {
                    this.level = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }

        public String toString() {
            return this.name + " -> " + ApiUtil.stateName((DevState)this.state) + "\t- " + (this.controlled ? "" : "not ") + "Controlled \tlevel " + this.level;
        }
    }
}

