/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.jgl3dchart;

import fr.esrf.tangoatk.widget.util.jgl3dchart.JGL3DAxis;
import fr.esrf.tangoatk.widget.util.jgl3dchart.JGL3DChart;
import fr.esrf.tangoatk.widget.util.jgl3dchart.LabelInfo;
import fr.esrf.tangoatk.widget.util.jgl3dchart.Utils;
import fr.esrf.tangoatk.widget.util.jgl3dchart.VERTEX3D;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.font.FontRenderContext;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLJPanel;
import javax.media.opengl.glu.GLU;

class JGL3DView
extends GLJPanel
implements GLEventListener,
MouseListener,
MouseMotionListener,
MouseWheelListener {
    static final GLU glu = new GLU();
    static final int ZOOM_ZY = 1;
    static final int ZOOM_ZX = 2;
    static final int ZOOM_YX = 3;
    private double angleOx = 0.5;
    private double angleOy = 0.785f;
    private double camDist;
    private boolean isDraggingRot;
    private boolean isDraggingZoom;
    private int mX;
    private int mY;
    private int mX2;
    private int mY2;
    private boolean autoScaleCameraRequest;
    private int[] gColormap;
    private JGL3DAxis xAxis;
    private JGL3DAxis yAxis;
    private JGL3DAxis zAxis;
    private double colMin = 0.0;
    private double colMax = 100.0;
    private double Scmin = 0.0;
    private double Scmax = 100.0;
    private boolean yDataAutoScale;
    private double x0;
    private double y0;
    private double x1;
    private double y1;
    private double zNear = -1.0E100;
    private double zFar = 1.0E100;
    private double[][] data;
    private boolean updateDataRequest;
    private int dataList;
    private JGL3DChart parent;
    private int lastWidth = 0;
    private int lastHeight = 0;
    private int zoomAllowedMode = 0;
    private boolean zoomRequest;
    private int zoomMode = 0;

    JGL3DView(JGL3DChart jGL3DChart) {
        this.parent = jGL3DChart;
        this.addGLEventListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
        this.setPreferredSize(new Dimension(640, 480));
        this.xAxis = new JGL3DAxis(this, 0);
        this.yAxis = new JGL3DAxis(this, 1);
        this.zAxis = new JGL3DAxis(this, 2);
        this.xAxis.setName("Xaxis");
        this.yAxis.setName("Yaxis");
        this.zAxis.setName("Zaxis");
        this.xAxis.setLabelColor(Color.RED);
        this.yAxis.setLabelColor(new Color(0, 128, 0));
        this.zAxis.setLabelColor(Color.BLUE);
        this.updateAxisPosition();
        this.autoScaleCameraRequest();
        this.updateDataRequest = false;
        this.zoomRequest = false;
        this.dataList = 0;
        this.yDataAutoScale = true;
    }

    void setColorMap(int[] nArray) {
        this.gColormap = nArray;
    }

    void autoScaleCameraRequest() {
        this.autoScaleCameraRequest = true;
    }

    JGL3DAxis getXAxis() {
        return this.xAxis;
    }

    JGL3DAxis getYAxis() {
        return this.yAxis;
    }

    JGL3DAxis getZAxis() {
        return this.zAxis;
    }

    private void transformBoxSide(GL gL, double d, double d2, double d3) {
        double[] dArray = new double[3];
        Utils.project3D(gL, d, d2, d3, dArray);
        if (dArray[0] < this.x0) {
            this.x0 = dArray[0];
        }
        if (dArray[0] > this.x1) {
            this.x1 = dArray[0];
        }
        if (dArray[1] < this.y0) {
            this.y0 = dArray[1];
        }
        if (dArray[1] > this.y1) {
            this.y1 = dArray[1];
        }
    }

    private void computeBoundingBoxSide(GL gL) {
        this.x0 = 1.0E100;
        this.y0 = 1.0E100;
        this.x1 = -1.0E100;
        this.y1 = -1.0E100;
        double d = this.xAxis.getMin();
        double d2 = this.xAxis.getMax();
        double d3 = this.yAxis.getMin();
        double d4 = this.yAxis.getMax();
        double d5 = this.zAxis.getMin();
        double d6 = this.zAxis.getMax();
        this.transformBoxSide(gL, d2, d4, d6);
        this.transformBoxSide(gL, d, d4, d6);
        this.transformBoxSide(gL, d, d3, d6);
        this.transformBoxSide(gL, d2, d3, d6);
        this.transformBoxSide(gL, d2, d4, d5);
        this.transformBoxSide(gL, d, d4, d5);
        this.transformBoxSide(gL, d, d3, d5);
        this.transformBoxSide(gL, d2, d3, d5);
    }

    private void transformBoxDepth(GL gL, double d, double d2, double d3) {
        double[] dArray = new double[3];
        Utils.project3D(gL, d, d2, d3, dArray);
        if (dArray[2] < this.zNear) {
            this.zNear = dArray[2];
        }
        if (dArray[2] > this.zFar) {
            this.zFar = dArray[2];
        }
    }

    private void computeBoundingBoxDepth(GL gL) {
        this.zNear = 1.0E100;
        this.zFar = -1.0E100;
        double d = this.xAxis.getMin();
        double d2 = this.xAxis.getMax();
        double d3 = this.yAxis.getMin();
        double d4 = this.yAxis.getMax();
        double d5 = this.zAxis.getMin();
        double d6 = this.zAxis.getMax();
        this.transformBoxDepth(gL, d2, d4, d6);
        this.transformBoxDepth(gL, d, d4, d6);
        this.transformBoxDepth(gL, d, d3, d6);
        this.transformBoxDepth(gL, d2, d3, d6);
        this.transformBoxDepth(gL, d2, d4, d5);
        this.transformBoxDepth(gL, d, d4, d5);
        this.transformBoxDepth(gL, d, d3, d5);
        this.transformBoxDepth(gL, d2, d3, d5);
    }

    private void computeOrthographicProj(GL gL) {
        this.updateModelMatrix(gL, this.camDist);
        this.computeBoundingBoxDepth(gL);
        Dimension dimension = this.getSize();
        gL.glMatrixMode(5889);
        gL.glLoadIdentity();
        gL.glOrtho((double)(dimension.width / 2), (double)(-dimension.width / 2), (double)(-dimension.height / 2), (double)(dimension.height / 2), this.zNear * 1.1, this.zFar * 1.1);
    }

    private void autoScaleCamera(GL gL) {
        this.updateModelMatrix(gL, 1.0);
        this.computeBoundingBoxSide(gL);
        Dimension dimension = this.getSize();
        double d = (double)dimension.width * 0.8 / (this.x1 - this.x0);
        double d2 = (double)dimension.height * 0.8 / (this.y1 - this.y0);
        this.camDist = d > d2 ? d2 : d;
        this.updateAxisPosition();
        this.autoScaleCameraRequest = false;
    }

    private void updateAxisPosition() {
        double d = this.xAxis.getMin();
        double d2 = this.xAxis.getMax();
        double d3 = this.yAxis.getMin();
        double d4 = this.yAxis.getMax();
        double d5 = this.zAxis.getMin();
        double d6 = this.zAxis.getMax();
        if (this.angleOy < 1.5707963267948966) {
            this.xAxis.setPosition(new VERTEX3D(d, d3, d5), new VERTEX3D(d2, d3, d5));
        } else {
            this.xAxis.setPosition(new VERTEX3D(d, d3, d6), new VERTEX3D(d2, d3, d6));
        }
        if (this.angleOx >= 0.5) {
            if (this.angleOy < 1.5707963267948966) {
                this.xAxis.setNormal(new VERTEX3D(0.0, 0.0, -10.0 / this.camDist));
            } else {
                this.xAxis.setNormal(new VERTEX3D(0.0, 0.0, 10.0 / this.camDist));
            }
        } else {
            this.xAxis.setNormal(new VERTEX3D(0.0, -10.0 / this.camDist, 0.0));
        }
        if (this.angleOy < 1.5707963267948966) {
            this.yAxis.setPosition(new VERTEX3D(d2, d3, d5), new VERTEX3D(d2, d4, d5));
        } else {
            this.yAxis.setPosition(new VERTEX3D(d2, d3, d6), new VERTEX3D(d2, d4, d6));
        }
        if (this.angleOy < 1.5707963267948966) {
            if (this.angleOy < 0.7853981633974483) {
                this.yAxis.setNormal(new VERTEX3D(10.0 / this.camDist, 0.0, 0.0));
            } else {
                this.yAxis.setNormal(new VERTEX3D(0.0, 0.0, -10.0 / this.camDist));
            }
        } else if (this.angleOy > 2.356194490192345) {
            this.yAxis.setNormal(new VERTEX3D(10.0 / this.camDist, 0.0, 0.0));
        } else {
            this.yAxis.setNormal(new VERTEX3D(0.0, 0.0, 10.0 / this.camDist));
        }
        this.zAxis.setPosition(new VERTEX3D(d, d3, d5), new VERTEX3D(d, d3, d6));
        if (this.angleOx >= 0.5) {
            this.zAxis.setNormal(new VERTEX3D(-10.0 / this.camDist, 0.0, 0.0));
        } else {
            this.zAxis.setNormal(new VERTEX3D(0.0, -10.0 / this.camDist, 0.0));
        }
    }

    void setData(double[][] dArray) {
        this.data = dArray;
        this.computeScale();
    }

    void computeScale() {
        if (this.data == null) {
            this.xAxis.setMin(this.xAxis.getMinimum());
            this.xAxis.setMax(this.xAxis.getMaximum());
            this.yAxis.setMin(this.yAxis.getMinimum());
            this.yAxis.setMax(this.yAxis.getMaximum());
            this.zAxis.setMin(this.zAxis.getMinimum());
            this.zAxis.setMax(this.zAxis.getMaximum());
            this.repaint();
            return;
        }
        if (this.data.length > 2 && this.data[0].length > 2) {
            double d = this.xAxis.getGainTransform();
            double d2 = this.xAxis.getOffsetTransform();
            double d3 = this.yAxis.getGainTransform();
            double d4 = this.yAxis.getOffsetTransform();
            double d5 = this.zAxis.getGainTransform();
            double d6 = this.zAxis.getOffsetTransform();
            boolean bl = false;
            this.Scmin = Double.MAX_VALUE;
            this.Scmax = -1.7976931348623157E308;
            if (!this.yDataAutoScale) {
                this.Scmax = this.colMax;
                this.Scmin = this.colMin;
            }
            if (this.yDataAutoScale) {
                for (int i = 0; i < this.data.length - 1; ++i) {
                    for (int j = 0; j < this.data[i].length - 1; ++j) {
                        double d7 = d3 * this.data[i][j] + d4;
                        if (Double.isNaN(d7)) continue;
                        if (d7 < this.Scmin) {
                            this.Scmin = d7;
                        }
                        if (d7 > this.Scmax) {
                            this.Scmax = d7;
                        }
                        bl = true;
                    }
                }
            }
            if (bl) {
                if (this.Scmax - this.Scmin < 1.0E-100) {
                    this.Scmax += 0.999;
                    this.Scmin -= 0.999;
                }
            } else {
                this.Scmin = this.colMin;
                this.Scmax = this.colMax;
            }
            switch (this.zoomMode) {
                case 1: {
                    if (this.xAxis.isAutoScale()) {
                        if (d < 0.0) {
                            this.xAxis.setMin(d * (double)this.data.length + d2);
                            this.xAxis.setMax(d2);
                            break;
                        }
                        this.xAxis.setMin(d2);
                        this.xAxis.setMax(d * (double)this.data.length + d2);
                        break;
                    }
                    this.xAxis.setMin(this.xAxis.getMinimum());
                    this.xAxis.setMax(this.xAxis.getMaximum());
                    break;
                }
                case 2: {
                    if (this.yAxis.isAutoScale()) {
                        this.yAxis.setMin(this.Scmin);
                        this.yAxis.setMax(this.Scmax);
                        break;
                    }
                    this.yAxis.setMin(this.yAxis.getMinimum());
                    this.yAxis.setMax(this.yAxis.getMaximum());
                    break;
                }
                case 3: {
                    if (this.zAxis.isAutoScale()) {
                        if (d5 < 0.0) {
                            this.zAxis.setMin(d5 * (double)this.data[0].length + d6);
                            this.zAxis.setMax(d6);
                            break;
                        }
                        this.zAxis.setMin(d6);
                        this.zAxis.setMax(d5 * (double)this.data[0].length + d6);
                        break;
                    }
                    this.zAxis.setMin(this.zAxis.getMinimum());
                    this.zAxis.setMax(this.zAxis.getMaximum());
                    break;
                }
                default: {
                    if (this.xAxis.isAutoScale()) {
                        if (d < 0.0) {
                            this.xAxis.setMin(d * (double)this.data.length + d2);
                            this.xAxis.setMax(d2);
                        } else {
                            this.xAxis.setMin(d2);
                            this.xAxis.setMax(d * (double)this.data.length + d2);
                        }
                    } else {
                        this.xAxis.setMin(this.xAxis.getMinimum());
                        this.xAxis.setMax(this.xAxis.getMaximum());
                    }
                    if (this.yAxis.isAutoScale()) {
                        this.yAxis.setMin(this.Scmin);
                        this.yAxis.setMax(this.Scmax);
                    } else {
                        this.yAxis.setMin(this.yAxis.getMinimum());
                        this.yAxis.setMax(this.yAxis.getMaximum());
                    }
                    if (this.zAxis.isAutoScale()) {
                        if (d5 < 0.0) {
                            this.zAxis.setMin(d5 * (double)this.data[0].length + d6);
                            this.zAxis.setMax(d6);
                            break;
                        }
                        this.zAxis.setMin(d6);
                        this.zAxis.setMax(d5 * (double)this.data[0].length + d6);
                        break;
                    }
                    this.zAxis.setMin(this.zAxis.getMinimum());
                    this.zAxis.setMax(this.zAxis.getMaximum());
                }
            }
            this.updateAxisPosition();
            this.parent.gradientViewer.getAxis().setMinimum(this.Scmin);
            this.parent.gradientViewer.getAxis().setMaximum(this.Scmax);
            this.parent.revalidate();
            this.parent.repaint();
        }
        this.updateDataRequest = true;
    }

    void zoomBack() {
        if (this.zoomMode != 0) {
            this.zoomMode = 0;
            this.computeScale();
            this.repaint();
        }
    }

    private void getColor(double d, double d2, double d3, float[] fArray) {
        double d4 = (d - d2) / (d3 - d2) * 65536.0;
        if (d4 < 0.0) {
            d4 = 0.0;
        }
        if (d4 > 65535.0) {
            d4 = 65535.0;
        }
        fArray[0] = (float)((this.gColormap[(int)d4] & 0xFF0000) >> 16) / 256.0f;
        fArray[1] = (float)((this.gColormap[(int)d4] & 0xFF00) >> 8) / 256.0f;
        fArray[2] = (float)(this.gColormap[(int)d4] & 0xFF) / 256.0f;
    }

    private void buildDataList(GL gL) {
        if (this.data == null) {
            return;
        }
        if (this.dataList != 0) {
            gL.glDeleteLists(this.dataList, 1);
        }
        this.dataList = 0;
        if (this.data.length > 2 && this.data[0].length > 2) {
            double d = this.xAxis.getGainTransform();
            double d2 = this.xAxis.getOffsetTransform();
            double d3 = this.yAxis.getGainTransform();
            double d4 = this.yAxis.getOffsetTransform();
            double d5 = this.zAxis.getGainTransform();
            double d6 = this.zAxis.getOffsetTransform();
            this.dataList = gL.glGenLists(1);
            gL.glNewList(this.dataList, 4864);
            gL.glBegin(4);
            float[] fArray = new float[3];
            for (int i = 0; i < this.data.length - 1; ++i) {
                for (int j = 0; j < this.data[i].length - 1; ++j) {
                    if (!(d * (double)i + d2 >= this.xAxis.getMin()) || !(d * ((double)i + 1.0) + d2 <= this.xAxis.getMax()) || !(d5 * (double)j + d6 >= this.zAxis.getMin()) || !(d5 * ((double)j + 1.0) + d6 <= this.zAxis.getMax()) || Double.isNaN(this.data[i][j]) || Double.isNaN(this.data[i + 1][j]) || Double.isNaN(this.data[i][j + 1]) || Double.isNaN(this.data[i + 1][j + 1])) continue;
                    double d7 = d * (double)i + d2;
                    double d8 = d3 * this.data[i][j] + d4;
                    double d9 = d5 * (double)j + d6;
                    double d10 = d7;
                    double d11 = d3 * this.data[i][j + 1] + d4;
                    double d12 = d5 * ((double)j + 1.0) + d6;
                    double d13 = d * ((double)i + 1.0) + d2;
                    double d14 = d3 * this.data[i + 1][j] + d4;
                    double d15 = d9;
                    double d16 = d13;
                    double d17 = d3 * this.data[i + 1][j + 1] + d4;
                    double d18 = d12;
                    this.getColor(d8, this.Scmin, this.Scmax, fArray);
                    gL.glColor3f(fArray[0], fArray[1], fArray[2]);
                    gL.glVertex3d(d7, d8, d9);
                    this.getColor(d11, this.Scmin, this.Scmax, fArray);
                    gL.glColor3f(fArray[0], fArray[1], fArray[2]);
                    gL.glVertex3d(d10, d11, d12);
                    this.getColor(d14, this.Scmin, this.Scmax, fArray);
                    gL.glColor3f(fArray[0], fArray[1], fArray[2]);
                    gL.glVertex3d(d13, d14, d15);
                    this.getColor(d11, this.Scmin, this.Scmax, fArray);
                    gL.glColor3f(fArray[0], fArray[1], fArray[2]);
                    gL.glVertex3d(d10, d11, d12);
                    this.getColor(d17, this.Scmin, this.Scmax, fArray);
                    gL.glColor3f(fArray[0], fArray[1], fArray[2]);
                    gL.glVertex3d(d16, d17, d18);
                    this.getColor(d14, this.Scmin, this.Scmax, fArray);
                    gL.glColor3f(fArray[0], fArray[1], fArray[2]);
                    gL.glVertex3d(d13, d14, d15);
                }
            }
            gL.glEnd();
            gL.glEndList();
        }
    }

    private void manageZoom(GL gL) {
        double[] dArray = new double[3];
        double[] dArray2 = new double[3];
        switch (this.zoomAllowedMode) {
            case 1: {
                Utils.unproject(gL, this.mX, this.mY, 0.0, dArray);
                Utils.unproject(gL, this.mX2, this.mY2, 0.0, dArray2);
                if (dArray[1] > dArray2[1]) {
                    this.yAxis.setMax(dArray[1]);
                    this.yAxis.setMin(dArray2[1]);
                } else {
                    this.yAxis.setMax(dArray2[1]);
                    this.yAxis.setMin(dArray[1]);
                }
                if (dArray[2] > dArray2[2]) {
                    this.zAxis.setMax(dArray[2]);
                    this.zAxis.setMin(dArray2[2]);
                } else {
                    this.zAxis.setMax(dArray2[2]);
                    this.zAxis.setMin(dArray[2]);
                }
                this.updateAxisPosition();
                this.buildDataList(gL);
                this.repaint();
                this.zoomMode = this.zoomAllowedMode;
                break;
            }
            case 2: {
                Utils.unproject(gL, this.mX, this.mY, 0.0, dArray);
                Utils.unproject(gL, this.mX2, this.mY2, 0.0, dArray2);
                if (dArray[0] > dArray2[0]) {
                    this.xAxis.setMax(dArray[0]);
                    this.xAxis.setMin(dArray2[0]);
                } else {
                    this.xAxis.setMax(dArray2[0]);
                    this.xAxis.setMin(dArray[0]);
                }
                if (dArray[2] > dArray2[2]) {
                    this.zAxis.setMax(dArray[2]);
                    this.zAxis.setMin(dArray2[2]);
                } else {
                    this.zAxis.setMax(dArray2[2]);
                    this.zAxis.setMin(dArray[2]);
                }
                this.updateAxisPosition();
                this.buildDataList(gL);
                this.repaint();
                this.zoomMode = this.zoomAllowedMode;
                break;
            }
            case 3: {
                Utils.unproject(gL, this.mX, this.mY, 0.0, dArray);
                Utils.unproject(gL, this.mX2, this.mY2, 0.0, dArray2);
                if (dArray[0] > dArray2[0]) {
                    this.xAxis.setMax(dArray[0]);
                    this.xAxis.setMin(dArray2[0]);
                } else {
                    this.xAxis.setMax(dArray2[0]);
                    this.xAxis.setMin(dArray[0]);
                }
                if (dArray[1] > dArray2[1]) {
                    this.yAxis.setMax(dArray[1]);
                    this.yAxis.setMin(dArray2[1]);
                } else {
                    this.yAxis.setMax(dArray2[1]);
                    this.yAxis.setMin(dArray[1]);
                }
                this.updateAxisPosition();
                this.buildDataList(gL);
                this.repaint();
                this.zoomMode = this.zoomAllowedMode;
            }
        }
    }

    public void init(GLAutoDrawable gLAutoDrawable) {
        GL gL = gLAutoDrawable.getGL();
        gL.glClearColor(0.9f, 0.9f, 0.9f, 0.0f);
        gL.glClearDepth(0.0);
        gL.glDepthFunc(518);
        gL.glEnable(2929);
        gL.glDisable(2884);
        gL.glDisable(2896);
        gL.glDisable(3553);
    }

    public void display(GLAutoDrawable gLAutoDrawable) {
        LabelInfo labelInfo;
        int n;
        GL gL = gLAutoDrawable.getGL();
        double d = this.xAxis.getMin();
        double d2 = this.xAxis.getMax();
        double d3 = this.yAxis.getMin();
        double d4 = this.yAxis.getMax();
        double d5 = this.zAxis.getMin();
        double d6 = this.zAxis.getMax();
        if (this.autoScaleCameraRequest) {
            this.autoScaleCamera(gL);
        }
        this.computeOrthographicProj(gL);
        this.updateModelMatrix(gL, this.camDist);
        gL.glClear(16384);
        gL.glClear(256);
        gL.glDisable(2929);
        gL.glBegin(7);
        gL.glColor3f(0.8f, 0.8f, 0.8f);
        gL.glVertex3d(d2, d3, d5);
        gL.glVertex3d(d2, d3, d6);
        gL.glVertex3d(d2, d4, d6);
        gL.glVertex3d(d2, d4, d5);
        gL.glColor3f(0.91f, 0.91f, 0.91f);
        gL.glVertex3d(d, d3, d5);
        gL.glVertex3d(d, d3, d6);
        gL.glVertex3d(d2, d3, d6);
        gL.glVertex3d(d2, d3, d5);
        gL.glColor3f(0.85f, 0.85f, 0.85f);
        if (this.angleOy < 1.5707963267948966) {
            gL.glVertex3d(d, d3, d6);
            gL.glVertex3d(d, d4, d6);
            gL.glVertex3d(d2, d4, d6);
            gL.glVertex3d(d2, d3, d6);
        } else {
            gL.glVertex3d(d, d3, d5);
            gL.glVertex3d(d, d4, d5);
            gL.glVertex3d(d2, d4, d5);
            gL.glVertex3d(d2, d3, d5);
        }
        gL.glEnd();
        this.xAxis.measureAxis(gL);
        this.xAxis.paintAxis(gL);
        this.yAxis.measureAxis(gL);
        this.yAxis.paintAxis(gL);
        this.zAxis.measureAxis(gL);
        this.zAxis.paintAxis(gL);
        short s = 3855;
        gL.glLineStipple(1, s);
        gL.glEnable(2852);
        gL.glColor3f(0.5f, 0.5f, 0.5f);
        gL.glBegin(1);
        for (n = 0; n < this.yAxis.labelInfo.size(); ++n) {
            labelInfo = (LabelInfo)this.yAxis.labelInfo.get(n);
            gL.glVertex3d(d2, labelInfo.p1.y, d5);
            gL.glVertex3d(d2, labelInfo.p1.y, d6);
        }
        for (n = 0; n < this.zAxis.labelInfo.size(); ++n) {
            labelInfo = (LabelInfo)this.zAxis.labelInfo.get(n);
            gL.glVertex3d(d2, d3, labelInfo.p1.z);
            gL.glVertex3d(d2, d4, labelInfo.p1.z);
        }
        for (n = 0; n < this.xAxis.labelInfo.size(); ++n) {
            labelInfo = (LabelInfo)this.xAxis.labelInfo.get(n);
            gL.glVertex3d(labelInfo.p1.x, d3, d5);
            gL.glVertex3d(labelInfo.p1.x, d3, d6);
        }
        for (n = 0; n < this.zAxis.labelInfo.size(); ++n) {
            labelInfo = (LabelInfo)this.zAxis.labelInfo.get(n);
            gL.glVertex3d(d, d3, labelInfo.p1.z);
            gL.glVertex3d(d2, d3, labelInfo.p1.z);
        }
        if (this.angleOy < 1.5707963267948966) {
            for (n = 0; n < this.yAxis.labelInfo.size(); ++n) {
                labelInfo = (LabelInfo)this.yAxis.labelInfo.get(n);
                gL.glVertex3d(d, labelInfo.p1.y, d6);
                gL.glVertex3d(d2, labelInfo.p1.y, d6);
            }
            for (n = 0; n < this.xAxis.labelInfo.size(); ++n) {
                labelInfo = (LabelInfo)this.xAxis.labelInfo.get(n);
                gL.glVertex3d(labelInfo.p1.x, d3, d6);
                gL.glVertex3d(labelInfo.p1.x, d4, d6);
            }
        } else {
            for (n = 0; n < this.yAxis.labelInfo.size(); ++n) {
                labelInfo = (LabelInfo)this.yAxis.labelInfo.get(n);
                gL.glVertex3d(d, labelInfo.p1.y, d5);
                gL.glVertex3d(d2, labelInfo.p1.y, d5);
            }
            for (n = 0; n < this.xAxis.labelInfo.size(); ++n) {
                labelInfo = (LabelInfo)this.xAxis.labelInfo.get(n);
                gL.glVertex3d(labelInfo.p1.x, d3, d5);
                gL.glVertex3d(labelInfo.p1.x, d4, d5);
            }
        }
        gL.glEnd();
        if (this.updateDataRequest) {
            this.buildDataList(gL);
            this.updateDataRequest = false;
        }
        if (this.dataList > 0) {
            gL.glEnable(2929);
            gL.glCallList(this.dataList);
        }
        if (this.zoomRequest) {
            this.manageZoom(gL);
            this.autoScaleCameraRequest = true;
            this.zoomRequest = false;
        }
    }

    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        if (this.lastWidth != n3 || this.lastHeight != n4) {
            GL gL = gLAutoDrawable.getGL();
            this.computeOrthographicProj(gL);
            this.updateDataRequest = true;
            this.lastWidth = n3;
            this.lastHeight = n4;
        }
    }

    public void displayChanged(GLAutoDrawable gLAutoDrawable, boolean bl, boolean bl2) {
    }

    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        this.camDist = mouseWheelEvent.getWheelRotation() < 0 ? (this.camDist *= 0.95) : (this.camDist *= 1.05);
        this.updateAxisPosition();
        this.display();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 1) {
            if (mouseEvent.isControlDown()) {
                this.isDraggingZoom = this.zoomAllowedMode != 0;
            } else {
                this.isDraggingRot = true;
            }
            this.mX = mouseEvent.getX();
            this.mY = mouseEvent.getY();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.isDraggingRot = false;
        if (this.isDraggingZoom) {
            this.zoomRequest = true;
            this.isDraggingZoom = false;
            this.repaint();
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.isDraggingRot) {
            double d = (double)(this.mX - mouseEvent.getX()) * 0.02;
            double d2 = (double)(this.mY - mouseEvent.getY()) * 0.02;
            this.mX = mouseEvent.getX();
            this.mY = mouseEvent.getY();
            this.angleOx -= d2;
            this.angleOy += d;
            if (this.angleOx < 0.0) {
                this.angleOx = 0.0;
            }
            if (this.angleOx > 1.5707963267948966) {
                this.angleOx = 1.5707963267948966;
            }
            if (this.angleOy < 0.0) {
                this.angleOy = 0.0;
            }
            if (this.angleOy > Math.PI) {
                this.angleOy = Math.PI;
            }
            this.updateAxisPosition();
            this.display();
            this.zoomAllowedMode = 0;
        }
        if (this.isDraggingZoom) {
            this.mX2 = mouseEvent.getX();
            this.mY2 = mouseEvent.getY();
            this.repaint();
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void resetRotation() {
        this.angleOx = 0.5;
        this.angleOy = 0.785f;
        this.updateAxisPosition();
        this.display();
        this.zoomAllowedMode = 0;
    }

    void rotateYX() {
        this.angleOx = 0.0;
        this.angleOy = Math.PI;
        this.updateAxisPosition();
        this.display();
        this.zoomAllowedMode = 3;
    }

    void rotateYZ() {
        this.angleOx = 0.0;
        this.angleOy = 1.5707963267948966;
        this.updateAxisPosition();
        this.display();
        this.zoomAllowedMode = 1;
    }

    void rotateXZ() {
        this.angleOx = 1.5707963267948966;
        this.angleOy = 1.5707963267948966;
        this.updateAxisPosition();
        this.display();
        this.zoomAllowedMode = 2;
    }

    void rotate(double d, double d2) {
        this.angleOx = d;
        this.angleOy = d2;
        if (this.angleOx < 0.0) {
            this.angleOx = 0.0;
        }
        if (this.angleOx > 1.5707963267948966) {
            this.angleOx = 1.5707963267948966;
        }
        if (this.angleOy < 0.0) {
            this.angleOy = 0.0;
        }
        if (this.angleOy > Math.PI) {
            this.angleOy = Math.PI;
        }
        this.updateAxisPosition();
        this.display();
        this.zoomAllowedMode = 0;
    }

    private Rectangle buildZoomRect() {
        Rectangle rectangle = new Rectangle();
        if (this.mX < this.mX2) {
            if (this.mY < this.mY2) {
                rectangle.setRect(this.mX, this.mY, this.mX2 - this.mX, this.mY2 - this.mY);
            } else {
                rectangle.setRect(this.mX, this.mY2, this.mX2 - this.mX, this.mY - this.mY2);
            }
        } else if (this.mY < this.mY2) {
            rectangle.setRect(this.mX2, this.mY, this.mX - this.mX2, this.mY2 - this.mY);
        } else {
            rectangle.setRect(this.mX2, this.mY2, this.mX - this.mX2, this.mY - this.mY2);
        }
        return rectangle;
    }

    public void paint(Graphics graphics) {
        LabelInfo labelInfo;
        int n;
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        super.paint(graphics);
        if (this.xAxis.isVisible() && this.xAxis.isDrawAble()) {
            for (n = 0; n < this.xAxis.labelInfo.size(); ++n) {
                labelInfo = (LabelInfo)this.xAxis.labelInfo.get(n);
                labelInfo.measureLabel(fontRenderContext);
                labelInfo.computePosition();
                labelInfo.paint(graphics);
            }
            this.xAxis.nameInfo.measureLabel(fontRenderContext);
            this.xAxis.nameInfo.computePosition();
            this.xAxis.nameInfo.paint(graphics);
        }
        if (this.yAxis.isVisible() && this.yAxis.isDrawAble()) {
            for (n = 0; n < this.yAxis.labelInfo.size(); ++n) {
                labelInfo = (LabelInfo)this.yAxis.labelInfo.get(n);
                labelInfo.measureLabel(fontRenderContext);
                labelInfo.computePosition();
                labelInfo.paint(graphics);
            }
            this.yAxis.nameInfo.measureLabel(fontRenderContext);
            this.yAxis.nameInfo.computePosition();
            this.yAxis.nameInfo.paint(graphics);
        }
        if (this.zAxis.isVisible() && this.zAxis.isDrawAble()) {
            for (n = 0; n < this.zAxis.labelInfo.size(); ++n) {
                labelInfo = (LabelInfo)this.zAxis.labelInfo.get(n);
                labelInfo.measureLabel(fontRenderContext);
                labelInfo.computePosition();
                labelInfo.paint(graphics);
            }
            this.zAxis.nameInfo.measureLabel(fontRenderContext);
            this.zAxis.nameInfo.computePosition();
            this.zAxis.nameInfo.paint(graphics);
        }
        if (this.isDraggingZoom) {
            graphics.setColor(Color.WHITE);
            Rectangle rectangle = this.buildZoomRect();
            graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    private void updateModelMatrix(GL gL, double d) {
        this.angleOx = Utils.RoundAngle(this.angleOx);
        this.angleOy = Utils.RoundAngle(this.angleOy);
        VERTEX3D vERTEX3D = new VERTEX3D();
        vERTEX3D.x = (this.xAxis.getMax() + this.xAxis.getMin()) / 2.0;
        vERTEX3D.y = (this.yAxis.getMax() + this.yAxis.getMin()) / 2.0;
        vERTEX3D.z = (this.zAxis.getMax() + this.zAxis.getMin()) / 2.0;
        gL.glMatrixMode(5888);
        gL.glLoadIdentity();
        gL.glScaled(d, d, d);
        gL.glRotated(-Utils.ToDeg(this.angleOx), 1.0, 0.0, 0.0);
        gL.glRotated(-Utils.ToDeg(this.angleOy), 0.0, 1.0, 0.0);
        gL.glTranslated(-vERTEX3D.x, -vERTEX3D.y, -vERTEX3D.z);
    }
}

