/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.chart;

import fr.esrf.tangoatk.widget.util.ATKFontChooser;
import fr.esrf.tangoatk.widget.util.JSmoothLabel;
import fr.esrf.tangoatk.widget.util.chart.AxisPanel;
import fr.esrf.tangoatk.widget.util.chart.GraphicsUtils;
import fr.esrf.tangoatk.widget.util.chart.JLChart;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class JLChartOption
extends JDialog
implements ActionListener,
MouseListener,
ChangeListener,
KeyListener {
    private JLChart chart;
    private JTabbedPane tabPane;
    private JButton closeBtn;
    private JPanel generalPanel;
    private JPanel gLegendPanel;
    private JLabel generalLegendLabel;
    private JTextField generalLegendText;
    private JCheckBox generalLabelVisibleCheck;
    private JPanel gColorFontPanel;
    private JLabel generalFontHeaderLabel;
    private JSmoothLabel generalFontHeaderSampleLabel;
    private JButton generalFontHeaderBtn;
    private JLabel generalFontLabelLabel;
    private JSmoothLabel generalFontLabelSampleLabel;
    private JButton generalFontLabelBtn;
    private JLabel generalBackColorLabel;
    private JLabel generalBackColorView;
    private JButton generalBackColorBtn;
    private JPanel gGridPanel;
    private JComboBox generalGridCombo;
    private JComboBox generalLabelPCombo;
    private JLabel generalLabelPLabel;
    private JCheckBox xSubGribVisibleCheck;
    private JLabel xNbTickLabel;
    private JTextField xNbTickText;
    private JComboBox generalGridStyleCombo;
    private JLabel generalGridStyleLabel;
    private JPanel gMiscPanel;
    private JLabel generalDurationLabel;
    private JTextField generalDurationText;
    private JLabel percentScrollLabel;
    private JTextField percentScrollText;
    private AxisPanel y1Panel;
    private AxisPanel y2Panel;
    private AxisPanel xPanel;

    public JLChartOption(JDialog jDialog, JLChart jLChart) {
        super((Dialog)jDialog, false);
        this.chart = jLChart;
        this.initComponents();
    }

    public JLChartOption(JFrame jFrame, JLChart jLChart) {
        super((Frame)jFrame, false);
        this.chart = jLChart;
        this.initComponents();
    }

    private void initComponents() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(null);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                JLChartOption.this.setVisible(false);
                JLChartOption.this.dispose();
            }
        });
        this.setTitle("Chart properties");
        this.tabPane = new JTabbedPane();
        this.generalPanel = new JPanel();
        this.generalPanel.setLayout(null);
        this.gLegendPanel = new JPanel();
        this.gLegendPanel.setLayout(null);
        this.gLegendPanel.setBorder(GraphicsUtils.createTitleBorder("Legends"));
        this.gColorFontPanel = new JPanel();
        this.gColorFontPanel.setLayout(null);
        this.gColorFontPanel.setBorder(GraphicsUtils.createTitleBorder("Colors & Fonts"));
        this.gGridPanel = new JPanel();
        this.gGridPanel.setLayout(null);
        this.gGridPanel.setBorder(GraphicsUtils.createTitleBorder("Axis grid"));
        this.gMiscPanel = new JPanel();
        this.gMiscPanel.setLayout(null);
        this.gMiscPanel.setBorder(GraphicsUtils.createTitleBorder("Misc"));
        this.generalLegendLabel = new JLabel("Chart title");
        this.generalLegendLabel.setFont(GraphicsUtils.labelFont);
        this.generalLegendLabel.setForeground(GraphicsUtils.fColor);
        this.generalLegendText = new JTextField();
        this.generalLegendText.setEditable(true);
        this.generalLegendText.setText(this.chart.getHeader());
        this.generalLegendText.setMargin(GraphicsUtils.zInset);
        this.generalLegendText.addKeyListener(this);
        this.generalLabelVisibleCheck = new JCheckBox();
        this.generalLabelVisibleCheck.setFont(GraphicsUtils.labelFont);
        this.generalLabelVisibleCheck.setForeground(GraphicsUtils.fColor);
        this.generalLabelVisibleCheck.setText("Visible");
        this.generalLabelVisibleCheck.setSelected(this.chart.isLabelVisible());
        this.generalLabelVisibleCheck.addActionListener(this);
        this.generalBackColorLabel = new JLabel("Chart background");
        this.generalBackColorLabel.setFont(GraphicsUtils.labelFont);
        this.generalBackColorLabel.setForeground(GraphicsUtils.fColor);
        this.generalBackColorView = new JLabel("");
        this.generalBackColorView.setOpaque(true);
        this.generalBackColorView.setBorder(BorderFactory.createLineBorder(Color.black));
        this.generalBackColorView.setBackground(this.chart.getChartBackground());
        this.generalBackColorBtn = new JButton("...");
        this.generalBackColorBtn.addMouseListener(this);
        this.generalBackColorBtn.setMargin(GraphicsUtils.zInset);
        this.generalLabelPLabel = new JLabel("Placement");
        this.generalLabelPLabel.setHorizontalAlignment(4);
        this.generalLabelPLabel.setFont(GraphicsUtils.labelFont);
        this.generalLabelPLabel.setForeground(GraphicsUtils.fColor);
        this.generalLabelPCombo = new JComboBox();
        this.generalLabelPCombo.setFont(GraphicsUtils.labelFont);
        this.generalLabelPCombo.addItem("Bottom");
        this.generalLabelPCombo.addItem("Top");
        this.generalLabelPCombo.addItem("Right");
        this.generalLabelPCombo.addItem("Left");
        this.generalLabelPCombo.addItem("Row");
        this.generalLabelPCombo.setSelectedIndex(this.chart.getLabelPlacement());
        this.generalLabelPCombo.addActionListener(this);
        this.generalGridCombo = new JComboBox();
        this.generalGridCombo.setFont(GraphicsUtils.labelFont);
        this.generalGridCombo.addItem("None");
        this.generalGridCombo.addItem("On X");
        this.generalGridCombo.addItem("On Y1");
        this.generalGridCombo.addItem("On Y2");
        this.generalGridCombo.addItem("On X and Y1");
        this.generalGridCombo.addItem("On X and Y2");
        boolean bl = this.chart.getXAxis().isGridVisible();
        boolean bl2 = this.chart.getY1Axis().isGridVisible();
        boolean bl3 = this.chart.getY2Axis().isGridVisible();
        int n = 0;
        if (bl && !bl2 && !bl3) {
            n = 1;
        }
        if (!bl && bl2 && !bl3) {
            n = 2;
        }
        if (!bl && !bl2 && bl3) {
            n = 3;
        }
        if (bl && bl2 && !bl3) {
            n = 4;
        }
        if (bl && !bl2 && bl3) {
            n = 5;
        }
        this.generalGridCombo.setSelectedIndex(n);
        this.generalGridCombo.addActionListener(this);
        this.generalGridStyleLabel = new JLabel("Style");
        this.generalGridStyleLabel.setFont(GraphicsUtils.labelFont);
        this.generalGridStyleLabel.setHorizontalAlignment(4);
        this.generalGridStyleLabel.setForeground(GraphicsUtils.fColor);
        this.generalGridStyleCombo = new JComboBox();
        this.generalGridStyleCombo.setFont(GraphicsUtils.labelFont);
        this.generalGridStyleCombo.addItem("Solid");
        this.generalGridStyleCombo.addItem("Dot");
        this.generalGridStyleCombo.addItem("Short dash");
        this.generalGridStyleCombo.addItem("Long dash");
        this.generalGridStyleCombo.addItem("Dot dash");
        this.generalGridStyleCombo.setSelectedIndex(this.chart.getY1Axis().getGridStyle());
        this.generalGridStyleCombo.addActionListener(this);
        this.xSubGribVisibleCheck = new JCheckBox();
        this.xSubGribVisibleCheck.setFont(GraphicsUtils.labelFont);
        this.xSubGribVisibleCheck.setForeground(GraphicsUtils.fColor);
        this.xSubGribVisibleCheck.setText("show X sub grid");
        this.xSubGribVisibleCheck.setSelected(this.chart.getXAxis().isSubGridVisible());
        this.xSubGribVisibleCheck.addActionListener(this);
        this.xNbTickLabel = new JLabel("Sub tick interval number");
        this.xNbTickLabel.setFont(GraphicsUtils.labelFont);
        this.xNbTickLabel.setForeground(GraphicsUtils.fColor);
        this.xNbTickText = new JTextField();
        this.xNbTickText.setEditable(true);
        this.xNbTickText.setToolTipText("Number of sub tick interval (0 to disable)");
        this.xNbTickText.setText(Integer.toString(this.chart.getXAxis().getTimeAnnoSubTickInterval()));
        this.xNbTickText.setMargin(GraphicsUtils.zInset);
        this.xNbTickText.addKeyListener(this);
        this.generalDurationLabel = new JLabel("Display duration (s)");
        this.generalDurationLabel.setFont(GraphicsUtils.labelFont);
        this.generalDurationLabel.setForeground(GraphicsUtils.fColor);
        this.generalDurationText = new JTextField();
        this.generalDurationText.setEditable(true);
        this.generalDurationText.setToolTipText("Type Infinity to disable");
        this.generalDurationText.setText(Double.toString(this.chart.getDisplayDuration() / 1000.0));
        this.generalDurationText.setMargin(GraphicsUtils.zInset);
        this.generalDurationText.addKeyListener(this);
        this.percentScrollLabel = new JLabel("Percent scrollback");
        this.percentScrollLabel.setFont(GraphicsUtils.labelFont);
        this.percentScrollLabel.setForeground(GraphicsUtils.fColor);
        this.percentScrollText = new JTextField();
        this.percentScrollText.setEditable(true);
        this.percentScrollText.setToolTipText("Type 0 disable");
        this.percentScrollText.setText(Double.toString(this.chart.getXAxis().getPercentScrollback()));
        this.percentScrollText.setMargin(GraphicsUtils.zInset);
        this.percentScrollText.addKeyListener(this);
        this.generalFontHeaderLabel = new JLabel("Header font");
        this.generalFontHeaderLabel.setFont(GraphicsUtils.labelFont);
        this.generalFontHeaderLabel.setForeground(GraphicsUtils.fColor);
        this.generalFontHeaderSampleLabel = new JSmoothLabel();
        this.generalFontHeaderSampleLabel.setText("Sample text");
        this.generalFontHeaderSampleLabel.setForeground(GraphicsUtils.fColor);
        this.generalFontHeaderSampleLabel.setOpaque(false);
        this.generalFontHeaderSampleLabel.setFont(this.chart.getHeaderFont());
        this.generalFontHeaderBtn = new JButton("...");
        this.generalFontHeaderBtn.addMouseListener(this);
        this.generalFontHeaderBtn.setMargin(GraphicsUtils.zInset);
        this.generalFontLabelLabel = new JLabel("Label font");
        this.generalFontLabelLabel.setFont(GraphicsUtils.labelFont);
        this.generalFontLabelLabel.setForeground(GraphicsUtils.fColor);
        this.generalFontLabelSampleLabel = new JSmoothLabel();
        this.generalFontLabelSampleLabel.setText("Sample 0123456789");
        this.generalFontLabelSampleLabel.setForeground(GraphicsUtils.fColor);
        this.generalFontLabelSampleLabel.setOpaque(false);
        this.generalFontLabelSampleLabel.setFont(this.chart.getXAxis().getFont());
        this.generalFontLabelBtn = new JButton("...");
        this.generalFontLabelBtn.addMouseListener(this);
        this.generalFontHeaderBtn.setMargin(GraphicsUtils.zInset);
        this.gLegendPanel.add(this.generalLabelVisibleCheck);
        this.gLegendPanel.add(this.generalLabelPLabel);
        this.gLegendPanel.add(this.generalLabelPCombo);
        this.generalPanel.add(this.gLegendPanel);
        this.gGridPanel.add(this.generalGridCombo);
        this.gGridPanel.add(this.generalGridStyleLabel);
        this.gGridPanel.add(this.generalGridStyleCombo);
        this.gGridPanel.add(this.xSubGribVisibleCheck);
        this.gGridPanel.add(this.xNbTickLabel);
        this.gGridPanel.add(this.xNbTickText);
        this.generalPanel.add(this.gGridPanel);
        this.gColorFontPanel.add(this.generalBackColorLabel);
        this.gColorFontPanel.add(this.generalBackColorView);
        this.gColorFontPanel.add(this.generalBackColorBtn);
        this.gColorFontPanel.add(this.generalFontHeaderLabel);
        this.gColorFontPanel.add(this.generalFontHeaderSampleLabel);
        this.gColorFontPanel.add(this.generalFontHeaderBtn);
        this.gColorFontPanel.add(this.generalFontLabelLabel);
        this.gColorFontPanel.add(this.generalFontLabelSampleLabel);
        this.gColorFontPanel.add(this.generalFontLabelBtn);
        this.generalPanel.add(this.gColorFontPanel);
        this.gMiscPanel.add(this.generalLegendLabel);
        this.gMiscPanel.add(this.generalLegendText);
        this.gMiscPanel.add(this.generalDurationLabel);
        this.gMiscPanel.add(this.generalDurationText);
        this.gMiscPanel.add(this.percentScrollLabel);
        this.gMiscPanel.add(this.percentScrollText);
        this.generalPanel.add(this.gMiscPanel);
        this.generalLabelVisibleCheck.setBounds(5, 20, 80, 25);
        this.generalLabelPLabel.setBounds(90, 20, 95, 25);
        this.generalLabelPCombo.setBounds(190, 20, 95, 25);
        this.gLegendPanel.setBounds(5, 10, 290, 55);
        this.generalBackColorLabel.setBounds(10, 20, 140, 25);
        this.generalBackColorView.setBounds(155, 20, 95, 25);
        this.generalBackColorBtn.setBounds(255, 20, 30, 25);
        this.generalFontHeaderLabel.setBounds(10, 50, 90, 25);
        this.generalFontHeaderSampleLabel.setBounds(105, 50, 145, 25);
        this.generalFontHeaderBtn.setBounds(255, 50, 30, 25);
        this.generalFontLabelLabel.setBounds(10, 80, 90, 25);
        this.generalFontLabelSampleLabel.setBounds(105, 80, 145, 25);
        this.generalFontLabelBtn.setBounds(255, 80, 30, 25);
        this.gColorFontPanel.setBounds(5, 70, 290, 115);
        this.generalGridCombo.setBounds(10, 20, 120, 25);
        this.generalGridStyleLabel.setBounds(135, 20, 45, 25);
        this.generalGridStyleCombo.setBounds(185, 20, 100, 25);
        this.xSubGribVisibleCheck.setBounds(7, 50, 150, 25);
        this.xNbTickLabel.setBounds(10, 75, 180, 25);
        this.xNbTickText.setBounds(195, 75, 90, 25);
        if (this.chart.getXAxis().getAnnotation() != 1) {
            this.gGridPanel.setBounds(5, 190, 290, 55);
            this.xSubGribVisibleCheck.setVisible(false);
            this.xNbTickLabel.setVisible(false);
            this.xNbTickText.setVisible(false);
        } else {
            this.gGridPanel.setBounds(5, 190, 290, 105);
            this.xSubGribVisibleCheck.setVisible(true);
            this.xNbTickLabel.setVisible(true);
            this.xNbTickText.setVisible(true);
        }
        this.generalLegendLabel.setBounds(10, 20, 70, 25);
        this.generalLegendText.setBounds(85, 20, 200, 25);
        this.generalDurationLabel.setBounds(10, 50, 120, 25);
        this.generalDurationText.setBounds(135, 50, 150, 25);
        this.percentScrollLabel.setBounds(10, 80, 120, 25);
        this.percentScrollText.setBounds(135, 80, 150, 25);
        if (this.chart.getXAxis().getAnnotation() != 1) {
            this.gMiscPanel.setBounds(5, 250, 290, 85);
            this.percentScrollLabel.setVisible(false);
            this.percentScrollText.setVisible(false);
        } else {
            this.gMiscPanel.setBounds(5, 300, 290, 110);
            this.percentScrollLabel.setVisible(true);
            this.percentScrollText.setVisible(true);
        }
        this.y1Panel = new AxisPanel(this.chart.getY1Axis(), 1, this.chart);
        this.y2Panel = new AxisPanel(this.chart.getY2Axis(), 2, this.chart);
        this.xPanel = new AxisPanel(this.chart.getXAxis(), 3, this.chart);
        this.tabPane.add("General", this.generalPanel);
        if (this.chart.getXAxis().getAnnotation() != 1) {
            this.tabPane.add("X axis", this.xPanel);
        }
        this.tabPane.add("Y1 axis", this.y1Panel);
        this.tabPane.add("Y2 axis", this.y2Panel);
        jPanel.add(this.tabPane);
        this.closeBtn = new JButton();
        this.closeBtn.setText("Close");
        jPanel.add(this.closeBtn);
        if (this.chart.getXAxis().getAnnotation() != 1) {
            this.tabPane.setBounds(5, 5, 300, 370);
            this.closeBtn.setBounds(225, 380, 80, 25);
            jPanel.setPreferredSize(new Dimension(310, 410));
        } else {
            this.tabPane.setBounds(5, 5, 300, 445);
            this.closeBtn.setBounds(225, 455, 80, 25);
            jPanel.setPreferredSize(new Dimension(310, 485));
        }
        this.closeBtn.addMouseListener(this);
        this.setContentPane(jPanel);
        this.setResizable(false);
    }

    private void Commit() {
        if (this.chart != null) {
            this.chart.repaint();
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        Font font;
        if (mouseEvent.getSource() == this.closeBtn) {
            this.setVisible(false);
            this.dispose();
        } else if (mouseEvent.getSource() == this.generalBackColorBtn) {
            Color color = JColorChooser.showDialog(this, "Choose background Color", this.chart.getChartBackground());
            if (color != null) {
                this.chart.setChartBackground(color);
                this.generalBackColorView.setBackground(color);
                this.Commit();
            }
        } else if (mouseEvent.getSource() == this.generalFontHeaderBtn) {
            Font font2 = ATKFontChooser.getNewFont(this, "Choose Header Font", this.chart.getHeaderFont());
            if (font2 != null) {
                this.chart.setHeaderFont(font2);
                this.generalFontHeaderSampleLabel.setFont(font2);
                this.Commit();
            }
        } else if (mouseEvent.getSource() == this.generalFontLabelBtn && (font = ATKFontChooser.getNewFont(this, "Choose label Font", this.chart.getXAxis().getFont())) != null) {
            this.chart.getXAxis().setFont(font);
            this.chart.getY1Axis().setFont(font);
            this.chart.getY2Axis().setFont(font);
            this.chart.setLabelFont(font);
            this.generalFontLabelSampleLabel.setFont(font);
            this.Commit();
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.generalLabelVisibleCheck) {
            this.chart.setLabelVisible(this.generalLabelVisibleCheck.isSelected());
            this.Commit();
        } else if (actionEvent.getSource() == this.generalGridCombo) {
            int n = this.generalGridCombo.getSelectedIndex();
            switch (n) {
                case 1: {
                    this.chart.getXAxis().setGridVisible(true);
                    this.chart.getY1Axis().setGridVisible(false);
                    this.chart.getY2Axis().setGridVisible(false);
                    break;
                }
                case 2: {
                    this.chart.getXAxis().setGridVisible(false);
                    this.chart.getY1Axis().setGridVisible(true);
                    this.chart.getY2Axis().setGridVisible(false);
                    break;
                }
                case 3: {
                    this.chart.getXAxis().setGridVisible(false);
                    this.chart.getY1Axis().setGridVisible(false);
                    this.chart.getY2Axis().setGridVisible(true);
                    break;
                }
                case 4: {
                    this.chart.getXAxis().setGridVisible(true);
                    this.chart.getY1Axis().setGridVisible(true);
                    this.chart.getY2Axis().setGridVisible(false);
                    break;
                }
                case 5: {
                    this.chart.getXAxis().setGridVisible(true);
                    this.chart.getY1Axis().setGridVisible(false);
                    this.chart.getY2Axis().setGridVisible(true);
                    break;
                }
                default: {
                    this.chart.getXAxis().setGridVisible(false);
                    this.chart.getY1Axis().setGridVisible(false);
                    this.chart.getY2Axis().setGridVisible(false);
                }
            }
            this.Commit();
        } else if (actionEvent.getSource() == this.generalGridStyleCombo) {
            int n = this.generalGridStyleCombo.getSelectedIndex();
            this.chart.getXAxis().setGridStyle(n);
            this.chart.getY1Axis().setGridStyle(n);
            this.chart.getY2Axis().setGridStyle(n);
            this.Commit();
        } else if (actionEvent.getSource() == this.generalLabelPCombo) {
            int n = this.generalLabelPCombo.getSelectedIndex();
            this.chart.setLabelPlacement(n);
            this.Commit();
        } else if (actionEvent.getSource() == this.xSubGribVisibleCheck) {
            this.chart.getXAxis().setSubGridVisible(this.xSubGribVisibleCheck.isSelected());
            this.Commit();
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getSource() == this.generalLegendText) {
            if (keyEvent.getKeyCode() == 10) {
                this.chart.setHeader(this.generalLegendText.getText());
                this.Commit();
            }
            if (keyEvent.getKeyCode() == 27) {
                this.generalLegendText.setText(this.chart.getHeader());
            }
        } else if (keyEvent.getSource() == this.generalDurationText) {
            if (keyEvent.getKeyCode() == 10) {
                if (this.generalDurationText.getText().equalsIgnoreCase("infinty")) {
                    this.chart.setDisplayDuration(Double.POSITIVE_INFINITY);
                    return;
                }
                try {
                    double d = Double.parseDouble(this.generalDurationText.getText());
                    this.chart.setDisplayDuration(d * 1000.0);
                    this.Commit();
                }
                catch (NumberFormatException numberFormatException) {
                    this.error("Display duration: malformed number.");
                }
                this.Commit();
            }
            if (keyEvent.getKeyCode() == 27) {
                this.generalLegendText.setText(Double.toString(this.chart.getDisplayDuration() / 1000.0));
            }
        } else if (keyEvent.getSource() == this.xNbTickText) {
            if (keyEvent.getKeyCode() == 10) {
                try {
                    int n = Integer.parseInt(this.xNbTickText.getText());
                    this.chart.getXAxis().setTimeAnnoSubTickInterval(n);
                    this.Commit();
                }
                catch (NumberFormatException numberFormatException) {
                    this.error("Sub tick number: malformed number.");
                }
                this.Commit();
            }
        } else if (keyEvent.getSource() == this.percentScrollText && keyEvent.getKeyCode() == 10) {
            try {
                double d = Double.parseDouble(this.percentScrollText.getText());
                if (d < 0.0 || d > 100.0) {
                    this.error("Invalid percent scrollback value [0,100]");
                    return;
                }
                this.chart.getXAxis().setPercentScrollback(d);
                this.Commit();
            }
            catch (NumberFormatException numberFormatException) {
                this.error("Percent scrollbak: malformed number.");
            }
        }
    }

    private void error(String string) {
        JOptionPane.showMessageDialog(this, string, "Chart options error", 0);
    }
}

