/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.INumberScalar;
import fr.esrf.tangoatk.core.INumberScalarHistory;
import fr.esrf.tangoatk.core.INumberScalarListener;
import fr.esrf.tangoatk.core.NumberScalarEvent;
import fr.esrf.tangoatk.widget.attribute.Trend;
import fr.esrf.tangoatk.widget.util.chart.DataList;
import fr.esrf.tangoatk.widget.util.chart.JLDataView;
import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;

class TrendSelectionNode
extends DefaultMutableTreeNode
implements INumberScalarListener,
PropertyChangeListener {
    private String devname = "";
    private INumberScalar model;
    private int selected;
    private JLDataView data;
    private JLDataView minAlarmData;
    private JLDataView maxAlarmData;
    private long lastErrorTime = 0L;
    private double minAlarm;
    private double maxAlarm;
    private boolean showMinAlarm;
    private boolean showMaxAlarm;
    static GregorianCalendar calendar = new GregorianCalendar();
    static SimpleDateFormat format = new SimpleDateFormat("HH:mm:ss");
    Trend chart;

    public TrendSelectionNode(Trend trend) {
        this.devname = "Trend";
        this.model = null;
        this.data = null;
        this.chart = trend;
    }

    public TrendSelectionNode(Trend trend, String string) {
        this.devname = string;
        this.data = null;
        this.model = null;
        this.chart = trend;
    }

    public TrendSelectionNode(Trend trend, String string, INumberScalar iNumberScalar, int n, Color color) {
        this.devname = string;
        this.model = iNumberScalar;
        this.selected = n;
        this.showMinAlarm = false;
        this.showMaxAlarm = false;
        this.chart = trend;
        this.data = new JLDataView();
        this.data.setColor(color);
        this.data.setMarkerColor(color);
        this.minAlarmData = new JLDataView();
        this.minAlarmData.setColor(color);
        this.minAlarmData.setMarkerColor(color);
        this.minAlarmData.setStyle(2);
        this.maxAlarmData = new JLDataView();
        this.maxAlarmData.setColor(color);
        this.maxAlarmData.setMarkerColor(color);
        this.maxAlarmData.setStyle(2);
        INumberScalarHistory[] iNumberScalarHistoryArray = iNumberScalar.getNumberScalarHistory();
        if (iNumberScalarHistoryArray != null) {
            for (int i = 0; i < iNumberScalarHistoryArray.length; ++i) {
                this.data.add(iNumberScalarHistoryArray[i].getTimestamp(), iNumberScalarHistoryArray[i].getValue());
            }
            this.chart.getChart().garbageData(this.data);
        }
        iNumberScalar.addNumberScalarListener((INumberScalarListener)this);
        iNumberScalar.getProperty("label").addPresentationListener((PropertyChangeListener)this);
        iNumberScalar.getProperty("unit").addPresentationListener((PropertyChangeListener)this);
        iNumberScalar.getProperty("format").addPresentationListener((PropertyChangeListener)this);
        iNumberScalar.getProperty("min_alarm").addPresentationListener((PropertyChangeListener)this);
        iNumberScalar.getProperty("max_alarm").addPresentationListener((PropertyChangeListener)this);
    }

    public void refreshNode() {
        this.data.setUnit(this.model.getUnit());
        this.data.setUserFormat(this.model.getFormat());
        if (this.model.getLabel().length() > 0 && !this.model.getLabel().equalsIgnoreCase("not specified")) {
            if (this.chart.displayDeviceNames()) {
                String string = this.devname + "/" + this.model.getLabel();
                this.data.setName(string);
                this.minAlarmData.setName(string + " [Min alarm]");
                this.maxAlarmData.setName(string + " [Max alarm]");
            } else {
                String string = this.model.getLabel();
                this.data.setName(string);
                this.minAlarmData.setName(string + " [Min alarm]");
                this.maxAlarmData.setName(string + " [Max alarm]");
            }
        } else {
            String string = this.model.getName();
            this.data.setName(string);
            this.minAlarmData.setName(string + " [Min alarm]");
            this.maxAlarmData.setName(string + " [Max alarm]");
        }
        this.minAlarm = this.model.getMinAlarm();
        this.maxAlarm = this.model.getMaxAlarm();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.model != null) {
            this.refreshNode();
            this.chart.refreshNode(this);
        }
    }

    public int getSelected() {
        return this.selected;
    }

    public void showMinAlarm() {
        this.showMinAlarm = true;
        switch (this.selected) {
            case 2: {
                this.chart.getChart().getY1Axis().addDataView(this.minAlarmData);
                break;
            }
            case 3: {
                this.chart.getChart().getY2Axis().addDataView(this.minAlarmData);
            }
        }
    }

    public void hideMinAlarm() {
        this.showMinAlarm = false;
        switch (this.selected) {
            case 2: {
                this.chart.getChart().getY1Axis().removeDataView(this.minAlarmData);
                break;
            }
            case 3: {
                this.chart.getChart().getY2Axis().removeDataView(this.minAlarmData);
            }
        }
    }

    public boolean isShowingMinAlarm() {
        return this.showMinAlarm;
    }

    public void showMaxAlarm() {
        this.showMaxAlarm = true;
        switch (this.selected) {
            case 2: {
                this.chart.getChart().getY1Axis().addDataView(this.maxAlarmData);
                break;
            }
            case 3: {
                this.chart.getChart().getY2Axis().addDataView(this.maxAlarmData);
            }
        }
    }

    public void hideMaxAlarm() {
        this.showMaxAlarm = false;
        switch (this.selected) {
            case 2: {
                this.chart.getChart().getY1Axis().removeDataView(this.maxAlarmData);
                break;
            }
            case 3: {
                this.chart.getChart().getY2Axis().removeDataView(this.maxAlarmData);
            }
        }
    }

    public boolean isShowingMaxAlarm() {
        return this.showMaxAlarm;
    }

    public void setSelected(int n) {
        switch (n) {
            case 0: {
                switch (this.selected) {
                    case 1: {
                        this.chart.getChart().getXAxis().removeDataView(this.data);
                        break;
                    }
                    case 2: {
                        this.chart.getChart().getY1Axis().removeDataView(this.data);
                        if (this.showMinAlarm) {
                            this.chart.getChart().getY1Axis().removeDataView(this.minAlarmData);
                        }
                        if (!this.showMaxAlarm) break;
                        this.chart.getChart().getY1Axis().removeDataView(this.maxAlarmData);
                        break;
                    }
                    case 3: {
                        this.chart.getChart().getY2Axis().removeDataView(this.data);
                        if (this.showMinAlarm) {
                            this.chart.getChart().getY2Axis().removeDataView(this.minAlarmData);
                        }
                        if (!this.showMaxAlarm) break;
                        this.chart.getChart().getY2Axis().removeDataView(this.maxAlarmData);
                    }
                }
                break;
            }
            case 1: {
                switch (this.selected) {
                    case 2: {
                        this.chart.getChart().getY1Axis().removeDataView(this.data);
                        if (this.showMinAlarm) {
                            this.chart.getChart().getY1Axis().removeDataView(this.minAlarmData);
                        }
                        if (!this.showMaxAlarm) break;
                        this.chart.getChart().getY1Axis().removeDataView(this.maxAlarmData);
                        break;
                    }
                    case 3: {
                        this.chart.getChart().getY2Axis().removeDataView(this.data);
                        if (this.showMinAlarm) {
                            this.chart.getChart().getY2Axis().removeDataView(this.minAlarmData);
                        }
                        if (!this.showMaxAlarm) break;
                        this.chart.getChart().getY2Axis().removeDataView(this.maxAlarmData);
                    }
                }
                this.chart.getChart().getXAxis().addDataView(this.data);
                break;
            }
            case 2: {
                switch (this.selected) {
                    case 1: {
                        this.chart.getChart().getXAxis().removeDataView(this.data);
                        break;
                    }
                    case 3: {
                        this.chart.getChart().getY2Axis().removeDataView(this.data);
                        if (this.showMinAlarm) {
                            this.chart.getChart().getY2Axis().removeDataView(this.minAlarmData);
                        }
                        if (!this.showMaxAlarm) break;
                        this.chart.getChart().getY2Axis().removeDataView(this.maxAlarmData);
                    }
                }
                this.chart.getChart().getY1Axis().addDataView(this.data);
                if (this.showMinAlarm) {
                    this.chart.getChart().getY1Axis().addDataView(this.minAlarmData);
                }
                if (!this.showMaxAlarm) break;
                this.chart.getChart().getY1Axis().addDataView(this.maxAlarmData);
                break;
            }
            case 3: {
                switch (this.selected) {
                    case 1: {
                        this.chart.getChart().getXAxis().removeDataView(this.data);
                        break;
                    }
                    case 2: {
                        this.chart.getChart().getY1Axis().removeDataView(this.data);
                        if (this.showMinAlarm) {
                            this.chart.getChart().getY1Axis().removeDataView(this.minAlarmData);
                        }
                        if (!this.showMaxAlarm) break;
                        this.chart.getChart().getY1Axis().removeDataView(this.maxAlarmData);
                    }
                }
                this.chart.getChart().getY2Axis().addDataView(this.data);
                if (this.showMinAlarm) {
                    this.chart.getChart().getY2Axis().addDataView(this.minAlarmData);
                }
                if (!this.showMaxAlarm) break;
                this.chart.getChart().getY2Axis().addDataView(this.maxAlarmData);
            }
        }
        this.selected = n;
    }

    public boolean isLeaf() {
        return this.model != null;
    }

    public INumberScalar getModel() {
        return this.model;
    }

    public JLDataView getData() {
        return this.data;
    }

    public JLDataView getMinAlarmData() {
        return this.minAlarmData;
    }

    public JLDataView getMaxAlarmData() {
        return this.maxAlarmData;
    }

    public void delItem(INumberScalar iNumberScalar) {
        int n = 0;
        int n2 = 0;
        int n3 = this.getChildCount();
        boolean bl = false;
        String string = iNumberScalar.getName();
        String string2 = string.substring(0, string.lastIndexOf(47));
        while (n < n3 && !bl) {
            bl = string2.equals(this.getChild(n).toString());
            if (bl) continue;
            ++n;
        }
        if (bl) {
            TrendSelectionNode trendSelectionNode = (TrendSelectionNode)this.getChildAt(n);
            bl = false;
            n2 = 0;
            int n4 = trendSelectionNode.getChildCount();
            while (n2 < n4 && !bl) {
                bl = string.equals(trendSelectionNode.getChild(n2).getModelName());
                if (bl) continue;
                ++n2;
            }
            if (bl) {
                trendSelectionNode.getChild(n2).setSelected(0);
                trendSelectionNode.getChild(n2).clearModel();
                trendSelectionNode.remove(n2);
                if (n4 == 1) {
                    this.remove(n);
                }
            }
        }
    }

    public TrendSelectionNode addItem(Trend trend, INumberScalar iNumberScalar, Color color) {
        int n = 0;
        int n2 = this.getChildCount();
        boolean bl = false;
        String string = iNumberScalar.getName();
        String string2 = string.substring(0, string.lastIndexOf(47));
        while (n < n2 && !bl) {
            bl = string2.equals(this.getChild(n).toString());
            if (bl) continue;
            ++n;
        }
        TrendSelectionNode trendSelectionNode = new TrendSelectionNode(trend, string2, iNumberScalar, 0, color);
        if (bl) {
            this.getChild(n).add(trendSelectionNode);
        } else {
            TrendSelectionNode trendSelectionNode2 = new TrendSelectionNode(trend, string2);
            this.add(trendSelectionNode2);
            trendSelectionNode2.add(trendSelectionNode);
        }
        return trendSelectionNode;
    }

    public Vector getSelectableItems() {
        Vector<TrendSelectionNode> vector;
        if (this.isLeaf()) {
            vector = new Vector<TrendSelectionNode>();
            vector.add(this);
        } else {
            int n = this.getChildCount();
            vector = new Vector();
            for (int i = 0; i < n; ++i) {
                TrendSelectionNode trendSelectionNode = this.getChild(i);
                vector.addAll(trendSelectionNode.getSelectableItems());
            }
        }
        return vector;
    }

    public void showOptions() {
        if (this.data != null) {
            this.chart.getChart().showDataOptionDialog(this.data);
        }
    }

    public String getModelName() {
        if (this.model != null) {
            return this.model.getName();
        }
        return "";
    }

    public void clearModel() {
        if (this.model != null) {
            this.model.removeNumberScalarListener((INumberScalarListener)this);
            this.model.getProperty("label").removePresentationListener((PropertyChangeListener)this);
            this.model.getProperty("unit").removePresentationListener((PropertyChangeListener)this);
            this.model.getProperty("format").removePresentationListener((PropertyChangeListener)this);
            this.model.getProperty("min_alarm").removePresentationListener((PropertyChangeListener)this);
            this.model.getProperty("max_alarm").removePresentationListener((PropertyChangeListener)this);
        }
        this.data = null;
        this.minAlarmData = null;
        this.maxAlarmData = null;
        this.model = null;
    }

    public TrendSelectionNode getChild(int n) {
        return (TrendSelectionNode)this.getChildAt(n);
    }

    public void numberScalarChange(NumberScalarEvent numberScalarEvent) {
        if (this.model == null) {
            return;
        }
        boolean bl = true;
        DataList dataList = this.data.getLastValue();
        double d = numberScalarEvent.getTimeStamp();
        double d2 = numberScalarEvent.getValue();
        if (dataList != null) {
            boolean bl2 = bl = dataList.x != d || dataList.y != d2;
        }
        if (bl) {
            if (this.chart.getChart().getXAxis().getPercentScrollback() == 0.0) {
                this.data.add(numberScalarEvent.getTimeStamp(), numberScalarEvent.getValue());
                this.chart.getChart().garbageData(this.data);
                if (this.showMinAlarm) {
                    this.minAlarmData.add(numberScalarEvent.getTimeStamp(), this.minAlarm);
                    this.chart.getChart().garbageData(this.minAlarmData);
                }
                if (this.showMaxAlarm) {
                    this.maxAlarmData.add(numberScalarEvent.getTimeStamp(), this.maxAlarm);
                    this.chart.getChart().garbageData(this.maxAlarmData);
                }
            } else {
                this.chart.getChart().addData(this.data, numberScalarEvent.getTimeStamp(), numberScalarEvent.getValue());
                if (this.showMinAlarm) {
                    this.chart.getChart().addData(this.minAlarmData, numberScalarEvent.getTimeStamp(), this.minAlarm);
                }
                if (this.showMaxAlarm) {
                    this.chart.getChart().addData(this.maxAlarmData, numberScalarEvent.getTimeStamp(), this.maxAlarm);
                }
            }
        }
    }

    public void errorChange(ErrorEvent errorEvent) {
        if (this.model == null) {
            return;
        }
        if (this.lastErrorTime != errorEvent.getTimeStamp()) {
            this.lastErrorTime = errorEvent.getTimeStamp();
            if (this.chart.getChart().getXAxis().getPercentScrollback() == 0.0) {
                this.data.add(this.lastErrorTime, Double.NaN);
                this.chart.getChart().garbageData(this.data);
                if (this.showMinAlarm) {
                    this.minAlarmData.add(errorEvent.getTimeStamp(), this.minAlarm);
                    this.chart.getChart().garbageData(this.minAlarmData);
                }
                if (this.showMaxAlarm) {
                    this.maxAlarmData.add(errorEvent.getTimeStamp(), this.maxAlarm);
                    this.chart.getChart().garbageData(this.maxAlarmData);
                }
            } else {
                this.chart.getChart().addData(this.data, this.lastErrorTime, Double.NaN);
                if (this.showMinAlarm) {
                    this.chart.getChart().addData(this.minAlarmData, errorEvent.getTimeStamp(), this.minAlarm);
                }
                if (this.showMaxAlarm) {
                    this.chart.getChart().addData(this.maxAlarmData, errorEvent.getTimeStamp(), this.maxAlarm);
                }
            }
        }
    }

    public void stateChange(AttributeStateEvent attributeStateEvent) {
    }

    public String toString() {
        if (this.model != null) {
            if (this.model.getLabel().length() > 0 && !this.model.getLabel().equalsIgnoreCase("not specified")) {
                return this.model.getLabel();
            }
            return this.model.getNameSansDevice();
        }
        return this.devname;
    }
}

