/*
 * Decompiled with CFR 0.152.
 */
package tool_panels.atktable;

import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class TablePreference
extends JDialog {
    private static final int NB_ROWS_MAX = 30;
    private static final int NB_COL_MAX = 10;
    private int retVal = 0;
    private int nbColumns;
    private int nbRows;
    private JButton cancelBtn;
    private JLabel columnsLbl;
    private JTextField columnsTxt;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JButton okBtn;
    private JLabel rowsLbl;
    private JTextField rowsTxt;
    private JLabel titleLabel;
    private JLabel titleLbl;
    private JTextField titleTxt;

    public TablePreference(JFrame parent) {
        super((Frame)parent, true);
        this.initComponents();
        this.initOwnComponents(parent);
    }

    public TablePreference(JDialog parent) {
        super((Dialog)parent, true);
        this.initComponents();
        this.initOwnComponents(parent);
    }

    private void initOwnComponents(Component parent) {
        this.titleTxt.setText("ATK Table Panel");
        this.rowsTxt.setText("3");
        this.columnsTxt.setText("2");
        Point p = parent.getLocation();
        p.x += 20;
        p.y += 20;
        this.setLocation(p);
        this.pack();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.okBtn = new JButton();
        this.cancelBtn = new JButton();
        this.jPanel2 = new JPanel();
        this.titleLabel = new JLabel();
        this.jPanel3 = new JPanel();
        this.titleLbl = new JLabel();
        this.titleTxt = new JTextField();
        this.rowsLbl = new JLabel();
        this.rowsTxt = new JTextField();
        this.columnsLbl = new JLabel();
        this.columnsTxt = new JTextField();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                TablePreference.this.closeDialog(evt);
            }
        });
        this.okBtn.setText("OK");
        this.okBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TablePreference.this.okBtnActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.okBtn);
        this.cancelBtn.setText("Cancel");
        this.cancelBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TablePreference.this.cancelBtnActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.cancelBtn);
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.titleLabel.setFont(new Font("Dialog", 1, 18));
        this.titleLabel.setText("Viewer Preferences");
        this.jPanel2.add(this.titleLabel);
        this.getContentPane().add((Component)this.jPanel2, "North");
        this.jPanel3.setLayout(new GridBagLayout());
        this.titleLbl.setText("Title:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 15);
        this.jPanel3.add((Component)this.titleLbl, gridBagConstraints);
        this.titleTxt.setColumns(40);
        this.titleTxt.setText("jTextField1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.jPanel3.add((Component)this.titleTxt, gridBagConstraints);
        this.rowsLbl.setText("Nb Rows");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 15);
        this.jPanel3.add((Component)this.rowsLbl, gridBagConstraints);
        this.rowsTxt.setColumns(8);
        this.rowsTxt.setText("jTextField1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel3.add((Component)this.rowsTxt, gridBagConstraints);
        this.columnsLbl.setText("Nb Columns:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(15, 0, 0, 15);
        this.jPanel3.add((Component)this.columnsLbl, gridBagConstraints);
        this.columnsTxt.setColumns(8);
        this.columnsTxt.setText("jTextField1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(15, 0, 0, 0);
        this.jPanel3.add((Component)this.columnsTxt, gridBagConstraints);
        this.getContentPane().add((Component)this.jPanel3, "Center");
        this.pack();
    }

    int getNbCol() {
        return this.nbColumns;
    }

    int getNbRows() {
        return this.nbRows;
    }

    String getProjectTitle() {
        return this.titleTxt.getText();
    }

    private boolean checkResult() {
        String s = this.rowsTxt.getText();
        try {
            this.nbRows = Integer.parseInt(s);
            if (this.nbRows <= 0 || this.nbRows >= 30) {
                throw new Exception("Value out of bound ! \n  0 > Nb Rows > 30");
            }
        }
        catch (Exception e) {
            ErrorPane.showErrorMessage((Component)this, (String)"Getting Nb Rows", (Exception)e);
            return false;
        }
        s = this.columnsTxt.getText();
        try {
            this.nbColumns = Integer.parseInt(s);
            if (this.nbColumns <= 0 || this.nbColumns >= 10) {
                throw new Exception("Value out of bound ! \n  0 > Nb Columns > 10");
            }
        }
        catch (Exception e) {
            ErrorPane.showErrorMessage((Component)this, (String)"Getting Nb Columns", (Exception)e);
            return false;
        }
        return true;
    }

    private void okBtnActionPerformed(ActionEvent evt) {
        if (this.checkResult()) {
            this.retVal = 0;
            this.doClose();
        }
    }

    private void cancelBtnActionPerformed(ActionEvent evt) {
        this.retVal = 2;
        this.doClose();
    }

    private void closeDialog(WindowEvent evt) {
        this.retVal = 2;
        this.doClose();
    }

    private void doClose() {
        this.setVisible(false);
        this.dispose();
    }

    public int showDialog() {
        this.setVisible(true);
        return this.retVal;
    }

    public static void main(String[] args) {
        new TablePreference(new JFrame()).setVisible(true);
    }
}

