/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoDs.Except;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

class HostInfo {
    private static String name = null;
    private static String address = null;
    private static Vector<String> addresses = new Vector();

    private HostInfo() throws DevFailed {
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            block2: while (enumeration.hasMoreElements() && name == null) {
                NetworkInterface networkInterface = enumeration.nextElement();
                Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
                while (enumeration2.hasMoreElements()) {
                    InetAddress inetAddress = enumeration2.nextElement();
                    if (inetAddress.getCanonicalHostName().startsWith("local") || inetAddress.getCanonicalHostName().equalsIgnoreCase(inetAddress.getHostAddress())) continue;
                    addresses.add(inetAddress.getHostAddress());
                    if (!this.isIPV4adress(inetAddress.getHostAddress())) continue;
                    name = inetAddress.getCanonicalHostName();
                    address = inetAddress.getHostAddress();
                    continue block2;
                }
            }
        }
        catch (SocketException socketException) {
            Except.throw_exception("TangoApi_SockectException", socketException.toString(), "HostInfo.HostInfo()");
        }
    }

    private boolean isIPV4adress(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        Vector<String> vector = new Vector<String>();
        while (stringTokenizer.hasMoreTokens()) {
            vector.add(stringTokenizer.nextToken());
        }
        return vector.size() == 4;
    }

    static String getName() throws DevFailed {
        if (name == null) {
            new HostInfo();
        }
        return name;
    }

    static String getAddress() throws DevFailed {
        if (address == null) {
            new HostInfo();
        }
        return address;
    }

    static Vector<String> getAddresses() throws DevFailed {
        if (address == null) {
            new HostInfo();
        }
        return addresses;
    }

    private static String toStaticString() {
        String string = "";
        try {
            if (name == null) {
                new HostInfo();
            }
            string = string + "name:          " + name + "\n";
            string = string + "address:       " + address + "\n";
        }
        catch (DevFailed devFailed) {
            string = devFailed.errors[0].desc;
        }
        return string;
    }

    public static void main(String[] stringArray) {
        System.out.println(HostInfo.toStaticString());
    }
}

