/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.tools;

import admin.astor.tools.EventsTable;
import admin.astor.tools.Utils;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.AttributeInfoEx;
import fr.esrf.TangoApi.AttributeProxy;
import fr.esrf.TangoDs.TangoConst;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class PropertyDialog
extends JDialog
implements TangoConst {
    private JFrame parent;
    private String signame;
    static int ADD_OPTION = 0;
    static int UPDATE_OPTION = 1;
    static int CANCEL_OPTION = 2;
    private int mode;
    private AttributeProxy att = null;
    private AttributeInfoEx info;
    private String abs_change;
    private String rel_change;
    private String period;
    private JLabel absLbl;
    private JTextField absTxt;
    private JButton cancelBtn;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JLabel periodLbl;
    private JTextField periodTxt;
    private JLabel relLbl;
    private JTextField relTxt;
    private JButton resetAbsBtn;
    private JButton resetPerBtn;
    private JButton resetRelBtn;
    private JLabel titleLabel;
    private JButton updateBtn;

    public PropertyDialog(JFrame jFrame, String string, int n) {
        super((Frame)jFrame, true);
        this.parent = jFrame;
        this.signame = string;
        this.mode = n;
        this.initComponents();
        this.titleLabel.setText(EventsTable.strMode[n] + " Event for " + string);
        switch (n) {
            case 0: {
                this.periodLbl.setVisible(false);
                this.periodTxt.setVisible(false);
                this.resetPerBtn.setVisible(false);
                break;
            }
            case 1: {
                this.absLbl.setVisible(false);
                this.absTxt.setVisible(false);
                this.resetAbsBtn.setVisible(false);
                this.relLbl.setVisible(false);
                this.relTxt.setVisible(false);
                this.resetRelBtn.setVisible(false);
            }
        }
        this.pack();
        Point point = jFrame.getLocationOnScreen();
        point.x += 50;
        point.y += 50;
        this.setLocation(point);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.updateBtn = new JButton();
        this.cancelBtn = new JButton();
        this.jPanel2 = new JPanel();
        this.titleLabel = new JLabel();
        this.jPanel3 = new JPanel();
        this.absLbl = new JLabel();
        this.relLbl = new JLabel();
        this.periodLbl = new JLabel();
        this.absTxt = new JTextField();
        this.relTxt = new JTextField();
        this.periodTxt = new JTextField();
        this.resetAbsBtn = new JButton();
        this.resetRelBtn = new JButton();
        this.resetPerBtn = new JButton();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                PropertyDialog.this.closeDialog(windowEvent);
            }
        });
        this.updateBtn.setText("Update");
        this.updateBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PropertyDialog.this.updateBtnActionPerformed(actionEvent);
            }
        });
        this.jPanel1.add(this.updateBtn);
        this.cancelBtn.setText("Cancel");
        this.cancelBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PropertyDialog.this.cancelBtnActionPerformed(actionEvent);
            }
        });
        this.jPanel1.add(this.cancelBtn);
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.titleLabel.setFont(new Font("Dialog", 1, 18));
        this.titleLabel.setText("Dialog Title");
        this.jPanel2.add(this.titleLabel);
        this.getContentPane().add((Component)this.jPanel2, "North");
        this.jPanel3.setLayout(new GridBagLayout());
        this.absLbl.setText("abs_change");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.jPanel3.add((Component)this.absLbl, gridBagConstraints);
        this.relLbl.setText("rel_change");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.jPanel3.add((Component)this.relLbl, gridBagConstraints);
        this.periodLbl.setText("period");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.jPanel3.add((Component)this.periodLbl, gridBagConstraints);
        this.absTxt.setColumns(10);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.jPanel3.add((Component)this.absTxt, gridBagConstraints);
        this.relTxt.setColumns(10);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.jPanel3.add((Component)this.relTxt, gridBagConstraints);
        this.periodTxt.setColumns(10);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.jPanel3.add((Component)this.periodTxt, gridBagConstraints);
        this.resetAbsBtn.setText("Reset");
        this.resetAbsBtn.setMargin(new Insets(2, 2, 2, 2));
        this.resetAbsBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PropertyDialog.this.resetAbsBtnActionPerformed(actionEvent);
            }
        });
        this.jPanel3.add((Component)this.resetAbsBtn, new GridBagConstraints());
        this.resetRelBtn.setText("Reset");
        this.resetRelBtn.setMargin(new Insets(2, 2, 2, 2));
        this.resetRelBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PropertyDialog.this.resetRelBtnActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        this.jPanel3.add((Component)this.resetRelBtn, gridBagConstraints);
        this.resetPerBtn.setText("Reset");
        this.resetPerBtn.setMargin(new Insets(2, 2, 2, 2));
        this.resetPerBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PropertyDialog.this.resetPerBtnActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        this.jPanel3.add((Component)this.resetPerBtn, gridBagConstraints);
        this.getContentPane().add((Component)this.jPanel3, "Center");
        this.pack();
    }

    private void resetPerBtnActionPerformed(ActionEvent actionEvent) {
        this.periodTxt.setText("Not specified");
    }

    private void resetRelBtnActionPerformed(ActionEvent actionEvent) {
        this.relTxt.setText("Not specified");
    }

    private void resetAbsBtnActionPerformed(ActionEvent actionEvent) {
        this.absTxt.setText("Not specified");
    }

    private boolean checkValues() {
        try {
            String string = this.getAbs();
            if (!string.equals("Not specified") && !string.equals("NaN")) {
                Double.parseDouble(string);
            }
            if (!(string = this.getRel()).equals("Not specified") && !string.equals("NaN")) {
                Double.parseDouble(string);
            }
            if (!(string = this.getPeriod()).equals("Not specified") && !string.equals("NaN")) {
                Integer.parseInt(string);
            }
        }
        catch (Exception exception) {
            Utils.popupError(this, null, exception);
            return false;
        }
        return true;
    }

    private boolean writeValues() {
        try {
            boolean bl = false;
            if (!this.abs_change.equals(this.getAbs())) {
                bl = true;
                if (this.mode == 0) {
                    this.info.events.ch_event.abs_change = this.getAbs();
                } else if (this.mode == 2) {
                    this.info.events.arch_event.abs_change = this.getAbs();
                }
            }
            if (!this.rel_change.equals(this.getRel())) {
                bl = true;
                if (this.mode == 0) {
                    this.info.events.ch_event.rel_change = this.getRel();
                } else if (this.mode == 2) {
                    this.info.events.arch_event.rel_change = this.getRel();
                }
            }
            if (!this.period.equals(this.getPeriod())) {
                bl = true;
                if (this.mode == 1) {
                    this.info.events.per_event.period = this.getPeriod();
                } else if (this.mode == 2) {
                    this.info.events.arch_event.period = this.getPeriod();
                }
            }
            if (bl) {
                AttributeInfoEx[] attributeInfoExArray = new AttributeInfoEx[]{this.info};
                this.att.set_info(attributeInfoExArray);
            }
            return true;
        }
        catch (DevFailed devFailed) {
            Utils.popupError(this.parent, null, (Exception)((Object)devFailed));
            return false;
        }
    }

    private void updateBtnActionPerformed(ActionEvent actionEvent) {
        if (this.checkValues() && this.writeValues()) {
            this.doClose();
        }
    }

    private void cancelBtnActionPerformed(ActionEvent actionEvent) {
        this.doClose();
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.doClose();
    }

    private void doClose() {
        this.setVisible(false);
        this.dispose();
    }

    String getAbs() {
        String string = this.absTxt.getText().trim();
        if (string.equals("Not specified")) {
            return "NaN";
        }
        return string;
    }

    String getRel() {
        String string = this.relTxt.getText().trim();
        if (string.equals("Not specified")) {
            return "NaN";
        }
        return string;
    }

    String getPeriod() {
        String string = this.periodTxt.getText().trim();
        if (string.equals("Not specified")) {
            return "NaN";
        }
        return string;
    }

    private void displayProperty() throws DevFailed {
        if (this.att == null) {
            this.att = new AttributeProxy(this.signame);
        }
        this.info = this.att.get_info_ex();
        switch (this.mode) {
            case 0: {
                if (this.info.events != null && this.info.events.ch_event != null) {
                    this.abs_change = this.info.events.ch_event.abs_change;
                    this.rel_change = this.info.events.ch_event.rel_change;
                    this.period = "Not specified";
                    break;
                }
                this.abs_change = "Not specified";
                this.rel_change = "Not specified";
                this.period = "Not specified";
                break;
            }
            case 2: {
                if (this.info.events != null && this.info.events.arch_event != null) {
                    this.abs_change = this.info.events.arch_event.abs_change;
                    this.rel_change = this.info.events.arch_event.rel_change;
                    this.period = this.info.events.arch_event.period;
                    break;
                }
                this.abs_change = "Not specified";
                this.rel_change = "Not specified";
                this.period = "Not specified";
                break;
            }
            case 1: {
                if (this.info.events != null && this.info.events.per_event != null) {
                    this.abs_change = "Not specified";
                    this.rel_change = "Not specified";
                    this.period = this.info.events.per_event.period;
                    break;
                }
                this.abs_change = "Not specified";
                this.rel_change = "Not specified";
                this.period = "Not specified";
            }
        }
        this.absTxt.setText(this.abs_change);
        this.relTxt.setText(this.rel_change);
        this.periodTxt.setText(this.period);
    }

    public void showDialog() {
        try {
            this.displayProperty();
            this.setVisible(true);
        }
        catch (DevFailed devFailed) {
            Utils.popupError(this.parent, null, (Exception)((Object)devFailed));
        }
    }
}

