/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.tools;

import admin.astor.AstorTree;
import admin.astor.TangoServer;
import admin.astor.tools.Utils;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoDs.TangoConst;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.TransferHandler;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class PoolThreadsTree
extends JTree
implements TangoConst {
    static ImageIcon tango_icon;
    static ImageIcon class_icon;
    static ImageIcon cmd_icon;
    private DefaultTreeModel treeModel;
    private DefaultMutableTreeNode root;
    private JDialog parent;
    private PoolThreadsInfo pool_info;
    private TangoRenderer renderer;
    private TangoServer server;
    private static final Color background;
    private DefaultMutableTreeNode dragged_node = null;

    public PoolThreadsTree(JDialog jDialog, TangoServer tangoServer) throws DevFailed {
        this.parent = jDialog;
        this.server = tangoServer;
        this.setBackground(background);
        this.pool_info = new PoolThreadsInfo();
        this.buildTree();
        this.expandChildren(this.root);
        this.setSelectionPath(null);
        this.setDragEnabled(true);
        this.setTransferHandler(new TransferHandler("Text"));
    }

    private void buildTree() {
        this.root = new DefaultMutableTreeNode(this.server);
        this.createThreadsNodes();
        this.getSelectionModel().setSelectionMode(1);
        this.treeModel = new DefaultTreeModel(this.root);
        this.setModel(this.treeModel);
        ToolTipManager.sharedInstance().registerComponent(this);
        this.renderer = new TangoRenderer();
        this.setCellRenderer(this.renderer);
        this.addTreeExpansionListener(new TreeExpansionListener(){

            public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
            }

            public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                PoolThreadsTree.this.treeMousePressed(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                PoolThreadsTree.this.treeMouseReleased(mouseEvent);
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                PoolThreadsTree.this.treeMouseClicked(mouseEvent);
            }
        });
    }

    private void treeMouseClicked(MouseEvent mouseEvent) {
        TreePath treePath = this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (treePath == null) {
            return;
        }
        int n = mouseEvent.getModifiers();
        if (mouseEvent.getClickCount() == 2 && (n & 0x10) != 0 || (n & 4) != 0) {
            // empty if block
        }
    }

    private void createThreadsNodes() {
        for (int i = 0; i < this.pool_info.size(); ++i) {
            PollThread pollThread = this.pool_info.threadAt(i);
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(pollThread);
            this.root.add(defaultMutableTreeNode);
            for (String string : pollThread) {
                defaultMutableTreeNode.add(new DefaultMutableTreeNode(string));
            }
        }
    }

    private DefaultMutableTreeNode getSelectedNode() {
        return (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
    }

    private Object getSelectedObject() {
        DefaultMutableTreeNode defaultMutableTreeNode = this.getSelectedNode();
        if (defaultMutableTreeNode == null) {
            return null;
        }
        return defaultMutableTreeNode.getUserObject();
    }

    boolean selectedObjectIsThread() {
        return this.getSelectedObject() instanceof PollThread;
    }

    private void expandChildren(DefaultMutableTreeNode defaultMutableTreeNode) {
        boolean bl = false;
        for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
            if (defaultMutableTreeNode2.isLeaf()) {
                if (bl) continue;
                this.expandNode(defaultMutableTreeNode2);
                bl = true;
                continue;
            }
            this.expandChildren(defaultMutableTreeNode2);
        }
    }

    private void expandNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        Vector<DefaultMutableTreeNode> vector = new Vector<DefaultMutableTreeNode>();
        vector.add(defaultMutableTreeNode);
        while (defaultMutableTreeNode != this.root) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
            vector.insertElementAt(defaultMutableTreeNode, 0);
        }
        Object[] objectArray = new DefaultMutableTreeNode[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            objectArray[i] = (TreeNode)vector.get(i);
        }
        TreePath treePath = new TreePath(objectArray);
        this.setSelectionPath(treePath);
        this.scrollPathToVisible(treePath);
    }

    private DefaultMutableTreeNode getFutureSelectedNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2;
        DefaultMutableTreeNode defaultMutableTreeNode3 = defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
        for (int i = 0; i < defaultMutableTreeNode2.getChildCount(); ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode4 = (DefaultMutableTreeNode)defaultMutableTreeNode2.getChildAt(i);
            if (defaultMutableTreeNode4 != defaultMutableTreeNode) continue;
            if (i == defaultMutableTreeNode2.getChildCount() - 1) {
                if (i <= 0) continue;
                defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode2.getChildAt(i - 1);
                continue;
            }
            defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode2.getChildAt(i + 1);
        }
        return defaultMutableTreeNode3;
    }

    void removeThread() {
        Object object;
        DefaultMutableTreeNode defaultMutableTreeNode = this.getSelectedNode();
        if (defaultMutableTreeNode != null && (object = defaultMutableTreeNode.getUserObject()) instanceof PollThread) {
            if (defaultMutableTreeNode.getChildCount() == 0) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = this.getFutureSelectedNode(defaultMutableTreeNode);
                this.treeModel.removeNodeFromParent(defaultMutableTreeNode);
                PollThread pollThread = (PollThread)object;
                this.pool_info.remove(pollThread);
                Object[] objectArray = defaultMutableTreeNode2.getPath();
                TreePath treePath = new TreePath(objectArray);
                this.setSelectionPath(treePath);
                this.scrollPathToVisible(treePath);
            } else {
                Utils.popupError(this.parent, "Cannot remove a not empty thread !");
            }
        }
    }

    DefaultMutableTreeNode addThreadNode() {
        PollThread pollThread = new PollThread(this.getNextThreadNum());
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(pollThread);
        this.treeModel.insertNodeInto(defaultMutableTreeNode, this.root, this.root.getChildCount());
        return defaultMutableTreeNode;
    }

    private int getNextThreadNum() {
        int n = 0;
        for (int i = 0; i < this.root.getChildCount(); ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.root.getChildAt(i);
            n = ((PollThread)defaultMutableTreeNode.getUserObject()).num;
        }
        return ++n;
    }

    void putPoolThreadInfo() {
        int n = this.root.getChildCount();
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < this.root.getChildCount(); ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.root.getChildAt(i);
            int n2 = defaultMutableTreeNode.getChildCount();
            if (n2 <= 0) continue;
            String string = "";
            for (int j = 0; j < n2; ++j) {
                string = string + defaultMutableTreeNode.getChildAt(j).toString();
                if (j >= n2 - 1) continue;
                string = string + ",";
            }
            vector.add(string);
        }
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            stringArray[i] = (String)vector.get(i);
        }
        try {
            DbDatum[] dbDatumArray = new DbDatum[]{new DbDatum("polling_threads_pool_size", n), new DbDatum("polling_threads_pool_conf", stringArray)};
            this.server.put_property(dbDatumArray);
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)this.parent, null, (DevFailed)devFailed);
        }
    }

    private TreePath getUpperPath(int n, int n2) {
        TreePath treePath = null;
        while (treePath == null && n2 > 10) {
            treePath = this.getPathForLocation(n, n2);
            n2 -= 10;
        }
        return treePath;
    }

    private void treeMouseReleased(MouseEvent mouseEvent) {
        int n = mouseEvent.getModifiers();
        if ((n & 0x10) != 0) {
            Serializable serializable;
            if (this.dragged_node == null) {
                return;
            }
            TreePath treePath = this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (treePath == null && (treePath = this.getUpperPath(mouseEvent.getX(), mouseEvent.getY())) == null) {
                return;
            }
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getPathComponent(treePath.getPathCount() - 1);
            Object object = defaultMutableTreeNode.getUserObject();
            int n2 = 0;
            if (object instanceof String) {
                serializable = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
                n2 = serializable.getIndex(defaultMutableTreeNode);
                defaultMutableTreeNode = serializable;
            }
            this.moveLeaf(defaultMutableTreeNode, this.dragged_node, n2);
            this.dragged_node = null;
            serializable = new Cursor(0);
            this.parent.setCursor((Cursor)serializable);
        }
    }

    private void treeMousePressed(MouseEvent mouseEvent) {
        int n = mouseEvent.getModifiers();
        if ((n & 0x10) != 0) {
            TreePath treePath = this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (treePath == null) {
                return;
            }
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getPathComponent(treePath.getPathCount() - 1);
            Object object = defaultMutableTreeNode.getUserObject();
            if (object instanceof String) {
                TransferHandler transferHandler = this.getTransferHandler();
                transferHandler.exportAsDrag(this, mouseEvent, 1);
                this.dragged_node = defaultMutableTreeNode;
                this.parent.setCursor(this.renderer.getNodeCursor(defaultMutableTreeNode));
            }
        }
    }

    private void moveLeaf(DefaultMutableTreeNode defaultMutableTreeNode, DefaultMutableTreeNode defaultMutableTreeNode2, int n) {
        Object object = defaultMutableTreeNode.getUserObject();
        if (object instanceof PollThread) {
            this.treeModel.removeNodeFromParent(defaultMutableTreeNode2);
            if (n < 0) {
                this.treeModel.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
            } else {
                this.treeModel.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, n);
            }
            this.expandNode(defaultMutableTreeNode2);
        }
    }

    static {
        background = AstorTree.background;
    }

    private class TangoRenderer
    extends DefaultTreeCellRenderer {
        private Font[] fonts;
        private final int TITLE = 0;
        private final int THREAD = 1;
        private final int DEVICE = 2;
        private Cursor dd_cursor;

        public TangoRenderer() {
            Utils utils = Utils.getInstance();
            tango_icon = utils.getIcon("network5.gif");
            class_icon = utils.getIcon("class.gif");
            cmd_icon = utils.getIcon("attleaf.gif");
            this.dd_cursor = this.getNodeCursor("drg-drp.gif");
            this.fonts = new Font[3];
            this.fonts[0] = new Font("Dialog", 1, 18);
            this.fonts[1] = new Font("Dialog", 1, 12);
            this.fonts[2] = new Font("Dialog", 0, 12);
        }

        Cursor getNodeCursor(DefaultMutableTreeNode defaultMutableTreeNode) {
            Object object = defaultMutableTreeNode.getUserObject();
            if (object instanceof String) {
                return this.dd_cursor;
            }
            return new Cursor(0);
        }

        Cursor getNodeCursor(String string) {
            URL uRL = this.getClass().getResource("/admin/astor/images/" + string);
            Image image = Toolkit.getDefaultToolkit().getImage(uRL);
            return Toolkit.getDefaultToolkit().createCustomCursor(image, new Point(0, 0), string);
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            this.setBackgroundNonSelectionColor(background);
            this.setForeground(Color.black);
            this.setBackgroundSelectionColor(Color.lightGray);
            if (n == 0) {
                this.setFont(this.fonts[0]);
                this.setIcon(tango_icon);
            } else {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
                if (defaultMutableTreeNode.getUserObject() instanceof PollThread) {
                    this.setFont(this.fonts[1]);
                    this.setIcon(class_icon);
                } else {
                    this.setFont(this.fonts[2]);
                    this.setIcon(cmd_icon);
                }
            }
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PoolThreadsInfo
    extends Vector<PollThread> {
        int size = 1;

        private PoolThreadsInfo() throws DevFailed {
            DbDatum[] dbDatumArray = new DbDatum[]{new DbDatum("polling_threads_pool_size"), new DbDatum("polling_threads_pool_conf")};
            DbDatum[] dbDatumArray2 = PoolThreadsTree.this.server.get_property(dbDatumArray);
            String[] stringArray = new String[]{};
            if (dbDatumArray2[0].is_empty() && dbDatumArray2[1].is_empty()) {
                String[] stringArray2 = PoolThreadsTree.this.server.queryDeviceFromDb();
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < stringArray2.length; ++i) {
                    stringBuffer.append(stringArray2[i]);
                    if (i >= stringArray2.length - 1) continue;
                    stringBuffer.append(',');
                }
                stringArray = new String[]{stringBuffer.toString()};
            }
            if (!dbDatumArray2[0].is_empty()) {
                this.size = dbDatumArray2[0].extractLong();
            }
            if (!dbDatumArray2[1].is_empty()) {
                stringArray = dbDatumArray2[1].extractStringArray();
            }
            this.buidConfig(stringArray);
        }

        private void buidConfig(String[] stringArray) {
            int n;
            for (n = 0; n < stringArray.length; ++n) {
                StringTokenizer stringTokenizer = new StringTokenizer(stringArray[n], ",");
                PollThread pollThread = new PollThread(n);
                while (stringTokenizer.hasMoreTokens()) {
                    pollThread.add(stringTokenizer.nextToken());
                }
                this.add(pollThread);
            }
            for (n = stringArray.length; n < this.size; ++n) {
                this.add(new PollThread(n));
            }
        }

        private PollThread threadAt(int n) {
            return (PollThread)this.get(n);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PollThread
    extends Vector<String> {
        String name;
        int num;

        private PollThread(int n) {
            this.num = n;
            this.name = "Thread " + (n + 1);
        }

        @Override
        public String toString() {
            return this.name;
        }
    }
}

