/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.tools;

import admin.astor.AstorUtil;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevState;
import fr.esrf.TangoDs.Except;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PingHosts {
    private Vector<DevState> states = new Vector();
    private String[] hosts;

    public PingHosts(String[] stringArray) throws DevFailed {
        this.hosts = stringArray;
        Vector<PingThread> vector = new Vector<PingThread>();
        for (String string : stringArray) {
            vector.add(new PingThread(string));
        }
        for (PingThread pingThread : vector) {
            pingThread.start();
        }
        try {
            if (AstorUtil.osIsUnix()) {
                Thread.sleep(2000L);
            } else {
                Thread.sleep(5000L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        for (PingThread pingThread : vector) {
            if (pingThread.hostAlive()) {
                this.states.add(DevState.ON);
            } else {
                this.states.add(DevState.FAULT);
            }
            pingThread.interrupt();
        }
    }

    public Vector<DevState> getStates() throws DevFailed {
        return this.states;
    }

    public Vector<String> getRunning() throws DevFailed {
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < this.hosts.length && i < this.states.size(); ++i) {
            if (this.states.get(i) != DevState.ON) continue;
            vector.add(this.hosts[i]);
        }
        return vector;
    }

    public Vector<String> getStopped() throws DevFailed {
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < this.hosts.length && i < this.states.size(); ++i) {
            if (this.states.get(i) != DevState.FAULT) continue;
            vector.add(this.hosts[i]);
        }
        return vector;
    }

    public static void main(String[] stringArray) {
        try {
            String[] stringArray2 = AstorUtil.getInstance().getHostControlledList();
            int n = 0;
            int n2 = 0;
            long l = System.currentTimeMillis();
            PingHosts pingHosts = new PingHosts(stringArray2);
            Vector<DevState> vector = pingHosts.getStates();
            for (int i = 0; i < stringArray2.length && i < vector.size(); ++i) {
                if (vector.get(i) == DevState.FAULT) {
                    ++n2;
                } else {
                    ++n;
                }
                System.out.println(stringArray2[i] + ":\t" + (vector.get(i) == DevState.FAULT ? "NOT " : "") + " alive");
            }
            long l2 = System.currentTimeMillis();
            System.out.println("elapsed time: " + (l2 - l) + " ms");
            System.out.println(n + " hosts alive   and  " + n2 + " hosts dead");
        }
        catch (DevFailed devFailed) {
            Except.print_exception((Exception)((Object)devFailed));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        System.exit(0);
    }

    private class PingThread
    extends Thread {
        private String hostName;
        private boolean alive = false;

        private PingThread(String string) {
            this.hostName = string;
        }

        private boolean hostAlive() {
            return this.alive;
        }

        public void run() {
            try {
                String string = this.executeShellCmdOneLine("ping " + this.hostName);
                this.alive = AstorUtil.osIsUnix() ? string.toLowerCase().indexOf("unreachable") < 0 : string.toLowerCase().indexOf("unreachable") < 0 && string.length() > 0 && string.indexOf("timed out") < 0;
            }
            catch (DevFailed devFailed) {
                Except.print_exception((Exception)((Object)devFailed));
            }
        }

        public String executeShellCmdOneLine(String string) throws DevFailed {
            StringBuffer stringBuffer = new StringBuffer();
            try {
                String string2;
                Process process = Runtime.getRuntime().exec(string);
                InputStream inputStream = process.getInputStream();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                int n = 0;
                while (n < 2 && (string2 = bufferedReader.readLine()) != null) {
                    if ((string2 = string2.trim()).length() <= 0) continue;
                    stringBuffer.append(string2.trim()).append("\n");
                    ++n;
                }
                process.destroy();
            }
            catch (Exception exception) {
                Except.throw_exception((String)exception.toString(), (String)("The shell command\n" + string + "\nHas failed"), (String)"Utils.executeShellCmd()");
            }
            return stringBuffer.toString();
        }
    }
}

