/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.access;

import admin.astor.access.AccessProxy;
import admin.astor.access.UsersTree;
import admin.astor.tools.Utils;
import fr.esrf.Tango.DevFailed;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class EditDialog
extends JDialog {
    private int retVal = 0;
    static final int CHECK_ACCESS = 0;
    static final int EDIT_USER = 1;
    private int mode = 1;
    private static String[] titles;
    private static final String[] check_titles;
    private static final String[] edit_titles;
    static final int USER = 0;
    static final int ADDRESS = 1;
    static final int DEVICE = 2;
    private AccessProxy access_dev;
    private JTextField[] textFields;
    private JLabel check_result;
    private JLabel[] labels;
    private JButton cancelBtn;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JButton okBtn;
    private JLabel titleLabel;

    public EditDialog(JFrame jFrame, String string, String string2) {
        super((Frame)jFrame, true);
        this.mode = 1;
        titles = edit_titles;
        this.initComponents();
        this.initOwnComponents(titles);
        this.labels[2].setVisible(false);
        this.textFields[2].setVisible(false);
        this.textFields[0].setText(string);
        this.textFields[0].setText(string);
        this.textFields[1].setText(string2);
        this.titleLabel.setText("");
        this.pack();
        Point point = jFrame.getLocationOnScreen();
        point.x += (jFrame.getWidth() - this.getWidth()) / 2;
        point.y += (jFrame.getHeight() - this.getHeight()) / 2;
        if (point.y <= 0) {
            point.y = 20;
        }
        if (point.x <= 0) {
            point.x = 20;
        }
        this.setLocation(point);
    }

    public EditDialog(JFrame jFrame, AccessProxy accessProxy) {
        super((Frame)jFrame, true);
        this.mode = 0;
        titles = check_titles;
        this.access_dev = accessProxy;
        this.initComponents();
        this.initOwnComponents(titles);
        this.titleLabel.setText("");
        this.pack();
        Point point = jFrame.getLocationOnScreen();
        point.x += (jFrame.getWidth() - this.getWidth()) / 2;
        point.y += (jFrame.getHeight() - this.getHeight()) / 2;
        if (point.y <= 0) {
            point.y = 20;
        }
        if (point.x <= 0) {
            point.x = 20;
        }
        this.setLocation(point);
    }

    private void initOwnComponents(String[] stringArray) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.textFields = new JTextField[stringArray.length];
        this.labels = new JLabel[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            this.labels[i] = new JLabel(stringArray[i] + ":  ");
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = i;
            gridBagConstraints.fill = 2;
            this.jPanel3.add((Component)this.labels[i], gridBagConstraints);
            this.textFields[i] = new JTextField();
            this.textFields[i].setColumns(20);
            this.textFields[i].addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent keyEvent) {
                    EditDialog.this.textKeyPressed(keyEvent);
                }
            });
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = i;
            gridBagConstraints.fill = 2;
            this.jPanel3.add((Component)this.textFields[i], gridBagConstraints);
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.okBtn = new JButton();
        this.cancelBtn = new JButton();
        this.jPanel2 = new JPanel();
        this.titleLabel = new JLabel();
        this.jPanel3 = new JPanel();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                EditDialog.this.closeDialog(windowEvent);
            }
        });
        this.okBtn.setText("OK");
        this.okBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EditDialog.this.okBtnActionPerformed(actionEvent);
            }
        });
        this.jPanel1.add(this.okBtn);
        this.cancelBtn.setText("Cancel");
        this.cancelBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EditDialog.this.cancelBtnActionPerformed(actionEvent);
            }
        });
        this.jPanel1.add(this.cancelBtn);
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.titleLabel.setFont(new Font("Dialog", 1, 18));
        this.titleLabel.setText("Dialog Title");
        this.jPanel2.add(this.titleLabel);
        this.getContentPane().add((Component)this.jPanel2, "North");
        this.jPanel3.setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.jPanel3, "Center");
        this.pack();
    }

    private boolean checkInputs() {
        StringTokenizer stringTokenizer;
        Serializable serializable;
        String string = this.textFields[0].getText().trim().toLowerCase();
        String string2 = this.textFields[1].getText().trim();
        String string3 = this.textFields[2].getText().trim().toLowerCase();
        if (string.length() == 0 || string2.length() == 0 || this.mode == 0 && string3.length() == 0) {
            Utils.popupError(this, "Please fill all fields !");
            return false;
        }
        this.textFields[0].setText(string);
        this.textFields[2].setText(string3);
        this.textFields[1].setText(string2);
        try {
            serializable = InetAddress.getByName(string2);
            string2 = ((InetAddress)serializable).getHostAddress();
            this.textFields[1].setText(string2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        serializable = new Vector();
        if (this.mode == 0) {
            stringTokenizer = new StringTokenizer(string3, "/");
            while (stringTokenizer.hasMoreTokens()) {
                ((Vector)serializable).add(stringTokenizer.nextToken());
            }
            if (((Vector)serializable).size() > 3) {
                Utils.popupError(this, "Incorrect device name  (too many members)");
                return false;
            }
            if (((Vector)serializable).size() < 3) {
                Utils.popupError(this, "Incorrect device name  (not enough members)");
                return false;
            }
        }
        stringTokenizer = new StringTokenizer(string2, ".");
        ((Vector)serializable).clear();
        while (stringTokenizer.hasMoreTokens()) {
            ((Vector)serializable).add(stringTokenizer.nextToken());
        }
        if (((Vector)serializable).size() > 4) {
            Utils.popupError(this, "Incorrect IP address  (Too many members)");
            return false;
        }
        if (((Vector)serializable).size() < 4) {
            Utils.popupError(this, "Incorrect IP address  (not enougth members)");
            return false;
        }
        string2 = (String)((Vector)serializable).get(0) + "." + (String)((Vector)serializable).get(1) + "." + (String)((Vector)serializable).get(2) + "." + (String)((Vector)serializable).get(3);
        this.textFields[1].setText(string2);
        for (int i = 0; i < ((Vector)serializable).size(); ++i) {
            try {
                Short.parseShort((String)((Vector)serializable).get(i));
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                if (((String)((Vector)serializable).get(i)).equals("*")) continue;
                Utils.popupError(this, "Incorrect IP address  (member #" + (i + 1) + " (" + (String)((Vector)serializable).get(i) + ") is not a number)");
                return false;
            }
        }
        return true;
    }

    private void checkAccess() {
        try {
            String string = this.access_dev.getAccess(this.getInputs());
            this.check_result.setText(string);
            if (string.equals("read")) {
                this.check_result.setIcon(UsersTree.read_icon);
            } else {
                this.check_result.setIcon(UsersTree.write_icon);
            }
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)this, (String)"Cannot check TANGO Access", (DevFailed)devFailed);
        }
    }

    private void textKeyPressed(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        switch (c) {
            case '\u001b': {
                this.retVal = 2;
                this.doClose();
                break;
            }
            case '\n': {
                switch (this.mode) {
                    case 1: {
                        if (!this.checkInputs()) break;
                        this.retVal = 0;
                        this.doClose();
                        break;
                    }
                    case 0: {
                        if (!this.checkInputs()) break;
                        this.checkAccess();
                    }
                }
                break;
            }
            default: {
                if (this.mode != 0) break;
                this.check_result.setText("...");
                this.check_result.setIcon(null);
            }
        }
    }

    private void okBtnActionPerformed(ActionEvent actionEvent) {
        if (this.checkInputs()) {
            this.retVal = 0;
            if (this.mode == 1) {
                this.doClose();
            } else {
                this.checkAccess();
            }
        }
    }

    private void cancelBtnActionPerformed(ActionEvent actionEvent) {
        this.retVal = 2;
        this.doClose();
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.retVal = 2;
        this.doClose();
    }

    private void doClose() {
        this.setVisible(false);
        this.dispose();
    }

    public String[] getInputs() {
        String[] stringArray = new String[this.textFields.length];
        for (int i = 0; i < this.textFields.length; ++i) {
            stringArray[i] = this.textFields[i].getText().trim();
        }
        return stringArray;
    }

    public int showDialog() {
        if (this.mode == 0) {
            try {
                this.textFields[0].setText(System.getProperty("user.name").toLowerCase());
                this.textFields[1].setText(InetAddress.getLocalHost().getHostAddress());
                this.okBtn.setText("Check");
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                this.check_result = new JLabel("...");
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = titles.length;
                gridBagConstraints.fill = 2;
                this.jPanel3.add((Component)this.check_result, gridBagConstraints);
                this.pack();
            }
            catch (UnknownHostException unknownHostException) {
                Utils.popupError(this, null, unknownHostException);
            }
        }
        this.setVisible(true);
        return this.retVal;
    }

    static {
        check_titles = new String[]{"User Name", "IP Address", "Device"};
        edit_titles = new String[]{"User Name", "Allowed Address", "Device"};
    }
}

