/*
 * Decompiled with CFR 0.152.
 */
package admin.astor;

import admin.astor.Astor;
import admin.astor.AstorDefs;
import admin.astor.Monitor;
import admin.astor.tools.Utils;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DbDevice;
import fr.esrf.TangoApi.DbServInfo;
import fr.esrf.TangoApi.DbServer;
import fr.esrf.TangoApi.DeviceInfo;
import fr.esrf.TangoApi.IORdump;
import fr.esrf.TangoDs.Except;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class DeviceTree
extends JTree
implements AstorDefs {
    private CtrlSystem cs;
    private Astor appli;
    private JTextArea infoLabel;
    private final String[] collections = new String[]{"Controlled Servers", "Not Controlled servers", "Devices"};
    private final int CTRL_SERVERS = 0;
    private final int N_CTRL_SERVERS = 1;
    private final int DEVICES = 2;
    private Monitor monitor;
    boolean canceled = false;
    private DefaultMutableTreeNode[] collnodes;

    public DeviceTree(Astor astor, Monitor monitor, JTextArea jTextArea, String string) {
        this.appli = astor;
        this.monitor = monitor;
        this.infoLabel = jTextArea;
        this.cs = new CtrlSystem(astor.tree.hosts.length);
        this.initComponent(string);
    }

    private void initComponent(String string) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(string);
        this.createNodes(defaultMutableTreeNode);
        this.getSelectionModel().setSelectionMode(1);
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(defaultMutableTreeNode);
        this.setModel(defaultTreeModel);
        ToolTipManager.sharedInstance().registerComponent(this);
        this.setCellRenderer(new TangoRenderer());
        this.addTreeExpansionListener(new TreeExpansionListener(){

            public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
                DeviceTree.this.collapsedPerfomed(treeExpansionEvent);
            }

            public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                DeviceTree.this.treeMouseClicked(mouseEvent);
            }
        });
    }

    private void createNodes(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.collnodes = new DefaultMutableTreeNode[this.collections.length];
        for (int i = 0; i < this.collections.length; ++i) {
            this.collnodes[i] = new DefaultMutableTreeNode(this.collections[i]);
            defaultMutableTreeNode.add(this.collnodes[i]);
        }
        try {
            String string;
            Object object;
            int n;
            String[] stringArray;
            String[] stringArray2;
            double d;
            DefaultMutableTreeNode[] defaultMutableTreeNodeArray = new DefaultMutableTreeNode[2];
            String[] stringArray3 = ApiUtil.get_db_obj().get_server_name_list();
            for (int i = 0; i < stringArray3.length; ++i) {
                d = (double)i / (double)stringArray3.length / 2.0;
                defaultMutableTreeNodeArray[0] = new DefaultMutableTreeNode(stringArray3[i]);
                defaultMutableTreeNodeArray[1] = new DefaultMutableTreeNode(stringArray3[i]);
                stringArray = stringArray2 = ApiUtil.get_db_obj().get_instance_name_list(stringArray3[i]);
                int n2 = stringArray.length;
                for (n = 0; n < n2; ++n) {
                    object = stringArray[n];
                    string = stringArray3[i] + "/" + (String)object;
                    this.canceled = this.monitor.isCanceled();
                    if (this.canceled) {
                        return;
                    }
                    this.monitor.setProgressValue(d, "Building for Server " + string);
                    String[] stringArray4 = new DbServer(string).get_info();
                    if (stringArray4.controlled) {
                        ++this.cs.nb_instances;
                        DbServer dbServer = new DbServer(string);
                        String[] stringArray5 = dbServer.get_class_list();
                        this.cs.nb_classes += stringArray5.length;
                        for (String string2 : stringArray5) {
                            String[] stringArray6 = dbServer.get_device_name(string2);
                            this.cs.nb_devices += stringArray6.length;
                        }
                        defaultMutableTreeNodeArray[0].add(new DefaultMutableTreeNode(object));
                        continue;
                    }
                    ++this.cs.not_c_instances;
                    defaultMutableTreeNodeArray[1].add(new DefaultMutableTreeNode(object));
                }
                if (defaultMutableTreeNodeArray[0].getChildCount() > 0) {
                    ++this.cs.nb_servers;
                    this.collnodes[0].add(defaultMutableTreeNodeArray[0]);
                }
                if (defaultMutableTreeNodeArray[1].getChildCount() > 0) {
                    this.collnodes[1].add(defaultMutableTreeNodeArray[1]);
                }
                Thread.sleep(10L);
            }
            Database database = ApiUtil.get_db_obj();
            String[] stringArray7 = database.get_device_domain("*");
            for (n = 0; n < stringArray7.length; ++n) {
                d = (double)n / (double)stringArray7.length / 2.0 + 0.5;
                object = new DefaultMutableTreeNode(stringArray7[n]);
                this.collnodes[2].add((MutableTreeNode)object);
                string = stringArray7[n] + "/*";
                for (String string3 : stringArray2 = database.get_device_family(string)) {
                    this.canceled = this.monitor.isCanceled();
                    if (this.canceled) {
                        return;
                    }
                    this.monitor.setProgressValue(d, "Building for Device family " + stringArray7[n] + "/" + string3);
                    DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(string3);
                    ((DefaultMutableTreeNode)object).add(defaultMutableTreeNode2);
                    string = stringArray7[n] + "/" + string3 + "/*";
                    for (String string4 : stringArray = database.get_device_member(string)) {
                        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(string4);
                        defaultMutableTreeNode2.add(defaultMutableTreeNode3);
                    }
                }
                Thread.sleep(10L);
            }
        }
        catch (DevFailed devFailed) {
            Utils.popupError(this.appli, null, (Exception)((Object)devFailed));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void treeMouseClicked(MouseEvent mouseEvent) {
        if (this.getRowForLocation(mouseEvent.getX(), mouseEvent.getY()) < 1) {
            return;
        }
        TreePath treePath = this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        int n = mouseEvent.getModifiers();
        if ((n & 0x10) != 0) {
            String string;
            String string2;
            switch (treePath.getPathCount()) {
                case 5: {
                    string2 = this.getDeviceName(treePath);
                    if (string2 != null) break;
                    return;
                }
                case 4: {
                    string = this.getServerName(treePath);
                    if (string == null) {
                        return;
                    }
                    string2 = "dserver/" + string;
                    break;
                }
                default: {
                    return;
                }
            }
            try {
                string = ApiUtil.get_db_obj().get_device_info(string2);
                this.infoLabel.setText(string.toString());
            }
            catch (DevFailed devFailed) {
                this.infoLabel.setText(" ");
            }
            if (mouseEvent.getClickCount() == 2) {
                this.showHostInfoDialogForDevice(string2, mouseEvent);
            }
        }
    }

    public void collapsedPerfomed(TreeExpansionEvent treeExpansionEvent) {
        TreePath treePath = treeExpansionEvent.getPath();
        if (treePath.getPathCount() > 2) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getPathComponent(treePath.getPathCount() - 1);
        if (treePath.getPathCount() == 1) {
            this.setExpandedState(new TreePath(defaultMutableTreeNode.getPath()), true);
            Utils.popupMessage(this.appli, this.cs.toString(), "/admin/astor/images/tango_icon.jpg");
        }
    }

    String[][] getNotCtrlServers() {
        DefaultMutableTreeNode defaultMutableTreeNode = this.collnodes[1];
        int n = defaultMutableTreeNode.getChildCount();
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < n; ++i) {
            defaultMutableTreeNode = defaultMutableTreeNode.getNextNode();
            String string = defaultMutableTreeNode.toString();
            int n2 = defaultMutableTreeNode.getChildCount();
            try {
                for (int j = 0; j < n2; ++j) {
                    defaultMutableTreeNode = defaultMutableTreeNode.getNextNode();
                    String string2 = string + "/" + defaultMutableTreeNode;
                    DbServInfo dbServInfo = new DbServer(string2).get_info();
                    if (dbServInfo.controlled || string.equals("Starter")) continue;
                    vector.add(string2);
                }
                continue;
            }
            catch (DevFailed devFailed) {
                vector.add(devFailed.errors[0].desc);
            }
        }
        String[][] stringArray = new String[vector.size()][];
        for (int i = 0; i < vector.size(); ++i) {
            String string = (String)vector.elementAt(i);
            stringArray[i] = new String[2];
            stringArray[i][0] = string;
            try {
                DeviceInfo deviceInfo = new DbDevice("dserver/" + string).get_info();
                stringArray[i][1] = deviceInfo.last_exported;
                continue;
            }
            catch (DevFailed devFailed) {
                stringArray[i][1] = devFailed.errors[0].desc;
            }
        }
        return stringArray;
    }

    private void showHostInfoDialogForDevice(String string, MouseEvent mouseEvent) {
        try {
            String string2 = new IORdump(string).get_host();
            if (string2 == null) {
                Except.throw_exception((String)"UNKNOWN_HOST", (String)"May be this device has never been exported !", (String)"");
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string2);
            string2 = stringTokenizer.nextToken();
            stringTokenizer = new StringTokenizer(string2, ".");
            string2 = stringTokenizer.nextToken();
            this.appli.tree.setSelectionPath(string2);
            this.appli.tree.displayHostInfo();
        }
        catch (DevFailed devFailed) {
            Utils.popupError(this, null, (Exception)((Object)devFailed));
        }
    }

    private String getDeviceName(TreePath treePath) {
        String string = treePath.getPathComponent(1).toString();
        if (!string.equals(this.collections[2])) {
            return null;
        }
        return treePath.getPathComponent(2).toString() + "/" + treePath.getPathComponent(3).toString() + "/" + treePath.getPathComponent(4).toString();
    }

    private String getServerName(TreePath treePath) {
        String string = treePath.getPathComponent(1).toString();
        if (string.equals(this.collections[0]) && string.equals(this.collections[1])) {
            return null;
        }
        return treePath.getPathComponent(2).toString() + "/" + treePath.getPathComponent(3).toString();
    }

    String csInfo() {
        return this.cs.toString();
    }

    private class TangoRenderer
    extends DefaultTreeCellRenderer {
        private ImageIcon tangoIcon = new ImageIcon(this.getClass().getResource("/admin/astor/images/network5.gif"));
        private ImageIcon serv_icon = new ImageIcon(this.getClass().getResource("/admin/astor/images/server.gif"));
        private ImageIcon dev_icon = new ImageIcon(this.getClass().getResource("/admin/astor/images/device.gif"));
        private Font[] fonts = new Font[2];
        private final int TITLE = 0;
        private final int LEAF = 1;

        public TangoRenderer() {
            this.fonts[0] = new Font("helvetica", 1, 18);
            this.fonts[1] = new Font("helvetica", 0, 12);
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            this.setBackgroundNonSelectionColor(Color.white);
            if (n == 0) {
                this.setBackgroundSelectionColor(Color.white);
                this.setIcon(this.tangoIcon);
                this.setFont(this.fonts[0]);
                this.setToolTipText("Double click to popup info");
            } else {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
                Object object2 = defaultMutableTreeNode.getUserObject();
                switch (defaultMutableTreeNode.getLevel()) {
                    case 1: {
                        this.setBackgroundSelectionColor(Color.white);
                        this.setToolTipText("Tango " + object2.toString());
                        this.setFont(this.fonts[0]);
                        break;
                    }
                    default: {
                        this.setBackgroundSelectionColor(Color.lightGray);
                        if (bl3) {
                            TreeNode[] treeNodeArray = defaultMutableTreeNode.getPath();
                            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)treeNodeArray[1];
                            String string = defaultMutableTreeNode2.getUserObject().toString();
                            if (string.equals(DeviceTree.this.collections[2])) {
                                this.setIcon(this.dev_icon);
                            } else {
                                this.setIcon(this.serv_icon);
                            }
                            this.setToolTipText("Double click to popup host window.");
                        }
                        this.setFont(this.fonts[1]);
                    }
                }
            }
            return this;
        }
    }

    class CtrlSystem {
        int nb_hosts = 0;
        int nb_servers = 0;
        int nb_instances = 0;
        int nb_classes = 0;
        int nb_devices = 0;
        int not_c_instances = 0;

        public CtrlSystem(int n) {
            this.nb_hosts = n;
        }

        public String toString() {
            String string = "";
            string = string + this.nb_hosts + "  Hosts controlled.\n";
            string = string + this.nb_servers + "  Different controlled servers.\n";
            string = string + this.nb_instances + "  Controlled servers/instances.\n";
            string = string + this.nb_classes + "  Controlled classes.\n";
            string = string + this.nb_devices + "  Controlled devices.\n\n";
            string = string + this.not_c_instances + "  NOT controlled servers/instances.";
            return string;
        }
    }
}

