/*
 * Decompiled with CFR 0.152.
 */
package admin.astor;

import admin.astor.Astor;
import admin.astor.AstorUtil;
import admin.astor.Monitor;
import admin.astor.ServersTree;
import admin.astor.TangoHost;
import admin.astor.tools.Utils;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DbServInfo;
import fr.esrf.TangoApi.DbServer;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoDs.Except;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collections;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class CtrlServersDialog
extends JDialog {
    private static final String separator = "___________________________________________________";
    private Astor parent;
    private TangoHost[] hosts;
    private JTextArea dbInfoArea;
    private JTextArea servInfoArea;
    private JPanel buttonPanel;
    private JPanel middlePanel;
    private JButton cancelButton;
    private JScrollPane jScrollPane1;

    public CtrlServersDialog(Astor astor, TangoHost[] tangoHostArray) {
        super((Frame)astor, false);
        this.parent = astor;
        this.hosts = tangoHostArray;
        this.initComponents();
        this.pack();
        new DisplayThread().start();
    }

    private void initComponents() {
        this.buttonPanel = new JPanel();
        this.middlePanel = new JPanel();
        this.cancelButton = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                CtrlServersDialog.this.closeDialog(windowEvent);
            }
        });
        this.buttonPanel.setLayout(new FlowLayout(2, 5, 5));
        this.cancelButton.setText("Dismiss");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CtrlServersDialog.this.cancelButtonActionPerformed(actionEvent);
            }
        });
        this.middlePanel.setLayout(new BorderLayout());
        this.servInfoArea = new JTextArea("Servers Info");
        this.servInfoArea.setBackground(Color.lightGray);
        this.servInfoArea.setEditable(false);
        this.servInfoArea.setFont(new Font("Dialog", 1, 14));
        this.getContentPane().add((Component)this.servInfoArea, "North");
        this.getContentPane().add((Component)this.jScrollPane1, "Center");
        this.dbInfoArea = new JTextArea("DB info.");
        this.dbInfoArea.setBackground(Color.lightGray);
        this.dbInfoArea.setEditable(false);
        this.dbInfoArea.setFont(new Font("Dialog", 1, 10));
        this.middlePanel.add((Component)this.dbInfoArea, "North");
        this.cancelButton.setBackground(Color.lightGray);
        this.buttonPanel.add(this.cancelButton);
        this.buttonPanel.setBackground(Color.lightGray);
        this.middlePanel.add((Component)this.buttonPanel, "South");
        this.getContentPane().add((Component)this.middlePanel, "South");
    }

    private void cancelButtonActionPerformed(ActionEvent actionEvent) {
        this.doClose();
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.doClose();
    }

    void doClose() {
        this.setVisible(false);
        this.dispose();
    }

    public void show(String string, Vector vector, Vector vector2) {
        ServersTree serversTree = new ServersTree(this.parent, "Controlled Servers", vector, vector2);
        this.jScrollPane1.setViewportView(serversTree);
        this.servInfoArea.setText(string);
        this.pack();
        AstorUtil.rightShiftDialog((JDialog)this, this.parent);
        this.setVisible(true);
    }

    class DisplayThread
    extends Thread {
        private Monitor monitor = null;

        private void updateProgressMonitor(String string, int n) {
            if (this.monitor == null) {
                this.monitor = new Monitor(CtrlServersDialog.this.parent, "Browsing TANGO database", "Reading host");
            }
            double d = (double)(n + 1) / (double)CtrlServersDialog.this.hosts.length;
            this.monitor.setProgressValue(d, "Query servers for " + string);
        }

        public DbServInfo[] getControledServers(String string) throws DevFailed {
            Database database = ApiUtil.get_db_obj();
            DeviceData deviceData = new DeviceData();
            deviceData.insert(string);
            DeviceData deviceData2 = database.command_inout("DbGetHostServerList", deviceData);
            String[] stringArray = deviceData2.extractStringArray();
            Vector<DbServInfo> vector = new Vector<DbServInfo>();
            for (String string2 : stringArray) {
                DbServInfo dbServInfo = database.get_server_info(string2);
                if (!dbServInfo.controlled) continue;
                vector.add(dbServInfo);
            }
            String[] stringArray2 = new DbServInfo[vector.size()];
            for (int i = 0; i < vector.size(); ++i) {
                stringArray2[i] = (DbServInfo)vector.elementAt(i);
            }
            return stringArray2;
        }

        private synchronized void wait_next_loop(long l) {
            try {
                this.wait(l);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public void run() {
            int n = 0;
            int n2 = 0;
            StringBuffer stringBuffer = new StringBuffer();
            Vector<String[]> vector = new Vector<String[]>();
            Vector<DbServInfo[]> vector2 = new Vector<DbServInfo[]>();
            try {
                int[] nArray = new int[]{4, 5, 6, 7, 9, 10};
                DeviceData deviceData = ApiUtil.get_db_obj().command_inout("DbInfo");
                String[] stringArray = deviceData.extractStringArray();
                String string = "Database Information:\n\n";
                for (int i = 0; i < nArray.length; ++i) {
                    string = string + stringArray[nArray[i]];
                    if (i >= nArray.length - 1) continue;
                    string = string + "\n";
                }
                CtrlServersDialog.this.dbInfoArea.setText(string);
            }
            catch (DevFailed devFailed) {
                Utils.popupError(CtrlServersDialog.this.parent, null, (Exception)((Object)devFailed));
            }
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            for (int i = 0; i < CtrlServersDialog.this.hosts.length; ++i) {
                int n6;
                Object object;
                this.updateProgressMonitor(CtrlServersDialog.this.hosts[i].getName(), i);
                if (((CtrlServersDialog)CtrlServersDialog.this).hosts[i].use_events) {
                    ++n3;
                }
                DbServInfo[] dbServInfoArray = new DbServInfo[]{};
                try {
                    for (DbServInfo dbServInfo : dbServInfoArray = this.getControledServers(CtrlServersDialog.this.hosts[i].getName())) {
                        DbServer dbServer = new DbServer(dbServInfo.name);
                        object = dbServer.get_class_list();
                        n4 += ((String[])object).length;
                        String[] stringArray = object;
                        n6 = stringArray.length;
                        for (int j = 0; j < n6; ++j) {
                            String string = stringArray[j];
                            String[] stringArray2 = dbServer.get_device_name(string);
                            n5 += stringArray2.length;
                        }
                    }
                }
                catch (DevFailed devFailed) {
                    Except.print_exception((Exception)((Object)devFailed));
                }
                stringBuffer.append(CtrlServersDialog.this.hosts[i].getName()).append(" (").append(dbServInfoArray.length).append(" server");
                if (dbServInfoArray.length > 1) {
                    stringBuffer.append("s");
                }
                stringBuffer.append("):\n");
                vector2.add(dbServInfoArray);
                for (DbServInfo dbServInfo : dbServInfoArray) {
                    ++n2;
                    stringBuffer.append("\t").append(dbServInfo.name).append("\tStartup level: ").append(dbServInfo.startup_level).append("\n");
                    int n7 = dbServInfo.name.indexOf("/");
                    if (n7 < 0) break;
                    object = dbServInfo.name.substring(0, n7);
                    boolean bl = false;
                    for (n6 = 0; n6 < vector.size() && !bl; ++n6) {
                        String string = (String)vector.elementAt(n6);
                        bl = string.equals(object);
                    }
                    if (bl) continue;
                    ++n;
                    vector.add((String[])object);
                }
                stringBuffer.append("___________________________________________________\n\n");
                this.wait_next_loop(50L);
            }
            this.monitor.setProgressValue(100.0);
            Collections.sort(vector, AstorUtil.getInstance().compare);
            String string = CtrlServersDialog.this.hosts.length + " hosts in control system";
            if (n3 > 0) {
                string = string + " (" + n3 + " controlled on events)";
            }
            string = string + "\n" + n + " different servers \n" + n2 + " controlled instances\n" + n4 + " classes  -  " + n5 + " devices.";
            CtrlServersDialog.this.show(string, vector, vector2);
        }
    }
}

