/*
 * Decompiled with CFR 0.152.
 */
package admin.astor;

import admin.astor.AstorDefs;
import admin.astor.TangoHost;
import admin.astor.tools.MySqlUtil;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.AsynReplyNotArrived;
import fr.esrf.TangoApi.CommunicationFailed;
import fr.esrf.TangoApi.ConnectionFailed;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DbClass;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoApi.DbDevImportInfo;
import fr.esrf.TangoApi.EventSystemFailed;
import fr.esrf.TangoApi.NonDbDevice;
import fr.esrf.TangoApi.NonSupportedFeature;
import fr.esrf.TangoApi.WrongData;
import fr.esrf.TangoApi.WrongNameSyntax;
import fr.esrf.TangoApi.events.DbEventImportInfo;
import fr.esrf.TangoDs.Except;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import fr.esrf.tangoatk.widget.util.JSmoothProgressBar;
import fr.esrf.tangoatk.widget.util.Splash;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.Comparator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import jive.ExecDev;

public class AstorUtil
implements AstorDefs {
    private static DbClass _class = null;
    private static AstorUtil instance = null;
    private static short readInfoPeriod = (short)5;
    private static short nbStartupLevels = (short)5;
    private static String rloginCmd = null;
    private static String rloginUser = null;
    private static String[] tools = null;
    private static String[] known_tango_hosts = null;
    private static Dimension preferred_size = new Dimension(400, 600);
    private static Dimension host_dlg_preferred_size = new Dimension(800, 500);
    private static String[] last_collec = null;
    private static boolean jiveReadOnly = false;
    private static boolean starterStartup = true;
    private static String serverHelpURL = "http://www.esrf.fr/computing/cs/tango/";
    private static String appliHelpURL = "http://www.esrf.fr/computing/cs/tango/";
    private static boolean properties_read = false;
    private static boolean debug = false;
    private static boolean no_ctrl_btn = false;
    private static String[] helps;
    MyCompare compare = new MyCompare();
    private static final String starterStartupPropName = "StartServersAtStartup";
    private static final String[] astor_propnames;
    public static ImageIcon[] state_icons;
    private static boolean _osIsUnix;
    private static boolean _osIsUnixTested;
    private static Splash splash;
    private static int splash_progress;
    private static ImageIcon tango_icon;
    private static RGB rgb;

    private AstorUtil() {
    }

    public static AstorUtil getInstance() {
        if (instance == null) {
            instance = new AstorUtil();
        }
        return instance;
    }

    public void initIcons() {
        AstorUtil.state_icons[0] = new ImageIcon(this.getClass().getResource("/admin/astor/images/greyball.gif"));
        AstorUtil.state_icons[1] = new ImageIcon(this.getClass().getResource("/admin/astor/images/redball.gif"));
        AstorUtil.state_icons[2] = new ImageIcon(this.getClass().getResource("/admin/astor/images/orangebal.gif"));
        AstorUtil.state_icons[3] = new ImageIcon(this.getClass().getResource("/admin/astor/images/greenbal.gif"));
        AstorUtil.state_icons[4] = new ImageIcon(this.getClass().getResource("/admin/astor/images/blueball.gif"));
        AstorUtil.state_icons[5] = new ImageIcon(this.getClass().getResource("/admin/astor/images/failed.gif"));
    }

    static String[] string2array(String string) {
        return AstorUtil.string2array(string, null);
    }

    static String[] string2array(String string, String string2) {
        StringTokenizer stringTokenizer = string2 == null ? new StringTokenizer(string) : new StringTokenizer(string, string2);
        Vector<String> vector = new Vector<String>();
        while (stringTokenizer.hasMoreTokens()) {
            vector.add(stringTokenizer.nextToken());
        }
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            stringArray[i] = (String)vector.get(i);
        }
        return stringArray;
    }

    static boolean getCtrlBtn() {
        if (!no_ctrl_btn) {
            AstorUtil.readAstorProperties();
        }
        return !no_ctrl_btn;
    }

    static boolean getDebug() {
        if (!properties_read) {
            AstorUtil.readAstorProperties();
        }
        return debug;
    }

    public static String getRloginCmd() {
        if (!properties_read) {
            AstorUtil.readAstorProperties();
        }
        return rloginCmd;
    }

    public static void setRloginCmd(String string) {
        rloginCmd = string;
    }

    public static String getRloginUser() {
        if (!properties_read) {
            AstorUtil.readAstorProperties();
        }
        return rloginUser;
    }

    public static void setRloginUser(String string) {
        rloginUser = string;
    }

    public static void setTools(String[] stringArray) {
        tools = stringArray;
    }

    public static String[] getTools() {
        if (!properties_read) {
            AstorUtil.readAstorProperties();
        }
        return tools;
    }

    public static void setHtmlHelps(String[] stringArray) {
        helps = stringArray;
    }

    public static String[] getHtmlHelps() {
        if (!properties_read) {
            AstorUtil.readAstorProperties();
        }
        return helps;
    }

    public static String[] getKnownTangoHosts() {
        if (!properties_read) {
            AstorUtil.readAstorProperties();
        }
        return known_tango_hosts;
    }

    public static Dimension getPreferredSize() {
        if (!properties_read) {
            AstorUtil.readAstorProperties();
        }
        return preferred_size;
    }

    public static void setPreferredSize(Dimension dimension) {
        preferred_size = dimension;
    }

    public static Dimension getHostDialogPreferredSize() {
        if (!properties_read) {
            AstorUtil.readAstorProperties();
        }
        return host_dlg_preferred_size;
    }

    public static void setHostDialogPreferredSize(Dimension dimension) {
        host_dlg_preferred_size = dimension;
    }

    public static void setKnownTangoHosts(String[] stringArray) {
        known_tango_hosts = stringArray;
    }

    public static void readAstorProperties() {
        try {
            DbDatum dbDatum;
            int n;
            int n2;
            DbClass dbClass;
            Database database = ApiUtil.get_db_obj();
            DbDatum[] dbDatumArray = database.get_property("Astor", astor_propnames);
            int n3 = -1;
            if (!dbDatumArray[++n3].is_empty()) {
                debug = dbDatumArray[n3].extractBoolean();
            }
            if (!dbDatumArray[++n3].is_empty()) {
                last_collec = dbDatumArray[n3].extractStringArray();
            }
            if (!dbDatumArray[++n3].is_empty()) {
                rloginCmd = dbDatumArray[n3].extractString();
            }
            if (!dbDatumArray[++n3].is_empty()) {
                rloginUser = dbDatumArray[n3].extractString();
            }
            if (!dbDatumArray[++n3].is_empty()) {
                no_ctrl_btn = dbDatumArray[n3].extractBoolean();
            }
            if (!dbDatumArray[++n3].is_empty()) {
                jiveReadOnly = dbDatumArray[n3].extractBoolean();
            }
            if (!dbDatumArray[++n3].is_empty()) {
                known_tango_hosts = dbDatumArray[n3].extractStringArray();
            }
            if (!dbDatumArray[++n3].is_empty()) {
                dbClass = dbDatumArray[n3].extractStringArray();
                try {
                    n2 = Integer.parseInt(dbClass[0]);
                    n = Integer.parseInt(dbClass[1]);
                    preferred_size = new Dimension(n2, n);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (!dbDatumArray[++n3].is_empty()) {
                dbClass = dbDatumArray[n3].extractStringArray();
                try {
                    n2 = Integer.parseInt(dbClass[0]);
                    n = Integer.parseInt(dbClass[1]);
                    host_dlg_preferred_size = new Dimension(n2, n);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (!dbDatumArray[++n3].is_empty()) {
                tools = dbDatumArray[n3].extractStringArray();
            }
            if (!dbDatumArray[++n3].is_empty()) {
                helps = dbDatumArray[n3].extractStringArray();
            }
            if (!(dbDatum = (dbClass = new DbClass("Starter")).get_property(starterStartupPropName)).is_empty()) {
                starterStartup = dbDatum.extractBoolean();
            }
            properties_read = true;
        }
        catch (DevFailed devFailed) {
            // empty catch block
        }
    }

    static void putAstorProperties() throws DevFailed {
        Database database = ApiUtil.get_db_obj();
        DbDatum[] dbDatumArray = new DbDatum[astor_propnames.length];
        int n = 0;
        dbDatumArray[n] = new DbDatum(astor_propnames[n]);
        dbDatumArray[n++].insert(debug);
        dbDatumArray[n] = new DbDatum(astor_propnames[n]);
        dbDatumArray[n++].insert(last_collec);
        dbDatumArray[n] = new DbDatum(astor_propnames[n]);
        dbDatumArray[n++].insert(rloginCmd);
        dbDatumArray[n] = new DbDatum(astor_propnames[n]);
        dbDatumArray[n++].insert(rloginUser);
        dbDatumArray[n] = new DbDatum(astor_propnames[n]);
        dbDatumArray[n++].insert(no_ctrl_btn);
        dbDatumArray[n] = new DbDatum(astor_propnames[n]);
        dbDatumArray[n++].insert(jiveReadOnly);
        dbDatumArray[n] = new DbDatum(astor_propnames[n]);
        dbDatumArray[n++].insert(known_tango_hosts);
        dbDatumArray[n] = new DbDatum(astor_propnames[n]);
        String[] stringArray = new String[]{Integer.toString(AstorUtil.preferred_size.width), Integer.toString(AstorUtil.preferred_size.height)};
        dbDatumArray[n++].insert(stringArray);
        dbDatumArray[n] = new DbDatum(astor_propnames[n]);
        String[] stringArray2 = new String[]{Integer.toString(AstorUtil.host_dlg_preferred_size.width), Integer.toString(AstorUtil.host_dlg_preferred_size.height)};
        dbDatumArray[n++].insert(stringArray2);
        dbDatumArray[n] = new DbDatum(astor_propnames[n]);
        dbDatumArray[n++].insert(tools);
        dbDatumArray[n] = new DbDatum(astor_propnames[n]);
        dbDatumArray[n].insert(helps);
        database.put_property("Astor", dbDatumArray);
        DbDatum dbDatum = new DbDatum(starterStartupPropName);
        dbDatum.insert(starterStartup);
        DbClass dbClass = new DbClass("Starter");
        dbClass.put_property(new DbDatum[]{dbDatum});
    }

    void setJiveReadOnly(boolean bl) {
        jiveReadOnly = bl;
    }

    void setStarterStartup(boolean bl) {
        starterStartup = bl;
    }

    boolean jiveIsReadOnly() {
        if (!properties_read) {
            AstorUtil.readAstorProperties();
        }
        return jiveReadOnly;
    }

    boolean getStarterStartup() {
        if (!properties_read) {
            AstorUtil.readAstorProperties();
        }
        return starterStartup;
    }

    void setLastCollectionList(String[] stringArray) {
        last_collec = stringArray;
    }

    String[] getLastCollectionList() {
        if (!properties_read) {
            AstorUtil.readAstorProperties();
        }
        return last_collec;
    }

    String[] getCollectionList(TangoHost[] tangoHostArray) {
        int n;
        int n2;
        Vector<String> vector = new Vector<String>();
        TangoHost[] objectArray = tangoHostArray;
        int objectArray2 = objectArray.length;
        for (n2 = 0; n2 < objectArray2; ++n2) {
            TangoHost i = objectArray[n2];
            if (i.collection == null) {
                i.collection = "Miscellaneous";
            }
            boolean bl = false;
            for (n = 0; n < vector.size() && !bl; ++n) {
                bl = i.collection.equals(vector.elementAt(n));
            }
            if (bl) continue;
            vector.add(i.collection);
        }
        Collections.sort(vector, this.compare);
        vector.add(0, "Tango Database");
        String[] stringArray = this.getLastCollectionList();
        if (stringArray != null) {
            String[] stringArray2 = stringArray;
            n2 = stringArray2.length;
            for (int i = 0; i < n2; ++i) {
                String string = stringArray2[i];
                n = 0;
                for (int j = 0; n == 0 && j < vector.size(); ++j) {
                    boolean bl = string.equals(vector.get(j));
                    n = bl ? 1 : 0;
                    if (!bl) continue;
                    String string2 = (String)vector.get(j);
                    vector.remove(j);
                    vector.add(string2);
                }
            }
        }
        String[] stringArray3 = new String[vector.size()];
        for (n2 = 0; n2 < vector.size(); ++n2) {
            stringArray3[n2] = (String)vector.elementAt(n2);
        }
        return stringArray3;
    }

    public TangoHost[] getTangoHostList() throws DevFailed {
        TangoHost[] tangoHostArray;
        String[] stringArray = this.getHostControlledList();
        boolean bl = ApiUtil.get_db_obj().get_idl_version() >= 4;
        DbDevImportInfo[] dbDevImportInfoArray = null;
        DbDevImportInfo[] dbDevImportInfoArray2 = null;
        DbEventImportInfo[] dbEventImportInfoArray = null;
        if (bl) {
            tangoHostArray = MySqlUtil.getInstance();
            dbDevImportInfoArray = tangoHostArray.getHostDevImportInfo("tango/admin/%");
            dbDevImportInfoArray2 = tangoHostArray.getHostDevImportInfo("dserver/starter/%");
            dbEventImportInfoArray = tangoHostArray.getMultipleEventImportInfo("dserver/starter/%");
        }
        tangoHostArray = new TangoHost[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            if (bl) {
                DbDevImportInfo dbDevImportInfo = this.getAdmDevImportInfo(dbDevImportInfoArray[i], dbDevImportInfoArray2);
                if (!dbDevImportInfoArray[i].exported || dbDevImportInfo == null) {
                    tangoHostArray[i] = new TangoHost(stringArray[i], !bl);
                    continue;
                }
                DbEventImportInfo dbEventImportInfo = this.getEventImportInfo(dbDevImportInfo.name, dbEventImportInfoArray);
                tangoHostArray[i] = new TangoHost(dbDevImportInfoArray[i], dbDevImportInfo, dbEventImportInfo);
                continue;
            }
            tangoHostArray[i] = new TangoHost(stringArray[i], !bl);
        }
        if (bl) {
            MySqlUtil.getInstance().manageTangoHostProperties(tangoHostArray);
        }
        return tangoHostArray;
    }

    private DbDevImportInfo getAdmDevImportInfo(DbDevImportInfo dbDevImportInfo, DbDevImportInfo[] dbDevImportInfoArray) {
        int n = dbDevImportInfo.name.indexOf(47);
        n = dbDevImportInfo.name.indexOf(47, n + 1);
        String string = dbDevImportInfo.name.substring(n);
        for (DbDevImportInfo dbDevImportInfo2 : dbDevImportInfoArray) {
            n = dbDevImportInfo2.name.indexOf(47);
            String string2 = dbDevImportInfo2.name.substring(n = dbDevImportInfo2.name.indexOf(47, n + 1));
            if (!string2.equals(string)) continue;
            return dbDevImportInfo2;
        }
        return null;
    }

    private DbEventImportInfo getEventImportInfo(String string, DbEventImportInfo[] dbEventImportInfoArray) {
        if (dbEventImportInfoArray != null) {
            for (DbEventImportInfo dbEventImportInfo : dbEventImportInfoArray) {
                if (!dbEventImportInfo.name.equals(string)) continue;
                return dbEventImportInfo;
            }
        }
        return null;
    }

    public String[] getHostControlledList() throws DevFailed {
        Database database = ApiUtil.get_db_obj();
        return database.get_device_member("tango/admin/*");
    }

    public static String getTangoHost() {
        String string;
        block3: {
            try {
                string = ApiUtil.getTangoHost();
            }
            catch (DevFailed devFailed) {
                return null;
            }
            catch (NoSuchMethodError noSuchMethodError) {
                string = System.getProperty("TANGO_HOST");
                if (string != null) break block3;
                string = System.getenv("TANGO_HOST");
            }
        }
        return string;
    }

    public static void setTangoHost(String string) {
        Properties properties = System.getProperties();
        properties.put("TANGO_HOST", string);
        System.setProperties(properties);
        _class = null;
    }

    public static short getStarterReadPeriod() {
        if (_class == null) {
            AstorUtil.getStarterClassProperties();
        }
        return readInfoPeriod;
    }

    public static short getStarterNbStartupLevels() {
        if (_class == null) {
            AstorUtil.getStarterClassProperties();
        }
        return nbStartupLevels;
    }

    public static String getStarterHelpURL() {
        if (_class == null) {
            AstorUtil.getStarterClassProperties();
        }
        return serverHelpURL;
    }

    public static String getAppliHelpURL() {
        if (_class == null) {
            AstorUtil.getStarterClassProperties();
        }
        return appliHelpURL;
    }

    private static void getStarterClassProperties() {
        try {
            _class = new DbClass("Starter");
            String[] stringArray = new String[]{"NbStartupLevels", "ReadInfoDbPeriod", "doc_url", "appli_doc_url"};
            DbDatum[] dbDatumArray = _class.get_property(stringArray);
            if (!dbDatumArray[0].is_empty()) {
                nbStartupLevels = dbDatumArray[0].extractShort();
            }
            if (!dbDatumArray[1].is_empty()) {
                readInfoPeriod = dbDatumArray[1].extractShort();
            }
            readInfoPeriod = (short)(readInfoPeriod * 1000);
            if (!dbDatumArray[2].is_empty()) {
                serverHelpURL = dbDatumArray[2].extractString();
            }
            if (!dbDatumArray[3].is_empty()) {
                appliHelpURL = dbDatumArray[3].extractString();
            }
        }
        catch (DevFailed devFailed) {
            Except.print_exception((Exception)((Object)devFailed));
        }
        if (AstorUtil.getDebug()) {
            System.out.println("NbStartupLevels:  " + nbStartupLevels);
            System.out.println("ReadInfoDbPeriod: " + readInfoPeriod);
            System.out.println("server doc_url:   " + serverHelpURL);
            System.out.println("appli_doc_url:    " + appliHelpURL);
        }
    }

    static String[] getServerClassProperties(String string) {
        String[] stringArray = new String[3];
        try {
            DbClass dbClass = new DbClass(string);
            String[] stringArray2 = new String[]{"ProjectTitle", "Description", "doc_url"};
            DbDatum[] dbDatumArray = dbClass.get_property(stringArray2);
            if (!dbDatumArray[0].is_empty()) {
                stringArray[0] = dbDatumArray[0].extractString();
            }
            if (!dbDatumArray[1].is_empty()) {
                String[] stringArray3 = dbDatumArray[1].extractStringArray();
                stringArray[1] = "";
                for (int i = 0; i < stringArray3.length; ++i) {
                    stringArray[1] = stringArray[1] + stringArray3[i];
                    if (i >= stringArray3.length - 1) continue;
                    stringArray[1] = stringArray[1] + "\n";
                }
            }
            stringArray[2] = dbDatumArray[2].is_empty() ? "Doc location unknown...." : dbDatumArray[2].extractString();
        }
        catch (DevFailed devFailed) {
            stringArray[2] = null;
            stringArray[1] = null;
            stringArray[0] = null;
        }
        return stringArray;
    }

    public static String strException(Exception exception) {
        String string = "";
        if (exception instanceof ConnectionFailed) {
            string = string + ((ConnectionFailed)exception).getStack();
        } else if (exception instanceof CommunicationFailed) {
            string = string + ((CommunicationFailed)exception).getStack();
        } else if (exception instanceof WrongNameSyntax) {
            string = string + ((WrongNameSyntax)exception).getStack();
        } else if (exception instanceof WrongData) {
            string = string + ((WrongData)exception).getStack();
        } else if (exception instanceof NonDbDevice) {
            string = string + ((NonDbDevice)exception).getStack();
        } else if (exception instanceof NonSupportedFeature) {
            string = string + ((NonSupportedFeature)exception).getStack();
        } else if (exception instanceof EventSystemFailed) {
            string = string + ((EventSystemFailed)exception).getStack();
        } else if (exception instanceof AsynReplyNotArrived) {
            string = string + ((AsynReplyNotArrived)exception).getStack();
        } else if (exception instanceof DevFailed) {
            DevFailed devFailed = (DevFailed)((Object)exception);
            string = string + "Tango exception  " + devFailed.toString() + "\n";
            for (int i = 0; i < devFailed.errors.length; ++i) {
                string = string + "Severity -> ";
                switch (devFailed.errors[i].severity.value()) {
                    case 0: {
                        string = string + "WARNING \n";
                        break;
                    }
                    case 1: {
                        string = string + "ERROR \n";
                        break;
                    }
                    case 2: {
                        string = string + "PANIC \n";
                        break;
                    }
                    default: {
                        string = string + "Unknown severity code";
                    }
                }
                string = string + "Desc   -> " + devFailed.errors[i].desc + "\n";
                string = string + "Reason -> " + devFailed.errors[i].reason + "\n";
                string = string + "Origin -> " + devFailed.errors[i].origin + "\n";
                if (i >= devFailed.errors.length - 1) continue;
                string = string + "-------------------------------------------------------------\n";
            }
        } else {
            string = exception.toString();
        }
        return string;
    }

    public static void centerDialog(JDialog jDialog, JFrame jFrame) {
        Point point = jFrame.getLocationOnScreen();
        point.x += (jFrame.getWidth() - jDialog.getWidth()) / 2;
        point.y += (jFrame.getHeight() - jDialog.getHeight()) / 2;
        if (point.y <= 0) {
            point.y = 20;
        }
        if (point.x <= 0) {
            point.x = 20;
        }
        jDialog.setLocation(point);
    }

    public static void centerDialog(JDialog jDialog, JDialog jDialog2) {
        Point point = jDialog2.getLocationOnScreen();
        point.x += (jDialog2.getWidth() - jDialog.getWidth()) / 2;
        point.y += (jDialog2.getHeight() - jDialog.getHeight()) / 2;
        if (point.y <= 0) {
            point.y = 20;
        }
        if (point.x <= 0) {
            point.x = 20;
        }
        jDialog.setLocation(point);
    }

    public static void rightShiftDialog(JDialog jDialog, JFrame jFrame) {
        Point point = jFrame.getLocationOnScreen();
        point.x += jFrame.getWidth();
        point.y += (jFrame.getHeight() - jDialog.getHeight()) / 2;
        if (point.y <= 0) {
            point.y = 20;
        }
        if (point.x <= 0) {
            point.x = 20;
        }
        jDialog.setLocation(point);
    }

    public static void rightShiftDialog(JDialog jDialog, JDialog jDialog2) {
        Point point = jDialog2.getLocationOnScreen();
        point.x += jDialog2.getWidth();
        point.y += (jDialog2.getHeight() - jDialog.getHeight()) / 2;
        if (point.y <= 0) {
            point.y = 20;
        }
        if (point.x <= 0) {
            point.x = 20;
        }
        jDialog.setLocation(point);
    }

    public static void cascadeDialog(JDialog jDialog, JFrame jFrame) {
        Point point = jFrame.getLocationOnScreen();
        point.x += 20;
        point.y += 20;
        jDialog.setLocation(point);
    }

    public static void cascadeDialog(JDialog jDialog, JDialog jDialog2) {
        Point point = jDialog2.getLocationOnScreen();
        point.x += 20;
        point.y += 20;
        jDialog.setLocation(point);
    }

    static String[] string2StringArray(String string) {
        int n;
        Vector<String> vector = new Vector<String>();
        while ((n = string.indexOf("\n")) > 0) {
            vector.add(string.substring(0, n));
            string = string.substring(n + 1);
        }
        vector.add(string);
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            stringArray[i] = (String)vector.elementAt(i);
        }
        return stringArray;
    }

    public static void executeShellCmdAndReturn(String string) throws IOException {
        Process process = Runtime.getRuntime().exec(string);
        InputStream inputStream = process.getInputStream();
        new BufferedReader(new InputStreamReader(inputStream));
    }

    public static String executeShellCmd(String string) throws IOException, InterruptedException, DevFailed {
        String string2;
        Process process = Runtime.getRuntime().exec(string);
        InputStream inputStream = process.getInputStream();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        String string3 = "";
        while ((string2 = bufferedReader.readLine()) != null) {
            string3 = string3 + string2 + "\n";
        }
        process.waitFor();
        int n = process.exitValue();
        if (n != 0) {
            InputStream inputStream2 = process.getErrorStream();
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream2));
            while ((string2 = bufferedReader.readLine()) != null) {
                System.out.println(string2);
                string3 = string3 + string2 + "\n";
            }
            Except.throw_exception((String)"SHELL_CMD_FAILED", (String)("the shell command\n" + string + "\nreturns : " + n + " !\n\n" + string3), (String)"AstorUtil.executeShellCmd()");
        }
        return string3;
    }

    public static boolean osIsUnix() {
        if (!_osIsUnixTested) {
            try {
                String string = System.getProperty("os.name");
                _osIsUnix = !string.toLowerCase().startsWith("windows");
                _osIsUnixTested = true;
            }
            catch (Exception exception) {
                _osIsUnix = false;
            }
        }
        return _osIsUnix;
    }

    public static void testDevice(Component component, String string) {
        JDialog jDialog = component instanceof JDialog ? new JDialog((Dialog)((JDialog)component), false) : new JDialog((Frame)((JFrame)component), false);
        jDialog.setTitle(string + " Device Panel");
        try {
            jDialog.setContentPane((Container)new ExecDev(string));
            ATKGraphicsUtils.centerDialog((Dialog)jDialog);
            jDialog.setVisible(true);
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)component, null, (DevFailed)devFailed);
        }
    }

    public static void showInHtmBrowser(String string) {
        String string2 = System.getProperty("BROWSER");
        if (string2 == null) {
            string2 = AstorUtil.osIsUnix() ? "firefox - turbo" : "explorer";
        }
        String string3 = string2 + " " + string;
        try {
            AstorUtil.executeShellCmdAndReturn(string3);
        }
        catch (Exception exception) {
            ErrorPane.showErrorMessage((Component)new JFrame(), null, (Exception)exception);
        }
    }

    public static String getAccessControlDeviceName() {
        String string;
        try {
            String[] stringArray = ApiUtil.get_db_obj().getServices("AccessControl", "*");
            string = stringArray.length > 0 ? stringArray[0] : null;
        }
        catch (DevFailed devFailed) {
            string = null;
        }
        return string;
    }

    public static void startSplash(String string) {
        JSmoothProgressBar jSmoothProgressBar = new JSmoothProgressBar();
        jSmoothProgressBar.setStringPainted(true);
        jSmoothProgressBar.setBackground(Color.lightGray);
        jSmoothProgressBar.setProgressBarColors(Color.yellow, Color.yellow, Color.yellow);
        if (tango_icon == null) {
            tango_icon = new ImageIcon(AstorUtil.getInstance().getClass().getResource("/admin/astor/images/tango.jpg"));
        }
        splash = new Splash(tango_icon, Color.yellow, jSmoothProgressBar);
        splash.setTitle(string);
        splash.setMessage("Starting....");
        splash_progress = 0;
        splash.setVisible(true);
        splash.repaint();
    }

    public static void stopSplash() {
        splash_progress = 100;
        splash.progress(splash_progress);
        splash.setVisible(false);
    }

    public static void increaseSplashProgress(int n, String string) {
        if ((splash_progress += n) > 99) {
            splash_progress = 99;
        }
        splash.progress(splash_progress);
        splash.setMessage(string);
    }

    public void initColors(int n) {
        if (rgb == null) {
            rgb = new RGB(n);
        } else {
            rgb.initColor(n);
        }
    }

    public Color getNewColor() {
        if (rgb == null) {
            rgb = new RGB();
        }
        return rgb.getNewColor();
    }

    public void sort(Vector[] vectorArray) {
        for (Vector vector : vectorArray) {
            Collections.sort(vector, this.compare);
        }
    }

    public void sort(Vector vector) {
        Collections.sort(vector, this.compare);
    }

    static {
        astor_propnames = new String[]{"Debug", "LastCollections", "RloginCmd", "RloginUser", "NoCtrlButton", "JiveReadOnly", "KnownTangoHosts", "PreferredSize", "HostDialogPreferredSize", "Tools", "HtmlHelps"};
        state_icons = new ImageIcon[6];
        _osIsUnix = true;
        _osIsUnixTested = false;
        tango_icon = null;
        rgb = null;
    }

    class MyCompare
    implements Comparator {
        MyCompare() {
        }

        public int compare(Object object, Object object2) {
            String string = object.toString().toLowerCase();
            String string2 = object2.toString().toLowerCase();
            if (string == null) {
                return 1;
            }
            if (string2 == null) {
                return -1;
            }
            return string.compareTo(string2);
        }
    }

    class RGB {
        int r = 0;
        int g = 0;
        int b = 0;
        int step = 10;
        private boolean red = true;
        private boolean green = false;
        private boolean blue = false;

        RGB() {
        }

        RGB(int n) {
            this.initColor(n);
        }

        void initColor(int n) {
            this.step = 1020 / n;
            if (this.step == 255) {
                this.step = 128;
            }
            this.red = true;
            this.green = false;
            this.blue = false;
            this.b = 0;
            this.g = 0;
            this.r = 0;
        }

        void increase() {
            if (this.red) {
                if (this.r + this.step < 255) {
                    this.r += this.step;
                } else {
                    this.r = 255;
                    this.red = false;
                    this.green = true;
                }
            } else if (this.green) {
                if (this.g + this.step < 255) {
                    if (this.r - this.step > 0) {
                        this.r -= this.step;
                    }
                    this.g += this.step;
                } else {
                    this.g = 255;
                    this.green = false;
                    this.blue = true;
                }
            } else if (this.blue) {
                if (this.b + this.step < 255) {
                    if (this.g - this.step > 0) {
                        this.g -= this.step;
                    }
                    this.b += this.step;
                } else {
                    this.b = 255;
                    this.r = 255;
                    this.blue = false;
                }
            } else if (this.r - this.step > 0) {
                this.r -= this.step;
                this.b -= this.step;
            }
        }

        Color getNewColor() {
            this.increase();
            return new Color(this.r, this.g, this.b);
        }
    }
}

