/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.attribute;

import fr.esrf.Tango.AttrQuality;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.DeviceDataHistory;
import fr.esrf.tangoatk.core.IAttributeSpectrumHistory;
import fr.esrf.tangoatk.core.INumberSpectrumHistory;
import fr.esrf.tangoatk.core.attribute.AAttribute;
import fr.esrf.tangoatk.core.attribute.ANumberSpectrumHelper;
import fr.esrf.tangoatk.core.attribute.NumberSpectrumHistory;

public class ULongSpectrumHelper
extends ANumberSpectrumHelper {
    public ULongSpectrumHelper(AAttribute aAttribute) {
        this.init(aAttribute);
    }

    void insert(double[] dArray) {
        double d = 1.0;
        long[] lArray = new long[dArray.length];
        d = this.attribute.getDisplayUnitFactor();
        DeviceAttribute deviceAttribute = this.attribute.getAttribute();
        for (int i = 0; i < lArray.length; ++i) {
            lArray[i] = (long)(dArray[i] / d);
        }
        deviceAttribute.insert_ul(lArray);
    }

    protected INumberSpectrumHistory[] getNumberSpectrumAttHistory(DeviceDataHistory[] deviceDataHistoryArray) {
        INumberSpectrumHistory[] iNumberSpectrumHistoryArray = new NumberSpectrumHistory[deviceDataHistoryArray.length];
        double d = 1.0;
        if (deviceDataHistoryArray.length <= 0) {
            return null;
        }
        d = this.attribute.getDisplayUnitFactor();
        if (d <= 0.0) {
            d = 1.0;
        }
        for (int i = 0; i < deviceDataHistoryArray.length; ++i) {
            NumberSpectrumHistory numberSpectrumHistory = new NumberSpectrumHistory();
            try {
                numberSpectrumHistory.setTimestamp(deviceDataHistoryArray[i].getTime());
            }
            catch (Exception exception) {
                numberSpectrumHistory.setTimestamp(0L);
            }
            try {
                AttrQuality attrQuality = deviceDataHistoryArray[i].getAttrQuality();
                if (0 == attrQuality.value()) {
                    numberSpectrumHistory.setState("VALID");
                } else if (1 == attrQuality.value()) {
                    numberSpectrumHistory.setState("INVALID");
                } else if (2 == attrQuality.value()) {
                    numberSpectrumHistory.setState("ALARM");
                } else if (4 == attrQuality.value()) {
                    numberSpectrumHistory.setState("WARNING");
                } else if (3 == attrQuality.value()) {
                    numberSpectrumHistory.setState("CHANGING");
                } else {
                    numberSpectrumHistory.setState("UNKNOWN");
                }
            }
            catch (Exception exception) {
                numberSpectrumHistory.setState("UNKNOWN");
            }
            try {
                int[] nArray = deviceDataHistoryArray[i].extractULongArray();
                double[] dArray = new double[nArray.length];
                for (int j = 0; j < nArray.length; ++j) {
                    dArray[j] = (double)nArray[j] * d;
                }
                numberSpectrumHistory.setValue(dArray);
            }
            catch (Exception exception) {
                numberSpectrumHistory.setValue(new double[0]);
            }
            iNumberSpectrumHistoryArray[i] = numberSpectrumHistory;
        }
        return iNumberSpectrumHistoryArray;
    }

    protected INumberSpectrumHistory[] getNumberSpectrumDeviceAttHistory(DeviceDataHistory[] deviceDataHistoryArray) {
        INumberSpectrumHistory[] iNumberSpectrumHistoryArray = new NumberSpectrumHistory[deviceDataHistoryArray.length];
        if (deviceDataHistoryArray.length <= 0) {
            return null;
        }
        for (int i = 0; i < deviceDataHistoryArray.length; ++i) {
            NumberSpectrumHistory numberSpectrumHistory = new NumberSpectrumHistory();
            try {
                numberSpectrumHistory.setTimestamp(deviceDataHistoryArray[i].getTime());
            }
            catch (Exception exception) {
                numberSpectrumHistory.setTimestamp(0L);
            }
            try {
                AttrQuality attrQuality = deviceDataHistoryArray[i].getAttrQuality();
                if (0 == attrQuality.value()) {
                    numberSpectrumHistory.setState("VALID");
                } else if (1 == attrQuality.value()) {
                    numberSpectrumHistory.setState("INVALID");
                } else if (2 == attrQuality.value()) {
                    numberSpectrumHistory.setState("ALARM");
                } else if (4 == attrQuality.value()) {
                    numberSpectrumHistory.setState("WARNING");
                } else if (3 == attrQuality.value()) {
                    numberSpectrumHistory.setState("CHANGING");
                } else {
                    numberSpectrumHistory.setState("UNKNOWN");
                }
            }
            catch (Exception exception) {
                numberSpectrumHistory.setState("UNKNOWN");
            }
            try {
                short[] sArray = deviceDataHistoryArray[i].extractUCharArray();
                double[] dArray = new double[sArray.length];
                for (int j = 0; j < sArray.length; ++j) {
                    dArray[j] = sArray[j];
                }
                numberSpectrumHistory.setValue(dArray);
            }
            catch (Exception exception) {
                numberSpectrumHistory.setValue(new double[0]);
            }
            iNumberSpectrumHistoryArray[i] = numberSpectrumHistory;
        }
        return iNumberSpectrumHistoryArray;
    }

    protected IAttributeSpectrumHistory[] getSpectrumDeviceAttHistory(DeviceDataHistory[] deviceDataHistoryArray) {
        return this.getNumberSpectrumDeviceAttHistory(deviceDataHistoryArray);
    }

    protected IAttributeSpectrumHistory[] getSpectrumAttHistory(DeviceDataHistory[] deviceDataHistoryArray) {
        return this.getNumberSpectrumAttHistory(deviceDataHistoryArray);
    }

    void setMinAlarm(double d) {
        this.setProperty("min_alarm", new Long((long)d));
    }

    void setMaxAlarm(double d) {
        this.setProperty("max_alarm", new Long((long)d));
    }

    void setMinValue(double d) {
        this.setProperty("min_value", new Long((long)d));
    }

    void setMaxValue(double d) {
        this.setProperty("max_value", new Long((long)d));
    }

    void setMinWarning(double d) {
        this.setProperty("min_warning", new Long((long)d));
    }

    void setMaxWarning(double d) {
        this.setProperty("max_warning", new Long((long)d));
    }

    void setDeltaT(double d) {
        this.setProperty("delta_t", new Long((long)d));
    }

    void setDeltaVal(double d) {
        this.setProperty("delta_val", new Long((long)d));
    }

    void setMinWarning(double d, boolean bl) {
        this.setProperty("min_warning", new Long((long)d), bl);
    }

    void setMaxWarning(double d, boolean bl) {
        this.setProperty("max_warning", new Long((long)d), bl);
    }

    void setDeltaT(double d, boolean bl) {
        this.setProperty("delta_t", new Long((long)d), bl);
    }

    void setDeltaVal(double d, boolean bl) {
        this.setProperty("delta_val", new Long((long)d), bl);
    }

    void setMinAlarm(double d, boolean bl) {
        this.setProperty("min_alarm", new Long((long)d), bl);
    }

    void setMaxAlarm(double d, boolean bl) {
        this.setProperty("max_alarm", new Long((long)d), bl);
    }

    void setMinValue(double d, boolean bl) {
        this.setProperty("min_value", new Long((long)d), bl);
    }

    void setMaxValue(double d, boolean bl) {
        this.setProperty("max_value", new Long((long)d), bl);
    }

    double[] getNumberSpectrumValue(DeviceAttribute deviceAttribute) throws DevFailed {
        long[] lArray = deviceAttribute.extractULongArray();
        int n = deviceAttribute.getNbRead();
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = lArray[i];
        }
        return dArray;
    }

    double[] getNumberSpectrumSetPoint(DeviceAttribute deviceAttribute) throws DevFailed {
        int n;
        long[] lArray = deviceAttribute.extractULongArray();
        int n2 = lArray.length - (n = deviceAttribute.getNbRead());
        if (n2 <= 0) {
            return this.getNumberSpectrumValue(deviceAttribute);
        }
        double[] dArray = new double[n2];
        int n3 = 0;
        for (int i = n; i < lArray.length; ++i) {
            dArray[n3] = lArray[i];
            ++n3;
        }
        return dArray;
    }

    double[] getNumberSpectrumDisplayValue(DeviceAttribute deviceAttribute) throws DevFailed {
        long[] lArray = deviceAttribute.extractULongArray();
        double d = this.attribute.getDisplayUnitFactor();
        int n = deviceAttribute.getNbRead();
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = (double)lArray[i] * d;
        }
        return dArray;
    }

    double[] getNumberSpectrumDisplaySetPoint(DeviceAttribute deviceAttribute) throws DevFailed {
        long[] lArray = deviceAttribute.extractULongArray();
        int n = deviceAttribute.getNbRead();
        int n2 = lArray.length - n;
        double d = this.attribute.getDisplayUnitFactor();
        if (n2 <= 0) {
            return this.getNumberSpectrumDisplayValue(deviceAttribute);
        }
        double[] dArray = new double[n2];
        int n3 = 0;
        for (int i = n; i < lArray.length; ++i) {
            dArray[n3] = (double)lArray[i] * d;
            ++n3;
        }
        return dArray;
    }

    public String getVersion() {
        return "$Id: ULongSpectrumHelper.java,v 1.7 2010/09/24 13:11:54 poncet Exp $";
    }
}

