/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.attribute;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.tangoatk.core.EventSupport;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.IBooleanScalar;
import fr.esrf.tangoatk.core.IBooleanScalarListener;
import fr.esrf.tangoatk.core.attribute.AAttribute;
import java.io.Serializable;

class BooleanScalarHelper
implements Serializable {
    AAttribute attribute;
    EventSupport propChanges;

    public BooleanScalarHelper(AAttribute aAttribute) {
        this.init(aAttribute);
    }

    void init(AAttribute aAttribute) {
        this.setAttribute(aAttribute);
        this.propChanges = aAttribute.getPropChanges();
    }

    public void setAttribute(AAttribute aAttribute) {
        this.attribute = aAttribute;
    }

    public IAttribute getAttribute() {
        return this.attribute;
    }

    protected void setProperty(String string, Number number) {
        this.attribute.setProperty(string, number);
        this.attribute.storeConfig();
    }

    protected void setProperty(String string, Number number, boolean bl) {
        this.attribute.setProperty(string, number, bl);
    }

    void fireValueChanged(boolean bl, long l) {
        this.propChanges.fireBooleanScalarEvent((IBooleanScalar)((Object)this.attribute), bl, l);
    }

    void insert(boolean bl) {
        this.attribute.getAttribute().insert(bl);
    }

    boolean extract() throws DevFailed {
        return this.attribute.getAttribute().extractBoolean();
    }

    void addBooleanScalarListener(IBooleanScalarListener iBooleanScalarListener) {
        this.propChanges.addBooleanScalarListener(iBooleanScalarListener);
    }

    void removeBooleanScalarListener(IBooleanScalarListener iBooleanScalarListener) {
        this.propChanges.removeBooleanScalarListener(iBooleanScalarListener);
    }

    public boolean getBooleanScalarSetPoint(DeviceAttribute deviceAttribute) throws DevFailed {
        boolean[] blArray = null;
        blArray = deviceAttribute.extractBooleanArray();
        if (blArray == null) {
            return false;
        }
        if (blArray.length < 1) {
            return false;
        }
        if (blArray.length > 1) {
            return blArray[1];
        }
        return blArray[0];
    }

    public String getVersion() {
        return "$Id: BooleanScalarHelper.java,v 1.3 2010/09/24 13:11:54 poncet Exp $";
    }
}

