/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.Device;
import fr.esrf.tangoatk.core.DeviceFactory;
import fr.esrf.tangoatk.core.DeviceItem;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.attribute.AAttribute;
import fr.esrf.tangoatk.core.attribute.PolledAttributeFactory;
import java.util.Vector;

public class AttributePolledList
extends AttributeList {
    private Vector<DeviceItem> deviceList = new Vector();
    private boolean forceRefresh = false;
    private DeviceAttribute[] att = null;
    private DeviceItem devItem = null;
    private Device dev = null;
    private long currentTime;

    public AttributePolledList() {
        this.factory = PolledAttributeFactory.getPolledInstance();
    }

    public void addElement(Object object) {
        if (!(object instanceof AAttribute)) {
            System.out.println("Warning, AttributePolledList supports only IAttribute.");
            return;
        }
        AAttribute aAttribute = (AAttribute)object;
        super.addElement(aAttribute);
        this.addEntity(aAttribute);
    }

    public Object remove(int n) {
        Object e = super.remove(n);
        if (e != null && e instanceof AAttribute) {
            this.removeEntity((AAttribute)e);
        }
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        for (int i = 0; i < this.deviceList.size(); ++i) {
            AttributePolledList attributePolledList = this;
            synchronized (attributePolledList) {
                int n;
                this.devItem = this.deviceList.get(i);
                this.dev = this.devItem.getDevice();
                this.currentTime = System.currentTimeMillis();
                if (this.isForceRefresh()) {
                    for (n = 0; n < this.devItem.getEntityNumber(); ++n) {
                        this.devItem.getEntity(n).refresh();
                    }
                } else {
                    try {
                        this.att = this.dev.read_attribute(this.devItem.getNames());
                        this.trace(4, "Device.read_attribute(" + this.dev.getName() + ") " + this.devItem.getEntityNumber() + " attributes read : OK", this.currentTime);
                        for (n = 0; n < this.devItem.getEntityNumber(); ++n) {
                            this.devItem.getEntity(n).dispatch(this.att[n]);
                        }
                        this.att = null;
                    }
                    catch (DevFailed devFailed) {
                        this.att = null;
                        this.trace(4, "Device.read_attribute(" + this.dev.getName() + ") " + this.devItem.getEntityNumber() + " attributes read : Failed", this.currentTime);
                        AttributePolledList attributePolledList2 = this;
                        synchronized (attributePolledList2) {
                            for (int j = 0; j < this.devItem.getEntityNumber(); ++j) {
                                this.devItem.getEntity(j).dispatchError(devFailed);
                            }
                        }
                    }
                }
                this.devItem = null;
                this.dev = null;
                continue;
            }
        }
        this.fireRefresherStepEvent();
    }

    private synchronized void addEntity(AAttribute aAttribute) {
        int n = 0;
        boolean bl = false;
        Device device = aAttribute.getDevice();
        while (n < this.deviceList.size() && !bl) {
            bl = this.deviceList.get(n).getDevice() == device;
            if (bl) continue;
            ++n;
        }
        if (bl) {
            this.deviceList.get(n).add(aAttribute);
        } else {
            DeviceItem deviceItem = new DeviceItem(device);
            deviceItem.add(aAttribute);
            this.deviceList.add(deviceItem);
        }
    }

    private synchronized void removeEntity(AAttribute aAttribute) {
        int n = 0;
        boolean bl = false;
        Device device = aAttribute.getDevice();
        while (n < this.deviceList.size() && !bl) {
            bl = this.deviceList.get(n).getDevice() == device;
            if (bl) continue;
            ++n;
        }
        if (bl) {
            this.deviceList.get(n).remove(aAttribute);
            if (this.deviceList.get(n).getEntityNumber() == 0) {
                this.deviceList.remove(n);
            }
        }
    }

    private void trace(int n, String string, long l) {
        DeviceFactory.getInstance().trace(n, string, l);
    }

    public String getVersion() {
        return "$Id: AttributePolledList.java,v 1.11 2010/09/24 14:30:26 poncet Exp $";
    }

    public boolean isForceRefresh() {
        return this.forceRefresh;
    }

    public void setForceRefresh(boolean bl) {
        this.forceRefresh = bl;
    }

    public void removeAllElements() {
        for (int i = 0; i < this.size(); ++i) {
            this.remove(i);
        }
    }

    public void clear() {
        this.removeAllElements();
    }

    public void startRefresher() {
        for (int i = 0; i < this.size(); ++i) {
            IAttribute iAttribute = (IAttribute)this.get(i);
            int n = iAttribute.getDevice().getIdlVersion();
            if (n >= 3) continue;
            System.out.println("Warning, " + iAttribute.getName() + " has an IDL<=2 and does not support multiple DevFailed, switching to classic refresh.");
            this.forceRefresh = true;
        }
        super.startRefresher();
    }
}

