/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.impl.macosx;

import com.sun.opengl.impl.GLContextImpl;
import com.sun.opengl.impl.GLContextShareSet;
import com.sun.opengl.impl.macosx.CGL;
import com.sun.opengl.impl.macosx.CGLExt;
import com.sun.opengl.impl.macosx.CGLExtImpl;
import com.sun.opengl.impl.macosx.CGLExtProcAddressTable;
import com.sun.opengl.impl.macosx.MacOSXGLDrawable;
import java.nio.ByteBuffer;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawable;
import javax.media.opengl.GLException;

public abstract class MacOSXGLContext
extends GLContextImpl {
    protected MacOSXGLDrawable drawable;
    protected long nsContext;
    private CGLExt cglExt;
    private CGLExtProcAddressTable cglExtProcAddressTable;

    public MacOSXGLContext(MacOSXGLDrawable macOSXGLDrawable, GLContext gLContext) {
        super(gLContext);
        this.drawable = macOSXGLDrawable;
    }

    public Object getPlatformGLExtensions() {
        return this.getCGLExt();
    }

    public CGLExt getCGLExt() {
        if (this.cglExt == null) {
            this.cglExt = new CGLExtImpl(this);
        }
        return this.cglExt;
    }

    public GLDrawable getGLDrawable() {
        return this.drawable;
    }

    protected String mapToRealGLFunctionName(String string) {
        return string;
    }

    protected String mapToRealGLExtensionName(String string) {
        return string;
    }

    protected abstract boolean create();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean create(boolean bl, boolean bl2) {
        long l;
        MacOSXGLContext macOSXGLContext = (MacOSXGLContext)GLContextShareSet.getShareContext(this);
        long l2 = 0L;
        if (macOSXGLContext != null && (l2 = macOSXGLContext.getNSContext()) == 0L) {
            throw new GLException("GLContextShareSet returned an invalid OpenGL context");
        }
        int[] nArray = new int[1];
        GLCapabilities gLCapabilities = this.drawable.getCapabilities();
        int[] nArray2 = new int[128];
        int[] nArray3 = new int[128];
        int n = 0;
        if (bl) {
            nArray2[n] = 90;
            nArray3[n] = 1;
            ++n;
        }
        if (bl2) {
            nArray2[n] = 58;
            nArray3[n] = 1;
            ++n;
        }
        nArray2[n] = 5;
        nArray3[n] = gLCapabilities.getDoubleBuffered() ? 1 : 0;
        nArray2[++n] = 6;
        nArray3[n] = gLCapabilities.getStereo() ? 1 : 0;
        nArray2[++n] = 8;
        nArray3[n] = gLCapabilities.getRedBits() + gLCapabilities.getGreenBits() + gLCapabilities.getBlueBits();
        nArray2[++n] = 11;
        nArray3[n] = gLCapabilities.getAlphaBits();
        nArray2[++n] = 12;
        nArray3[n] = gLCapabilities.getDepthBits();
        nArray2[++n] = 14;
        nArray3[n] = gLCapabilities.getAccumRedBits() + gLCapabilities.getAccumGreenBits() + gLCapabilities.getAccumBlueBits() + gLCapabilities.getAccumAlphaBits();
        nArray2[++n] = 13;
        nArray3[n] = gLCapabilities.getStencilBits();
        ++n;
        if (gLCapabilities.getSampleBuffers()) {
            nArray2[n] = 55;
            nArray3[n] = 1;
            nArray2[++n] = 56;
            nArray3[n] = gLCapabilities.getNumSamples();
            ++n;
        }
        if ((l = CGL.createPixelFormat(nArray2, 0, n, nArray3, 0)) == 0L) {
            throw new GLException("Unable to allocate pixel format with requested GLCapabilities");
        }
        try {
            this.nsContext = CGL.createContext(l2, this.drawable.getView(), l, nArray, 0);
            if (this.nsContext == 0L) {
                if (nArray[0] == 1) {
                    if (DEBUG) {
                        System.err.println("!!! View not ready for " + ((Object)((Object)this)).getClass().getName());
                    }
                    boolean bl3 = false;
                    return bl3;
                }
                throw new GLException("Error creating NSOpenGLContext with requested pixel format");
            }
            if (this.drawable.getChosenGLCapabilities() == null) {
                GLCapabilities gLCapabilities2 = new GLCapabilities();
                CGL.queryPixelFormat(l, nArray2, 0, n, nArray3, 0);
                block16: for (int i = 0; i < n; ++i) {
                    int n2 = nArray2[i];
                    switch (n2) {
                        case 58: {
                            gLCapabilities2.setPbufferFloatingPointBuffers(nArray3[i] != 0);
                            continue block16;
                        }
                        case 5: {
                            gLCapabilities2.setDoubleBuffered(nArray3[i] != 0);
                            continue block16;
                        }
                        case 6: {
                            gLCapabilities2.setStereo(nArray3[i] != 0);
                            continue block16;
                        }
                        case 8: {
                            int n3 = nArray3[i];
                            if (n3 == 32) {
                                n3 = 24;
                            }
                            gLCapabilities2.setRedBits(n3 /= 3);
                            gLCapabilities2.setGreenBits(n3);
                            gLCapabilities2.setBlueBits(n3);
                            continue block16;
                        }
                        case 11: {
                            gLCapabilities2.setAlphaBits(nArray3[i]);
                            continue block16;
                        }
                        case 12: {
                            gLCapabilities2.setDepthBits(nArray3[i]);
                            continue block16;
                        }
                        case 14: {
                            int n3 = nArray3[i] / 4;
                            gLCapabilities2.setAccumRedBits(n3);
                            gLCapabilities2.setAccumGreenBits(n3);
                            gLCapabilities2.setAccumBlueBits(n3);
                            gLCapabilities2.setAccumAlphaBits(n3);
                            continue block16;
                        }
                        case 13: {
                            gLCapabilities2.setStencilBits(nArray3[i]);
                            continue block16;
                        }
                        case 55: {
                            gLCapabilities2.setSampleBuffers(nArray3[i] != 0);
                            continue block16;
                        }
                        case 56: {
                            gLCapabilities2.setNumSamples(nArray3[i]);
                            continue block16;
                        }
                    }
                }
                this.drawable.setChosenGLCapabilities(gLCapabilities2);
            }
        }
        finally {
            CGL.deletePixelFormat(l);
        }
        GLContextShareSet.contextCreated(this);
        return true;
    }

    protected int makeCurrentImpl() throws GLException {
        boolean bl = false;
        if (this.nsContext == 0L) {
            if (!this.create()) {
                return 0;
            }
            if (DEBUG) {
                System.err.println("!!! Created OpenGL context " + MacOSXGLContext.toHexString(this.nsContext) + " for " + ((Object)((Object)this)).getClass().getName());
            }
            bl = true;
        }
        if (!CGL.makeCurrentContext(this.nsContext)) {
            throw new GLException("Error making nsContext current");
        }
        if (bl) {
            this.resetGLFunctionAvailability();
            return 2;
        }
        return 1;
    }

    protected void releaseImpl() throws GLException {
        if (!CGL.clearCurrentContext(this.nsContext)) {
            throw new GLException("Error freeing OpenGL nsContext");
        }
    }

    protected void destroyImpl() throws GLException {
        if (this.nsContext != 0L) {
            if (!CGL.deleteContext(this.nsContext)) {
                throw new GLException("Unable to delete OpenGL context");
            }
            if (DEBUG) {
                System.err.println("!!! Destroyed OpenGL context " + this.nsContext);
            }
            this.nsContext = 0L;
            GLContextShareSet.contextDestroyed(this);
        }
    }

    public boolean isCreated() {
        return this.nsContext != 0L;
    }

    public void copy(GLContext gLContext, int n) throws GLException {
        long l = this.getNSContext();
        long l2 = ((MacOSXGLContext)gLContext).getNSContext();
        if (l2 == 0L) {
            throw new GLException("Source OpenGL context has not been created");
        }
        if (l == 0L) {
            throw new GLException("Destination OpenGL context has not been created");
        }
        CGL.copyContext(l, l2, n);
    }

    protected void resetGLFunctionAvailability() {
        super.resetGLFunctionAvailability();
        if (DEBUG) {
            System.err.println("!!! Initializing CGL extension address table");
        }
        this.resetProcAddressTable(this.getCGLExtProcAddressTable());
    }

    public CGLExtProcAddressTable getCGLExtProcAddressTable() {
        if (this.cglExtProcAddressTable == null) {
            this.cglExtProcAddressTable = new CGLExtProcAddressTable();
        }
        return this.cglExtProcAddressTable;
    }

    public String getPlatformExtensionsString() {
        return "";
    }

    public void setSwapInterval(int n) {
        if (this.nsContext == 0L) {
            throw new GLException("OpenGL context not current");
        }
        CGL.setSwapInterval(this.nsContext, n);
    }

    public ByteBuffer glAllocateMemoryNV(int n, float f, float f2, float f3) {
        throw new GLException("Not yet implemented");
    }

    protected boolean isFunctionAvailable(String string) {
        return super.isFunctionAvailable(string);
    }

    public boolean isExtensionAvailable(String string) {
        if (string.equals("GL_ARB_pbuffer") || string.equals("GL_ARB_pixel_format")) {
            return true;
        }
        return super.isExtensionAvailable(string);
    }

    public int getOffscreenContextPixelDataType() {
        throw new GLException("Should not call this");
    }

    public int getOffscreenContextReadBuffer() {
        throw new GLException("Should not call this");
    }

    public boolean offscreenImageNeedsVerticalFlip() {
        throw new GLException("Should not call this");
    }

    public void bindPbufferToTexture() {
        throw new GLException("Should not call this");
    }

    public void releasePbufferFromTexture() {
        throw new GLException("Should not call this");
    }

    public abstract void setOpenGLMode(int var1);

    public abstract int getOpenGLMode();

    public long getNSContext() {
        return this.nsContext;
    }
}

