/*
 * Decompiled with CFR 0.152.
 */
package explorer.ui;

import fr.esrf.tangoatk.widget.util.ButtonBar;
import fr.esrf.tangoatk.widget.util.IControlee;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeNode;

public class PreferencesDialog
extends JDialog
implements IControlee {
    JTree tree;
    JSplitPane mainSplit;
    JScrollPane prefPanel;
    ButtonBar buttons;
    PreferenceNode top;
    Map categories;
    protected static PreferencesDialog instance;

    protected PreferencesDialog() {
        this.initComponents();
    }

    public static PreferencesDialog getInstance() {
        if (instance == null) {
            instance = new PreferencesDialog();
        }
        return instance;
    }

    protected void initComponents() {
        this.top = new PreferenceNode();
        this.buttons = new ButtonBar();
        this.buttons.setControlee((IControlee)this);
        this.tree = new JTree(this.top);
        this.categories = new HashMap();
        this.tree.getSelectionModel().setSelectionMode(1);
        DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer();
        renderer.setLeafIcon(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/icons/Properties16.gif")));
        this.tree.setCellRenderer(renderer);
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                DefaultMutableTreeNode n = (DefaultMutableTreeNode)PreferencesDialog.this.tree.getLastSelectedPathComponent();
                if (n == null || !(n instanceof PreferenceNode)) {
                    PreferencesDialog.this.buttons.setControlee((IControlee)PreferencesDialog.this);
                    return;
                }
                PreferenceNode node = (PreferenceNode)n;
                PreferencesDialog.this.showPreference(node.getComponent());
            }
        });
        this.prefPanel = new JScrollPane();
        JScrollPane treeView = new JScrollPane(this.tree);
        this.mainSplit = new JSplitPane(1, treeView, this.prefPanel);
        this.mainSplit.setDividerSize(9);
        this.mainSplit.setOneTouchExpandable(true);
        this.mainSplit.setDividerLocation(150);
        this.prefPanel.setPreferredSize(new Dimension(400, 300));
        treeView.setPreferredSize(new Dimension(150, 300));
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.insets = new Insets(5, 10, 0, 10);
        this.getContentPane().add((Component)this.mainSplit, constraints);
        constraints.gridy = 1;
        constraints.insets = new Insets(0, 0, 0, 0);
        constraints.weighty = 0.0;
        this.getContentPane().add((Component)this.buttons, constraints);
    }

    protected void showPreference(JComponent component) {
        JScrollPane pane = new JScrollPane(component);
        pane.setPreferredSize(new Dimension(400, 300));
        this.mainSplit.setRightComponent(pane);
        this.buttons.setControlee((IControlee)component);
        this.pack();
    }

    public void setTop(String name, JComponent preferenceDialog) {
        this.top.setName(name);
        this.top.setComponent(preferenceDialog);
        this.showPreference(preferenceDialog);
    }

    public void addTop(String name, JComponent preferenceDialog) {
        PreferenceNode node = null;
        node = new PreferenceNode(name, preferenceDialog);
        this.top.add(node);
        this.pack();
    }

    public void addCategory(String category, String name, JComponent preferenceDialog) {
        Enumeration<TreeNode> i = this.top.children();
        CategoryNode node = null;
        boolean found = false;
        while (i.hasMoreElements()) {
            DefaultMutableTreeNode n = (DefaultMutableTreeNode)i.nextElement();
            if (n instanceof PreferenceNode || !(node = (CategoryNode)n).getCategory().equals(category)) continue;
            found = true;
            break;
        }
        if (!found) {
            node = new CategoryNode(category, name, preferenceDialog);
            this.top.add(node);
        } else {
            node.add(name, preferenceDialog);
        }
    }

    public void ok() {
        this.getRootPane().getParent().setVisible(false);
    }

    public void show() {
        this.tree.expandRow(0);
        this.pack();
        super.show();
    }

    class PreferenceNode
    extends DefaultMutableTreeNode {
        String name;
        JComponent comp;

        public PreferenceNode() {
        }

        public PreferenceNode(String name, JComponent comp) {
            this.name = name;
            this.comp = comp;
        }

        public String toString() {
            return this.name;
        }

        public JComponent getComponent() {
            return this.comp;
        }

        public void setComponent(JComponent comp) {
            this.comp = comp;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    class CategoryNode
    extends DefaultMutableTreeNode {
        String category;

        public CategoryNode(String category, String name, JComponent comp) {
            this.category = category;
            this.add(name, comp);
        }

        public String getCategory() {
            return this.category;
        }

        public String toString() {
            return this.category;
        }

        public void add(String name, JComponent comp) {
            this.add(new PreferenceNode(name, comp));
        }
    }
}

