//=============================================================================
//
// file :         EventTesterClass.h
//
// description :  Include for the Event commands which are part of
//		  the DServer class.
//			
// project :      TANGO events
//
// $Author: taurel $
//
// Copyright (C) :      2004,2005,2006,2007,2008,2009,2010
//						European Synchrotron Radiation Facility
//                      BP 220, Grenoble 38043
//                      FRANCE
//
// This file is part of Tango.
//
// Tango is free software: you can redistribute it and/or modify
// it under the terms of the GNU Lesser General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// Tango is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public License
// along with Tango.  If not, see <http://www.gnu.org/licenses/>.
//
// $Revision: 1.6 $
//
// $Log: eventcmds.h,v $
// Revision 1.6  2010/09/09 13:46:00  taurel
// - Add year 2010 in Copyright notice
//
// Revision 1.5  2009/01/21 12:49:03  taurel
// - Change CopyRights for 2009
//
// Revision 1.4  2008/10/06 15:01:09  taurel
// - Changed the licensing info from GPL to LGPL
//
// Revision 1.3  2008/10/03 06:52:31  taurel
// - Add some licensing info in each files
//
// Revision 1.2  2004/07/07 07:59:20  taurel
// Added some files
//
// Revision 1.1.4.1  2004/01/20 08:32:37  taurel
// -First commit after merge with the event branch and work on the AttributeProxy class
// - Fix bug in the stream "clear()" method usage when used with gcc 3.3
//
// Revision 1.1.2.1  2003/04/10 11:07:44  andy_gotz
// added event commands to DServer admin object
//
//
//=============================================================================
//
//  		This file is generated by POGO
//	(Program Obviously used to Generate tango Object)
//
//         (c) - Software Engineering Group - ESRF
//=============================================================================

#ifndef _EVENTCMDS_H
#define _EVENTCMDS_H

#include <tango.h>

namespace Tango
{
//
// Define classes for commands
//
class EventObtainOfferedTypesCmd : public Tango::Command
{
public:
	EventObtainOfferedTypesCmd(const char *,Tango::CmdArgType, Tango::CmdArgType,const char *,const char *);
	EventObtainOfferedTypesCmd(const char *,Tango::CmdArgType, Tango::CmdArgType);
	~EventObtainOfferedTypesCmd() {};
	
	virtual bool is_allowed (Tango::DeviceImpl *, const CORBA::Any &);
	virtual CORBA::Any *execute (Tango::DeviceImpl *, const CORBA::Any &);
};


class EventSubscriptionChangeCmd : public Tango::Command
{
public:
	EventSubscriptionChangeCmd(const char *,Tango::CmdArgType, Tango::CmdArgType,const char *,const char *);
	EventSubscriptionChangeCmd(const char *,Tango::CmdArgType, Tango::CmdArgType);
	~EventSubscriptionChangeCmd() {};
	
	virtual bool is_allowed (Tango::DeviceImpl *, const CORBA::Any &);
	virtual CORBA::Any *execute (Tango::DeviceImpl *, const CORBA::Any &);
};
}	//	namespace Tango

#endif // _EVENTTESTERCLASS_H
