static const char *RcsId = "$Id: class_factory.cpp,v 3.10 2010/09/09 13:44:46 taurel Exp $\n$Name: Release_7_2_0 $";

//+===========================================================================
//
// file :		class_factory.cpp
//
// description :	C++ source file for a dummy DServer::class_factory()
//			method. For server, this method is redefined by the
//			DS programmer in its own file and the linker will not
//			use this file. For client where ther is no
//			class_factory() method, this one will be used by the
//			linker
//			This works only if class_factory() is in its own file
//
// project :		TANGO
//
// author(s) :		A.Gotz + E.Taurel
//
// Copyright (C) :      2004,2005,2006,2007,2008,2009,2010
//						European Synchrotron Radiation Facility
//                      BP 220, Grenoble 38043
//                      FRANCE
//
// This file is part of Tango.
//
// Tango is free software: you can redistribute it and/or modify
// it under the terms of the GNU Lesser General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// Tango is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public License
// along with Tango.  If not, see <http://www.gnu.org/licenses/>.
//
// $Revision: 3.10 $
//
// $Log: class_factory.cpp,v $
// Revision 3.10  2010/09/09 13:44:46  taurel
// - Add year 2010 in Copyright notice
//
// Revision 3.9  2009/01/21 12:49:04  taurel
// - Change CopyRights for 2009
//
// Revision 3.8  2008/10/06 15:00:36  taurel
// - Changed the licensing info from GPL to LGPL
//
// Revision 3.7  2008/10/03 06:51:36  taurel
// - Add some licensing info in each files
//
// Revision 3.6  2008/03/20 07:38:46  taurel
// - Last commit before Release 6.1 ?
//
// Revision 3.5  2008/02/28 12:32:54  jensmeyer
// For MacOSX (__darwin__) shared libraries are linked as under Windows!
// Need to search for the user class_factory() dynamically as for Windows.
//
// Revision 3.4  2007/04/20 14:40:24  taurel
// - Ported to Windows 64 bits x64 architecture
//
// Revision 3.3  2006/05/18 08:52:37  taurel
// - Miscellaneous changes due to Python device server ported to Windows
// - Fix some bugs discovered by Windows VC8 using the test suite
// - Update Windows resource file include path
// - Fix some Windows VC8 warnings
//
// Revision 3.2  2004/07/07 08:39:56  taurel
//
// - Fisrt commit after merge between Trunk and release 4 branch
// - Add EventData copy ctor, asiignement operator and dtor
// - Add Database and DeviceProxy::get_alias() method
// - Add AttributeProxy ctor from "device_alias/attribute_name"
// - Exception thrown when subscribing two times for exactly yhe same event
//
// Revision 3.1.2.2  2003/11/28 16:58:02  taurel
// Changes to handle tango lib build as a Windows DLL and used in a device
// server
//
// Revision 3.1  2003/05/28 14:55:08  taurel
// Add the include (conditionally) of the include files generated by autoconf
//
// Revision 3.0  2003/03/25 16:41:59  taurel
// Many changes for Tango release 3.0 including
// - Added full logging features
// - Added asynchronous calls
// - Host name of clients now stored in black-box
// - Three serialization model in DS
// - Fix miscellaneous bugs
// - Ported to gcc 3.2
// - Added ApiUtil::cleanup() and destructor methods
// - Some internal cleanups
// - Change the way how TangoMonitor class is implemented. It's a recursive
//   mutex
//
// Revision 2.9  2003/01/09 12:03:15  taurel
// - Ported to gcc 3.2
// - Added ApiUtil::cleanup() and ApiUtil::~ApiUtil() methods
// - Replace some ORB * by ORB_ptr
// - Use CORBA::ORB::is_nil() instead of comparing to NULL
//
// Revision 2.8  2002/12/16 12:06:21  taurel
// No change in code at all but only forgot th emost important line in
// list of updates in the previous release :
// - Change underlying ORB from ORBacus to omniORB
//
// Revision 2.7  2002/12/16 10:15:36  taurel
// - New method get_device_list() in Util class
// - Util::get_class_list takes DServer device into account
// - Util::get_device_by_name() takes DServer device into account
// - Util::get_device_list_by_class() takes DServer device into account
// - New parameter to the attribute::set_value() method to enable CORBA to free
// memory allocated for the attribute
//
// Revision 2.6  2002/10/17 07:43:05  taurel
// Fix bug in history stored by the polling thread :
// - We need one copy of the attribute data to build an history!!! It is true
// also for command which return data created by the DeviceImpl::create_xxx
// methods. Chnage in pollring.cpp/pollring.h/dserverpoll.cpp/pollobj.cpp
// and pollobj.h
//
// Revision 2.5  2002/10/15 11:27:18  taurel
// Fix bugs in device.cpp file :
// - Protect the state and status CORBA attribute with the device monitor
// Add the "TgLibVers" string as a #define in tango_config.h
//
// Revision 2.4  2002/08/12 15:06:53  taurel
// Several big fixes and changes
//   - Remove HP-UX specific code
//   - Fix bug in polling alogorithm which cause the thread to enter an infinite
//     loop (pollthread.cpp)
//   - For bug for Win32 device when trying to set attribute config
//     (attribute.cpp)
//
// Revision 2.3  2002/07/02 15:22:23  taurel
// Miscellaneous small changes/bug fixes for Tango CPP release 2.1.0
//     - classes reference documentation now generated using doxygen instead of doc++
//     - A little file added to the library which summarizes version number.
//       The RCS/CVS "ident" command will now tells you that release library x.y.z is composed
//       by C++ client classes set release a.b and C++ server classes set release c.d
//     - Fix incorrect field setting for DevFailed exception re-thrown from a CORBA exception
//     - It's now not possible to poll the Init command
//     - It's now possible to define a default class doc. per control system
//       instance (using property)
//     - The test done to check if attribute value has been set before it is
//       returned to caller is done only if the attribute quality is set to VALID
//     - The JTCInitialize object is now stored in the Util
//     - Windows specific : The tango.h file now also include winsock.h
//
// Revision 2.2  2002/04/30 10:50:40  taurel
// Don't check alarm on attribute if attribute quality factor is INVALID
//
// Revision 2.1  2002/04/29 12:24:02  taurel
// Fix bug in attribute::set_value method and on the check against min and max value when writing attributes
//
// Revision 2.0  2002/04/09 14:45:09  taurel
// See Tango WEB pages for list of changes
//
// Revision 1.6  2001/10/08 09:03:11  taurel
// See tango WEB pages for list of changes
//
// Revision 1.5  2001/07/04 12:27:09  taurel
// New methods re_throw_exception(). Read_attributes supports AllAttr mnemonic A new add_attribute()method in DeviceImpl class New way to define attribute properties New pattern to prevent full re-compile For multi-classes DS, it is now possible to use the Util::get_device_by_name() method in device constructor Adding << operator ovebloading Fix devie CORBA ref. number when device constructor sends an excep.
//
// Revision 1.4  2001/05/04 09:28:12  taurel
// Fix bugs in DServer::restart() method and in Util::get_device_by_name() method
//
// Revision 1.3  2001/03/30 08:03:44  taurel
// Fix bugs in attributes. For linux, add signal_handler in its own thread, change the way to kill server. For all system, change DevRestart philosophy.
//
// Revision 1.2  2001/03/09 08:20:14  taurel
// Fix bug in the MultiClassAttribute::init_class_attribute() method. Also remove the DbErr_DeviceNotDefined define.
//
// Revision 1.1.1.1  2001/02/27 08:46:20  taurel
// Imported sources
//
// Revision 1.3  2000/04/13 10:40:40  taurel
// Added attribute support
//
// Revision 1.2  2000/02/04 11:00:13  taurel
// Just update revision number
//
// Revision 1.1.1.1  2000/02/04 10:58:29  taurel
// Imported sources
//
//-===========================================================================

#if HAVE_CONFIG_H
#include <ac_config.h>
#endif

#include <dserver.h>

namespace Tango
{

//
// There is a trick to build Windows DLL and to use it in a server.
// To build a DLL, you have to pass your code into the linker. The linker
// try to resolve all symbols. Therefore, it resolves the DServer::class_factory
// with this default class_factory. For a server, it's annoying because we
// want the user DServer::class_factory to be called !!
// For all other kinds of lib (Unix type or Windows static), the linker is used
// only when the application is built and symbols are resolved first from the
// supplied object files and only if not found in object files with symbols
// defined in libraries.
// Therefore, the trick for DLL, is inside the default DServer::class_factory
// to force calling the user DServer::class_factory
// To do this, we use the GetProcAddress and we defines in dserver.h file
// the class_factory has "export".
// There is another trick to cast the pointer returned by GetProcAddress
// which is a pointer to function into a pointer to method.
// This is done using an union and initializing the pointeur to method
// with a local method and then modifying it
//

#ifdef _TG_WINDOWS_
typedef void (DServer::*PTR)(void);
typedef union _convertor
{
	PTR d;
	FARPROC s;
}convertor;
#endif


#ifdef __darwin__
#include <dlfcn.h>

typedef void (DServer::*PTR)(void);
typedef union _convertor
{
	PTR d;
	void *s;
}convertor;
#endif



void DServer::class_factory()
{
#ifdef _TG_WINDOWS_
	Tango::Util *tg = Tango::Util::instance();
	string exe_name = tg->get_ds_exec_name();
	exe_name = exe_name + ".exe";
	HMODULE mod;
	FARPROC proc;
	convertor conv;
	PTR tmp;

	if (tg->is_py_ds() == false)
	{
		if ((mod = GetModuleHandle(exe_name.c_str())) == NULL)
		{
			cerr << "Oups, no class defined in this server. Exiting ..." << endl;
			exit(-1);
		}
	}
	else
	{
		if ((mod = GetModuleHandle(TANGO_PY_MOD_NAME)) == NULL)
		{
			cerr << "Oups, no class defined in this server. Exiting ..." << endl;
			exit(-1);
		}
	}

//
// Use the mangled name to find the user DServer::class_factory method
//
// Due to the fact that on Windows 64 bits we have both WIN32 and WIN64
// defined, start by testing WIN64 (See tango_config.h)
//

#ifdef WIN64
	if ((proc = GetProcAddress(mod,"?class_factory@DServer@Tango@@AEAAXXZ")) == NULL)
#else /* WIN32 */
	if ((proc = GetProcAddress(mod,"?class_factory@DServer@Tango@@AAEXXZ")) == NULL)
#endif
	{
		cerr << "Oups, no class defined in this server. Exiting ..." << endl;
		exit(-1); 
	}
	else
	{
		conv.d = &DServer::stop_polling;
		conv.s = proc;
		
		tmp = conv.d;
		(this->*tmp)();
	}

#elif __darwin__
	Tango::Util *tg = Tango::Util::instance();
	string exe_name = tg->get_ds_exec_name();
	exe_name = exe_name;
	
	void *mod;
	void *proc;
	convertor conv;
	PTR tmp;

	if (tg->is_py_ds() == false)
	{
		if ((mod = dlopen (exe_name.c_str(), RTLD_LAZY )) == NULL)
		{
			cerr << "Oups, no class defined in this server. Exiting ..." << endl;
			exit(-1);
		}
	}
	else
	{
		/*
		if ((mod = GetModuleHandle(TANGO_PY_MOD_NAME)) == NULL)
		{
			cerr << "Oups, no class defined in this server. Exiting ..." << endl;
			exit(-1);
		}
		*/
	}

//
// Use the mangled name to find the user DServer::class_factory method
//
// Due to the fact that on Windows 64 bits we have both WIN32 and WIN64
// defined, start by testing WIN64 (See tango_config.h)
//

	if ((proc = dlsym (mod,"_ZN5Tango7DServer13class_factoryEv")) == NULL)
	{
		cerr << "error : " << dlerror() << endl;
		cerr << "Oups, no class defined in this server. Exiting ..." << endl;
		exit(-1); 
	}
	else
	{
		conv.d = &DServer::stop_polling;
		conv.s = proc;
		
		tmp = conv.d;
		(this->*tmp)();
	}	
#else
		cerr << "Oups, no class defined in this server. Exiting ..." << endl;
		exit(-1);
#endif
	
}

} // End of Tango namespace
