static const char *RcsId     = "$Header: /cvsroot/tango-cs/tango/cppserver/AbstractClasses/AccessControl/AccessControlClass.cpp,v 1.2 2010/09/21 11:47:40 taurel Exp $";
static const char *TagName   = "$Name:  $";
static const char *HttpServer= "http://www.esrf.fr/computing/cs/tango/tango_doc/ds_doc/";
//+=============================================================================
//
// file :        AccessControlClass.cpp
//
// description : C++ source for the AccessControlClass. A singleton
//               class derived from DeviceClass. It implements the
//               command list and all properties and methods required
//               by the AccessControl once per process.
//
// project :     TANGO Device Server
//
// $Author: taurel $
//
// Copyright (C) :      2004,2005,2006,2007,2008,2009,2010
//						European Synchrotron Radiation Facility
//                      BP 220, Grenoble 38043
//                      FRANCE
//
// This file is part of Tango.
//
// Tango is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// Tango is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with Tango.  If not, see <http://www.gnu.org/licenses/>.
//
// $Revision: 1.2 $
//
// $Log: AccessControlClass.cpp,v $
// Revision 1.2  2010/09/21 11:47:40  taurel
// - Add GPL header
//
// Revision 1.1.1.1  2006/09/15 11:52:57  pascal_verdier
// Initial Revision
//
//-=============================================================================
//
//  		This file is generated by POGO
//	(Program Obviously used to Generate tango Object)
//
//         (c) - Software Engineering Group - ESRF
//=============================================================================


#include <tango.h>

#include <AccessControl.h>
#include <AccessControlClass.h>


//+----------------------------------------------------------------------------
/**
 *	Create AccessControlClass singleton and return it in a C function for Python usage
 */
//+----------------------------------------------------------------------------
extern "C" {
#ifdef WIN32

__declspec(dllexport)

#endif

	Tango::DeviceClass *_create_AccessControl_class(const char *name) {
		return AccessControl_ns::AccessControlClass::init(name);
	}
}


namespace AccessControl_ns
{
//+----------------------------------------------------------------------------
//
// method : 		UnregisterServiceClass::execute()
// 
// description : 	method to trigger the execution of the command.
//                PLEASE DO NOT MODIFY this method core without pogo   
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *UnregisterServiceClass::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "UnregisterServiceClass::execute(): arrived" << endl;

	((static_cast<AccessControl *>(device))->unregister_service());
	return new CORBA::Any();
}

//+----------------------------------------------------------------------------
//
// method : 		RegisterServiceCmd::execute()
// 
// description : 	method to trigger the execution of the command.
//                PLEASE DO NOT MODIFY this method core without pogo   
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *RegisterServiceCmd::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "RegisterServiceCmd::execute(): arrived" << endl;

	((static_cast<AccessControl *>(device))->register_service());
	return new CORBA::Any();
}





//+----------------------------------------------------------------------------
//
// method : 		RemoveDeviceForUserClass::execute()
// 
// description : 	method to trigger the execution of the command.
//                PLEASE DO NOT MODIFY this method core without pogo   
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *RemoveDeviceForUserClass::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "RemoveDeviceForUserClass::execute(): arrived" << endl;

	const Tango::DevVarStringArray	*argin;
	extract(in_any, argin);

	((static_cast<AccessControl *>(device))->remove_device_for_user(argin));
	return new CORBA::Any();
}

//+----------------------------------------------------------------------------
//
// method : 		RemoveAddressForUserClass::execute()
// 
// description : 	method to trigger the execution of the command.
//                PLEASE DO NOT MODIFY this method core without pogo   
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *RemoveAddressForUserClass::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "RemoveAddressForUserClass::execute(): arrived" << endl;

	const Tango::DevVarStringArray	*argin;
	extract(in_any, argin);

	((static_cast<AccessControl *>(device))->remove_address_for_user(argin));
	return new CORBA::Any();
}

//+----------------------------------------------------------------------------
//
// method : 		GetUsersClass::execute()
// 
// description : 	method to trigger the execution of the command.
//                PLEASE DO NOT MODIFY this method core without pogo   
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *GetUsersClass::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "GetUsersClass::execute(): arrived" << endl;

	return insert((static_cast<AccessControl *>(device))->get_users());
}

//+----------------------------------------------------------------------------
//
// method : 		GetDeviceByUserClass::execute()
// 
// description : 	method to trigger the execution of the command.
//                PLEASE DO NOT MODIFY this method core without pogo   
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *GetDeviceByUserClass::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "GetDeviceByUserClass::execute(): arrived" << endl;

	Tango::DevString	argin;
	extract(in_any, argin);

	return insert((static_cast<AccessControl *>(device))->get_device_by_user(argin));
}

//+----------------------------------------------------------------------------
//
// method : 		GetAllowedCommandsClass::execute()
// 
// description : 	method to trigger the execution of the command.
//                PLEASE DO NOT MODIFY this method core without pogo   
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *GetAllowedCommandsClass::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "GetAllowedCommandsClass::execute(): arrived" << endl;

	Tango::DevString	argin;
	extract(in_any, argin);

	return insert((static_cast<AccessControl *>(device))->get_allowed_commands(argin));
}

//+----------------------------------------------------------------------------
//
// method : 		GetAddressByUserClass::execute()
// 
// description : 	method to trigger the execution of the command.
//                PLEASE DO NOT MODIFY this method core without pogo   
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *GetAddressByUserClass::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "GetAddressByUserClass::execute(): arrived" << endl;

	Tango::DevString	argin;
	extract(in_any, argin);

	return insert((static_cast<AccessControl *>(device))->get_address_by_user(argin));
}

//+----------------------------------------------------------------------------
//
// method : 		AddAddressForUserCmd::execute()
// 
// description : 	method to trigger the execution of the command.
//                PLEASE DO NOT MODIFY this method core without pogo   
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *AddAddressForUserCmd::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "AddAddressForUserCmd::execute(): arrived" << endl;

	const Tango::DevVarStringArray	*argin;
	extract(in_any, argin);

	((static_cast<AccessControl *>(device))->add_address_for_user(argin));
	return new CORBA::Any();
}

//+----------------------------------------------------------------------------
//
// method : 		AddDeviceForUserClass::execute()
// 
// description : 	method to trigger the execution of the command.
//                PLEASE DO NOT MODIFY this method core without pogo   
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *AddDeviceForUserClass::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "AddDeviceForUserClass::execute(): arrived" << endl;

	const Tango::DevVarStringArray	*argin;
	extract(in_any, argin);

	((static_cast<AccessControl *>(device))->add_device_for_user(argin));
	return new CORBA::Any();
}

//+----------------------------------------------------------------------------
//
// method : 		CloneUserCmd::execute()
// 
// description : 	method to trigger the execution of the command.
//                PLEASE DO NOT MODIFY this method core without pogo   
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *CloneUserCmd::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "CloneUserCmd::execute(): arrived" << endl;

	const Tango::DevVarStringArray	*argin;
	extract(in_any, argin);

	((static_cast<AccessControl *>(device))->clone_user(argin));
	return new CORBA::Any();
}

//+----------------------------------------------------------------------------
//
// method : 		GetAccessCmd::execute()
// 
// description : 	method to trigger the execution of the command.
//                PLEASE DO NOT MODIFY this method core without pogo   
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *GetAccessCmd::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "GetAccessCmd::execute(): arrived" << endl;

	const Tango::DevVarStringArray	*argin;
	extract(in_any, argin);

	return insert((static_cast<AccessControl *>(device))->get_access(argin));
}

//+----------------------------------------------------------------------------
//
// method : 		GetDeviceClassCmd::execute()
// 
// description : 	method to trigger the execution of the command.
//                PLEASE DO NOT MODIFY this method core without pogo   
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *GetDeviceClassCmd::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "GetDeviceClassCmd::execute(): arrived" << endl;

	Tango::DevString	argin;
	extract(in_any, argin);

	return insert((static_cast<AccessControl *>(device))->get_device_class(argin));
}

//+----------------------------------------------------------------------------
//
// method : 		RemoveUserClass::execute()
// 
// description : 	method to trigger the execution of the command.
//                PLEASE DO NOT MODIFY this method core without pogo   
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *RemoveUserClass::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "RemoveUserClass::execute(): arrived" << endl;

	Tango::DevString	argin;
	extract(in_any, argin);

	((static_cast<AccessControl *>(device))->remove_user(argin));
	return new CORBA::Any();
}


//+----------------------------------------------------------------------------
//
// method : 		AccessControlClass::AccessControlClass(string &s)
// 
// description : 	constructor for the AccessControlClass
//
// in : - s : The class name
//
//-----------------------------------------------------------------------------
AccessControlClass::AccessControlClass(string &s):DeviceClass(s)
{

	cout2 << "Entering AccessControlClass constructor" << endl;
	
	cout2 << "Leaving AccessControlClass constructor" << endl;

}
//+----------------------------------------------------------------------------
//
// method : 		AccessControlClass::command_factory
// 
// description : 	Create the command object(s) and store them in the 
//			command list
//
//-----------------------------------------------------------------------------
void AccessControlClass::command_factory()
{
	command_list.push_back(new AddAddressForUserCmd("AddAddressForUser",
		Tango::DEVVAR_STRINGARRAY, Tango::DEV_VOID,
		"user name, address",
		"",
		Tango::OPERATOR));
	command_list.push_back(new AddDeviceForUserClass("AddDeviceForUser",
		Tango::DEVVAR_STRINGARRAY, Tango::DEV_VOID,
		"user name, device adn value",
		"",
		Tango::OPERATOR));
	command_list.push_back(new CloneUserCmd("CloneUser",
		Tango::DEVVAR_STRINGARRAY, Tango::DEV_VOID,
		"[0] - source user name.\n[1] - target user name.",
		"",
		Tango::OPERATOR));
	command_list.push_back(new GetAccessCmd("GetAccess",
		Tango::DEVVAR_STRINGARRAY, Tango::DEV_STRING,
		"[0] - User name\n[1] - Device\n[2] - IP Address",
		"cess for specified inputs.",
		Tango::OPERATOR));
	command_list.push_back(new GetAddressByUserClass("GetAddressByUser",
		Tango::DEV_STRING, Tango::DEVVAR_STRINGARRAY,
		"user name.",
		"Addresses found for the specified user.",
		Tango::OPERATOR));
	command_list.push_back(new GetAllowedCommandsClass("GetAllowedCommands",
		Tango::DEV_STRING, Tango::DEVVAR_STRINGARRAY,
		"Device name",
		"Allowed commands found in database for specified device",
		Tango::OPERATOR));
	command_list.push_back(new GetDeviceByUserClass("GetDeviceByUser",
		Tango::DEV_STRING, Tango::DEVVAR_STRINGARRAY,
		"user name.",
		"devices and rights found for the specified user.",
		Tango::OPERATOR));
	command_list.push_back(new GetDeviceClassCmd("GetDeviceClass",
		Tango::DEV_STRING, Tango::DEV_STRING,
		"Device name",
		"Class found in database for specified device",
		Tango::OPERATOR));
	command_list.push_back(new GetUsersClass("GetUsers",
		Tango::DEV_VOID, Tango::DEVVAR_STRINGARRAY,
		"",
		"Users find in table access_address.",
		Tango::OPERATOR));
	command_list.push_back(new RemoveAddressForUserClass("RemoveAddressForUser",
		Tango::DEVVAR_STRINGARRAY, Tango::DEV_VOID,
		"user name, address",
		"",
		Tango::OPERATOR));
	command_list.push_back(new RemoveDeviceForUserClass("RemoveDeviceForUser",
		Tango::DEVVAR_STRINGARRAY, Tango::DEV_VOID,
		"user name, device and value",
		"",
		Tango::OPERATOR));
	command_list.push_back(new RemoveUserClass("RemoveUser",
		Tango::DEV_STRING, Tango::DEV_VOID,
		"user name",
		"",
		Tango::OPERATOR));
	command_list.push_back(new RegisterServiceCmd("RegisterService",
		Tango::DEV_VOID, Tango::DEV_VOID,
		"",
		"",
		Tango::OPERATOR));
	command_list.push_back(new UnregisterServiceClass("UnregisterService",
		Tango::DEV_VOID, Tango::DEV_VOID,
		"",
		"",
		Tango::OPERATOR));

	//	add polling if any
	for (unsigned int i=0 ; i<command_list.size(); i++)
	{
	}
}

//+----------------------------------------------------------------------------
//
// method : 		AccessControlClass::get_class_property
// 
// description : 	Get the class property for specified name.
//
// in :		string	name : The property name
//
//+----------------------------------------------------------------------------
Tango::DbDatum AccessControlClass::get_class_property(string &prop_name)
{
	for (int i=0 ; i<cl_prop.size() ; i++)
		if (cl_prop[i].name == prop_name)
			return cl_prop[i];
	//	if not found, return  an empty DbDatum
	return Tango::DbDatum(prop_name);
}
//+----------------------------------------------------------------------------
//
// method : 		AccessControlClass::get_default_device_property()
// 
// description : 	Return the default value for device property.
//
//-----------------------------------------------------------------------------
Tango::DbDatum AccessControlClass::get_default_device_property(string &prop_name)
{
	for (int i=0 ; i<dev_def_prop.size() ; i++)
		if (dev_def_prop[i].name == prop_name)
			return dev_def_prop[i];
	//	if not found, return  an empty DbDatum
	return Tango::DbDatum(prop_name);
}

//+----------------------------------------------------------------------------
//
// method : 		AccessControlClass::get_default_class_property()
// 
// description : 	Return the default value for class property.
//
//-----------------------------------------------------------------------------
Tango::DbDatum AccessControlClass::get_default_class_property(string &prop_name)
{
	for (int i=0 ; i<cl_def_prop.size() ; i++)
		if (cl_def_prop[i].name == prop_name)
			return cl_def_prop[i];
	//	if not found, return  an empty DbDatum
	return Tango::DbDatum(prop_name);
}
//+----------------------------------------------------------------------------
//
// method : 		AccessControlClass::device_factory
// 
// description : 	Create the device object(s) and store them in the 
//			device list
//
// in :		Tango::DevVarStringArray *devlist_ptr : The device name list
//
//-----------------------------------------------------------------------------
void AccessControlClass::device_factory(const Tango::DevVarStringArray *devlist_ptr)
{

	//	Create all devices.(Automatic code generation)
	//-------------------------------------------------------------
	for (unsigned long i=0 ; i < devlist_ptr->length() ; i++)
	{
		cout4 << "Device name : " << (*devlist_ptr)[i].in() << endl;
						
		// Create devices and add it into the device list
		//----------------------------------------------------
		device_list.push_back(new AccessControl(this, (*devlist_ptr)[i]));							 

		// Export device to the outside world
		// Check before if database used.
		//---------------------------------------------
		if ((Tango::Util::_UseDb == true) && (Tango::Util::_FileDb == false))
			export_device(device_list.back());
		else
			export_device(device_list.back(), (*devlist_ptr)[i]);
	}
	//	End of Automatic code generation
	//-------------------------------------------------------------

}

}	// namespace
